/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.security.PrivilegedExceptionAction;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FSError;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.ipc.CallerContext;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.mapred.FileAlreadyExistsException;
import org.apache.hadoop.mapred.JVMId;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JvmContext;
import org.apache.hadoop.mapred.JvmTask;
import org.apache.hadoop.mapred.MapOutputFile;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskLog;
import org.apache.hadoop.mapred.TaskUmbilicalProtocol;
import org.apache.hadoop.mapred.YarnOutputFiles;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.counters.Limits;
import org.apache.hadoop.mapreduce.security.TokenCache;
import org.apache.hadoop.mapreduce.security.token.JobTokenIdentifier;
import org.apache.hadoop.mapreduce.security.token.JobTokenSecretManager;
import org.apache.hadoop.mapreduce.v2.util.MRApps;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.source.JvmMetrics;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.DiskChecker;
import org.apache.hadoop.util.ShutdownHookManager;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.YarnUncaughtExceptionHandler;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ContainerId;

class YarnChild {
    private static final Log LOG = LogFactory.getLog(YarnChild.class);
    static volatile TaskAttemptID taskid = null;
    private static final FsPermission urw_gr = FsPermission.createImmutable((short)416);

    YarnChild() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Throwable {
        block22: {
            Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new YarnUncaughtExceptionHandler());
            LOG.debug((Object)"Child starting");
            final JobConf job = new JobConf("job.xml");
            Limits.init((Configuration)job);
            UserGroupInformation.setConfiguration((Configuration)job);
            String host = args[0];
            int port = Integer.parseInt(args[1]);
            final InetSocketAddress address = NetUtils.createSocketAddrForHost((String)host, (int)port);
            TaskAttemptID firstTaskid = TaskAttemptID.forName((String)args[2]);
            long jvmIdLong = Long.parseLong(args[3]);
            JVMId jvmId = new JVMId(firstTaskid.getJobID(), firstTaskid.getTaskType() == TaskType.MAP, jvmIdLong);
            CallerContext.setCurrent((CallerContext)new CallerContext.Builder("mr_" + firstTaskid.toString()).build());
            DefaultMetricsSystem.initialize((String)(StringUtils.camelize((String)firstTaskid.getTaskType().name()) + "Task"));
            Credentials credentials = UserGroupInformation.getCurrentUser().getCredentials();
            LOG.info((Object)"Executing with tokens:");
            for (Token token : credentials.getAllTokens()) {
                LOG.info((Object)token);
            }
            UserGroupInformation taskOwner = UserGroupInformation.createRemoteUser((String)firstTaskid.getJobID().toString(), (boolean)false);
            Token jt = TokenCache.getJobToken((Credentials)credentials);
            SecurityUtil.setTokenService((Token)jt, (InetSocketAddress)address);
            taskOwner.addToken(jt);
            final TaskUmbilicalProtocol umbilical = (TaskUmbilicalProtocol)taskOwner.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<TaskUmbilicalProtocol>(){

                @Override
                public TaskUmbilicalProtocol run() throws Exception {
                    return (TaskUmbilicalProtocol)RPC.getProxy(TaskUmbilicalProtocol.class, (long)19L, (InetSocketAddress)address, (Configuration)job);
                }
            });
            JvmContext context = new JvmContext(jvmId, "-1000");
            LOG.debug((Object)("PID: " + System.getenv().get("JVM_PID")));
            Task task = null;
            UserGroupInformation childUGI = null;
            ScheduledExecutorService logSyncer = null;
            try {
                boolean idleLoopCount = false;
                JvmTask myTask = null;
                int idle = 0;
                while (null == myTask) {
                    long sleepTimeMilliSecs = Math.min(idle * 500, 1500);
                    LOG.info((Object)("Sleeping for " + sleepTimeMilliSecs + "ms before retrying again. Got null now."));
                    TimeUnit.MILLISECONDS.sleep(sleepTimeMilliSecs);
                    myTask = umbilical.getTask(context);
                    ++idle;
                }
                if (myTask.shouldDie()) {
                    return;
                }
                task = myTask.getTask();
                taskid = task.getTaskID();
                YarnChild.configureTask(job, task, credentials, (Token<JobTokenIdentifier>)jt);
                String systemPropsToLog = MRApps.getSystemPropertiesToLog((Configuration)job);
                if (systemPropsToLog != null) {
                    LOG.info((Object)systemPropsToLog);
                }
                JvmMetrics.initSingleton((String)jvmId.toString(), (String)job.getSessionId());
                childUGI = UserGroupInformation.createRemoteUser((String)System.getenv(ApplicationConstants.Environment.USER.toString()));
                childUGI.addCredentials(credentials);
                MRApps.setJobClassLoader((Configuration)job);
                logSyncer = TaskLog.createLogSyncer();
                final Task taskFinal = task;
                childUGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws Exception {
                        YarnChild.setEncryptedSpillKeyIfRequired(taskFinal);
                        FileSystem.get((Configuration)job).setWorkingDirectory(job.getWorkingDirectory());
                        taskFinal.run(job, umbilical);
                        return null;
                    }
                });
                RPC.stopProxy((Object)umbilical);
            }
            catch (FSError e) {
                LOG.fatal((Object)"FSError from child", (Throwable)e);
                if (!ShutdownHookManager.get().isShutdownInProgress()) {
                    umbilical.fsError(taskid, e.getMessage());
                }
                break block22;
            }
            catch (Exception exception) {
                LOG.warn((Object)("Exception running child : " + StringUtils.stringifyException((Throwable)exception)));
                try {
                    if (task != null) {
                        if (childUGI == null) {
                            task.taskCleanup(umbilical);
                        } else {
                            final Task taskFinal = task;
                            childUGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                                @Override
                                public Object run() throws Exception {
                                    taskFinal.taskCleanup(umbilical);
                                    return null;
                                }
                            });
                        }
                    }
                }
                catch (Exception e) {
                    LOG.info((Object)("Exception cleaning up: " + StringUtils.stringifyException((Throwable)e)));
                }
                if (taskid != null && !ShutdownHookManager.get().isShutdownInProgress()) {
                    umbilical.fatalError(taskid, StringUtils.stringifyException((Throwable)exception));
                }
                break block22;
            }
            catch (Throwable throwable) {
                LOG.fatal((Object)("Error running child : " + StringUtils.stringifyException((Throwable)throwable)));
                if (taskid != null && !ShutdownHookManager.get().isShutdownInProgress()) {
                    Throwable tCause = throwable.getCause();
                    String cause = tCause == null ? throwable.getMessage() : StringUtils.stringifyException((Throwable)tCause);
                    umbilical.fatalError(taskid, cause);
                }
                break block22;
            }
            finally {
                RPC.stopProxy((Object)umbilical);
                DefaultMetricsSystem.shutdown();
                TaskLog.syncLogsShutdown(logSyncer);
            }
            DefaultMetricsSystem.shutdown();
            TaskLog.syncLogsShutdown((ScheduledExecutorService)logSyncer);
        }
    }

    public static void setEncryptedSpillKeyIfRequired(Task task) throws Exception {
        if (task != null && task.getEncryptedSpillKey() != null && task.getEncryptedSpillKey().length > 1) {
            Credentials creds = UserGroupInformation.getCurrentUser().getCredentials();
            TokenCache.setEncryptedSpillKey((byte[])task.getEncryptedSpillKey(), (Credentials)creds);
            UserGroupInformation.getCurrentUser().addCredentials(creds);
        }
    }

    private static void configureLocalDirs(Task task, JobConf job) throws IOException {
        String[] localSysDirs = StringUtils.getTrimmedStrings((String)System.getenv(ApplicationConstants.Environment.LOCAL_DIRS.name()));
        job.setStrings("mapreduce.cluster.local.dir", localSysDirs);
        LOG.info((Object)("mapreduce.cluster.local.dir for child: " + job.get("mapreduce.cluster.local.dir")));
        LocalDirAllocator lDirAlloc = new LocalDirAllocator("mapreduce.cluster.local.dir");
        Path workDir = null;
        try {
            workDir = lDirAlloc.getLocalPathToRead("work", (Configuration)job);
        }
        catch (DiskChecker.DiskErrorException diskErrorException) {
            // empty catch block
        }
        if (workDir == null) {
            workDir = lDirAlloc.getLocalPathForWrite("work", (Configuration)job);
            FileSystem lfs = FileSystem.getLocal((Configuration)job).getRaw();
            boolean madeDir = false;
            try {
                madeDir = lfs.mkdirs(workDir);
            }
            catch (FileAlreadyExistsException e) {
                madeDir = true;
                workDir = lDirAlloc.getLocalPathToRead("work", (Configuration)job);
            }
            if (!madeDir) {
                throw new IOException("Mkdirs failed to create " + workDir.toString());
            }
        }
        job.set("mapreduce.job.local.dir", workDir.toString());
    }

    private static void configureTask(JobConf job, Task task, Credentials credentials, Token<JobTokenIdentifier> jt) throws IOException {
        job.setCredentials(credentials);
        ApplicationAttemptId appAttemptId = ContainerId.fromString((String)System.getenv(ApplicationConstants.Environment.CONTAINER_ID.name())).getApplicationAttemptId();
        LOG.debug((Object)("APPLICATION_ATTEMPT_ID: " + appAttemptId));
        job.setInt("mapreduce.job.application.attempt.id", appAttemptId.getAttemptId());
        job.setBoolean("ipc.client.tcpnodelay", true);
        job.setClass("mapreduce.task.local.output.class", YarnOutputFiles.class, MapOutputFile.class);
        task.setJobTokenSecret(JobTokenSecretManager.createSecretKey((byte[])jt.getPassword()));
        byte[] shuffleSecret = TokenCache.getShuffleSecretKey((Credentials)credentials);
        if (shuffleSecret == null) {
            LOG.warn((Object)"Shuffle secret missing from task credentials. Using job token secret as shuffle secret.");
            shuffleSecret = jt.getPassword();
        }
        task.setShuffleSecret(JobTokenSecretManager.createSecretKey((byte[])shuffleSecret));
        YarnChild.configureLocalDirs(task, job);
        task.localizeConfiguration(job);
        MRApps.setupDistributedCacheLocal((Configuration)job);
        Path localTaskFile = new Path("job.xml");
        YarnChild.writeLocalJobFile(localTaskFile, job);
        task.setJobFile(localTaskFile.toString());
        task.setConf((Configuration)job);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeLocalJobFile(Path jobFile, JobConf conf) throws IOException {
        LocalFileSystem localFs = FileSystem.getLocal((Configuration)conf);
        localFs.delete(jobFile);
        FSDataOutputStream out = null;
        try {
            out = FileSystem.create((FileSystem)localFs, (Path)jobFile, (FsPermission)urw_gr);
            conf.writeXml((OutputStream)out);
        }
        catch (Throwable throwable) {
            IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{out});
            throw throwable;
        }
        IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{out});
    }
}

