/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce;

import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobResourceUploader;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class TestJobResourceUploader {
    private String destinationPathPrefix = "hdfs:///destinationPath/";
    private String[] expectedFilesNoFrags = new String[]{this.destinationPathPrefix + "tmpFiles0.txt", this.destinationPathPrefix + "tmpFiles1.txt", this.destinationPathPrefix + "tmpFiles2.txt", this.destinationPathPrefix + "tmpFiles3.txt", this.destinationPathPrefix + "tmpFiles4.txt", this.destinationPathPrefix + "tmpjars0.jar", this.destinationPathPrefix + "tmpjars1.jar"};
    private String[] expectedFilesWithFrags = new String[]{this.destinationPathPrefix + "tmpFiles0.txt#tmpFilesfragment0.txt", this.destinationPathPrefix + "tmpFiles1.txt#tmpFilesfragment1.txt", this.destinationPathPrefix + "tmpFiles2.txt#tmpFilesfragment2.txt", this.destinationPathPrefix + "tmpFiles3.txt#tmpFilesfragment3.txt", this.destinationPathPrefix + "tmpFiles4.txt#tmpFilesfragment4.txt", this.destinationPathPrefix + "tmpjars0.jar#tmpjarsfragment0.jar", this.destinationPathPrefix + "tmpjars1.jar#tmpjarsfragment1.jar"};
    private String[] expectedFilesWithWildcard = new String[]{this.destinationPathPrefix + "tmpFiles0.txt", this.destinationPathPrefix + "tmpFiles1.txt", this.destinationPathPrefix + "tmpFiles2.txt", this.destinationPathPrefix + "tmpFiles3.txt", this.destinationPathPrefix + "tmpFiles4.txt", "file:///libjars-submit-dir/libjars/*"};
    private String[] expectedArchivesNoFrags = new String[]{this.destinationPathPrefix + "tmpArchives0.tgz", this.destinationPathPrefix + "tmpArchives1.tgz"};
    private String[] expectedArchivesWithFrags = new String[]{this.destinationPathPrefix + "tmpArchives0.tgz#tmpArchivesfragment0.tgz", this.destinationPathPrefix + "tmpArchives1.tgz#tmpArchivesfragment1.tgz"};
    private String jobjarSubmitDir = "/jobjar-submit-dir";
    private String basicExpectedJobJar = this.jobjarSubmitDir + "/job.jar";
    private final FileStatus mockedStatus = (FileStatus)Mockito.mock(FileStatus.class);

    @Test
    public void testStringToPath() throws IOException {
        Configuration conf = new Configuration();
        JobResourceUploader uploader = new JobResourceUploader((FileSystem)FileSystem.getLocal((Configuration)conf), false);
        Assert.assertEquals((String)"Failed: absolute, no scheme, with fragment", (Object)"/testWithFragment.txt", (Object)uploader.stringToPath("/testWithFragment.txt#fragment.txt").toString());
        Assert.assertEquals((String)"Failed: absolute, with scheme, with fragment", (Object)"file:/testWithFragment.txt", (Object)uploader.stringToPath("file:///testWithFragment.txt#fragment.txt").toString());
        Assert.assertEquals((String)"Failed: relative, no scheme, with fragment", (Object)"testWithFragment.txt", (Object)uploader.stringToPath("testWithFragment.txt#fragment.txt").toString());
        Assert.assertEquals((String)"Failed: relative, no scheme, no fragment", (Object)"testWithFragment.txt", (Object)uploader.stringToPath("testWithFragment.txt").toString());
        Assert.assertEquals((String)"Failed: absolute, with scheme, no fragment", (Object)"file:/testWithFragment.txt", (Object)uploader.stringToPath("file:///testWithFragment.txt").toString());
    }

    @Test
    public void testAllDefaults() throws IOException {
        ResourceConf.Builder b = new ResourceConf.Builder();
        this.runLimitsTest(b.build(), true, null);
    }

    @Test
    public void testNoLimitsWithResources() throws IOException {
        ResourceConf.Builder b = new ResourceConf.Builder();
        b.setNumOfDCArchives(1);
        b.setNumOfDCFiles(1);
        b.setNumOfTmpArchives(10);
        b.setNumOfTmpFiles(1);
        b.setNumOfTmpLibJars(1);
        b.setJobJar(true);
        b.setSizeOfResource(10L);
        this.runLimitsTest(b.build(), true, null);
    }

    @Test
    public void testAtResourceLimit() throws IOException {
        ResourceConf.Builder b = new ResourceConf.Builder();
        b.setNumOfDCArchives(1);
        b.setNumOfDCFiles(1);
        b.setNumOfTmpArchives(1);
        b.setNumOfTmpFiles(1);
        b.setNumOfTmpLibJars(1);
        b.setJobJar(true);
        b.setMaxResources(6);
        this.runLimitsTest(b.build(), true, null);
    }

    @Test
    public void testOverResourceLimit() throws IOException {
        ResourceConf.Builder b = new ResourceConf.Builder();
        b.setNumOfDCArchives(1);
        b.setNumOfDCFiles(1);
        b.setNumOfTmpArchives(1);
        b.setNumOfTmpFiles(2);
        b.setNumOfTmpLibJars(1);
        b.setJobJar(true);
        b.setMaxResources(6);
        this.runLimitsTest(b.build(), false, ResourceViolation.NUMBER_OF_RESOURCES);
    }

    @Test
    public void testAtResourcesMBLimit() throws IOException {
        ResourceConf.Builder b = new ResourceConf.Builder();
        b.setNumOfDCArchives(1);
        b.setNumOfDCFiles(1);
        b.setNumOfTmpArchives(1);
        b.setNumOfTmpFiles(2);
        b.setNumOfTmpLibJars(1);
        b.setJobJar(true);
        b.setMaxResourcesMB(7L);
        b.setSizeOfResource(1L);
        this.runLimitsTest(b.build(), true, null);
    }

    @Test
    public void testOverResourcesMBLimit() throws IOException {
        ResourceConf.Builder b = new ResourceConf.Builder();
        b.setNumOfDCArchives(1);
        b.setNumOfDCFiles(2);
        b.setNumOfTmpArchives(1);
        b.setNumOfTmpFiles(2);
        b.setNumOfTmpLibJars(1);
        b.setJobJar(true);
        b.setMaxResourcesMB(7L);
        b.setSizeOfResource(1L);
        this.runLimitsTest(b.build(), false, ResourceViolation.TOTAL_RESOURCE_SIZE);
    }

    @Test
    public void testAtSingleResourceMBLimit() throws IOException {
        ResourceConf.Builder b = new ResourceConf.Builder();
        b.setNumOfDCArchives(1);
        b.setNumOfDCFiles(2);
        b.setNumOfTmpArchives(1);
        b.setNumOfTmpFiles(2);
        b.setNumOfTmpLibJars(1);
        b.setJobJar(true);
        b.setMaxSingleResourceMB(1L);
        b.setSizeOfResource(1L);
        this.runLimitsTest(b.build(), true, null);
    }

    @Test
    public void testOverSingleResourceMBLimit() throws IOException {
        ResourceConf.Builder b = new ResourceConf.Builder();
        b.setNumOfDCArchives(1);
        b.setNumOfDCFiles(2);
        b.setNumOfTmpArchives(1);
        b.setNumOfTmpFiles(2);
        b.setNumOfTmpLibJars(1);
        b.setJobJar(true);
        b.setMaxSingleResourceMB(1L);
        b.setSizeOfResource(10L);
        this.runLimitsTest(b.build(), false, ResourceViolation.SINGLE_RESOURCE_SIZE);
    }

    @Test
    public void testPathsWithNoFragNoSchemeRelative() throws IOException {
        ResourceConf.Builder b = new ResourceConf.Builder();
        b.setNumOfTmpFiles(5);
        b.setNumOfTmpLibJars(2);
        b.setNumOfTmpArchives(2);
        b.setJobJar(true);
        b.setPathsWithScheme(false);
        b.setPathsWithFrags(false);
        ResourceConf rConf = b.build();
        JobConf jConf = new JobConf();
        StubedUploader uploader = new StubedUploader(jConf);
        this.runTmpResourcePathTest(uploader, rConf, jConf, this.expectedFilesNoFrags, this.expectedArchivesNoFrags, this.basicExpectedJobJar);
    }

    @Test
    public void testPathsWithNoFragNoSchemeAbsolute() throws IOException {
        ResourceConf.Builder b = new ResourceConf.Builder();
        b.setNumOfTmpFiles(5);
        b.setNumOfTmpLibJars(2);
        b.setNumOfTmpArchives(2);
        b.setJobJar(true);
        b.setPathsWithFrags(false);
        b.setPathsWithScheme(false);
        b.setAbsolutePaths(true);
        ResourceConf rConf = b.build();
        JobConf jConf = new JobConf();
        StubedUploader uploader = new StubedUploader(jConf);
        this.runTmpResourcePathTest(uploader, rConf, jConf, this.expectedFilesNoFrags, this.expectedArchivesNoFrags, this.basicExpectedJobJar);
    }

    @Test
    public void testPathsWithFragNoSchemeAbsolute() throws IOException {
        ResourceConf.Builder b = new ResourceConf.Builder();
        b.setNumOfTmpFiles(5);
        b.setNumOfTmpLibJars(2);
        b.setNumOfTmpArchives(2);
        b.setJobJar(true);
        b.setPathsWithFrags(true);
        b.setPathsWithScheme(false);
        b.setAbsolutePaths(true);
        ResourceConf rConf = b.build();
        JobConf jConf = new JobConf();
        StubedUploader uploader = new StubedUploader(jConf);
        this.runTmpResourcePathTest(uploader, rConf, jConf, this.expectedFilesWithFrags, this.expectedArchivesWithFrags, this.basicExpectedJobJar);
    }

    @Test
    public void testPathsWithFragNoSchemeRelative() throws IOException {
        ResourceConf.Builder b = new ResourceConf.Builder();
        b.setNumOfTmpFiles(5);
        b.setNumOfTmpLibJars(2);
        b.setNumOfTmpArchives(2);
        b.setJobJar(true);
        b.setPathsWithFrags(true);
        b.setAbsolutePaths(false);
        b.setPathsWithScheme(false);
        ResourceConf rConf = b.build();
        JobConf jConf = new JobConf();
        StubedUploader uploader = new StubedUploader(jConf);
        this.runTmpResourcePathTest(uploader, rConf, jConf, this.expectedFilesWithFrags, this.expectedArchivesWithFrags, this.basicExpectedJobJar);
    }

    @Test
    public void testPathsWithFragSchemeAbsolute() throws IOException {
        ResourceConf.Builder b = new ResourceConf.Builder();
        b.setNumOfTmpFiles(5);
        b.setNumOfTmpLibJars(2);
        b.setNumOfTmpArchives(2);
        b.setJobJar(true);
        b.setPathsWithFrags(true);
        b.setAbsolutePaths(true);
        b.setPathsWithScheme(true);
        ResourceConf rConf = b.build();
        JobConf jConf = new JobConf();
        StubedUploader uploader = new StubedUploader(jConf);
        this.runTmpResourcePathTest(uploader, rConf, jConf, this.expectedFilesWithFrags, this.expectedArchivesWithFrags, this.basicExpectedJobJar);
    }

    @Test
    public void testPathsWithNoFragWithSchemeAbsolute() throws IOException {
        ResourceConf.Builder b = new ResourceConf.Builder();
        b.setNumOfTmpFiles(5);
        b.setNumOfTmpLibJars(2);
        b.setNumOfTmpArchives(2);
        b.setJobJar(true);
        b.setPathsWithFrags(false);
        b.setPathsWithScheme(true);
        b.setAbsolutePaths(true);
        ResourceConf rConf = b.build();
        JobConf jConf = new JobConf();
        StubedUploader uploader = new StubedUploader(jConf);
        this.runTmpResourcePathTest(uploader, rConf, jConf, this.expectedFilesNoFrags, this.expectedArchivesNoFrags, this.basicExpectedJobJar);
    }

    @Test
    public void testPathsWithNoFragAndWildCard() throws IOException {
        ResourceConf.Builder b = new ResourceConf.Builder();
        b.setNumOfTmpFiles(5);
        b.setNumOfTmpLibJars(4);
        b.setNumOfTmpArchives(2);
        b.setJobJar(true);
        b.setPathsWithFrags(false);
        b.setPathsWithScheme(true);
        b.setAbsolutePaths(true);
        ResourceConf rConf = b.build();
        JobConf jConf = new JobConf();
        StubedUploader uploader = new StubedUploader(jConf, true);
        this.runTmpResourcePathTest(uploader, rConf, jConf, this.expectedFilesWithWildcard, this.expectedArchivesNoFrags, this.basicExpectedJobJar);
    }

    @Test
    public void testPathsWithFragsAndWildCard() throws IOException {
        ResourceConf.Builder b = new ResourceConf.Builder();
        b.setNumOfTmpFiles(5);
        b.setNumOfTmpLibJars(2);
        b.setNumOfTmpArchives(2);
        b.setJobJar(true);
        b.setPathsWithFrags(true);
        b.setPathsWithScheme(true);
        b.setAbsolutePaths(true);
        ResourceConf rConf = b.build();
        JobConf jConf = new JobConf();
        StubedUploader uploader = new StubedUploader(jConf, true);
        this.runTmpResourcePathTest(uploader, rConf, jConf, this.expectedFilesWithFrags, this.expectedArchivesWithFrags, this.basicExpectedJobJar);
    }

    @Ignore
    @Test
    public void testErasureCodingDefault() throws IOException {
        this.testErasureCodingSetting(true);
    }

    @Ignore
    @Test
    public void testErasureCodingDisabled() throws IOException {
        this.testErasureCodingSetting(false);
    }

    private void testErasureCodingSetting(boolean defaultBehavior) throws IOException {
        JobConf jConf = new JobConf();
        if (!defaultBehavior) {
            jConf.setBoolean("yarn.app.mapreduce.am.staging-dir.erasurecoding.enabled", true);
        }
        DistributedFileSystem fs = (DistributedFileSystem)Mockito.mock(DistributedFileSystem.class);
        Path path = new Path("/");
        Mockito.when((Object)fs.makeQualified((Path)Matchers.any(Path.class))).thenReturn((Object)path);
        StubedUploader uploader = new StubedUploader((FileSystem)fs, true);
        Job job = Job.getInstance((Configuration)jConf);
        uploader.uploadResources(job, new Path("/test"));
    }

    private void runTmpResourcePathTest(JobResourceUploader uploader, ResourceConf rConf, JobConf jConf, String[] expectedFiles, String[] expectedArchives, String expectedJobJar) throws IOException {
        Job job = rConf.setupJobConf(jConf);
        this.uploadResources(uploader, job);
        this.validateResourcePaths(job, expectedFiles, expectedArchives, expectedJobJar);
    }

    private void uploadResources(JobResourceUploader uploader, Job job) throws IOException {
        Configuration conf = job.getConfiguration();
        Collection files = conf.getStringCollection("tmpfiles");
        Collection libjars = conf.getStringCollection("tmpjars");
        Collection archives = conf.getStringCollection("tmparchives");
        HashMap statCache = new HashMap();
        HashMap fileSCUploadPolicies = new HashMap();
        String jobJar = job.getJar();
        uploader.uploadFiles(job, files, new Path("/files-submit-dir"), null, (short)3, fileSCUploadPolicies, statCache);
        uploader.uploadArchives(job, archives, new Path("/archives-submit-dir"), null, (short)3, fileSCUploadPolicies, statCache);
        uploader.uploadLibJars(job, libjars, new Path("/libjars-submit-dir"), null, (short)3, fileSCUploadPolicies, statCache);
        uploader.uploadJobJar(job, jobJar, new Path(this.jobjarSubmitDir), (short)3, statCache);
    }

    private void validateResourcePaths(Job job, String[] expectedFiles, String[] expectedArchives, String expectedJobJar) throws IOException {
        this.validateResourcePathsSub(job.getCacheFiles(), expectedFiles);
        this.validateResourcePathsSub(job.getCacheArchives(), expectedArchives);
        Assert.assertEquals((String)"Job jar path is different than expected!", (Object)expectedJobJar, (Object)job.getJar());
    }

    private void validateResourcePathsSub(URI[] actualURIs, String[] expectedURIs) {
        List<URI> actualList = Arrays.asList(actualURIs);
        HashSet<String> expectedSet = new HashSet<String>(Arrays.asList(expectedURIs));
        if (actualList.size() != expectedSet.size()) {
            Assert.fail((String)("Expected list of resources (" + expectedSet.size() + ") and actual list of resources (" + actualList.size() + ") are different lengths!"));
        }
        for (URI u : actualList) {
            if (expectedSet.contains(u.toString())) continue;
            Assert.fail((String)("Resource list contained unexpected path: " + u.toString()));
        }
    }

    private void runLimitsTest(ResourceConf rlConf, boolean checkShouldSucceed, ResourceViolation violation) throws IOException {
        if (!checkShouldSucceed && violation == null) {
            Assert.fail((String)"Test is misconfigured. checkShouldSucceed is set to false and a ResourceViolation is not specified.");
        }
        JobConf conf = new JobConf();
        rlConf.setupJobConf(conf);
        StubedUploader uploader = new StubedUploader(conf);
        long configuredSizeOfResourceBytes = rlConf.sizeOfResource * 1024L * 1024L;
        Mockito.when((Object)this.mockedStatus.getLen()).thenReturn((Object)configuredSizeOfResourceBytes);
        Mockito.when((Object)this.mockedStatus.isDirectory()).thenReturn((Object)false);
        HashMap statCache = new HashMap();
        try {
            uploader.checkLocalizationLimits((Configuration)conf, conf.getStringCollection("tmpfiles"), conf.getStringCollection("tmpjars"), conf.getStringCollection("tmparchives"), conf.getJar(), statCache);
            Assert.assertTrue((String)"Limits check succeeded when it should have failed.", (boolean)checkShouldSucceed);
        }
        catch (IOException e) {
            if (checkShouldSucceed) {
                Assert.fail((String)("Limits check failed when it should have succeeded: " + e));
            }
            switch (violation) {
                case NUMBER_OF_RESOURCES: {
                    if (e.getMessage().contains("This job has exceeded the maximum number of submitted resources")) break;
                    Assert.fail((String)("Test failed unexpectedly: " + e));
                    break;
                }
                case TOTAL_RESOURCE_SIZE: {
                    if (e.getMessage().contains("This job has exceeded the maximum size of submitted resources")) break;
                    Assert.fail((String)("Test failed unexpectedly: " + e));
                    break;
                }
                case SINGLE_RESOURCE_SIZE: {
                    if (e.getMessage().contains("This job has exceeded the maximum size of a single submitted resource")) break;
                    Assert.fail((String)("Test failed unexpectedly: " + e));
                    break;
                }
                default: {
                    Assert.fail((String)("Test failed unexpectedly: " + e));
                }
            }
        }
    }

    private class StubedUploader
    extends JobResourceUploader {
        StubedUploader(JobConf conf) throws IOException {
            this(conf, false);
        }

        StubedUploader(JobConf conf, boolean useWildcard) throws IOException {
            super((FileSystem)FileSystem.getLocal((Configuration)conf), useWildcard);
        }

        StubedUploader(FileSystem fs, boolean useWildcard) throws IOException {
            super(fs, useWildcard);
        }

        FileStatus getFileStatus(Map<URI, FileStatus> statCache, Configuration job, Path p) throws IOException {
            return TestJobResourceUploader.this.mockedStatus;
        }

        boolean mkdirs(FileSystem fs, Path dir, FsPermission permission) throws IOException {
            return true;
        }

        Path copyRemoteFiles(Path parentDir, Path originalPath, Configuration conf, short replication) throws IOException {
            return new Path(TestJobResourceUploader.this.destinationPathPrefix + originalPath.getName());
        }

        void copyJar(Path originalJarPath, Path submitJarFile, short replication) throws IOException {
        }
    }

    private static class ResourceConf {
        private final int maxResources;
        private final long maxResourcesMB;
        private final long maxSingleResourceMB;
        private final int numOfTmpFiles;
        private final int numOfTmpArchives;
        private final int numOfTmpLibJars;
        private final boolean jobJar;
        private final int numOfDCFiles;
        private final int numOfDCArchives;
        private final long sizeOfResource;
        private final boolean pathsWithFrags;
        private final boolean pathsWithScheme;
        private final boolean absolutePaths;

        private ResourceConf() {
            this(new Builder());
        }

        private ResourceConf(Builder builder) {
            this.maxResources = builder.maxResources;
            this.maxResourcesMB = builder.maxResourcesMB;
            this.maxSingleResourceMB = builder.maxSingleResourceMB;
            this.numOfTmpFiles = builder.numOfTmpFiles;
            this.numOfTmpArchives = builder.numOfTmpArchives;
            this.numOfTmpLibJars = builder.numOfTmpLibJars;
            this.jobJar = builder.jobJar;
            this.numOfDCFiles = builder.numOfDCFiles;
            this.numOfDCArchives = builder.numOfDCArchives;
            this.sizeOfResource = builder.sizeOfResource;
            this.pathsWithFrags = builder.pathsWithFrags;
            this.pathsWithScheme = builder.pathsWithScheme;
            this.absolutePaths = builder.absolutePaths;
        }

        private Job setupJobConf(JobConf conf) throws IOException {
            conf.set("tmpfiles", this.buildPathString("tmpFiles", this.numOfTmpFiles, ".txt"));
            conf.set("tmpjars", this.buildPathString("tmpjars", this.numOfTmpLibJars, ".jar"));
            conf.set("tmparchives", this.buildPathString("tmpArchives", this.numOfTmpArchives, ".tgz"));
            conf.set("mapreduce.job.cache.archives", this.buildDistributedCachePathString("cacheArchives", this.numOfDCArchives, ".tgz"));
            conf.set("mapreduce.job.cache.files", this.buildDistributedCachePathString("cacheFiles", this.numOfDCFiles, ".txt"));
            if (this.jobJar) {
                String fragment = "";
                if (this.pathsWithFrags) {
                    fragment = "#jobjarfrag.jar";
                }
                if (this.pathsWithScheme) {
                    conf.setJar("file:///jobjar.jar" + fragment);
                } else if (this.absolutePaths) {
                    conf.setJar("/jobjar.jar" + fragment);
                } else {
                    conf.setJar("jobjar.jar" + fragment);
                }
            }
            conf.setInt("mapreduce.job.cache.limit.max-resources", this.maxResources);
            conf.setLong("mapreduce.job.cache.limit.max-resources-mb", this.maxResourcesMB);
            conf.setLong("mapreduce.job.cache.limit.max-single-resource-mb", this.maxSingleResourceMB);
            return new Job(conf);
        }

        private String buildDistributedCachePathString(String pathPrefix, int numOfPaths, String extension) {
            if (numOfPaths < 1) {
                return "";
            }
            StringBuilder b = new StringBuilder();
            b.append(this.buildPathStringSub(pathPrefix, "file:///" + pathPrefix, extension, 0));
            for (int i = 1; i < numOfPaths; ++i) {
                b.append("," + this.buildPathStringSub(pathPrefix, "file:///" + pathPrefix, extension, i));
            }
            return b.toString();
        }

        private String buildPathString(String pathPrefix, int numOfPaths, String extension) {
            if (numOfPaths < 1) {
                return "";
            }
            StringBuilder b = new StringBuilder();
            String processedPath = this.pathsWithScheme ? "file:///" + pathPrefix : (this.absolutePaths ? "/" + pathPrefix : pathPrefix);
            b.append(this.buildPathStringSub(pathPrefix, processedPath, extension, 0));
            for (int i = 1; i < numOfPaths; ++i) {
                b.append("," + this.buildPathStringSub(pathPrefix, processedPath, extension, i));
            }
            return b.toString();
        }

        private String buildPathStringSub(String pathPrefix, String processedPath, String extension, int num) {
            if (this.pathsWithFrags) {
                return processedPath + num + extension + "#" + pathPrefix + "fragment" + num + extension;
            }
            return processedPath + num + extension;
        }

        static class Builder {
            private int maxResources = 0;
            private long maxResourcesMB = 0L;
            private long maxSingleResourceMB = 0L;
            private int numOfTmpFiles = 0;
            private int numOfTmpArchives = 0;
            private int numOfTmpLibJars = 0;
            private boolean jobJar = false;
            private int numOfDCFiles = 0;
            private int numOfDCArchives = 0;
            private long sizeOfResource = 0L;
            private boolean pathsWithFrags = false;
            private boolean pathsWithScheme = false;
            private boolean absolutePaths = true;

            private Builder() {
            }

            private Builder setMaxResources(int max) {
                this.maxResources = max;
                return this;
            }

            private Builder setMaxResourcesMB(long max) {
                this.maxResourcesMB = max;
                return this;
            }

            private Builder setMaxSingleResourceMB(long max) {
                this.maxSingleResourceMB = max;
                return this;
            }

            private Builder setNumOfTmpFiles(int num) {
                this.numOfTmpFiles = num;
                return this;
            }

            private Builder setNumOfTmpArchives(int num) {
                this.numOfTmpArchives = num;
                return this;
            }

            private Builder setNumOfTmpLibJars(int num) {
                this.numOfTmpLibJars = num;
                return this;
            }

            private Builder setJobJar(boolean jar) {
                this.jobJar = jar;
                return this;
            }

            private Builder setNumOfDCFiles(int num) {
                this.numOfDCFiles = num;
                return this;
            }

            private Builder setNumOfDCArchives(int num) {
                this.numOfDCArchives = num;
                return this;
            }

            private Builder setSizeOfResource(long sizeMB) {
                this.sizeOfResource = sizeMB;
                return this;
            }

            private Builder setPathsWithFrags(boolean fragments) {
                this.pathsWithFrags = fragments;
                return this;
            }

            private Builder setPathsWithScheme(boolean scheme) {
                this.pathsWithScheme = scheme;
                return this;
            }

            private Builder setAbsolutePaths(boolean absolute) {
                this.absolutePaths = absolute;
                return this;
            }

            ResourceConf build() {
                return new ResourceConf(this);
            }
        }
    }

    private static enum ResourceViolation {
        NUMBER_OF_RESOURCES,
        TOTAL_RESOURCE_SIZE,
        SINGLE_RESOURCE_SIZE;

    }
}

