/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.mapred.JobQueueInfo;
import org.apache.hadoop.mapred.Queue;
import org.apache.hadoop.mapred.QueueACL;
import org.apache.hadoop.mapred.QueueAclsInfo;
import org.apache.hadoop.mapred.QueueManager;
import org.apache.hadoop.mapred.TestJobConf;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestQueue {
    private static File testDir = new File(System.getProperty("test.build.data", "/tmp"), TestJobConf.class.getSimpleName());

    @Before
    public void setup() {
        testDir.mkdirs();
    }

    @After
    public void cleanup() {
        FileUtil.fullyDelete((File)testDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=5000L)
    public void testQueue() throws IOException {
        File f = null;
        try {
            f = this.writeFile();
            QueueManager manager = new QueueManager(f.getCanonicalPath(), true);
            manager.setSchedulerInfo("first", (Object)"queueInfo");
            manager.setSchedulerInfo("second", (Object)"queueInfoqueueInfo");
            Queue root = manager.getRoot();
            Assert.assertTrue((root.getChildren().size() == 2 ? 1 : 0) != 0);
            Iterator iterator = root.getChildren().iterator();
            Queue firstSubQueue = (Queue)iterator.next();
            Assert.assertEquals((Object)"first", (Object)firstSubQueue.getName());
            Assert.assertEquals((Object)((AccessControlList)firstSubQueue.getAcls().get("mapred.queue.first.acl-submit-job")).toString(), (Object)"Users [user1, user2] and members of the groups [group1, group2] are allowed");
            Queue secondSubQueue = (Queue)iterator.next();
            Assert.assertEquals((Object)"second", (Object)secondSubQueue.getName());
            Assert.assertEquals((Object)secondSubQueue.getProperties().getProperty("key"), (Object)"value");
            Assert.assertEquals((Object)secondSubQueue.getProperties().getProperty("key1"), (Object)"value1");
            Assert.assertEquals((Object)firstSubQueue.getState().getStateName(), (Object)"running");
            Assert.assertEquals((Object)secondSubQueue.getState().getStateName(), (Object)"stopped");
            HashSet<String> template = new HashSet<String>();
            template.add("first");
            template.add("second");
            Assert.assertEquals((Object)manager.getLeafQueueNames(), template);
            UserGroupInformation mockUGI = (UserGroupInformation)Mockito.mock(UserGroupInformation.class);
            Mockito.when((Object)mockUGI.getShortUserName()).thenReturn((Object)"user1");
            String[] groups = new String[]{"group1"};
            Mockito.when((Object)mockUGI.getGroupNames()).thenReturn((Object)groups);
            Assert.assertTrue((boolean)manager.hasAccess("first", QueueACL.SUBMIT_JOB, mockUGI));
            Assert.assertFalse((boolean)manager.hasAccess("second", QueueACL.SUBMIT_JOB, mockUGI));
            Assert.assertFalse((boolean)manager.hasAccess("first", QueueACL.ADMINISTER_JOBS, mockUGI));
            Mockito.when((Object)mockUGI.getShortUserName()).thenReturn((Object)"user3");
            Assert.assertTrue((boolean)manager.hasAccess("first", QueueACL.ADMINISTER_JOBS, mockUGI));
            QueueAclsInfo[] qai = manager.getQueueAcls(mockUGI);
            Assert.assertEquals((long)qai.length, (long)1L);
            manager.refreshQueues(this.getConfiguration(), null);
            iterator = root.getChildren().iterator();
            Queue firstSubQueue1 = (Queue)iterator.next();
            Queue secondSubQueue1 = (Queue)iterator.next();
            Assert.assertTrue((boolean)firstSubQueue.equals((Object)firstSubQueue1));
            Assert.assertEquals((Object)firstSubQueue1.getState().getStateName(), (Object)"running");
            Assert.assertEquals((Object)secondSubQueue1.getState().getStateName(), (Object)"stopped");
            Assert.assertEquals((Object)firstSubQueue1.getSchedulingInfo(), (Object)"queueInfo");
            Assert.assertEquals((Object)secondSubQueue1.getSchedulingInfo(), (Object)"queueInfoqueueInfo");
            Assert.assertEquals((Object)firstSubQueue.getJobQueueInfo().getQueueName(), (Object)"first");
            Assert.assertEquals((Object)firstSubQueue.getJobQueueInfo().getQueueState(), (Object)"running");
            Assert.assertEquals((Object)firstSubQueue.getJobQueueInfo().getSchedulingInfo(), (Object)"queueInfo");
            Assert.assertEquals((long)secondSubQueue.getJobQueueInfo().getChildren().size(), (long)0L);
            Assert.assertEquals((Object)manager.getSchedulerInfo("first"), (Object)"queueInfo");
            HashSet<String> queueJobQueueInfos = new HashSet<String>();
            for (JobQueueInfo jobInfo : manager.getJobQueueInfos()) {
                queueJobQueueInfos.add(jobInfo.getQueueName());
            }
            HashSet<String> rootJobQueueInfos = new HashSet<String>();
            for (Queue queue : root.getChildren()) {
                rootJobQueueInfos.add(queue.getJobQueueInfo().getQueueName());
            }
            Assert.assertEquals(queueJobQueueInfos, rootJobQueueInfos);
            Assert.assertEquals((Object)((JobQueueInfo)manager.getJobQueueInfoMapping().get("first")).getQueueName(), (Object)"first");
            StringWriter writer = new StringWriter();
            Configuration conf = this.getConfiguration();
            conf.unset("mapred.queue.names");
            QueueManager.dumpConfiguration((Writer)writer, (String)f.getAbsolutePath(), (Configuration)conf);
            String result = ((Object)writer).toString();
            Assert.assertTrue((result.indexOf("\"name\":\"first\",\"state\":\"running\",\"acl_submit_job\":\"user1,user2 group1,group2\",\"acl_administer_jobs\":\"user3,user4 group3,group4\",\"properties\":[],\"children\":[]") > 0 ? 1 : 0) != 0);
            writer = new StringWriter();
            QueueManager.dumpConfiguration((Writer)writer, (Configuration)conf);
            result = ((Object)writer).toString();
            Assert.assertTrue((boolean)result.contains("{\"queues\":[{\"name\":\"default\",\"state\":\"running\",\"acl_submit_job\":\"*\",\"acl_administer_jobs\":\"*\",\"properties\":[],\"children\":[]},{\"name\":\"q1\",\"state\":\"running\",\"acl_submit_job\":\" \",\"acl_administer_jobs\":\" \",\"properties\":[],\"children\":[{\"name\":\"q1:q2\",\"state\":\"running\",\"acl_submit_job\":\" \",\"acl_administer_jobs\":\" \",\"properties\":["));
            Assert.assertTrue((boolean)result.contains("{\"key\":\"capacity\",\"value\":\"20\"}"));
            Assert.assertTrue((boolean)result.contains("{\"key\":\"user-limit\",\"value\":\"30\"}"));
            Assert.assertTrue((boolean)result.contains("],\"children\":[]}]}]}"));
            QueueAclsInfo qi = new QueueAclsInfo();
            Assert.assertNull((Object)qi.getQueueName());
        }
        finally {
            if (f != null) {
                f.delete();
            }
        }
    }

    private Configuration getConfiguration() {
        Configuration conf = new Configuration();
        conf.set("mapred.queue.names", "first,second");
        conf.set("mapred.queue.first.acl-submit-job", "user1,user2 group1,group2");
        conf.set("mapreduce.cluster.acls.enabled", "true");
        conf.set("mapred.queue.first.state", "running");
        conf.set("mapred.queue.second.state", "stopped");
        return conf;
    }

    @Test(timeout=5000L)
    public void testDefaultConfig() {
        QueueManager manager = new QueueManager(true);
        Assert.assertEquals((long)manager.getRoot().getChildren().size(), (long)2L);
    }

    @Test(timeout=5000L)
    public void test2Queue() throws IOException {
        Configuration conf = this.getConfiguration();
        QueueManager manager = new QueueManager(conf);
        manager.setSchedulerInfo("first", (Object)"queueInfo");
        manager.setSchedulerInfo("second", (Object)"queueInfoqueueInfo");
        Queue root = manager.getRoot();
        Assert.assertTrue((root.getChildren().size() == 2 ? 1 : 0) != 0);
        Iterator iterator = root.getChildren().iterator();
        Queue firstSubQueue = (Queue)iterator.next();
        Assert.assertEquals((Object)"first", (Object)firstSubQueue.getName());
        Assert.assertEquals((Object)((AccessControlList)firstSubQueue.getAcls().get("mapred.queue.first.acl-submit-job")).toString(), (Object)"Users [user1, user2] and members of the groups [group1, group2] are allowed");
        Queue secondSubQueue = (Queue)iterator.next();
        Assert.assertEquals((Object)"second", (Object)secondSubQueue.getName());
        Assert.assertEquals((Object)firstSubQueue.getState().getStateName(), (Object)"running");
        Assert.assertEquals((Object)secondSubQueue.getState().getStateName(), (Object)"stopped");
        Assert.assertTrue((boolean)manager.isRunning("first"));
        Assert.assertFalse((boolean)manager.isRunning("second"));
        Assert.assertEquals((Object)firstSubQueue.getSchedulingInfo(), (Object)"queueInfo");
        Assert.assertEquals((Object)secondSubQueue.getSchedulingInfo(), (Object)"queueInfoqueueInfo");
        HashSet<String> template = new HashSet<String>();
        template.add("first");
        template.add("second");
        Assert.assertEquals((Object)manager.getLeafQueueNames(), template);
    }

    private File writeFile() throws IOException {
        File f = new File(testDir, "tst.xml");
        BufferedWriter out = new BufferedWriter(new FileWriter(f));
        String properties = "<properties><property key=\"key\" value=\"value\"/><property key=\"key1\" value=\"value1\"/></properties>";
        out.write("<queues>");
        out.newLine();
        out.write("<queue><name>first</name><acl-submit-job>user1,user2 group1,group2</acl-submit-job><acl-administer-jobs>user3,user4 group3,group4</acl-administer-jobs><state>running</state></queue>");
        out.newLine();
        out.write("<queue><name>second</name><acl-submit-job>u1,u2 g1,g2</acl-submit-job>" + properties + "<state>stopped</state></queue>");
        out.newLine();
        out.write("</queues>");
        out.flush();
        out.close();
        return f;
    }
}

