/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.lib;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.mapred.lib.CombineFileRecordReader;
import org.apache.hadoop.mapred.lib.CombineFileRecordReaderWrapper;
import org.apache.hadoop.mapred.lib.CombineFileSplit;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestCombineFileRecordReader {
    private static Path outDir = new Path(System.getProperty("test.build.data", "/tmp"), TestCombineFileRecordReader.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInitNextRecordReader() throws IOException {
        JobConf conf = new JobConf();
        Path[] paths = new Path[3];
        long[] fileLength = new long[3];
        File[] files = new File[3];
        LongWritable key = new LongWritable(1L);
        Text value = new Text();
        try {
            for (int i = 0; i < 3; ++i) {
                fileLength[i] = i;
                File dir = new File(outDir.toString());
                dir.mkdir();
                files[i] = new File(dir, "testfile" + i);
                FileWriter fileWriter = new FileWriter(files[i]);
                fileWriter.close();
                paths[i] = new Path(outDir + "/testfile" + i);
            }
            CombineFileSplit combineFileSplit = new CombineFileSplit(conf, paths, fileLength);
            Reporter reporter = (Reporter)Mockito.mock(Reporter.class);
            CombineFileRecordReader cfrr = new CombineFileRecordReader(conf, combineFileSplit, reporter, TextRecordReaderWrapper.class);
            ((Reporter)Mockito.verify((Object)reporter)).progress();
            Assert.assertFalse((boolean)cfrr.next((Object)key, (Object)value));
            ((Reporter)Mockito.verify((Object)reporter, (VerificationMode)Mockito.times((int)3))).progress();
        }
        finally {
            FileUtil.fullyDelete((File)new File(outDir.toString()));
        }
    }

    private static class TextRecordReaderWrapper
    extends CombineFileRecordReaderWrapper<LongWritable, Text> {
        public TextRecordReaderWrapper(CombineFileSplit split, Configuration conf, Reporter reporter, Integer idx) throws IOException {
            super((FileInputFormat)new TextInputFormat(), split, conf, reporter, idx);
        }
    }
}

