/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.lib.db;

import java.sql.DriverManager;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.lib.db.DBConfiguration;
import org.apache.hadoop.mapred.lib.db.DBInputFormat;
import org.apache.hadoop.mapred.lib.db.DBWritable;
import org.apache.hadoop.mapreduce.lib.db.DriverForTest;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestDBInputFormat {
    @Test(timeout=10000L)
    public void testDBInputFormat() throws Exception {
        JobConf configuration = new JobConf();
        this.setupDriver(configuration);
        DBInputFormat format = new DBInputFormat();
        format.setConf((Configuration)configuration);
        format.setConf((Configuration)configuration);
        DBInputFormat.DBInputSplit splitter = new DBInputFormat.DBInputSplit(1L, 10L);
        Reporter reporter = (Reporter)Mockito.mock(Reporter.class);
        RecordReader reader = format.getRecordReader((InputSplit)splitter, configuration, reporter);
        configuration.setInt("mapreduce.job.maps", 3);
        InputSplit[] lSplits = format.getSplits(configuration, 3);
        Assert.assertEquals((long)5L, (long)lSplits[0].getLength());
        Assert.assertEquals((long)3L, (long)lSplits.length);
        Assert.assertEquals(LongWritable.class, ((LongWritable)reader.createKey()).getClass());
        Assert.assertEquals((long)0L, (long)reader.getPos());
        Assert.assertEquals((double)0.0, (double)reader.getProgress(), (double)0.001);
        reader.close();
    }

    @Test(timeout=5000L)
    public void testSetInput() {
        JobConf configuration = new JobConf();
        String[] fieldNames = new String[]{"field1", "field2"};
        DBInputFormat.setInput((JobConf)configuration, DBInputFormat.NullDBWritable.class, (String)"table", (String)"conditions", (String)"orderBy", (String[])fieldNames);
        Assert.assertEquals((Object)"org.apache.hadoop.mapred.lib.db.DBInputFormat$NullDBWritable", (Object)configuration.getClass("mapreduce.jdbc.input.class", null).getName());
        Assert.assertEquals((Object)"table", (Object)configuration.get("mapreduce.jdbc.input.table.name", null));
        String[] fields = configuration.getStrings("mapreduce.jdbc.input.field.names");
        Assert.assertEquals((Object)"field1", (Object)fields[0]);
        Assert.assertEquals((Object)"field2", (Object)fields[1]);
        Assert.assertEquals((Object)"conditions", (Object)configuration.get("mapreduce.jdbc.input.conditions", null));
        Assert.assertEquals((Object)"orderBy", (Object)configuration.get("mapreduce.jdbc.input.orderby", null));
        configuration = new JobConf();
        DBInputFormat.setInput((JobConf)configuration, DBInputFormat.NullDBWritable.class, (String)"query", (String)"countQuery");
        Assert.assertEquals((Object)"query", (Object)configuration.get("mapreduce.jdbc.input.query", null));
        Assert.assertEquals((Object)"countQuery", (Object)configuration.get("mapreduce.jdbc.input.count.query", null));
        JobConf jConfiguration = new JobConf();
        DBConfiguration.configureDB((JobConf)jConfiguration, (String)"driverClass", (String)"dbUrl", (String)"user", (String)"password");
        Assert.assertEquals((Object)"driverClass", (Object)jConfiguration.get("mapreduce.jdbc.driver.class"));
        Assert.assertEquals((Object)"dbUrl", (Object)jConfiguration.get("mapreduce.jdbc.url"));
        Assert.assertEquals((Object)"user", (Object)jConfiguration.get("mapreduce.jdbc.username"));
        Assert.assertEquals((Object)"password", (Object)jConfiguration.get("mapreduce.jdbc.password"));
        jConfiguration = new JobConf();
        DBConfiguration.configureDB((JobConf)jConfiguration, (String)"driverClass", (String)"dbUrl");
        Assert.assertEquals((Object)"driverClass", (Object)jConfiguration.get("mapreduce.jdbc.driver.class"));
        Assert.assertEquals((Object)"dbUrl", (Object)jConfiguration.get("mapreduce.jdbc.url"));
        Assert.assertNull((Object)jConfiguration.get("mapreduce.jdbc.username"));
        Assert.assertNull((Object)jConfiguration.get("mapreduce.jdbc.password"));
    }

    @Test(timeout=5000L)
    public void testDBRecordReader() throws Exception {
        JobConf job = (JobConf)Mockito.mock(JobConf.class);
        DBConfiguration dbConfig = (DBConfiguration)Mockito.mock(DBConfiguration.class);
        String[] fields = new String[]{"field1", "filed2"};
        DBInputFormat dBInputFormat = new DBInputFormat();
        dBInputFormat.getClass();
        DBInputFormat.DBRecordReader reader = new DBInputFormat.DBRecordReader(dBInputFormat, new DBInputFormat.DBInputSplit(), DBInputFormat.NullDBWritable.class, job, DriverForTest.getConnection(), dbConfig, "condition", fields, "table");
        LongWritable key = reader.createKey();
        Assert.assertEquals((long)0L, (long)key.get());
        DBWritable value = reader.createValue();
        Assert.assertEquals((Object)"org.apache.hadoop.mapred.lib.db.DBInputFormat$NullDBWritable", (Object)value.getClass().getName());
        Assert.assertEquals((long)0L, (long)reader.getPos());
        Assert.assertFalse((boolean)reader.next(key, value));
    }

    private void setupDriver(JobConf configuration) throws Exception {
        configuration.set("mapreduce.jdbc.url", "testUrl");
        DriverManager.registerDriver(new DriverForTest());
        configuration.set("mapreduce.jdbc.driver.class", DriverForTest.class.getCanonicalName());
    }
}

