/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.output;

import org.apache.hadoop.io.MapFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.Partitioner;
import org.apache.hadoop.mapreduce.lib.output.MapFileOutputFormat;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestMapFileOutputFormat {
    @Test
    public void testPartitionerShouldNotBeCalledWhenOneReducerIsPresent() throws Exception {
        MapFileOutputFormat outputFormat = new MapFileOutputFormat();
        MapFile.Reader reader = (MapFile.Reader)Mockito.mock(MapFile.Reader.class);
        MapFile.Reader[] readers = new MapFile.Reader[]{reader};
        MapFileOutputFormat.getEntry((MapFile.Reader[])readers, (Partitioner)new MyPartitioner(), (WritableComparable)new Text(), (Writable)new Text());
        Assert.assertTrue((!MyPartitioner.isGetPartitionCalled() ? 1 : 0) != 0);
    }

    @After
    public void tearDown() throws Exception {
        MyPartitioner.setGetPartitionCalled(false);
    }

    private static class MyPartitioner
    extends Partitioner<WritableComparable, Writable> {
        private static boolean getPartitionCalled = false;

        private MyPartitioner() {
        }

        public static boolean isGetPartitionCalled() {
            return getPartitionCalled;
        }

        public int getPartition(WritableComparable key, Writable value, int numPartitions) {
            MyPartitioner.setGetPartitionCalled(true);
            return -1;
        }

        public static void setGetPartitionCalled(boolean getPartitionCalled) {
            MyPartitioner.getPartitionCalled = getPartitionCalled;
        }
    }
}

