/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.StringWriter;
import java.io.Writer;
import org.apache.hadoop.mapred.TaskLogAppender;
import org.apache.log4j.Category;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LoggingEvent;
import org.junit.Assert;
import org.junit.Test;

public class TestTaskLogAppender {
    @Test(timeout=5000L)
    public void testTaskLogAppender() {
        TaskLogAppender appender = new TaskLogAppender();
        System.setProperty("hadoop.tasklog.taskid", "attempt_01_02_m03_04_001");
        System.setProperty("hadoop.tasklog.totalLogFileSize", "1003");
        appender.activateOptions();
        Assert.assertEquals((Object)appender.getTaskId(), (Object)"attempt_01_02_m03_04_001");
        Assert.assertEquals((long)appender.getTotalLogFileSize(), (long)1000L);
        Assert.assertEquals((Object)appender.getIsCleanup(), (Object)false);
        StringWriter writer = new StringWriter();
        appender.setWriter((Writer)writer);
        PatternLayout layout = new PatternLayout("%-5p [%t]: %m%n");
        appender.setLayout((Layout)layout);
        Logger logger = Logger.getLogger((String)this.getClass().getName());
        LoggingEvent event = new LoggingEvent("fqnOfCategoryClass", (Category)logger, Priority.INFO, (Object)"message", new Throwable());
        appender.append(event);
        appender.flush();
        appender.close();
        Assert.assertTrue((((Object)writer).toString().length() > 0 ? 1 : 0) != 0);
        appender = new TaskLogAppender();
        appender.setIsCleanup(true);
        appender.activateOptions();
        Assert.assertEquals((Object)appender.getIsCleanup(), (Object)true);
    }
}

