/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.input;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.StatusReporter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.lib.input.CombineFileRecordReader;
import org.apache.hadoop.mapreduce.lib.input.CombineFileRecordReaderWrapper;
import org.apache.hadoop.mapreduce.lib.input.CombineFileSplit;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestCombineFileRecordReader {
    private static Path outDir = new Path(System.getProperty("test.build.data", "/tmp"), TestCombineFileRecordReader.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProgressIsReportedIfInputASeriesOfEmptyFiles() throws IOException, InterruptedException {
        JobConf conf = new JobConf();
        Path[] paths = new Path[3];
        File[] files = new File[3];
        long[] fileLength = new long[3];
        try {
            for (int i = 0; i < 3; ++i) {
                File dir = new File(outDir.toString());
                dir.mkdir();
                files[i] = new File(dir, "testfile" + i);
                FileWriter fileWriter = new FileWriter(files[i]);
                fileWriter.flush();
                fileWriter.close();
                fileLength[i] = i;
                paths[i] = new Path(outDir + "/testfile" + i);
            }
            CombineFileSplit combineFileSplit = new CombineFileSplit(paths, fileLength);
            TaskAttemptID taskAttemptID = (TaskAttemptID)Mockito.mock(TaskAttemptID.class);
            Task.TaskReporter reporter = (Task.TaskReporter)Mockito.mock(Task.TaskReporter.class);
            TaskAttemptContextImpl taskAttemptContext = new TaskAttemptContextImpl((Configuration)conf, taskAttemptID, (StatusReporter)reporter);
            CombineFileRecordReader cfrr = new CombineFileRecordReader(combineFileSplit, (TaskAttemptContext)taskAttemptContext, TextRecordReaderWrapper.class);
            cfrr.initialize((InputSplit)combineFileSplit, (TaskAttemptContext)taskAttemptContext);
            ((Task.TaskReporter)Mockito.verify((Object)reporter)).progress();
            Assert.assertFalse((boolean)cfrr.nextKeyValue());
            ((Task.TaskReporter)Mockito.verify((Object)reporter, (VerificationMode)Mockito.times((int)3))).progress();
        }
        finally {
            FileUtil.fullyDelete((File)new File(outDir.toString()));
        }
    }

    private static class TextRecordReaderWrapper
    extends CombineFileRecordReaderWrapper<LongWritable, Text> {
        public TextRecordReaderWrapper(CombineFileSplit split, TaskAttemptContext context, Integer idx) throws IOException, InterruptedException {
            super((FileInputFormat)new TextInputFormat(), split, context, idx);
        }
    }
}

