/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.text.ParseException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.GroupFactoryForTest;
import org.apache.hadoop.mapred.JobInProgress;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.FileSystemCounter;
import org.apache.hadoop.mapreduce.JobCounter;
import org.apache.hadoop.mapreduce.TaskCounter;
import org.apache.hadoop.mapreduce.counters.CounterGroupFactory;
import org.apache.hadoop.mapreduce.counters.FrameworkCounterGroup;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestCounters {
    private static final long MAX_VALUE = 10L;
    private static final Logger LOG = LoggerFactory.getLogger(TestCounters.class);
    static final Enum<?> FRAMEWORK_COUNTER = TaskCounter.CPU_MILLISECONDS;
    static final long FRAMEWORK_COUNTER_VALUE = 8L;
    static final String FS_SCHEME = "HDFS";
    static final FileSystemCounter FS_COUNTER = FileSystemCounter.BYTES_READ;
    static final long FS_COUNTER_VALUE = 10L;

    private Counters getEnumCounters(Enum[] keys) {
        Counters counters = new Counters();
        for (Enum key : keys) {
            for (long i = 0L; i < 10L; ++i) {
                counters.incrCounter(key, i);
            }
        }
        return counters;
    }

    private Counters getEnumCounters(String[] gNames, String[] cNames) {
        Counters counters = new Counters();
        for (String gName : gNames) {
            for (String cName : cNames) {
                for (long i = 0L; i < 10L; ++i) {
                    counters.incrCounter(gName, cName, i);
                }
            }
        }
        return counters;
    }

    private void testCounter(Counters counter) throws ParseException {
        String compactEscapedString = counter.makeEscapedCompactString();
        Assert.assertFalse((String)"compactEscapedString should not contain null", (boolean)compactEscapedString.contains("null"));
        Counters recoveredCounter = Counters.fromEscapedCompactString((String)compactEscapedString);
        Assert.assertEquals((String)"Recovered counter does not match on content", (Object)counter, (Object)recoveredCounter);
    }

    @Test
    public void testCounters() throws IOException {
        Enum[] keysWithResource = new Enum[]{TaskCounter.MAP_INPUT_RECORDS, TaskCounter.MAP_OUTPUT_BYTES};
        Enum[] keysWithoutResource = new Enum[]{myCounters.TEST1, myCounters.TEST2};
        String[] groups = new String[]{"group1", "group2", "group{}()[]"};
        String[] counters = new String[]{"counter1", "counter2", "counter{}()[]"};
        try {
            this.testCounter(this.getEnumCounters(keysWithResource));
            this.testCounter(this.getEnumCounters(keysWithoutResource));
            this.testCounter(this.getEnumCounters(groups, counters));
        }
        catch (ParseException pe) {
            throw new IOException(pe);
        }
    }

    @Test
    public void testCounterValue() {
        Counters counters = new Counters();
        int NUMBER_TESTS = 100;
        int NUMBER_INC = 10;
        Random rand = new Random();
        for (int i = 0; i < 100; ++i) {
            long initValue;
            long expectedValue = initValue = (long)rand.nextInt();
            Counters.Counter counter = counters.findCounter("foo", "bar");
            counter.setValue(initValue);
            Assert.assertEquals((String)"Counter value is not initialized correctly", (long)expectedValue, (long)counter.getValue());
            for (int j = 0; j < 10; ++j) {
                int incValue = rand.nextInt();
                counter.increment((long)incValue);
                Assert.assertEquals((String)"Counter value is not incremented correctly", (long)(expectedValue += (long)incValue), (long)counter.getValue());
            }
            expectedValue = rand.nextInt();
            counter.setValue(expectedValue);
            Assert.assertEquals((String)"Counter value is not set correctly", (long)expectedValue, (long)counter.getValue());
        }
    }

    @Test
    public void testReadWithLegacyNames() {
        Counters counters = new Counters();
        counters.incrCounter((Enum)TaskCounter.MAP_INPUT_RECORDS, 1L);
        counters.incrCounter((Enum)JobCounter.DATA_LOCAL_MAPS, 1L);
        ((Counters.Counter)counters.findCounter("file", FileSystemCounter.BYTES_READ)).increment(1L);
        this.checkLegacyNames(counters);
    }

    @Test
    public void testWriteWithLegacyNames() {
        Counters counters = new Counters();
        counters.incrCounter((Enum)Task.Counter.MAP_INPUT_RECORDS, 1L);
        counters.incrCounter((Enum)JobInProgress.Counter.DATA_LOCAL_MAPS, 1L);
        counters.findCounter("FileSystemCounters", "FILE_BYTES_READ").increment(1L);
        this.checkLegacyNames(counters);
    }

    private void checkLegacyNames(Counters counters) {
        Assert.assertEquals((String)"New name", (long)1L, (long)counters.findCounter(TaskCounter.class.getName(), "MAP_INPUT_RECORDS").getValue());
        Assert.assertEquals((String)"Legacy name", (long)1L, (long)counters.findCounter("org.apache.hadoop.mapred.Task$Counter", "MAP_INPUT_RECORDS").getValue());
        Assert.assertEquals((String)"Legacy enum", (long)1L, (long)((Counters.Counter)counters.findCounter((Enum)Task.Counter.MAP_INPUT_RECORDS)).getValue());
        Assert.assertEquals((String)"New name", (long)1L, (long)counters.findCounter(JobCounter.class.getName(), "DATA_LOCAL_MAPS").getValue());
        Assert.assertEquals((String)"Legacy name", (long)1L, (long)counters.findCounter("org.apache.hadoop.mapred.JobInProgress$Counter", "DATA_LOCAL_MAPS").getValue());
        Assert.assertEquals((String)"Legacy enum", (long)1L, (long)((Counters.Counter)counters.findCounter((Enum)JobInProgress.Counter.DATA_LOCAL_MAPS)).getValue());
        Assert.assertEquals((String)"New name", (long)1L, (long)counters.findCounter(FileSystemCounter.class.getName(), "FILE_BYTES_READ").getValue());
        Assert.assertEquals((String)"New name and method", (long)1L, (long)((Counters.Counter)counters.findCounter("file", FileSystemCounter.BYTES_READ)).getValue());
        Assert.assertEquals((String)"Legacy name", (long)1L, (long)counters.findCounter("FileSystemCounters", "FILE_BYTES_READ").getValue());
    }

    @Test
    public void testCounterIteratorConcurrency() {
        Counters counters = new Counters();
        counters.incrCounter("group1", "counter1", 1L);
        Iterator iterator = counters.iterator();
        counters.incrCounter("group2", "counter2", 1L);
        iterator.next();
    }

    @Test
    public void testGroupIteratorConcurrency() {
        Counters counters = new Counters();
        counters.incrCounter("group1", "counter1", 1L);
        Counters.Group group = counters.getGroup("group1");
        Iterator iterator = group.iterator();
        counters.incrCounter("group1", "counter2", 1L);
        iterator.next();
    }

    @Test
    public void testFileSystemGroupIteratorConcurrency() {
        Counters counters = new Counters();
        ((Counters.Counter)counters.findCounter("fs1", FileSystemCounter.BYTES_READ)).increment(1L);
        ((Counters.Counter)counters.findCounter("fs2", FileSystemCounter.BYTES_READ)).increment(1L);
        Counters.Group group = counters.getGroup(FileSystemCounter.class.getName());
        Iterator iterator = group.iterator();
        ((Counters.Counter)counters.findCounter("fs3", FileSystemCounter.BYTES_READ)).increment(1L);
        Assert.assertTrue((boolean)iterator.hasNext());
        iterator.next();
        ((Counters.Counter)counters.findCounter("fs3", FileSystemCounter.BYTES_READ)).increment(1L);
        Assert.assertTrue((boolean)iterator.hasNext());
        iterator.next();
    }

    @Test
    public void testLegacyGetGroupNames() {
        Counters counters = new Counters();
        ((Counters.Counter)counters.findCounter("fs1", FileSystemCounter.BYTES_READ)).increment(1L);
        ((Counters.Counter)counters.findCounter("fs2", FileSystemCounter.BYTES_READ)).increment(1L);
        counters.incrCounter("group1", "counter1", 1L);
        HashSet groups = new HashSet(counters.getGroupNames());
        HashSet<String> expectedGroups = new HashSet<String>();
        expectedGroups.add("group1");
        expectedGroups.add("FileSystemCounters");
        expectedGroups.add("org.apache.hadoop.mapreduce.FileSystemCounter");
        Assert.assertEquals(expectedGroups, groups);
    }

    @Test
    public void testMakeCompactString() {
        String GC1 = "group1.counter1:1";
        String GC2 = "group2.counter2:3";
        Counters counters = new Counters();
        counters.incrCounter("group1", "counter1", 1L);
        Assert.assertEquals((Object)"group1.counter1:1", (Object)counters.makeCompactString());
        counters.incrCounter("group2", "counter2", 3L);
        String cs = counters.makeCompactString();
        Assert.assertTrue((String)"Bad compact string", (cs.equals("group1.counter1:1,group2.counter2:3") || cs.equals("group2.counter2:3,group1.counter1:1") ? 1 : 0) != 0);
    }

    @Test
    public void testCounterLimits() {
        this.testMaxCountersLimits(new Counters());
        this.testMaxGroupsLimits(new Counters());
    }

    private void testMaxCountersLimits(final Counters counters) {
        for (int i = 0; i < Counters.MAX_COUNTER_LIMIT; ++i) {
            counters.findCounter("test", "test" + i);
        }
        this.setExpected(counters);
        this.shouldThrow(Counters.CountersExceededException.class, new Runnable(){

            @Override
            public void run() {
                counters.findCounter("test", "bad");
            }
        });
        this.checkExpected(counters);
    }

    private void testMaxGroupsLimits(final Counters counters) {
        for (int i = 0; i < Counters.MAX_GROUP_LIMIT; ++i) {
            counters.findCounter("test" + i, "test");
        }
        this.setExpected(counters);
        this.shouldThrow(Counters.CountersExceededException.class, new Runnable(){

            @Override
            public void run() {
                counters.findCounter("bad", "test");
            }
        });
        this.checkExpected(counters);
    }

    private void setExpected(Counters counters) {
        ((Counters.Counter)counters.findCounter(FRAMEWORK_COUNTER)).setValue(8L);
        ((Counters.Counter)counters.findCounter(FS_SCHEME, FS_COUNTER)).setValue(10L);
    }

    private void checkExpected(Counters counters) {
        Assert.assertEquals((long)8L, (long)((Counters.Counter)counters.findCounter(FRAMEWORK_COUNTER)).getValue());
        Assert.assertEquals((long)10L, (long)((Counters.Counter)counters.findCounter(FS_SCHEME, FS_COUNTER)).getValue());
    }

    private void shouldThrow(Class<? extends Exception> ecls, Runnable runnable) {
        try {
            runnable.run();
        }
        catch (Counters.CountersExceededException e) {
            return;
        }
        Assert.fail((String)("Should've thrown " + ecls.getSimpleName()));
    }

    public static void main(String[] args) throws IOException {
        new TestCounters().testCounters();
    }

    @Test
    public void testFrameworkCounter() {
        GroupFactoryForTest groupFactory = new GroupFactoryForTest();
        CounterGroupFactory.FrameworkGroupFactory frameworkGroupFactory = groupFactory.newFrameworkGroupFactory(JobCounter.class);
        Counters.Group group = (Counters.Group)frameworkGroupFactory.newGroup("JobCounter");
        FrameworkCounterGroup counterGroup = (FrameworkCounterGroup)group.getUnderlyingGroup();
        Counter count1 = counterGroup.findCounter(JobCounter.NUM_FAILED_MAPS.toString());
        Assert.assertNotNull((Object)count1);
        Counter count2 = counterGroup.findCounter("Unknown");
        Assert.assertNull((Object)count2);
    }

    @Test
    public void testTaskCounter() {
        GroupFactoryForTest groupFactory = new GroupFactoryForTest();
        CounterGroupFactory.FrameworkGroupFactory frameworkGroupFactory = groupFactory.newFrameworkGroupFactory(TaskCounter.class);
        Counters.Group group = (Counters.Group)frameworkGroupFactory.newGroup("TaskCounter");
        FrameworkCounterGroup counterGroup = (FrameworkCounterGroup)group.getUnderlyingGroup();
        Counter count1 = counterGroup.findCounter(TaskCounter.PHYSICAL_MEMORY_BYTES.toString());
        Assert.assertNotNull((Object)count1);
        count1.increment(10L);
        count1.increment(10L);
        Assert.assertEquals((long)20L, (long)count1.getValue());
        Counter count2 = counterGroup.findCounter(TaskCounter.MAP_PHYSICAL_MEMORY_BYTES_MAX.toString());
        Assert.assertNotNull((Object)count2);
        count2.increment(5L);
        count2.increment(10L);
        Assert.assertEquals((long)10L, (long)count2.getValue());
    }

    @Test
    public void testFilesystemCounter() {
        GroupFactoryForTest groupFactory = new GroupFactoryForTest();
        Counters.Group fsGroup = groupFactory.newFileSystemGroup();
        Counters.Counter count1 = fsGroup.findCounter("ANY_BYTES_READ");
        Assert.assertNotNull((Object)count1);
        Counters.Counter count2 = fsGroup.findCounter("Unknown");
        Assert.assertNull((Object)count2);
    }

    static enum myCounters {
        TEST1,
        TEST2;

    }
}

