/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce;

import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.nio.ByteBuffer;
import org.apache.hadoop.io.DataInputByteBuffer;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.mapreduce.ID;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.junit.Assert;
import org.junit.Test;

public class TestTaskID {
    @Test
    public void testGetJobID() {
        JobID jobId = new JobID("1234", 0);
        TaskID taskId = new TaskID(jobId, TaskType.MAP, 0);
        Assert.assertSame((String)"TaskID did not store the JobID correctly", (Object)jobId, (Object)taskId.getJobID());
        taskId = new TaskID();
        Assert.assertEquals((String)"Job ID was set unexpectedly in default contsructor", (Object)"", (Object)taskId.getJobID().getJtIdentifier());
    }

    @Test
    public void testIsMap() {
        JobID jobId = new JobID("1234", 0);
        for (TaskType type : TaskType.values()) {
            TaskID taskId = new TaskID(jobId, type, 0);
            if (type == TaskType.MAP) {
                Assert.assertTrue((String)"TaskID for map task did not correctly identify itself as a map task", (boolean)taskId.isMap());
                continue;
            }
            Assert.assertFalse((String)("TaskID for " + type + " task incorrectly identified itself as a map task"), (boolean)taskId.isMap());
        }
        TaskID taskId = new TaskID();
        Assert.assertFalse((String)"TaskID of default type incorrectly identified itself as a map task", (boolean)taskId.isMap());
    }

    @Test
    public void testGetTaskType0args() {
        JobID jobId = new JobID("1234", 0);
        for (TaskType type : TaskType.values()) {
            TaskID taskId = new TaskID(jobId, type, 0);
            Assert.assertEquals((String)"TaskID incorrectly reported its type", (Object)type, (Object)taskId.getTaskType());
        }
        TaskID taskId = new TaskID();
        Assert.assertEquals((String)"TaskID of default type incorrectly reported its type", (Object)TaskType.REDUCE, (Object)taskId.getTaskType());
    }

    @Test
    public void testEquals() {
        JobID jobId1 = new JobID("1234", 1);
        JobID jobId2 = new JobID("2345", 2);
        TaskID taskId1 = new TaskID(jobId1, TaskType.MAP, 0);
        TaskID taskId2 = new TaskID(jobId1, TaskType.MAP, 0);
        Assert.assertTrue((String)"The equals() method reported two equal task IDs were not equal", (boolean)taskId1.equals((Object)taskId2));
        taskId2 = new TaskID(jobId2, TaskType.MAP, 0);
        Assert.assertFalse((String)"The equals() method reported two task IDs with different job IDs were equal", (boolean)taskId1.equals((Object)taskId2));
        taskId2 = new TaskID(jobId1, TaskType.MAP, 1);
        Assert.assertFalse((String)"The equals() method reported two task IDs with different IDs were equal", (boolean)taskId1.equals((Object)taskId2));
        TaskType[] types = TaskType.values();
        for (int i = 0; i < types.length; ++i) {
            for (int j = 0; j < types.length; ++j) {
                taskId1 = new TaskID(jobId1, types[i], 0);
                taskId2 = new TaskID(jobId1, types[j], 0);
                if (i == j) {
                    Assert.assertTrue((String)"The equals() method reported two equal task IDs were not equal", (boolean)taskId1.equals((Object)taskId2));
                    continue;
                }
                Assert.assertFalse((String)"The equals() method reported two task IDs with different types were equal", (boolean)taskId1.equals((Object)taskId2));
            }
        }
        Assert.assertFalse((String)"The equals() method matched against a JobID object", (boolean)taskId1.equals((Object)jobId1));
        Assert.assertFalse((String)"The equals() method matched against a null object", (boolean)taskId1.equals(null));
    }

    @Test
    public void testCompareTo() {
        JobID jobId = new JobID("1234", 1);
        TaskID taskId1 = new TaskID(jobId, TaskType.REDUCE, 0);
        TaskID taskId2 = new TaskID(jobId, TaskType.REDUCE, 0);
        Assert.assertEquals((String)"The compareTo() method returned non-zero for two equal task IDs", (long)0L, (long)taskId1.compareTo((ID)taskId2));
        taskId2 = new TaskID(jobId, TaskType.MAP, 1);
        Assert.assertTrue((String)"The compareTo() method did not weigh task type more than task ID", (taskId1.compareTo((ID)taskId2) > 0 ? 1 : 0) != 0);
        TaskType[] types = TaskType.values();
        for (int i = 0; i < types.length; ++i) {
            for (int j = 0; j < types.length; ++j) {
                taskId1 = new TaskID(jobId, types[i], 0);
                taskId2 = new TaskID(jobId, types[j], 0);
                if (i == j) {
                    Assert.assertEquals((String)"The compareTo() method returned non-zero for two equal task IDs", (long)0L, (long)taskId1.compareTo((ID)taskId2));
                    continue;
                }
                if (i < j) {
                    Assert.assertTrue((String)("The compareTo() method did not order " + types[i] + " before " + types[j]), (taskId1.compareTo((ID)taskId2) < 0 ? 1 : 0) != 0);
                    continue;
                }
                Assert.assertTrue((String)("The compareTo() method did not order " + types[i] + " after " + types[j]), (taskId1.compareTo((ID)taskId2) > 0 ? 1 : 0) != 0);
            }
        }
        try {
            taskId1.compareTo((ID)jobId);
            Assert.fail((String)"The compareTo() method allowed comparison to a JobID object");
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        try {
            taskId1.compareTo(null);
            Assert.fail((String)"The compareTo() method allowed comparison to a null object");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testToString() {
        JobID jobId = new JobID("1234", 1);
        for (TaskType type : TaskType.values()) {
            TaskID taskId = new TaskID(jobId, type, 0);
            String str = String.format("task_1234_0001_%c_000000", Character.valueOf(TaskID.getRepresentingCharacter((TaskType)type)));
            Assert.assertEquals((String)"The toString() method returned the wrong value", (Object)str, (Object)taskId.toString());
        }
    }

    @Test
    public void testAppendTo() {
        JobID jobId = new JobID("1234", 1);
        StringBuilder builder = new StringBuilder();
        for (TaskType type : TaskType.values()) {
            builder.setLength(0);
            TaskID taskId = new TaskID(jobId, type, 0);
            String str = String.format("_1234_0001_%c_000000", Character.valueOf(TaskID.getRepresentingCharacter((TaskType)type)));
            Assert.assertEquals((String)"The appendTo() method appended the wrong value", (Object)str, (Object)taskId.appendTo(builder).toString());
        }
        try {
            new TaskID().appendTo(null);
            Assert.fail((String)"The appendTo() method allowed a null builder");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testHashCode() {
        TaskType[] types = TaskType.values();
        for (int i = 0; i < types.length; ++i) {
            JobID jobId = new JobID("1234" + i, i);
            TaskID taskId1 = new TaskID(jobId, types[i], i);
            TaskID taskId2 = new TaskID(jobId, types[i], i);
            Assert.assertTrue((String)"The hashcode() method gave unequal hash codes for two equal task IDs", (taskId1.hashCode() == taskId2.hashCode() ? 1 : 0) != 0);
        }
    }

    @Test
    public void testReadFields() throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(baos);
        out.writeInt(0);
        out.writeInt(1);
        WritableUtils.writeVInt((DataOutput)out, (int)4);
        out.write(new byte[]{49, 50, 51, 52});
        WritableUtils.writeEnum((DataOutput)out, (Enum)TaskType.REDUCE);
        DataInputByteBuffer in = new DataInputByteBuffer();
        in.reset(new ByteBuffer[]{ByteBuffer.wrap(baos.toByteArray())});
        TaskID instance = new TaskID();
        instance.readFields((DataInput)in);
        Assert.assertEquals((String)"The readFields() method did not produce the expected task ID", (Object)"task_1234_0001_r_000000", (Object)instance.toString());
    }

    @Test
    public void testWrite() throws Exception {
        JobID jobId = new JobID("1234", 1);
        TaskID taskId = new TaskID(jobId, TaskType.JOB_SETUP, 0);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(baos);
        taskId.write((DataOutput)out);
        DataInputByteBuffer in = new DataInputByteBuffer();
        byte[] buffer = new byte[4];
        in.reset(new ByteBuffer[]{ByteBuffer.wrap(baos.toByteArray())});
        Assert.assertEquals((String)"The write() method did not write the expected task ID", (long)0L, (long)in.readInt());
        Assert.assertEquals((String)"The write() method did not write the expected job ID", (long)1L, (long)in.readInt());
        Assert.assertEquals((String)"The write() method did not write the expected job identifier length", (long)4L, (long)WritableUtils.readVInt((DataInput)in));
        in.readFully(buffer, 0, 4);
        Assert.assertEquals((String)"The write() method did not write the expected job identifier length", (Object)"1234", (Object)new String(buffer));
        Assert.assertEquals((String)"The write() method did not write the expected task type", (Object)TaskType.JOB_SETUP, (Object)WritableUtils.readEnum((DataInput)in, TaskType.class));
    }

    @Test
    public void testForName() {
        Assert.assertEquals((String)"The forName() method did not parse the task ID string correctly", (Object)"task_1_0001_m_000000", (Object)TaskID.forName((String)"task_1_0001_m_000").toString());
        Assert.assertEquals((String)"The forName() method did not parse the task ID string correctly", (Object)"task_23_0002_r_000001", (Object)TaskID.forName((String)"task_23_0002_r_0001").toString());
        Assert.assertEquals((String)"The forName() method did not parse the task ID string correctly", (Object)"task_345_0003_s_000002", (Object)TaskID.forName((String)"task_345_0003_s_00002").toString());
        Assert.assertEquals((String)"The forName() method did not parse the task ID string correctly", (Object)"task_6789_0004_c_000003", (Object)TaskID.forName((String)"task_6789_0004_c_000003").toString());
        Assert.assertEquals((String)"The forName() method did not parse the task ID string correctly", (Object)"task_12345_0005_t_4000000", (Object)TaskID.forName((String)"task_12345_0005_t_4000000").toString());
        try {
            TaskID.forName((String)"tisk_12345_0005_t_4000000");
            Assert.fail((String)"The forName() method parsed an invalid job ID: tisk_12345_0005_t_4000000");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            TaskID.forName((String)"tisk_12345_0005_t_4000000");
            Assert.fail((String)"The forName() method parsed an invalid job ID: tisk_12345_0005_t_4000000");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            TaskID.forName((String)"task_abc_0005_t_4000000");
            Assert.fail((String)"The forName() method parsed an invalid job ID: task_abc_0005_t_4000000");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            TaskID.forName((String)"task_12345_xyz_t_4000000");
            Assert.fail((String)"The forName() method parsed an invalid job ID: task_12345_xyz_t_4000000");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            TaskID.forName((String)"task_12345_0005_x_4000000");
            Assert.fail((String)"The forName() method parsed an invalid job ID: task_12345_0005_x_4000000");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            TaskID.forName((String)"task_12345_0005_t_jkl");
            Assert.fail((String)"The forName() method parsed an invalid job ID: task_12345_0005_t_jkl");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            TaskID.forName((String)"task_12345_0005_t");
            Assert.fail((String)"The forName() method parsed an invalid job ID: task_12345_0005_t");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            TaskID.forName((String)"task_12345_0005_4000000");
            Assert.fail((String)"The forName() method parsed an invalid job ID: task_12345_0005_4000000");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            TaskID.forName((String)"task_12345_t_4000000");
            Assert.fail((String)"The forName() method parsed an invalid job ID: task_12345_t_4000000");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            TaskID.forName((String)"12345_0005_t_4000000");
            Assert.fail((String)"The forName() method parsed an invalid job ID: 12345_0005_t_4000000");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testGetRepresentingCharacter() {
        Assert.assertEquals((String)"The getRepresentingCharacter() method did not return the expected character", (long)109L, (long)TaskID.getRepresentingCharacter((TaskType)TaskType.MAP));
        Assert.assertEquals((String)"The getRepresentingCharacter() method did not return the expected character", (long)114L, (long)TaskID.getRepresentingCharacter((TaskType)TaskType.REDUCE));
        Assert.assertEquals((String)"The getRepresentingCharacter() method did not return the expected character", (long)115L, (long)TaskID.getRepresentingCharacter((TaskType)TaskType.JOB_SETUP));
        Assert.assertEquals((String)"The getRepresentingCharacter() method did not return the expected character", (long)99L, (long)TaskID.getRepresentingCharacter((TaskType)TaskType.JOB_CLEANUP));
        Assert.assertEquals((String)"The getRepresentingCharacter() method did not return the expected character", (long)116L, (long)TaskID.getRepresentingCharacter((TaskType)TaskType.TASK_CLEANUP));
    }

    @Test
    public void testGetTaskTypeChar() {
        Assert.assertEquals((String)"The getTaskType() method did not return the expected type", (Object)TaskType.MAP, (Object)TaskID.getTaskType((char)'m'));
        Assert.assertEquals((String)"The getTaskType() method did not return the expected type", (Object)TaskType.REDUCE, (Object)TaskID.getTaskType((char)'r'));
        Assert.assertEquals((String)"The getTaskType() method did not return the expected type", (Object)TaskType.JOB_SETUP, (Object)TaskID.getTaskType((char)'s'));
        Assert.assertEquals((String)"The getTaskType() method did not return the expected type", (Object)TaskType.JOB_CLEANUP, (Object)TaskID.getTaskType((char)'c'));
        Assert.assertEquals((String)"The getTaskType() method did not return the expected type", (Object)TaskType.TASK_CLEANUP, (Object)TaskID.getTaskType((char)'t'));
        Assert.assertNull((String)"The getTaskType() method did not return null for an unknown type", (Object)TaskID.getTaskType((char)'x'));
    }

    @Test
    public void testGetAllTaskTypes() {
        Assert.assertEquals((String)"The getAllTaskTypes method did not return the expected string", (Object)"(m|r|s|c|t)", (Object)TaskID.getAllTaskTypes());
    }
}

