/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.hs;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.TypeConverter;
import org.apache.hadoop.mapreduce.jobhistory.JobHistoryParser;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskReport;
import org.apache.hadoop.mapreduce.v2.api.records.TaskState;
import org.apache.hadoop.mapreduce.v2.app.job.Task;
import org.apache.hadoop.mapreduce.v2.app.job.TaskAttempt;
import org.apache.hadoop.mapreduce.v2.hs.CompletedTaskAttempt;
import org.apache.hadoop.yarn.util.Records;

public class CompletedTask
implements Task {
    private static final Counters EMPTY_COUNTERS = new Counters();
    private final TaskId taskId;
    private final JobHistoryParser.TaskInfo taskInfo;
    private TaskReport report;
    private TaskAttemptId successfulAttempt;
    private List<String> reportDiagnostics = new LinkedList<String>();
    private Lock taskAttemptsLock = new ReentrantLock();
    private AtomicBoolean taskAttemptsLoaded = new AtomicBoolean(false);
    private final Map<TaskAttemptId, TaskAttempt> attempts = new LinkedHashMap<TaskAttemptId, TaskAttempt>();

    CompletedTask(TaskId taskId, JobHistoryParser.TaskInfo taskInfo) {
        this.taskInfo = taskInfo;
        this.taskId = taskId;
    }

    public boolean canCommit(TaskAttemptId taskAttemptID) {
        return false;
    }

    public TaskAttempt getAttempt(TaskAttemptId attemptID) {
        this.loadAllTaskAttempts();
        return this.attempts.get(attemptID);
    }

    public Map<TaskAttemptId, TaskAttempt> getAttempts() {
        this.loadAllTaskAttempts();
        return this.attempts;
    }

    public Counters getCounters() {
        return this.taskInfo.getCounters();
    }

    public TaskId getID() {
        return this.taskId;
    }

    public float getProgress() {
        return 1.0f;
    }

    public synchronized TaskReport getReport() {
        if (this.report == null) {
            this.constructTaskReport();
        }
        return this.report;
    }

    public org.apache.hadoop.mapreduce.v2.api.records.TaskType getType() {
        return TypeConverter.toYarn((TaskType)this.taskInfo.getTaskType());
    }

    public boolean isFinished() {
        return true;
    }

    public TaskState getState() {
        return this.taskInfo.getTaskStatus() == null ? TaskState.KILLED : TaskState.valueOf((String)this.taskInfo.getTaskStatus());
    }

    private void constructTaskReport() {
        this.loadAllTaskAttempts();
        this.report = (TaskReport)Records.newRecord(TaskReport.class);
        this.report.setTaskId(this.taskId);
        long minLaunchTime = Long.MAX_VALUE;
        for (TaskAttempt attempt : this.attempts.values()) {
            minLaunchTime = Math.min(minLaunchTime, attempt.getLaunchTime());
        }
        minLaunchTime = minLaunchTime == Long.MAX_VALUE ? -1L : minLaunchTime;
        this.report.setStartTime(minLaunchTime);
        this.report.setFinishTime(this.taskInfo.getFinishTime());
        this.report.setTaskState(this.getState());
        this.report.setProgress(this.getProgress());
        Counters counters = this.getCounters();
        if (counters == null) {
            counters = EMPTY_COUNTERS;
        }
        this.report.setRawCounters(counters);
        if (this.successfulAttempt != null) {
            this.report.setSuccessfulAttempt(this.successfulAttempt);
        }
        this.report.addAllDiagnostics(this.reportDiagnostics);
        this.report.addAllRunningAttempts(new ArrayList<TaskAttemptId>(this.attempts.keySet()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadAllTaskAttempts() {
        if (this.taskAttemptsLoaded.get()) {
            return;
        }
        this.taskAttemptsLock.lock();
        try {
            if (this.taskAttemptsLoaded.get()) {
                return;
            }
            for (JobHistoryParser.TaskAttemptInfo attemptHistory : this.taskInfo.getAllTaskAttempts().values()) {
                CompletedTaskAttempt attempt = new CompletedTaskAttempt(this.taskId, attemptHistory);
                this.reportDiagnostics.addAll(attempt.getDiagnostics());
                this.attempts.put(attempt.getID(), attempt);
                if (this.successfulAttempt != null || attemptHistory.getTaskStatus() == null || !attemptHistory.getTaskStatus().equals(TaskState.SUCCEEDED.toString())) continue;
                this.successfulAttempt = TypeConverter.toYarn((TaskAttemptID)attemptHistory.getAttemptId());
            }
            this.taskAttemptsLoaded.set(true);
        }
        finally {
            this.taskAttemptsLock.unlock();
        }
    }
}

