/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.server.namenode.ha.HopsRandomStickyFailoverProxyProvider;
import org.apache.hadoop.mapreduce.SleepJob;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.log4j.Level;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestLocalJobSubmission {
    private static Path TEST_ROOT_DIR = new Path(System.getProperty("test.build.data", "/tmp"));

    @Before
    public void configure() throws Exception {
    }

    private static void initLoggers() {
        ((Log4JLogger)HopsRandomStickyFailoverProxyProvider.LOG).getLogger().setLevel(Level.ALL);
    }

    @After
    public void cleanup() {
    }

    @Test
    public void testLocalJobLibjarsOption() throws IOException {
        TestLocalJobSubmission.initLoggers();
        Path jarPath = this.makeJar(new Path(TEST_ROOT_DIR, "test.jar"));
        Configuration conf = new Configuration();
        conf.set("fs.defaultFS", "hdfs://localhost:9000");
        conf.set("mapreduce.framework.name", "local");
        conf.setInt("dfs.client.failover.max.attempts", 1);
        conf.set("dfs.client.retry.policy.spec", "1,1");
        String[] args = new String[]{"-jt", "local", "-libjars", jarPath.toString(), "-m", "1", "-r", "1", "-mt", "1", "-rt", "1"};
        int res = -1;
        try {
            res = ToolRunner.run((Configuration)conf, (Tool)new SleepJob(), (String[])args);
        }
        catch (Exception e) {
            System.out.println("Job failed with " + e.getLocalizedMessage());
            e.printStackTrace(System.out);
            Assert.fail((String)"Job failed");
        }
        Assert.assertEquals((String)"dist job res is not 0:", (long)0L, (long)res);
    }

    @Test
    public void testLocalJobEncryptedIntermediateData() throws IOException {
        Configuration conf = new Configuration();
        conf.set("mapreduce.framework.name", "local");
        conf.setBoolean("mapreduce.job.encrypted-intermediate-data", true);
        String[] args = new String[]{"-m", "1", "-r", "1", "-mt", "1", "-rt", "1"};
        int res = -1;
        try {
            res = ToolRunner.run((Configuration)conf, (Tool)new SleepJob(), (String[])args);
        }
        catch (Exception e) {
            System.out.println("Job failed with " + e.getLocalizedMessage());
            e.printStackTrace(System.out);
            Assert.fail((String)"Job failed");
        }
        Assert.assertEquals((String)"dist job res is not 0:", (long)0L, (long)res);
    }

    private Path makeJar(Path p) throws IOException {
        FileOutputStream fos = new FileOutputStream(new File(p.toString()));
        JarOutputStream jos = new JarOutputStream(fos);
        ZipEntry ze = new ZipEntry("test.jar.inside");
        jos.putNextEntry(ze);
        jos.write("inside the jar!".getBytes());
        jos.closeEntry();
        jos.close();
        return p;
    }
}

