/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.File;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.NNBench;
import org.apache.hadoop.mapred.HadoopTestCase;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class TestNNBench
extends HadoopTestCase {
    private static final String BASE_DIR = new File(System.getProperty("test.build.data", "build/test/data"), "NNBench").getAbsolutePath();

    public TestNNBench() throws IOException {
        super(1, 4, 1, 1);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.getFileSystem().delete(new Path(BASE_DIR), true);
        this.getFileSystem().delete(new Path("NNBench_results.log"), true);
        super.tearDown();
    }

    @Test(timeout=30000L)
    public void testNNBenchCreateReadAndDelete() throws Exception {
        this.runNNBench((Configuration)this.createJobConf(), "create_write");
        Path path = new Path(BASE_DIR + "/data/file_0_0");
        Assert.assertTrue((String)"create_write should create the file", (boolean)this.getFileSystem().exists(path));
        this.runNNBench((Configuration)this.createJobConf(), "open_read");
        this.runNNBench((Configuration)this.createJobConf(), "delete");
        Assert.assertFalse((String)"Delete operation should delete the file", (boolean)this.getFileSystem().exists(path));
    }

    @Test(timeout=30000L)
    public void testNNBenchCreateAndRename() throws Exception {
        this.runNNBench((Configuration)this.createJobConf(), "create_write");
        Path path = new Path(BASE_DIR + "/data/file_0_0");
        Assert.assertTrue((String)"create_write should create the file", (boolean)this.getFileSystem().exists(path));
        this.runNNBench((Configuration)this.createJobConf(), "rename");
        Path renamedPath = new Path(BASE_DIR + "/data/file_0_r_0");
        Assert.assertFalse((String)"Rename should rename the file", (boolean)this.getFileSystem().exists(path));
        Assert.assertTrue((String)"Rename should rename the file", (boolean)this.getFileSystem().exists(renamedPath));
    }

    private void runNNBench(Configuration conf, String operation) throws Exception {
        String[] genArgs = new String[]{"-operation", operation, "-baseDir", BASE_DIR, "-startTime", "" + (Time.now() / 1000L + 3L)};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Configuration)conf, (Tool)new NNBench(), (String[])genArgs));
    }
}

