/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.mapred.Utils;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.LazyOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.junit.Assert;
import org.junit.Test;

public class TestMapReduceLazyOutput {
    private static final int NUM_HADOOP_WORKERS = 3;
    private static final int NUM_MAPS_PER_NODE = 2;
    private static final Path INPUTPATH = new Path("/testlazy/input");
    private static final List<String> INPUTLIST = Arrays.asList("All", "Roads", "Lead", "To", "Hadoop");

    private static void runTestLazyOutput(Configuration conf, Path output, int numReducers, boolean createLazily) throws Exception {
        Job job = Job.getInstance((Configuration)conf, (String)"Test-Lazy-Output");
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{INPUTPATH});
        FileOutputFormat.setOutputPath((Job)job, (Path)output);
        job.setJarByClass(TestMapReduceLazyOutput.class);
        job.setInputFormatClass(TextInputFormat.class);
        job.setOutputKeyClass(LongWritable.class);
        job.setOutputValueClass(Text.class);
        job.setNumReduceTasks(numReducers);
        job.setMapperClass(TestMapper.class);
        job.setReducerClass(TestReducer.class);
        if (createLazily) {
            LazyOutputFormat.setOutputFormatClass((Job)job, TextOutputFormat.class);
        } else {
            job.setOutputFormatClass(TextOutputFormat.class);
        }
        Assert.assertTrue((boolean)job.waitForCompletion(true));
    }

    public void createInput(FileSystem fs, int numMappers) throws Exception {
        for (int i = 0; i < numMappers; ++i) {
            FSDataOutputStream os = fs.create(new Path(INPUTPATH, "text" + i + ".txt"));
            OutputStreamWriter wr = new OutputStreamWriter((OutputStream)os);
            for (String inp : INPUTLIST) {
                wr.write(inp + "\n");
            }
            ((Writer)wr).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLazyOutput() throws Exception {
        MiniDFSCluster dfs = null;
        MiniMRCluster mr = null;
        DistributedFileSystem fileSys = null;
        try {
            Configuration conf = new Configuration();
            dfs = new MiniDFSCluster.Builder(conf).numDataNodes(3).build();
            fileSys = dfs.getFileSystem();
            mr = new MiniMRCluster(3, fileSys.getUri().toString(), 1, false);
            int numReducers = 2;
            int numMappers = 6;
            this.createInput((FileSystem)fileSys, numMappers);
            Path output1 = new Path("/testlazy/output1");
            TestMapReduceLazyOutput.runTestLazyOutput((Configuration)mr.createJobConf(), output1, numReducers, true);
            Path[] fileList = FileUtil.stat2Paths((FileStatus[])fileSys.listStatus(output1, (PathFilter)new Utils.OutputFileUtils.OutputFilesFilter()));
            for (int i = 0; i < fileList.length; ++i) {
                System.out.println("Test1 File list[" + i + "]: " + fileList[i]);
            }
            Assert.assertTrue((fileList.length == numReducers - 1 ? 1 : 0) != 0);
            Path output2 = new Path("/testlazy/output2");
            TestMapReduceLazyOutput.runTestLazyOutput((Configuration)mr.createJobConf(), output2, 0, true);
            fileList = FileUtil.stat2Paths((FileStatus[])fileSys.listStatus(output2, (PathFilter)new Utils.OutputFileUtils.OutputFilesFilter()));
            for (int i = 0; i < fileList.length; ++i) {
                System.out.println("Test2 File list[" + i + "]: " + fileList[i]);
            }
            Assert.assertTrue((fileList.length == numMappers - 1 ? 1 : 0) != 0);
            Path output3 = new Path("/testlazy/output3");
            TestMapReduceLazyOutput.runTestLazyOutput((Configuration)mr.createJobConf(), output3, 0, false);
            fileList = FileUtil.stat2Paths((FileStatus[])fileSys.listStatus(output3, (PathFilter)new Utils.OutputFileUtils.OutputFilesFilter()));
            for (int i = 0; i < fileList.length; ++i) {
                System.out.println("Test3 File list[" + i + "]: " + fileList[i]);
            }
            Assert.assertTrue((fileList.length == numMappers ? 1 : 0) != 0);
        }
        finally {
            if (dfs != null) {
                dfs.shutdown();
            }
            if (mr != null) {
                mr.shutdown();
            }
        }
    }

    public static class TestReducer
    extends Reducer<LongWritable, Text, LongWritable, Text> {
        public void reduce(LongWritable key, Iterable<Text> values, Reducer.Context context) throws IOException, InterruptedException {
            String id = context.getTaskAttemptID().toString();
            if (!id.endsWith("0_0")) {
                for (Text val : values) {
                    context.write((Object)key, (Object)val);
                }
            }
        }
    }

    public static class TestMapper
    extends Mapper<LongWritable, Text, LongWritable, Text> {
        public void map(LongWritable key, Text value, Mapper.Context context) throws IOException, InterruptedException {
            String id = context.getTaskAttemptID().toString();
            if (!id.endsWith("0_0")) {
                context.write((Object)key, (Object)value);
            }
        }
    }
}

