/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.util.Arrays;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.mapred.ClusterMapReduceTestCase;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.Cluster;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobPriority;
import org.apache.hadoop.mapreduce.JobSubmissionFiles;
import org.apache.hadoop.mapreduce.MapReduceTestUtil;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.apache.hadoop.mapreduce.tools.CLI;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestMRJobClient
extends ClusterMapReduceTestCase {
    private static final Logger LOG = LoggerFactory.getLogger(TestMRJobClient.class);

    private Job runJob(Configuration conf) throws Exception {
        String input = "hello1\nhello2\nhello3\n";
        Job job = MapReduceTestUtil.createJob(conf, this.getInputDir(), this.getOutputDir(), 1, 1, input);
        job.setJobName("mr");
        job.setPriority(JobPriority.NORMAL);
        job.waitForCompletion(true);
        return job;
    }

    private Job runJobInBackGround(Configuration conf) throws Exception {
        String input = "hello1\nhello2\nhello3\n";
        Job job = MapReduceTestUtil.createJob(conf, this.getInputDir(), this.getOutputDir(), 1, 1, input);
        job.setJobName("mr");
        job.setPriority(JobPriority.NORMAL);
        job.submit();
        int i = 0;
        while (i++ < 200 && job.getJobID() == null) {
            LOG.info("waiting for jobId...");
            Thread.sleep(100L);
        }
        return job;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int runTool(Configuration conf, Tool tool, String[] args, OutputStream out) throws Exception {
        LOG.info("args = " + Arrays.toString(args));
        PrintStream oldOut = System.out;
        PrintStream newOut = new PrintStream(out, true);
        try {
            System.setOut(newOut);
            int n = ToolRunner.run((Configuration)conf, (Tool)tool, (String[])args);
            return n;
        }
        finally {
            System.setOut(oldOut);
        }
    }

    @Test
    public void testJobSubmissionSpecsAndFiles() throws Exception {
        JobConf conf = this.createJobConf();
        Job job = MapReduceTestUtil.createJob((Configuration)conf, this.getInputDir(), this.getOutputDir(), 1, 1);
        job.setOutputFormatClass(BadOutputFormat.class);
        try {
            job.submit();
            Assert.fail((String)"Should've thrown an exception while checking output specs.");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IOException));
        }
        Cluster cluster = new Cluster((Configuration)conf);
        Path jobStagingArea = JobSubmissionFiles.getStagingDir((Cluster)cluster, (Configuration)job.getConfiguration());
        Path submitJobDir = new Path(jobStagingArea, "JobId");
        Path submitJobFile = JobSubmissionFiles.getJobConfPath((Path)submitJobDir);
        Assert.assertFalse((String)"Shouldn't have created a job file if job specs failed.", (boolean)FileSystem.get((Configuration)conf).exists(submitJobFile));
    }

    @Test
    public void testJobClient() throws Exception {
        JobConf conf = this.createJobConf();
        Job job = this.runJob((Configuration)conf);
        String jobId = job.getJobID().toString();
        this.testAllJobList(jobId, (Configuration)conf);
        this.testSubmittedJobList((Configuration)conf);
        this.testGetCounter(jobId, (Configuration)conf);
        this.testJobStatus(jobId, (Configuration)conf);
        this.testJobEvents(jobId, (Configuration)conf);
        this.testJobHistory(jobId, (Configuration)conf);
        this.testListTrackers((Configuration)conf);
        this.testListAttemptIds(jobId, (Configuration)conf);
        this.testListBlackList((Configuration)conf);
        this.startStop();
        this.testChangingJobPriority(jobId, (Configuration)conf);
        this.testSubmit((Configuration)conf);
        this.testKillTask((Configuration)conf);
        this.testfailTask((Configuration)conf);
        this.testKillJob((Configuration)conf);
        this.testConfig(jobId, (Configuration)conf);
    }

    private void testfailTask(Configuration conf) throws Exception {
        Job job = this.runJobInBackGround(conf);
        CLI jc = this.createJobClient();
        TaskID tid = new TaskID(job.getJobID(), TaskType.MAP, 0);
        TaskAttemptID taid = new TaskAttemptID(tid, 1);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int exitCode = TestMRJobClient.runTool(conf, (Tool)jc, new String[]{"-fail-task"}, out);
        Assert.assertEquals((String)"Exit code", (long)-1L, (long)exitCode);
        TestMRJobClient.runTool(conf, (Tool)jc, new String[]{"-fail-task", taid.toString()}, out);
        String answer = new String(out.toByteArray(), "UTF-8");
        Assert.assertTrue((boolean)answer.contains("Killed task " + taid + " by failing it"));
    }

    private void testKillTask(Configuration conf) throws Exception {
        Job job = this.runJobInBackGround(conf);
        CLI jc = this.createJobClient();
        TaskID tid = new TaskID(job.getJobID(), TaskType.MAP, 0);
        TaskAttemptID taid = new TaskAttemptID(tid, 1);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int exitCode = TestMRJobClient.runTool(conf, (Tool)jc, new String[]{"-kill-task"}, out);
        Assert.assertEquals((String)"Exit code", (long)-1L, (long)exitCode);
        TestMRJobClient.runTool(conf, (Tool)jc, new String[]{"-kill-task", taid.toString()}, out);
        String answer = new String(out.toByteArray(), "UTF-8");
        Assert.assertTrue((boolean)answer.contains("Killed task " + taid));
    }

    private void testKillJob(Configuration conf) throws Exception {
        Job job = this.runJobInBackGround(conf);
        String jobId = job.getJobID().toString();
        CLI jc = this.createJobClient();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int exitCode = TestMRJobClient.runTool(conf, (Tool)jc, new String[]{"-kill"}, out);
        Assert.assertEquals((String)"Exit code", (long)-1L, (long)exitCode);
        exitCode = TestMRJobClient.runTool(conf, (Tool)jc, new String[]{"-kill", jobId}, out);
        Assert.assertEquals((String)"Exit code", (long)0L, (long)exitCode);
        String answer = new String(out.toByteArray(), "UTF-8");
        Assert.assertTrue((boolean)answer.contains("Killed job " + jobId));
    }

    private void testSubmit(Configuration conf) throws Exception {
        CLI jc = this.createJobClient();
        Job job = MapReduceTestUtil.createJob(conf, this.getInputDir(), this.getOutputDir(), 1, 1, "ping");
        job.setJobName("mr");
        job.setPriority(JobPriority.NORMAL);
        File fcon = File.createTempFile("config", ".xml");
        LocalFileSystem localFs = FileSystem.getLocal((Configuration)conf);
        String fconUri = new Path(fcon.getAbsolutePath()).makeQualified(localFs.getUri(), localFs.getWorkingDirectory()).toUri().toString();
        job.getConfiguration().writeXml((OutputStream)new FileOutputStream(fcon));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int exitCode = TestMRJobClient.runTool(conf, (Tool)jc, new String[]{"-submit"}, out);
        Assert.assertEquals((String)"Exit code", (long)-1L, (long)exitCode);
        exitCode = TestMRJobClient.runTool(conf, (Tool)jc, new String[]{"-submit", fconUri}, out);
        Assert.assertEquals((String)"Exit code", (long)0L, (long)exitCode);
        String answer = new String(out.toByteArray());
        Assert.assertTrue((boolean)answer.contains("Created job "));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startStop() {
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        PrintStream error = System.err;
        System.setErr(new PrintStream(data));
        ExitUtil.disableSystemExit();
        try {
            CLI.main((String[])new String[0]);
            Assert.fail((String)" CLI.main should call System.exit");
        }
        catch (ExitUtil.ExitException e) {
            ExitUtil.resetFirstExitException();
            Assert.assertEquals((long)-1L, (long)e.status);
        }
        catch (Exception e) {
        }
        finally {
            System.setErr(error);
        }
        String s = new String(data.toByteArray());
        Assert.assertTrue((boolean)s.contains("-submit"));
        Assert.assertTrue((boolean)s.contains("-status"));
        Assert.assertTrue((boolean)s.contains("-kill"));
        Assert.assertTrue((boolean)s.contains("-set-priority"));
        Assert.assertTrue((boolean)s.contains("-events"));
        Assert.assertTrue((boolean)s.contains("-history"));
        Assert.assertTrue((boolean)s.contains("-list"));
        Assert.assertTrue((boolean)s.contains("-list-active-trackers"));
        Assert.assertTrue((boolean)s.contains("-list-blacklisted-trackers"));
        Assert.assertTrue((boolean)s.contains("-list-attempt-ids"));
        Assert.assertTrue((boolean)s.contains("-kill-task"));
        Assert.assertTrue((boolean)s.contains("-fail-task"));
        Assert.assertTrue((boolean)s.contains("-logs"));
    }

    private void testListBlackList(Configuration conf) throws Exception {
        String line;
        CLI jc = this.createJobClient();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int exitCode = TestMRJobClient.runTool(conf, (Tool)jc, new String[]{"-list-blacklisted-trackers", "second in"}, out);
        Assert.assertEquals((String)"Exit code", (long)-1L, (long)exitCode);
        exitCode = TestMRJobClient.runTool(conf, (Tool)jc, new String[]{"-list-blacklisted-trackers"}, out);
        Assert.assertEquals((String)"Exit code", (long)0L, (long)exitCode);
        BufferedReader br = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(out.toByteArray())));
        int counter = 0;
        while ((line = br.readLine()) != null) {
            LOG.info("line = " + line);
            ++counter;
        }
        Assert.assertEquals((long)0L, (long)counter);
    }

    private void testListAttemptIds(String jobId, Configuration conf) throws Exception {
        String line;
        CLI jc = this.createJobClient();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int exitCode = TestMRJobClient.runTool(conf, (Tool)jc, new String[]{"-list-attempt-ids"}, out);
        Assert.assertEquals((String)"Exit code", (long)-1L, (long)exitCode);
        exitCode = TestMRJobClient.runTool(conf, (Tool)jc, new String[]{"-list-attempt-ids", jobId, "MAP", "completed"}, out);
        Assert.assertEquals((String)"Exit code", (long)0L, (long)exitCode);
        BufferedReader br = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(out.toByteArray())));
        int counter = 0;
        while ((line = br.readLine()) != null) {
            LOG.info("line = " + line);
            ++counter;
        }
        Assert.assertEquals((long)1L, (long)counter);
    }

    private void testListTrackers(Configuration conf) throws Exception {
        String line;
        CLI jc = this.createJobClient();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int exitCode = TestMRJobClient.runTool(conf, (Tool)jc, new String[]{"-list-active-trackers", "second parameter"}, out);
        Assert.assertEquals((String)"Exit code", (long)-1L, (long)exitCode);
        exitCode = TestMRJobClient.runTool(conf, (Tool)jc, new String[]{"-list-active-trackers"}, out);
        Assert.assertEquals((String)"Exit code", (long)0L, (long)exitCode);
        BufferedReader br = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(out.toByteArray())));
        int counter = 0;
        while ((line = br.readLine()) != null) {
            LOG.info("line = " + line);
            ++counter;
        }
        Assert.assertEquals((long)2L, (long)counter);
    }

    private void testJobHistory(String jobId, Configuration conf) throws Exception {
        CLI jc = this.createJobClient();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        String historyFileUri = null;
        RemoteIterator it = this.getFileSystem().listFiles(new Path("/"), true);
        while (it.hasNext() && historyFileUri == null) {
            LocatedFileStatus file = (LocatedFileStatus)it.next();
            if (!file.getPath().getName().endsWith(".jhist")) continue;
            historyFileUri = file.getPath().toUri().toString();
        }
        Assert.assertNotNull((String)"Could not find jhist file", historyFileUri);
        for (String historyFileOrJobId : new String[]{historyFileUri, jobId}) {
            int exitCode = TestMRJobClient.runTool(conf, (Tool)jc, new String[]{"-history", "all", historyFileOrJobId}, out);
            Assert.assertEquals((String)"Exit code", (long)0L, (long)exitCode);
            this.checkHistoryHumanOutput(jobId, out);
            File outFile = File.createTempFile("myout", ".txt");
            exitCode = TestMRJobClient.runTool(conf, (Tool)jc, new String[]{"-history", "all", historyFileOrJobId, "-outfile", outFile.getAbsolutePath()}, out);
            Assert.assertEquals((String)"Exit code", (long)0L, (long)exitCode);
            this.checkHistoryHumanFileOutput(jobId, out, outFile);
            outFile = File.createTempFile("myout", ".txt");
            exitCode = TestMRJobClient.runTool(conf, (Tool)jc, new String[]{"-history", "all", historyFileOrJobId, "-outfile", outFile.getAbsolutePath(), "-format", "human"}, out);
            Assert.assertEquals((String)"Exit code", (long)0L, (long)exitCode);
            this.checkHistoryHumanFileOutput(jobId, out, outFile);
            exitCode = TestMRJobClient.runTool(conf, (Tool)jc, new String[]{"-history", historyFileOrJobId, "-format", "human"}, out);
            Assert.assertEquals((String)"Exit code", (long)0L, (long)exitCode);
            this.checkHistoryHumanOutput(jobId, out);
            exitCode = TestMRJobClient.runTool(conf, (Tool)jc, new String[]{"-history", "all", historyFileOrJobId, "-format", "json"}, out);
            Assert.assertEquals((String)"Exit code", (long)0L, (long)exitCode);
            this.checkHistoryJSONOutput(jobId, out);
            outFile = File.createTempFile("myout", ".txt");
            exitCode = TestMRJobClient.runTool(conf, (Tool)jc, new String[]{"-history", "all", historyFileOrJobId, "-outfile", outFile.getAbsolutePath(), "-format", "json"}, out);
            Assert.assertEquals((String)"Exit code", (long)0L, (long)exitCode);
            this.checkHistoryJSONFileOutput(jobId, out, outFile);
            exitCode = TestMRJobClient.runTool(conf, (Tool)jc, new String[]{"-history", historyFileOrJobId, "-format", "json"}, out);
            Assert.assertEquals((String)"Exit code", (long)0L, (long)exitCode);
            this.checkHistoryJSONOutput(jobId, out);
            exitCode = TestMRJobClient.runTool(conf, (Tool)jc, new String[]{"-history", historyFileOrJobId, "foo"}, out);
            Assert.assertEquals((String)"Exit code", (long)-1L, (long)exitCode);
            exitCode = TestMRJobClient.runTool(conf, (Tool)jc, new String[]{"-history", historyFileOrJobId, "-format"}, out);
            Assert.assertEquals((String)"Exit code", (long)-1L, (long)exitCode);
            exitCode = TestMRJobClient.runTool(conf, (Tool)jc, new String[]{"-history", historyFileOrJobId, "-outfile"}, out);
            Assert.assertEquals((String)"Exit code", (long)-1L, (long)exitCode);
            try {
                TestMRJobClient.runTool(conf, (Tool)jc, new String[]{"-history", historyFileOrJobId, "-format", "foo"}, out);
                Assert.fail();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        try {
            TestMRJobClient.runTool(conf, (Tool)jc, new String[]{"-history", "not_a_valid_history_file_or_job_id"}, out);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void checkHistoryHumanOutput(String jobId, ByteArrayOutputStream out) throws IOException, JSONException {
        BufferedReader br = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(out.toByteArray())));
        br.readLine();
        String line = br.readLine();
        br.close();
        Assert.assertEquals((Object)("Hadoop job: " + jobId), (Object)line);
        out.reset();
    }

    private void checkHistoryJSONOutput(String jobId, ByteArrayOutputStream out) throws IOException, JSONException {
        BufferedReader br = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(out.toByteArray())));
        String line = IOUtils.toString((Reader)br);
        br.close();
        JSONObject json = new JSONObject(line);
        Assert.assertEquals((Object)jobId, (Object)json.getString("hadoopJob"));
        out.reset();
    }

    private void checkHistoryHumanFileOutput(String jobId, ByteArrayOutputStream out, File outFile) throws IOException, JSONException {
        BufferedReader br = new BufferedReader(new FileReader(outFile));
        br.readLine();
        String line = br.readLine();
        br.close();
        Assert.assertEquals((Object)("Hadoop job: " + jobId), (Object)line);
        Assert.assertEquals((long)0L, (long)out.size());
    }

    private void checkHistoryJSONFileOutput(String jobId, ByteArrayOutputStream out, File outFile) throws IOException, JSONException {
        BufferedReader br = new BufferedReader(new FileReader(outFile));
        String line = IOUtils.toString((Reader)br);
        br.close();
        JSONObject json = new JSONObject(line);
        Assert.assertEquals((Object)jobId, (Object)json.getString("hadoopJob"));
        Assert.assertEquals((long)0L, (long)out.size());
    }

    private void testConfig(String jobId, Configuration conf) throws Exception {
        CLI jc = this.createJobClient();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int exitCode = TestMRJobClient.runTool(conf, (Tool)jc, new String[]{"-config"}, out);
        Assert.assertEquals((String)"Exit code", (long)-1L, (long)exitCode);
        exitCode = TestMRJobClient.runTool(conf, (Tool)jc, new String[]{"-config job_invalid foo.xml"}, out);
        Assert.assertEquals((String)"Exit code", (long)-1L, (long)exitCode);
        File outFile = File.createTempFile("config", ".xml");
        exitCode = TestMRJobClient.runTool(conf, (Tool)jc, new String[]{"-config", jobId, outFile.toString()}, out);
        Assert.assertEquals((String)"Exit code", (long)0L, (long)exitCode);
        BufferedReader br = new BufferedReader(new FileReader(outFile));
        String line = br.readLine();
        br.close();
        Assert.assertEquals((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?><configuration>", (Object)line);
    }

    private void testJobEvents(String jobId, Configuration conf) throws Exception {
        String line;
        CLI jc = this.createJobClient();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int exitCode = TestMRJobClient.runTool(conf, (Tool)jc, new String[]{"-events"}, out);
        Assert.assertEquals((String)"Exit code", (long)-1L, (long)exitCode);
        exitCode = TestMRJobClient.runTool(conf, (Tool)jc, new String[]{"-events", jobId, "0", "100"}, out);
        Assert.assertEquals((String)"Exit code", (long)0L, (long)exitCode);
        BufferedReader br = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(out.toByteArray())));
        int counter = 0;
        String attemptId = "attempt" + jobId.substring(3);
        while ((line = br.readLine()) != null) {
            LOG.info("line = " + line);
            if (!line.contains(attemptId)) continue;
            ++counter;
        }
        Assert.assertEquals((long)2L, (long)counter);
    }

    private void testJobStatus(String jobId, Configuration conf) throws Exception {
        String line;
        CLI jc = this.createJobClient();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int exitCode = TestMRJobClient.runTool(conf, (Tool)jc, new String[]{"-status"}, out);
        Assert.assertEquals((String)"Exit code", (long)-1L, (long)exitCode);
        exitCode = TestMRJobClient.runTool(conf, (Tool)jc, new String[]{"-status", jobId}, out);
        Assert.assertEquals((String)"Exit code", (long)0L, (long)exitCode);
        BufferedReader br = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(out.toByteArray())));
        while ((line = br.readLine()) != null) {
            LOG.info("line = " + line);
            if (!line.contains("Job state:")) continue;
        }
        Assert.assertNotNull((Object)line);
        Assert.assertTrue((boolean)line.contains("SUCCEEDED"));
    }

    public void testGetCounter(String jobId, Configuration conf) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int exitCode = TestMRJobClient.runTool(conf, (Tool)this.createJobClient(), new String[]{"-counter"}, out);
        Assert.assertEquals((String)"Exit code", (long)-1L, (long)exitCode);
        exitCode = TestMRJobClient.runTool(conf, (Tool)this.createJobClient(), new String[]{"-counter", jobId, "org.apache.hadoop.mapreduce.TaskCounter", "MAP_INPUT_RECORDS"}, out);
        Assert.assertEquals((String)"Exit code", (long)0L, (long)exitCode);
        Assert.assertEquals((String)"Counter", (Object)"3", (Object)out.toString().trim());
    }

    protected void testAllJobList(String jobId, Configuration conf) throws Exception {
        String line;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int exitCode = TestMRJobClient.runTool(conf, (Tool)this.createJobClient(), new String[]{"-list", "alldata"}, out);
        Assert.assertEquals((String)"Exit code", (long)-1L, (long)exitCode);
        exitCode = TestMRJobClient.runTool(conf, (Tool)this.createJobClient(), new String[]{"-list", "all"}, out);
        Assert.assertEquals((String)"Exit code", (long)0L, (long)exitCode);
        BufferedReader br = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(out.toByteArray())));
        int counter = 0;
        while ((line = br.readLine()) != null) {
            LOG.info("line = " + line);
            if (!line.contains(jobId)) continue;
            ++counter;
        }
        Assert.assertEquals((long)1L, (long)counter);
        out.reset();
    }

    protected void testSubmittedJobList(Configuration conf) throws Exception {
        String line;
        Job job = this.runJobInBackGround(conf);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int counter = 0;
        int exitCode = TestMRJobClient.runTool(conf, (Tool)this.createJobClient(), new String[]{"-list"}, out);
        Assert.assertEquals((String)"Exit code", (long)0L, (long)exitCode);
        BufferedReader br = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(out.toByteArray())));
        counter = 0;
        while ((line = br.readLine()) != null) {
            LOG.info("line = " + line);
            if (!line.contains(job.getJobID().toString())) continue;
            ++counter;
        }
        Assert.assertEquals((long)1L, (long)counter);
    }

    protected void verifyJobPriority(String jobId, String priority, Configuration conf, CLI jc) throws Exception {
        String line;
        PipedInputStream pis = new PipedInputStream();
        PipedOutputStream pos = new PipedOutputStream(pis);
        int exitCode = TestMRJobClient.runTool(conf, (Tool)jc, new String[]{"-list", "all"}, pos);
        Assert.assertEquals((String)"Exit code", (long)0L, (long)exitCode);
        BufferedReader br = new BufferedReader(new InputStreamReader(pis));
        while ((line = br.readLine()) != null) {
            LOG.info("line = " + line);
            if (!line.contains(jobId)) continue;
            Assert.assertTrue((boolean)line.contains(priority));
            break;
        }
        pis.close();
    }

    public void testChangingJobPriority(String jobId, Configuration conf) throws Exception {
        int exitCode = TestMRJobClient.runTool(conf, (Tool)this.createJobClient(), new String[]{"-set-priority"}, new ByteArrayOutputStream());
        Assert.assertEquals((String)"Exit code", (long)-1L, (long)exitCode);
        exitCode = TestMRJobClient.runTool(conf, (Tool)this.createJobClient(), new String[]{"-set-priority", jobId, "VERY_LOW"}, new ByteArrayOutputStream());
        Assert.assertEquals((String)"Exit code", (long)0L, (long)exitCode);
        this.verifyJobPriority(jobId, "DEFAULT", conf, this.createJobClient());
    }

    @Test
    public void testJobName() throws Exception {
        JobConf conf = this.createJobConf();
        CLI jc = this.createJobClient();
        Job job = MapReduceTestUtil.createJob((Configuration)conf, this.getInputDir(), this.getOutputDir(), 1, 1, "short_name");
        job.setJobName("mapreduce");
        job.setPriority(JobPriority.NORMAL);
        job.waitForCompletion(true);
        String jobId = job.getJobID().toString();
        this.verifyJobName(jobId, "mapreduce", (Configuration)conf, jc);
        Job job2 = MapReduceTestUtil.createJob((Configuration)conf, this.getInputDir(), this.getOutputDir(), 1, 1, "long_name");
        job2.setJobName("mapreduce_job_with_long_name");
        job2.setPriority(JobPriority.NORMAL);
        job2.waitForCompletion(true);
        jobId = job2.getJobID().toString();
        this.verifyJobName(jobId, "mapreduce_job_with_l", (Configuration)conf, jc);
    }

    protected void verifyJobName(String jobId, String name, Configuration conf, CLI jc) throws Exception {
        PipedInputStream pis = new PipedInputStream();
        PipedOutputStream pos = new PipedOutputStream(pis);
        int exitCode = TestMRJobClient.runTool(conf, (Tool)jc, new String[]{"-list", "all"}, pos);
        Assert.assertEquals((String)"Exit code", (long)0L, (long)exitCode);
        BufferedReader br = new BufferedReader(new InputStreamReader(pis));
        String line = null;
        while ((line = br.readLine()) != null) {
            LOG.info("line = " + line);
            if (!line.contains(jobId)) continue;
            Assert.assertTrue((boolean)line.contains(name));
            break;
        }
        pis.close();
    }

    protected CLI createJobClient() throws IOException {
        return new CLI();
    }

    private static class BadOutputFormat
    extends TextOutputFormat<Object, Object> {
        private BadOutputFormat() {
        }

        public void checkOutputSpecs(JobContext job) throws IOException {
            throw new IOException();
        }
    }
}

