/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.maven.plugin.shade.resource;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.apache.maven.plugins.shade.relocation.Relocator;
import org.apache.maven.plugins.shade.resource.ResourceTransformer;
import org.codehaus.plexus.util.IOUtil;

public class ServicesResourceTransformer
implements ResourceTransformer {
    private static final String SERVICES_PATH = "META-INF/services";
    private Map<String, ServiceStream> serviceEntries = new HashMap<String, ServiceStream>();
    private List<Relocator> relocators;

    public boolean canTransformResource(String resource) {
        return resource.startsWith(SERVICES_PATH);
    }

    public void processResource(String resource, InputStream is, List<Relocator> relocatorz) throws IOException {
        ServiceStream out = this.serviceEntries.get(resource);
        if (out == null) {
            out = new ServiceStream();
            this.serviceEntries.put(resource, out);
        }
        out.append(is);
        is.close();
        if (this.relocators == null) {
            this.relocators = relocatorz;
        }
    }

    public boolean hasTransformedResource() {
        return this.serviceEntries.size() > 0;
    }

    public void modifyOutputStream(JarOutputStream jos) throws IOException {
        for (Map.Entry<String, ServiceStream> entry : this.serviceEntries.entrySet()) {
            String className;
            String key = entry.getKey();
            ServiceStream data = entry.getValue();
            if (this.relocators != null) {
                key = key.substring(SERVICES_PATH.length() + 1);
                for (Relocator relocator : this.relocators) {
                    if (!relocator.canRelocateClass(key)) continue;
                    key = relocator.relocateClass(key);
                    break;
                }
                key = "META-INF/services/" + key;
            }
            jos.putNextEntry(new JarEntry(key));
            PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)jos, StandardCharsets.UTF_8));
            InputStreamReader streamReader = new InputStreamReader(data.toInputStream(), StandardCharsets.UTF_8);
            BufferedReader reader = new BufferedReader(streamReader);
            while ((className = reader.readLine()) != null) {
                if (this.relocators != null) {
                    for (Relocator relocator : this.relocators) {
                        if (!relocator.canRelocateClass(className)) continue;
                        className = relocator.applyToSourceContent(className);
                        break;
                    }
                }
                writer.println(className);
                writer.flush();
            }
            reader.close();
            data.reset();
        }
    }

    static class ServiceStream
    extends ByteArrayOutputStream {
        public ServiceStream() {
            super(1024);
        }

        public void append(InputStream is) throws IOException {
            if (this.count > 0 && this.buf[this.count - 1] != 10 && this.buf[this.count - 1] != 13) {
                this.write(10);
            }
            IOUtil.copy((InputStream)is, (OutputStream)this);
        }

        public InputStream toInputStream() {
            return new ByteArrayInputStream(this.buf, 0, this.count);
        }
    }
}

