/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.maven.plugin.paralleltests;

import java.io.File;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="parallel-tests-createdir", defaultPhase=LifecyclePhase.GENERATE_TEST_RESOURCES)
public class CreateDirsMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project.build.directory}/test-dir")
    private File testBuildDir;
    @Parameter(defaultValue="${project.build.directory}/test-dir")
    private File testBuildData;
    @Parameter(defaultValue="${project.build.directory}/tmp")
    private File hadoopTmpDir;
    @Parameter(defaultValue="${testsThreadCount}")
    private String testsThreadCount;

    public void execute() throws MojoExecutionException {
        int numDirs = this.getTestsThreadCount();
        this.mkParallelDirs(this.testBuildDir, numDirs);
        this.mkParallelDirs(this.testBuildData, numDirs);
        this.mkParallelDirs(this.hadoopTmpDir, numDirs);
    }

    public int getTestsThreadCount() {
        int threadCount = 1;
        if (this.testsThreadCount != null) {
            double multiplier;
            double calculated;
            String trimProp = this.testsThreadCount.trim();
            threadCount = trimProp.endsWith("C") ? ((calculated = (multiplier = Double.parseDouble(trimProp.substring(0, trimProp.length() - 1))) * (double)Runtime.getRuntime().availableProcessors()) > 0.0 ? Math.max((int)calculated, 1) : 0) : Integer.parseInt(this.testsThreadCount);
        }
        return threadCount;
    }

    private void mkParallelDirs(File testDir, int numDirs) throws MojoExecutionException {
        for (int i = 1; i <= numDirs; ++i) {
            File newDir = new File(testDir, String.valueOf(i));
            if (newDir.exists()) continue;
            this.getLog().info((CharSequence)("Creating " + newDir.toString()));
            if (newDir.mkdirs()) continue;
            throw new MojoExecutionException("Unable to create " + newDir.toString());
        }
    }
}

