/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.oncrpc;

import org.apache.hadoop.oncrpc.SimpleTcpClient;
import org.apache.hadoop.oncrpc.XDR;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleTcpClientHandler
extends SimpleChannelHandler {
    public static final Logger LOG = LoggerFactory.getLogger(SimpleTcpClient.class);
    protected final XDR request;

    public SimpleTcpClientHandler(XDR request) {
        this.request = request;
    }

    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("sending PRC request");
        }
        ChannelBuffer outBuf = XDR.writeMessageTcp(this.request, true);
        e.getChannel().write((Object)outBuf);
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) {
        e.getChannel().close();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) {
        LOG.warn("Unexpected exception from downstream: ", e.getCause());
        e.getChannel().close();
    }
}

