/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.nfs.nfs3.request;

import java.io.IOException;
import org.apache.hadoop.nfs.nfs3.FileHandle;
import org.apache.hadoop.nfs.nfs3.request.RequestWithHandle;
import org.apache.hadoop.oncrpc.XDR;

public class COMMIT3Request
extends RequestWithHandle {
    private final long offset;
    private final int count;

    public static COMMIT3Request deserialize(XDR xdr) throws IOException {
        FileHandle handle = COMMIT3Request.readHandle(xdr);
        long offset = xdr.readHyper();
        int count = xdr.readInt();
        return new COMMIT3Request(handle, offset, count);
    }

    public COMMIT3Request(FileHandle handle, long offset, int count) {
        super(handle);
        this.offset = offset;
        this.count = count;
    }

    public long getOffset() {
        return this.offset;
    }

    public int getCount() {
        return this.count;
    }

    @Override
    public void serialize(XDR xdr) {
        this.handle.serialize(xdr);
        xdr.writeLongAsHyper(this.offset);
        xdr.writeInt(this.count);
    }
}

