/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.sls.scheduler;

import com.codahale.metrics.Gauge;
import com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.Schedulable;
import org.apache.hadoop.yarn.sls.SLSRunner;
import org.apache.hadoop.yarn.sls.scheduler.SchedulerMetrics;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class FairSchedulerMetrics
extends SchedulerMetrics {
    private int totalMemoryMB = Integer.MAX_VALUE;
    private int totalVCores = Integer.MAX_VALUE;
    private boolean maxReset = false;

    public FairSchedulerMetrics() {
        for (Metric metric : Metric.values()) {
            this.appTrackedMetrics.add(metric.value + ".memory");
            this.appTrackedMetrics.add(metric.value + ".vcores");
            this.queueTrackedMetrics.add(metric.value + ".memory");
            this.queueTrackedMetrics.add(metric.value + ".vcores");
        }
    }

    private long getMemorySize(Schedulable schedulable, Metric metric) {
        if (schedulable != null) {
            switch (metric) {
                case DEMAND: {
                    return schedulable.getDemand().getMemorySize();
                }
                case USAGE: {
                    return schedulable.getResourceUsage().getMemorySize();
                }
                case MINSHARE: {
                    return schedulable.getMinShare().getMemorySize();
                }
                case MAXSHARE: {
                    return schedulable.getMaxShare().getMemorySize();
                }
                case FAIRSHARE: {
                    return schedulable.getFairShare().getMemorySize();
                }
            }
            return 0L;
        }
        return 0L;
    }

    private int getVirtualCores(Schedulable schedulable, Metric metric) {
        if (schedulable != null) {
            switch (metric) {
                case DEMAND: {
                    return schedulable.getDemand().getVirtualCores();
                }
                case USAGE: {
                    return schedulable.getResourceUsage().getVirtualCores();
                }
                case MINSHARE: {
                    return schedulable.getMinShare().getVirtualCores();
                }
                case MAXSHARE: {
                    return schedulable.getMaxShare().getVirtualCores();
                }
                case FAIRSHARE: {
                    return schedulable.getFairShare().getVirtualCores();
                }
            }
            return 0;
        }
        return 0;
    }

    private void registerAppMetrics(final ApplicationId appId, String oldAppId, final Metric metric) {
        this.metrics.register("variable.app." + oldAppId + "." + metric.value + ".memory", (com.codahale.metrics.Metric)new Gauge<Long>(){

            public Long getValue() {
                return FairSchedulerMetrics.this.getMemorySize((Schedulable)((FSAppAttempt)FairSchedulerMetrics.this.getSchedulerAppAttempt(appId)), metric);
            }
        });
        this.metrics.register("variable.app." + oldAppId + "." + metric.value + ".vcores", (com.codahale.metrics.Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return FairSchedulerMetrics.this.getVirtualCores((Schedulable)((FSAppAttempt)FairSchedulerMetrics.this.getSchedulerAppAttempt(appId)), metric);
            }
        });
    }

    @Override
    public void trackApp(ApplicationId appId, String oldAppId) {
        super.trackApp(appId, oldAppId);
        for (Metric metric : Metric.values()) {
            this.registerAppMetrics(appId, oldAppId, metric);
        }
    }

    private void registerQueueMetrics(final FSQueue queue, final Metric metric) {
        this.metrics.register("variable.queue." + queue.getName() + "." + metric.value + ".memory", (com.codahale.metrics.Metric)new Gauge<Long>(){

            public Long getValue() {
                return FairSchedulerMetrics.this.getMemorySize((Schedulable)queue, metric);
            }
        });
        this.metrics.register("variable.queue." + queue.getName() + "." + metric.value + ".vcores", (com.codahale.metrics.Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return FairSchedulerMetrics.this.getVirtualCores((Schedulable)queue, metric);
            }
        });
    }

    @Override
    protected void registerQueueMetrics(String queueName) {
        super.registerQueueMetrics(queueName);
        FairScheduler fair = (FairScheduler)this.scheduler;
        final FSQueue queue = fair.getQueueManager().getQueue(queueName);
        this.registerQueueMetrics(queue, Metric.DEMAND);
        this.registerQueueMetrics(queue, Metric.USAGE);
        this.registerQueueMetrics(queue, Metric.MINSHARE);
        this.registerQueueMetrics(queue, Metric.FAIRSHARE);
        this.metrics.register("variable.queue." + queueName + ".maxshare.memory", (com.codahale.metrics.Metric)new Gauge<Long>(){

            public Long getValue() {
                if (!FairSchedulerMetrics.this.maxReset && SLSRunner.getSimulateInfoMap().containsKey("Number of nodes") && SLSRunner.getSimulateInfoMap().containsKey("Node memory (MB)") && SLSRunner.getSimulateInfoMap().containsKey("Node VCores")) {
                    int numNMs = Integer.parseInt(SLSRunner.getSimulateInfoMap().get("Number of nodes").toString());
                    int numMemoryMB = Integer.parseInt(SLSRunner.getSimulateInfoMap().get("Node memory (MB)").toString());
                    int numVCores = Integer.parseInt(SLSRunner.getSimulateInfoMap().get("Node VCores").toString());
                    FairSchedulerMetrics.this.totalMemoryMB = numNMs * numMemoryMB;
                    FairSchedulerMetrics.this.totalVCores = numNMs * numVCores;
                    FairSchedulerMetrics.this.maxReset = false;
                }
                return Math.min(queue.getMaxShare().getMemorySize(), (long)FairSchedulerMetrics.this.totalMemoryMB);
            }
        });
        this.metrics.register("variable.queue." + queueName + ".maxshare.vcores", (com.codahale.metrics.Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return Math.min(queue.getMaxShare().getVirtualCores(), FairSchedulerMetrics.this.totalVCores);
            }
        });
    }

    @VisibleForTesting
    public static enum Metric {
        DEMAND("demand"),
        USAGE("usage"),
        MINSHARE("minshare"),
        MAXSHARE("maxshare"),
        FAIRSHARE("fairshare");

        private String value;

        private Metric(String value) {
            this.value = value;
        }

        @VisibleForTesting
        public String getValue() {
            return this.value;
        }
    }
}

