/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.sls;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.collections.SetUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.metrics2.source.JvmMetrics;
import org.apache.hadoop.tools.rumen.JobTraceReader;
import org.apache.hadoop.tools.rumen.LoggedJob;
import org.apache.hadoop.tools.rumen.LoggedTask;
import org.apache.hadoop.tools.rumen.LoggedTaskAttempt;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.hadoop.yarn.api.records.ExecutionType;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeLabel;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.api.records.ReservationId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceInformation;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.amlauncher.ApplicationMasterLauncher;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.ProportionalCapacityPreemptionPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fifo.FifoScheduler;
import org.apache.hadoop.yarn.sls.appmaster.AMSimulator;
import org.apache.hadoop.yarn.sls.conf.SLSConfiguration;
import org.apache.hadoop.yarn.sls.nodemanager.NMSimulator;
import org.apache.hadoop.yarn.sls.resourcemanager.MockAMLauncher;
import org.apache.hadoop.yarn.sls.scheduler.ContainerSimulator;
import org.apache.hadoop.yarn.sls.scheduler.SLSCapacityScheduler;
import org.apache.hadoop.yarn.sls.scheduler.SLSFairScheduler;
import org.apache.hadoop.yarn.sls.scheduler.SchedulerWrapper;
import org.apache.hadoop.yarn.sls.scheduler.TaskRunner;
import org.apache.hadoop.yarn.sls.synthetic.SynthJob;
import org.apache.hadoop.yarn.sls.synthetic.SynthTraceJobProducer;
import org.apache.hadoop.yarn.sls.utils.SLSUtils;
import org.apache.hadoop.yarn.util.UTCClock;
import org.apache.hadoop.yarn.util.resource.ResourceUtils;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class SLSRunner
extends Configured
implements Tool {
    private ResourceManager rm;
    private static TaskRunner runner = new TaskRunner();
    private String[] inputTraces;
    private Map<String, Integer> queueAppNumMap;
    private int poolSize;
    private Map<NodeId, NMSimulator> nmMap;
    private Resource nodeManagerResource;
    private String nodeFile;
    private int AM_ID;
    private Map<String, AMSimulator> amMap;
    private Set<String> trackedApps;
    private Map<String, Class> amClassMap;
    private static int remainingApps = 0;
    private String metricsOutputDir;
    private boolean printSimulation;
    private int numNMs;
    private int numRacks;
    private int numAMs;
    private int numTasks;
    private long maxRuntime;
    private static final Map<String, Object> simulateInfoMap = new HashMap<String, Object>();
    public static final Logger LOG = LoggerFactory.getLogger(SLSRunner.class);
    private static final int DEFAULT_MAPPER_PRIORITY = 20;
    private static final int DEFAULT_REDUCER_PRIORITY = 10;
    private static boolean exitAtTheFinish = false;
    private TraceType inputType;
    private SynthTraceJobProducer stjp;

    public SLSRunner() throws ClassNotFoundException {
        Configuration tempConf = new Configuration(false);
        this.init(tempConf);
    }

    public SLSRunner(Configuration tempConf) throws ClassNotFoundException {
        this.init(tempConf);
    }

    public void setConf(Configuration conf) {
        if (null != conf) {
            conf.addResource("sls-runner.xml");
        }
        super.setConf(conf);
    }

    private void init(Configuration tempConf) throws ClassNotFoundException {
        this.nmMap = new ConcurrentHashMap<NodeId, NMSimulator>();
        this.queueAppNumMap = new HashMap<String, Integer>();
        this.amMap = new ConcurrentHashMap<String, AMSimulator>();
        this.amClassMap = new HashMap<String, Class>();
        this.setConf(tempConf);
        this.poolSize = tempConf.getInt("yarn.sls.runner.pool.size", 10);
        runner.setQueueSize(this.poolSize);
        for (Map.Entry e : tempConf) {
            String key = e.getKey().toString();
            if (!key.startsWith("yarn.sls.am.type.")) continue;
            String amType = key.substring("yarn.sls.am.type.".length());
            this.amClassMap.put(amType, Class.forName(tempConf.get(key)));
        }
        this.nodeManagerResource = this.getNodeManagerResource();
    }

    private Resource getNodeManagerResource() {
        ResourceInformation[] infors;
        Resource resource = Resources.createResource((int)0);
        for (ResourceInformation info : infors = ResourceUtils.getResourceTypesArray()) {
            long value = info.getName().equals("memory-mb") ? (long)this.getConf().getInt("yarn.sls.nm.memory.mb", 10240) : (info.getName().equals("vcores") ? (long)this.getConf().getInt("yarn.sls.nm.vcores", 10) : this.getConf().getLong("yarn.sls.nm." + info.getName(), 0L));
            resource.setResourceValue(info.getName(), value);
        }
        return resource;
    }

    public static Map<String, Object> getSimulateInfoMap() {
        return Collections.unmodifiableMap(simulateInfoMap);
    }

    public void setSimulationParams(TraceType inType, String[] inTraces, String nodes, String outDir, Set<String> trackApps, boolean printsimulation) throws IOException, ClassNotFoundException {
        this.inputType = inType;
        this.inputTraces = (String[])inTraces.clone();
        this.nodeFile = nodes;
        this.trackedApps = trackApps;
        this.printSimulation = printsimulation;
        this.metricsOutputDir = outDir;
    }

    public void start() throws IOException, ClassNotFoundException, YarnException, InterruptedException {
        this.startRM();
        this.startNM();
        this.startAM();
        ((SchedulerWrapper)this.rm.getResourceScheduler()).getTracker().setQueueSet(this.queueAppNumMap.keySet());
        ((SchedulerWrapper)this.rm.getResourceScheduler()).getTracker().setTrackedAppSet(this.trackedApps);
        this.printSimulationInfo();
        this.waitForNodesRunning();
        runner.start();
    }

    private void startRM() throws ClassNotFoundException, YarnException {
        YarnConfiguration rmConf = new YarnConfiguration(this.getConf());
        String schedulerClass = rmConf.get("yarn.resourcemanager.scheduler.class");
        if (Class.forName(schedulerClass) == CapacityScheduler.class) {
            rmConf.set("yarn.resourcemanager.scheduler.class", SLSCapacityScheduler.class.getName());
            rmConf.setBoolean("yarn.resourcemanager.scheduler.monitor.enable", true);
            rmConf.set("yarn.resourcemanager.scheduler.monitor.policies", ProportionalCapacityPreemptionPolicy.class.getName());
        } else if (Class.forName(schedulerClass) == FairScheduler.class) {
            rmConf.set("yarn.resourcemanager.scheduler.class", SLSFairScheduler.class.getName());
        } else if (Class.forName(schedulerClass) == FifoScheduler.class) {
            throw new YarnException("Fifo Scheduler is not supported yet.");
        }
        rmConf.set("yarn.sls.metrics.output", this.metricsOutputDir);
        final SLSRunner se = this;
        this.rm = new ResourceManager(){

            protected ApplicationMasterLauncher createAMLauncher() {
                return new MockAMLauncher(se, (RMContext)this.rmContext, SLSRunner.this.amMap);
            }
        };
        JvmMetrics jvmMetrics = JvmMetrics.initSingleton((String)"ResourceManager", null);
        jvmMetrics.registerIfNeeded();
        this.rm.init((Configuration)rmConf);
        this.rm.start();
    }

    private void startNM() throws YarnException, IOException, InterruptedException {
        final int heartbeatInterval = this.getConf().getInt("yarn.sls.nm.heartbeat.interval.ms", 1000);
        final float resourceUtilizationRatio = this.getConf().getFloat("yarn.sls.nm.resource.utilization.ratio", -1.0f);
        Set<NodeDetails> nodeSet = null;
        if (this.nodeFile.isEmpty()) {
            block5: for (String inputTrace : this.inputTraces) {
                switch (this.inputType) {
                    case SLS: {
                        nodeSet = SLSUtils.parseNodesFromSLSTrace(inputTrace);
                        continue block5;
                    }
                    case RUMEN: {
                        nodeSet = SLSUtils.parseNodesFromRumenTrace(inputTrace);
                        continue block5;
                    }
                    case SYNTH: {
                        this.stjp = new SynthTraceJobProducer(this.getConf(), new Path(this.inputTraces[0]));
                        nodeSet = SLSUtils.generateNodes(this.stjp.getNumNodes(), this.stjp.getNumNodes() / this.stjp.getNodesPerRack());
                        continue block5;
                    }
                    default: {
                        throw new YarnException("Input configuration not recognized, trace type should be SLS, RUMEN, or SYNTH");
                    }
                }
            }
        } else {
            nodeSet = SLSUtils.parseNodesFromNodeFile(this.nodeFile, this.nodeManagerResource);
        }
        if (nodeSet == null || nodeSet.isEmpty()) {
            throw new YarnException("No node! Please configure nodes.");
        }
        final Random random = new Random();
        final ConcurrentHashMap.KeySetView rackSet = ConcurrentHashMap.newKeySet();
        int threadPoolSize = Math.max(this.poolSize, 10);
        ExecutorService executorService = Executors.newFixedThreadPool(threadPoolSize);
        for (final NodeDetails nodeDetails : nodeSet) {
            executorService.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        NMSimulator nm = new NMSimulator();
                        Resource nmResource = SLSRunner.this.nodeManagerResource;
                        String hostName = nodeDetails.getHostname();
                        if (nodeDetails.getNodeResource() != null) {
                            nmResource = nodeDetails.getNodeResource();
                        }
                        Set<NodeLabel> nodeLabels = nodeDetails.getLabels();
                        nm.init(hostName, nmResource, random.nextInt(heartbeatInterval), heartbeatInterval, SLSRunner.this.rm, resourceUtilizationRatio, nodeLabels);
                        SLSRunner.this.nmMap.put(nm.getNode().getNodeID(), nm);
                        runner.schedule(nm);
                        rackSet.add(nm.getNode().getRackName());
                    }
                    catch (IOException | YarnException e) {
                        LOG.error("Got an error while adding node", e);
                    }
                }
            });
        }
        executorService.shutdown();
        executorService.awaitTermination(10L, TimeUnit.MINUTES);
        this.numRacks = rackSet.size();
        this.numNMs = this.nmMap.size();
    }

    private void waitForNodesRunning() throws InterruptedException {
        long startTimeMS = System.currentTimeMillis();
        while (true) {
            int numRunningNodes = 0;
            for (RMNode node : this.rm.getRMContext().getRMNodes().values()) {
                if (node.getState() != NodeState.RUNNING) continue;
                ++numRunningNodes;
            }
            if (numRunningNodes == this.numNMs) break;
            LOG.info("SLSRunner is waiting for all nodes RUNNING. {} of {} NMs initialized.", (Object)numRunningNodes, (Object)this.numNMs);
            Thread.sleep(1000L);
        }
        LOG.info("SLSRunner takes {} ms to launch all nodes.", (Object)(System.currentTimeMillis() - startTimeMS));
    }

    private void startAM() throws YarnException, IOException {
        switch (this.inputType) {
            case SLS: {
                for (String inputTrace : this.inputTraces) {
                    this.startAMFromSLSTrace(inputTrace);
                }
                break;
            }
            case RUMEN: {
                long baselineTimeMS = 0L;
                for (String inputTrace : this.inputTraces) {
                    this.startAMFromRumenTrace(inputTrace, baselineTimeMS);
                }
                break;
            }
            case SYNTH: {
                this.startAMFromSynthGenerator();
                break;
            }
            default: {
                throw new YarnException("Input configuration not recognized, trace type should be SLS, RUMEN, or SYNTH");
            }
        }
        remainingApps = this.numAMs = this.amMap.size();
    }

    private void startAMFromSLSTrace(String inputTrace) throws IOException {
        JsonFactory jsonF = new JsonFactory();
        ObjectMapper mapper = new ObjectMapper();
        try (InputStreamReader input = new InputStreamReader((InputStream)new FileInputStream(inputTrace), "UTF-8");){
            MappingIterator jobIter = mapper.readValues(jsonF.createParser((Reader)input), Map.class);
            while (jobIter.hasNext()) {
                try {
                    this.createAMForJob((Map)jobIter.next());
                }
                catch (Exception e) {
                    LOG.error("Failed to create an AM: {}", (Object)e.getMessage());
                }
            }
        }
    }

    private void createAMForJob(Map jsonJob) throws YarnException {
        String user;
        long jobStartTime = Long.parseLong(jsonJob.get("job.start.ms").toString());
        long jobFinishTime = 0L;
        if (jsonJob.containsKey("job.end.ms")) {
            jobFinishTime = Long.parseLong(jsonJob.get("job.end.ms").toString());
        }
        String jobLabelExpr = null;
        if (jsonJob.containsKey("job.label.expression")) {
            jobLabelExpr = jsonJob.get("job.label.expression").toString();
        }
        if ((user = (String)jsonJob.get("job.user")) == null) {
            user = "default";
        }
        String queue = jsonJob.get("job.queue.name").toString();
        this.increaseQueueAppNum(queue);
        String amType = (String)jsonJob.get("yarn.sls.am.type");
        if (amType == null) {
            amType = "mapreduce";
        }
        int jobCount = 1;
        if (jsonJob.containsKey("job.count")) {
            jobCount = Integer.parseInt(jsonJob.get("job.count").toString());
        }
        jobCount = Math.max(jobCount, 1);
        String oldAppId = (String)jsonJob.get("job.id");
        if (jobCount > 1) {
            oldAppId = null;
        }
        for (int i = 0; i < jobCount; ++i) {
            this.runNewAM(amType, user, queue, oldAppId, jobStartTime, jobFinishTime, this.getTaskContainers(jsonJob), this.getAMContainerResource(jsonJob), jobLabelExpr);
        }
    }

    private List<ContainerSimulator> getTaskContainers(Map jsonJob) throws YarnException {
        ArrayList<ContainerSimulator> containers = new ArrayList<ContainerSimulator>();
        List tasks = (List)jsonJob.get("job.tasks");
        if (tasks == null || tasks.size() == 0) {
            throw new YarnException("No task for the job!");
        }
        for (Object o : tasks) {
            Map jsonTask = (Map)o;
            String hostname = (String)jsonTask.get("container.host");
            long duration = 0L;
            if (jsonTask.containsKey("container.duration.ms")) {
                duration = Integer.parseInt(jsonTask.get("container.duration.ms").toString());
            } else if (jsonTask.containsKey("duration.ms")) {
                duration = Integer.parseInt(jsonTask.get("duration.ms").toString());
            } else if (jsonTask.containsKey("container.start.ms") && jsonTask.containsKey("container.end.ms")) {
                long taskStart = Long.parseLong(jsonTask.get("container.start.ms").toString());
                long taskFinish = Long.parseLong(jsonTask.get("container.end.ms").toString());
                duration = taskFinish - taskStart;
            }
            if (duration <= 0L) {
                throw new YarnException("Duration of a task shouldn't be less or equal to 0!");
            }
            Resource res = this.getResourceForContainer(jsonTask);
            int priority = 20;
            if (jsonTask.containsKey("container.priority")) {
                priority = Integer.parseInt(jsonTask.get("container.priority").toString());
            }
            String type = "map";
            if (jsonTask.containsKey("container.type")) {
                type = jsonTask.get("container.type").toString();
            }
            int count = 1;
            if (jsonTask.containsKey("count")) {
                count = Integer.parseInt(jsonTask.get("count").toString());
            }
            count = Math.max(count, 1);
            ExecutionType executionType = ExecutionType.GUARANTEED;
            if (jsonTask.containsKey("container.execution.type")) {
                executionType = ExecutionType.valueOf((String)jsonTask.get("container.execution.type").toString());
            }
            for (int i = 0; i < count; ++i) {
                containers.add(new ContainerSimulator(res, duration, hostname, priority, type, executionType));
            }
        }
        return containers;
    }

    private Resource getResourceForContainer(Map jsonTask) {
        ResourceInformation[] infors;
        Resource res = this.getDefaultContainerResource();
        for (ResourceInformation info : infors = ResourceUtils.getResourceTypesArray()) {
            if (!jsonTask.containsKey("container." + info.getName())) continue;
            long value = Long.parseLong(jsonTask.get("container." + info.getName()).toString());
            res.setResourceValue(info.getName(), value);
        }
        return res;
    }

    private void startAMFromRumenTrace(String inputTrace, long baselineTimeMS) throws IOException {
        Configuration conf = new Configuration();
        conf.set("fs.defaultFS", "file:///");
        File fin = new File(inputTrace);
        try (JobTraceReader reader = new JobTraceReader(new Path(fin.getAbsolutePath()), conf);){
            LoggedJob job = (LoggedJob)reader.getNext();
            while (job != null) {
                try {
                    this.createAMForJob(job, baselineTimeMS);
                }
                catch (Exception e) {
                    LOG.error("Failed to create an AM: {}", (Object)e.getMessage());
                }
                job = (LoggedJob)reader.getNext();
            }
        }
    }

    private void createAMForJob(LoggedJob job, long baselineTimeMs) throws YarnException {
        long containerLifeTime;
        String hostname;
        LoggedTaskAttempt taskAttempt;
        String user = job.getUser() == null ? "default" : job.getUser().getValue();
        String jobQueue = job.getQueue().getValue();
        String oldJobId = job.getJobID().toString();
        long jobStartTimeMS = job.getSubmitTime();
        long jobFinishTimeMS = job.getFinishTime();
        if (baselineTimeMs == 0L) {
            baselineTimeMs = job.getSubmitTime();
        }
        jobFinishTimeMS -= baselineTimeMs;
        if ((jobStartTimeMS -= baselineTimeMs) < 0L) {
            LOG.warn("Warning: reset job {} start time to 0.", (Object)oldJobId);
            jobFinishTimeMS -= jobStartTimeMS;
            jobStartTimeMS = 0L;
        }
        this.increaseQueueAppNum(jobQueue);
        ArrayList<ContainerSimulator> containerList = new ArrayList<ContainerSimulator>();
        for (LoggedTask mapTask : job.getMapTasks()) {
            if (mapTask.getAttempts().size() == 0) {
                throw new YarnException("Invalid map task, no attempt for a mapper!");
            }
            taskAttempt = (LoggedTaskAttempt)mapTask.getAttempts().get(mapTask.getAttempts().size() - 1);
            hostname = taskAttempt.getHostName().getValue();
            containerLifeTime = taskAttempt.getFinishTime() - taskAttempt.getStartTime();
            containerList.add(new ContainerSimulator(this.getDefaultContainerResource(), containerLifeTime, hostname, 20, "map"));
        }
        for (LoggedTask reduceTask : job.getReduceTasks()) {
            if (reduceTask.getAttempts().size() == 0) {
                throw new YarnException("Invalid reduce task, no attempt for a reducer!");
            }
            taskAttempt = (LoggedTaskAttempt)reduceTask.getAttempts().get(reduceTask.getAttempts().size() - 1);
            hostname = taskAttempt.getHostName().getValue();
            containerLifeTime = taskAttempt.getFinishTime() - taskAttempt.getStartTime();
            containerList.add(new ContainerSimulator(this.getDefaultContainerResource(), containerLifeTime, hostname, 10, "reduce"));
        }
        this.runNewAM("mapreduce", user, jobQueue, oldJobId, jobStartTimeMS, jobFinishTimeMS, containerList, this.getAMContainerResource(null));
    }

    private Resource getDefaultContainerResource() {
        int containerMemory = this.getConf().getInt("yarn.sls.container.memory.mb", 1024);
        int containerVCores = this.getConf().getInt("yarn.sls.container.vcores", 1);
        return Resources.createResource((int)containerMemory, (int)containerVCores);
    }

    private void startAMFromSynthGenerator() throws YarnException, IOException {
        Configuration localConf = new Configuration();
        localConf.set("fs.defaultFS", "file:///");
        long baselineTimeMS = 0L;
        if (this.stjp == null) {
            this.stjp = new SynthTraceJobProducer(this.getConf(), new Path(this.inputTraces[0]));
        }
        SynthJob job = null;
        while ((job = (SynthJob)this.stjp.getNextJob()) != null) {
            String user = job.getUser();
            String jobQueue = job.getQueueName();
            String oldJobId = job.getJobID().toString();
            long jobStartTimeMS = job.getSubmissionTime();
            long jobFinishTimeMS = jobStartTimeMS + job.getDuration();
            if (baselineTimeMS == 0L) {
                baselineTimeMS = jobStartTimeMS;
            }
            jobFinishTimeMS -= baselineTimeMS;
            if ((jobStartTimeMS -= baselineTimeMS) < 0L) {
                LOG.warn("Warning: reset job {} start time to 0.", (Object)oldJobId);
                jobFinishTimeMS -= jobStartTimeMS;
                jobStartTimeMS = 0L;
            }
            this.increaseQueueAppNum(jobQueue);
            ArrayList<ContainerSimulator> containerList = new ArrayList<ContainerSimulator>();
            ArrayList<NodeId> keyAsArray = new ArrayList<NodeId>(this.nmMap.keySet());
            Random rand = new Random(this.stjp.getSeed());
            for (SynthJob.SynthTask task : job.getTasks()) {
                RMNode node = this.nmMap.get(keyAsArray.get(rand.nextInt(keyAsArray.size()))).getNode();
                String hostname = "/" + node.getRackName() + "/" + node.getHostName();
                long containerLifeTime = task.getTime();
                Resource containerResource = Resource.newInstance((int)((int)task.getMemory()), (int)((int)task.getVcores()));
                containerList.add(new ContainerSimulator(containerResource, containerLifeTime, hostname, task.getPriority(), task.getType(), task.getExecutionType()));
            }
            ReservationId reservationId = null;
            if (job.hasDeadline()) {
                reservationId = ReservationId.newInstance((long)this.rm.getStartTime(), (long)this.AM_ID);
            }
            this.runNewAM(job.getType(), user, jobQueue, oldJobId, jobStartTimeMS, jobFinishTimeMS, containerList, reservationId, job.getDeadline(), this.getAMContainerResource(null), null, job.getParams());
        }
    }

    private Resource getAMContainerResource(Map jsonJob) {
        ResourceInformation[] infors;
        Resource amContainerResource = SLSConfiguration.getAMContainerResource(this.getConf());
        if (jsonJob == null) {
            return amContainerResource;
        }
        for (ResourceInformation info : infors = ResourceUtils.getResourceTypesArray()) {
            String key = "am." + info.getName();
            if (!jsonJob.containsKey(key)) continue;
            long value = Long.parseLong(jsonJob.get(key).toString());
            amContainerResource.setResourceValue(info.getName(), value);
        }
        return amContainerResource;
    }

    private void increaseQueueAppNum(String queue) throws YarnException {
        SchedulerWrapper wrapper = (SchedulerWrapper)this.rm.getResourceScheduler();
        String queueName = wrapper.getRealQueueName(queue);
        Integer appNum = this.queueAppNumMap.get(queueName);
        if (appNum == null) {
            appNum = 1;
        } else {
            Integer n = appNum;
            Integer n2 = appNum = Integer.valueOf(appNum + 1);
        }
        this.queueAppNumMap.put(queueName, appNum);
        wrapper.getSchedulerMetrics().trackQueue(queueName);
    }

    private void runNewAM(String jobType, String user, String jobQueue, String oldJobId, long jobStartTimeMS, long jobFinishTimeMS, List<ContainerSimulator> containerList, Resource amContainerResource) {
        this.runNewAM(jobType, user, jobQueue, oldJobId, jobStartTimeMS, jobFinishTimeMS, containerList, null, -1L, amContainerResource, null, null);
    }

    private void runNewAM(String jobType, String user, String jobQueue, String oldJobId, long jobStartTimeMS, long jobFinishTimeMS, List<ContainerSimulator> containerList, Resource amContainerResource, String labelExpr) {
        this.runNewAM(jobType, user, jobQueue, oldJobId, jobStartTimeMS, jobFinishTimeMS, containerList, null, -1L, amContainerResource, labelExpr, null);
    }

    private void runNewAM(String jobType, String user, String jobQueue, String oldJobId, long jobStartTimeMS, long jobFinishTimeMS, List<ContainerSimulator> containerList, ReservationId reservationId, long deadline, Resource amContainerResource, String labelExpr, Map<String, String> params) {
        AMSimulator amSim = (AMSimulator)ReflectionUtils.newInstance((Class)this.amClassMap.get(jobType), (Configuration)new Configuration());
        if (amSim != null) {
            int heartbeatInterval = this.getConf().getInt("yarn.sls.am.heartbeat.interval.ms", 1000);
            boolean isTracked = this.trackedApps.contains(oldJobId);
            if (oldJobId == null) {
                oldJobId = Integer.toString(this.AM_ID);
            }
            ++this.AM_ID;
            amSim.init(heartbeatInterval, containerList, this.rm, this, jobStartTimeMS, jobFinishTimeMS, user, jobQueue, isTracked, oldJobId, runner.getStartTimeMS(), amContainerResource, labelExpr, params);
            if (reservationId != null) {
                UTCClock clock = new UTCClock();
                amSim.initReservation(reservationId, deadline, clock.getTime());
            }
            runner.schedule(amSim);
            this.maxRuntime = Math.max(this.maxRuntime, jobFinishTimeMS);
            this.numTasks += containerList.size();
            this.amMap.put(oldJobId, amSim);
        }
    }

    private void printSimulationInfo() {
        if (this.printSimulation) {
            LOG.info("------------------------------------");
            LOG.info("# nodes = {}, # racks = {}, capacity of each node {}.", new Object[]{this.numNMs, this.numRacks, this.nodeManagerResource});
            LOG.info("------------------------------------");
            LOG.info("# applications = {}, # total tasks = {}, average # tasks per application = {}", new Object[]{this.numAMs, this.numTasks, (int)Math.ceil(((double)this.numTasks + 0.0) / (double)this.numAMs)});
            LOG.info("JobId\tQueue\tAMType\tDuration\t#Tasks");
            for (Map.Entry<String, AMSimulator> entry : this.amMap.entrySet()) {
                AMSimulator am = entry.getValue();
                LOG.info(entry.getKey() + "\t" + am.getQueue() + "\t" + am.getAMType() + "\t" + am.getDuration() + "\t" + am.getNumTasks());
            }
            LOG.info("------------------------------------");
            LOG.info("number of queues = {}  average number of apps = {}", (Object)this.queueAppNumMap.size(), (Object)((int)Math.ceil(((double)this.numAMs + 0.0) / (double)this.queueAppNumMap.size())));
            LOG.info("------------------------------------");
            LOG.info("estimated simulation time is {} seconds", (Object)((long)Math.ceil((double)this.maxRuntime / 1000.0)));
            LOG.info("------------------------------------");
        }
        simulateInfoMap.put("Number of racks", this.numRacks);
        simulateInfoMap.put("Number of nodes", this.numNMs);
        simulateInfoMap.put("Node memory (MB)", this.nodeManagerResource.getResourceValue("memory-mb"));
        simulateInfoMap.put("Node VCores", this.nodeManagerResource.getResourceValue("vcores"));
        simulateInfoMap.put("Number of applications", this.numAMs);
        simulateInfoMap.put("Number of tasks", this.numTasks);
        simulateInfoMap.put("Average tasks per applicaion", (int)Math.ceil(((double)this.numTasks + 0.0) / (double)this.numAMs));
        simulateInfoMap.put("Number of queues", this.queueAppNumMap.size());
        simulateInfoMap.put("Average applications per queue", (int)Math.ceil(((double)this.numAMs + 0.0) / (double)this.queueAppNumMap.size()));
        simulateInfoMap.put("Estimated simulate time (s)", (long)Math.ceil((double)this.maxRuntime / 1000.0));
    }

    public Map<NodeId, NMSimulator> getNmMap() {
        return this.nmMap;
    }

    public static void decreaseRemainingApps() {
        if (--remainingApps == 0) {
            LOG.info("SLSRunner tears down.");
            if (exitAtTheFinish) {
                System.exit(0);
            }
        }
    }

    public void stop() throws InterruptedException {
        this.rm.stop();
        runner.stop();
    }

    public int run(String[] argv) throws IOException, InterruptedException, ParseException, ClassNotFoundException, YarnException {
        String output;
        File outputFile;
        Options options = new Options();
        options.addOption("inputrumen", true, "input rumen files");
        options.addOption("inputsls", true, "input sls files");
        options.addOption("tracetype", true, "the type of trace");
        options.addOption("tracelocation", true, "input trace files");
        options.addOption("nodes", true, "input topology");
        options.addOption("output", true, "output directory");
        options.addOption("trackjobs", true, "jobs to be tracked during simulating");
        options.addOption("printsimulation", false, "print out simulation information");
        GnuParser parser = new GnuParser();
        CommandLine cmd = parser.parse(options, argv);
        String traceType = null;
        String traceLocation = null;
        if (cmd.hasOption("inputrumen")) {
            traceType = "RUMEN";
            traceLocation = cmd.getOptionValue("inputrumen");
        }
        if (cmd.hasOption("inputsls")) {
            traceType = "SLS";
            traceLocation = cmd.getOptionValue("inputsls");
        }
        if (cmd.hasOption("tracetype")) {
            traceType = cmd.getOptionValue("tracetype");
            traceLocation = cmd.getOptionValue("tracelocation");
        }
        if (!(outputFile = new File(output = cmd.getOptionValue("output"))).exists() && !outputFile.mkdirs()) {
            System.err.println("ERROR: Cannot create output directory " + outputFile.getAbsolutePath());
            throw new YarnException("Cannot create output directory");
        }
        HashSet<String> trackedJobSet = new HashSet<String>();
        if (cmd.hasOption("trackjobs")) {
            String trackjobs = cmd.getOptionValue("trackjobs");
            String[] jobIds = trackjobs.split(",");
            trackedJobSet.addAll(Arrays.asList(jobIds));
        }
        String tempNodeFile = cmd.hasOption("nodes") ? cmd.getOptionValue("nodes") : "";
        TraceType tempTraceType = TraceType.SLS;
        switch (traceType) {
            case "SLS": {
                tempTraceType = TraceType.SLS;
                break;
            }
            case "RUMEN": {
                tempTraceType = TraceType.RUMEN;
                break;
            }
            case "SYNTH": {
                tempTraceType = TraceType.SYNTH;
                break;
            }
            default: {
                SLSRunner.printUsage();
                throw new YarnException("Misconfigured input");
            }
        }
        String[] inputFiles = traceLocation.split(",");
        this.setSimulationParams(tempTraceType, inputFiles, tempNodeFile, output, trackedJobSet, cmd.hasOption("printsimulation"));
        this.start();
        return 0;
    }

    public static void main(String[] argv) throws Exception {
        exitAtTheFinish = true;
        ToolRunner.run((Configuration)new Configuration(), (Tool)new SLSRunner(), (String[])argv);
    }

    static void printUsage() {
        System.err.println();
        System.err.println("ERROR: Wrong tracetype");
        System.err.println();
        System.err.println("Options: -tracetype SLS|RUMEN|SYNTH -tracelocation FILE,FILE... (deprecated alternative options --inputsls FILE, FILE,...  | --inputrumen FILE,FILE,...)-output FILE [-nodes FILE] [-trackjobs JobId,JobId...] [-printsimulation]");
        System.err.println();
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static class NodeDetails {
        private String hostname;
        private Resource nodeResource;
        private Set<NodeLabel> labels;

        public NodeDetails(String nodeHostname) {
            this.hostname = nodeHostname;
        }

        public String getHostname() {
            return this.hostname;
        }

        public void setHostname(String hostname) {
            this.hostname = hostname;
        }

        public Resource getNodeResource() {
            return this.nodeResource;
        }

        public void setNodeResource(Resource nodeResource) {
            this.nodeResource = nodeResource;
        }

        public Set<NodeLabel> getLabels() {
            return this.labels;
        }

        public void setLabels(Set<NodeLabel> labels) {
            this.labels = labels;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof NodeDetails)) {
                return false;
            }
            NodeDetails that = (NodeDetails)o;
            return StringUtils.equals((CharSequence)this.hostname, (CharSequence)that.hostname) && (this.nodeResource == null ? that.nodeResource == null : this.nodeResource.equals((Object)that.nodeResource)) && SetUtils.isEqualSet(this.labels, that.labels);
        }

        public int hashCode() {
            int result = this.hostname == null ? 0 : this.hostname.hashCode();
            result = 31 * result + (this.nodeResource == null ? 0 : this.nodeResource.hashCode());
            result = 31 * result + (this.labels == null ? 0 : this.labels.hashCode());
            return result;
        }
    }

    public static enum TraceType {
        SLS,
        RUMEN,
        SYNTH;

    }
}

