/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.sls.resourcemanager;

import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.amlauncher.AMLauncherEvent;
import org.apache.hadoop.yarn.server.resourcemanager.amlauncher.AMLauncherEventType;
import org.apache.hadoop.yarn.server.resourcemanager.amlauncher.ApplicationMasterLauncher;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptImpl;
import org.apache.hadoop.yarn.sls.SLSRunner;
import org.apache.hadoop.yarn.sls.appmaster.AMSimulator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockAMLauncher
extends ApplicationMasterLauncher
implements EventHandler<AMLauncherEvent> {
    private static final Logger LOG = LoggerFactory.getLogger(MockAMLauncher.class);
    Map<String, AMSimulator> amMap;
    SLSRunner se;

    public MockAMLauncher(SLSRunner se, RMContext rmContext, Map<String, AMSimulator> amMap) {
        super(rmContext);
        this.amMap = amMap;
        this.se = se;
    }

    protected void serviceInit(Configuration conf) throws Exception {
    }

    protected void serviceStart() throws Exception {
    }

    protected void serviceStop() throws Exception {
    }

    private void setupAMRMToken(RMAppAttempt appAttempt) {
        Token amrmToken = this.context.getAMRMTokenSecretManager().createAndGetAMRMToken(appAttempt.getAppAttemptId());
        ((RMAppAttemptImpl)appAttempt).setAMRMToken(amrmToken);
    }

    public void handle(AMLauncherEvent event) {
        if (AMLauncherEventType.LAUNCH == event.getType()) {
            ApplicationId appId = event.getAppAttempt().getAppAttemptId().getApplicationId();
            for (AMSimulator ams : this.amMap.values()) {
                if (ams.getApplicationId() == null || !ams.getApplicationId().equals((Object)appId)) continue;
                try {
                    Container amContainer = event.getAppAttempt().getMasterContainer();
                    this.setupAMRMToken(event.getAppAttempt());
                    this.context.getDispatcher().getEventHandler().handle((Event)new RMAppAttemptEvent(event.getAppAttempt().getAppAttemptId(), RMAppAttemptEventType.LAUNCHED));
                    ams.notifyAMContainerLaunched(event.getAppAttempt().getMasterContainer());
                    LOG.info("Notify AM launcher launched:" + amContainer.getId());
                    this.se.getNmMap().get(amContainer.getNodeId()).addNewContainer(amContainer, 100000000L);
                    return;
                }
                catch (Exception e) {
                    throw new YarnRuntimeException((Throwable)e);
                }
            }
            throw new YarnRuntimeException("Didn't find any AMSimulator for applicationId=" + appId);
        }
    }
}

