/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.api;

import com.google.common.annotations.VisibleForTesting;
import java.nio.ByteBuffer;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.ApplicationId;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class ApplicationInitializationContext {
    private final String user;
    private final String userFolder;
    private final ApplicationId applicationId;
    private ByteBuffer appDataForService;

    @VisibleForTesting
    public ApplicationInitializationContext(String user, ApplicationId applicationId, ByteBuffer appDataForService) {
        this(user, applicationId, appDataForService, user);
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public ApplicationInitializationContext(String user, ApplicationId applicationId, ByteBuffer appDataForService, String userFolder) {
        this.user = user;
        this.applicationId = applicationId;
        this.appDataForService = appDataForService;
        this.userFolder = userFolder;
    }

    public String getUser() {
        return this.user;
    }

    public String getUserFolder() {
        return this.userFolder;
    }

    public ApplicationId getApplicationId() {
        return this.applicationId;
    }

    public ByteBuffer getApplicationDataForService() {
        return this.appDataForService;
    }
}

