/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.conf;

import com.google.common.annotations.VisibleForTesting;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;

@InterfaceAudience.Private
public class HAUtil {
    private static Log LOG = LogFactory.getLog(HAUtil.class);
    public static final String BAD_CONFIG_MESSAGE_PREFIX = "Invalid configuration! ";

    private HAUtil() {
    }

    private static void throwBadConfigurationException(String msg) {
        throw new YarnRuntimeException(BAD_CONFIG_MESSAGE_PREFIX + msg);
    }

    public static boolean isHAEnabled(Configuration conf) {
        return conf.getBoolean("yarn.resourcemanager.ha.enabled", false);
    }

    public static boolean isAutomaticFailoverEnabled(Configuration conf) {
        return conf.getBoolean("yarn.resourcemanager.ha.automatic-failover.enabled", true);
    }

    public static boolean isHopsRMFailoverProxy(Configuration conf) {
        return conf.get("yarn.client.failover-leader-proxy-provider", "org.apache.hadoop.yarn.client.ConfiguredLeaderFailoverHAProxyProvider").equals("org.apache.hadoop.yarn.client.ConfiguredLeaderFailoverHAProxyProvider");
    }

    public static boolean isAutomaticFailoverEnabledAndEmbedded(Configuration conf) {
        return HAUtil.isAutomaticFailoverEnabled(conf) && HAUtil.isAutomaticFailoverEmbedded(conf);
    }

    public static boolean isAutomaticFailoverEmbedded(Configuration conf) {
        return conf.getBoolean("yarn.resourcemanager.ha.automatic-failover.embedded", true);
    }

    public static void verifyAndSetConfiguration(Configuration conf) throws YarnRuntimeException {
        HAUtil.verifyAndSetRMHAIdsList(conf);
        HAUtil.verifyAndSetCurrentRMHAId(conf);
        HAUtil.verifyAndSetAllServiceAddresses(conf);
    }

    private static void verifyAndSetRMHAIdsList(Configuration conf) {
        Collection ids = conf.getTrimmedStringCollection("yarn.resourcemanager.ha.rm-ids");
        if (ids.size() < 2) {
            HAUtil.throwBadConfigurationException(HAUtil.getInvalidValueMessage("yarn.resourcemanager.ha.rm-ids", conf.get("yarn.resourcemanager.ha.rm-ids") + "\nHA mode requires atleast two RMs"));
        }
        StringBuilder setValue = new StringBuilder();
        for (String id : ids) {
            for (String prefix : YarnConfiguration.getServiceAddressConfKeys(conf)) {
                HAUtil.checkAndSetRMRPCAddress(prefix, id, conf);
            }
            setValue.append(id);
            setValue.append(",");
        }
        conf.set("yarn.resourcemanager.ha.rm-ids", setValue.substring(0, setValue.length() - 1));
    }

    private static void verifyAndSetCurrentRMHAId(Configuration conf) {
        String rmId = HAUtil.getRMHAId(conf);
        if (rmId == null) {
            StringBuilder msg = new StringBuilder();
            msg.append("Can not find valid RM_HA_ID. None of ");
            for (String id : conf.getTrimmedStringCollection("yarn.resourcemanager.ha.rm-ids")) {
                msg.append(HAUtil.addSuffix("yarn.resourcemanager.address", id) + " ");
            }
            msg.append(" are matching the local address OR yarn.resourcemanager.ha.id is not specified in HA Configuration");
            HAUtil.throwBadConfigurationException(msg.toString());
        } else {
            Collection<String> ids = HAUtil.getRMHAIds(conf);
            if (!ids.contains(rmId)) {
                HAUtil.throwBadConfigurationException(HAUtil.getRMHAIdNeedToBeIncludedMessage(ids.toString(), rmId));
            }
        }
        conf.set("yarn.resourcemanager.ha.id", rmId);
    }

    private static void verifyAndSetConfValue(String prefix, Configuration conf) {
        String confKey = null;
        String confValue = null;
        try {
            confKey = HAUtil.getConfKeyForRMInstance(prefix, conf);
            confValue = HAUtil.getConfValueForRMInstance(prefix, conf);
            conf.set(prefix, confValue);
        }
        catch (YarnRuntimeException yre) {
            throw yre;
        }
        catch (IllegalArgumentException iae) {
            String errmsg = confKey == null ? HAUtil.getInvalidValueMessage("yarn.resourcemanager.ha.id", HAUtil.getRMHAId(conf)) : HAUtil.getNeedToSetValueMessage(confKey);
            HAUtil.throwBadConfigurationException(errmsg);
        }
    }

    public static void verifyAndSetAllServiceAddresses(Configuration conf) {
        for (String confKey : YarnConfiguration.getServiceAddressConfKeys(conf)) {
            HAUtil.verifyAndSetConfValue(confKey, conf);
        }
    }

    public static Collection<String> getRMHAIds(Configuration conf) {
        return conf.getStringCollection("yarn.resourcemanager.ha.rm-ids");
    }

    public static String getRMHAId(Configuration conf) {
        int found = 0;
        String currentRMId = conf.getTrimmed("yarn.resourcemanager.ha.id");
        if (currentRMId == null) {
            for (String rmId : HAUtil.getRMHAIds(conf)) {
                InetSocketAddress s;
                String key = HAUtil.addSuffix("yarn.resourcemanager.address", rmId);
                String addr = conf.get(key);
                if (addr == null) continue;
                try {
                    s = NetUtils.createSocketAddr((String)addr);
                }
                catch (Exception e) {
                    LOG.warn((Object)("Exception in creating socket address " + addr), (Throwable)e);
                    continue;
                }
                if (s.isUnresolved() || !NetUtils.isLocalAddress((InetAddress)s.getAddress())) continue;
                currentRMId = rmId.trim();
                ++found;
            }
        }
        if (found > 1) {
            String msg = "The HA Configuration has multiple addresses that match local node's address.";
            throw new HadoopIllegalArgumentException(msg);
        }
        return currentRMId;
    }

    @VisibleForTesting
    static String getNeedToSetValueMessage(String confKey) {
        return confKey + " needs to be set in a HA configuration.";
    }

    @VisibleForTesting
    static String getInvalidValueMessage(String confKey, String invalidValue) {
        return "Invalid value of " + confKey + ". Current value is " + invalidValue;
    }

    @VisibleForTesting
    static String getRMHAIdNeedToBeIncludedMessage(String ids, String rmId) {
        return "yarn.resourcemanager.ha.rm-ids(" + ids + ") need to contain " + "yarn.resourcemanager.ha.id" + "(" + rmId + ") in a HA configuration.";
    }

    @VisibleForTesting
    static String getRMHAIdsWarningMessage(String ids) {
        return "Resource Manager HA is enabled, but yarn.resourcemanager.ha.rm-ids has only one id(" + ids.toString() + ")";
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    static String getConfKeyForRMInstance(String prefix, Configuration conf) {
        if (!YarnConfiguration.getServiceAddressConfKeys(conf).contains(prefix)) {
            return prefix;
        }
        String RMId = HAUtil.getRMHAId(conf);
        HAUtil.checkAndSetRMRPCAddress(prefix, RMId, conf);
        return HAUtil.addSuffix(prefix, RMId);
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    static String getConfKeyForRMInstance(String prefix, Configuration conf, String RMId) {
        if (!YarnConfiguration.getServiceAddressConfKeys(conf).contains(prefix)) {
            return prefix;
        }
        HAUtil.checkAndSetRMRPCAddress(prefix, RMId, conf);
        return HAUtil.addSuffix(prefix, RMId);
    }

    public static String getConfValueForRMInstance(String prefix, Configuration conf, String host) {
        String confKey = HAUtil.getConfKeyForRMInstance(prefix, conf, host);
        String retVal = conf.getTrimmed(confKey);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("getConfValueForRMInstance: prefix = " + prefix + "; confKey being looked up = " + confKey + "; value being set to = " + retVal));
        }
        return retVal;
    }

    public static String getConfValueForRMInstance(String prefix, Configuration conf) {
        String confKey = HAUtil.getConfKeyForRMInstance(prefix, conf);
        String retVal = conf.getTrimmed(confKey);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("getConfValueForRMInstance: prefix = " + prefix + "; confKey being looked up = " + confKey + "; value being set to = " + retVal));
        }
        return retVal;
    }

    public static String getConfValueForRMInstance(String prefix, String defaultValue, Configuration conf, String host) {
        String value = HAUtil.getConfValueForRMInstance(prefix, conf, host);
        return value == null ? defaultValue : value;
    }

    public static String getConfValueForRMInstance(String prefix, String defaultValue, Configuration conf) {
        String value = HAUtil.getConfValueForRMInstance(prefix, conf);
        return value == null ? defaultValue : value;
    }

    public static String addSuffix(String key, String suffix) {
        if (suffix == null || suffix.isEmpty()) {
            return key;
        }
        if (suffix.startsWith(".")) {
            throw new IllegalArgumentException("suffix '" + suffix + "' should not already have '.' prepended.");
        }
        return key + "." + suffix;
    }

    private static void checkAndSetRMRPCAddress(String prefix, String RMId, Configuration conf) {
        String rpcAddressConfKey = null;
        try {
            rpcAddressConfKey = HAUtil.addSuffix(prefix, RMId);
            if (conf.getTrimmed(rpcAddressConfKey) == null) {
                String hostNameConfKey = HAUtil.addSuffix("yarn.resourcemanager.hostname", RMId);
                String confVal = conf.getTrimmed(hostNameConfKey);
                if (confVal == null) {
                    HAUtil.throwBadConfigurationException(HAUtil.getNeedToSetValueMessage(hostNameConfKey + " or " + HAUtil.addSuffix(prefix, RMId)));
                } else {
                    conf.set(HAUtil.addSuffix(prefix, RMId), confVal + ":" + YarnConfiguration.getRMDefaultPortNumber(prefix, conf));
                }
            }
        }
        catch (IllegalArgumentException iae) {
            String errmsg = iae.getMessage();
            if (rpcAddressConfKey == null) {
                errmsg = HAUtil.getInvalidValueMessage("yarn.resourcemanager.ha.id", RMId);
            }
            HAUtil.throwBadConfigurationException(errmsg);
        }
    }
}

