/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.resource;

import org.apache.hadoop.yarn.api.records.AllocationTagNamespaceType;
import org.apache.hadoop.yarn.api.resource.PlacementConstraint;
import org.apache.hadoop.yarn.api.resource.PlacementConstraints;
import org.junit.Assert;
import org.junit.Test;

public class TestPlacementConstraints {
    @Test
    public void testNodeAffinityToTag() {
        PlacementConstraint.AbstractConstraint constraintExpr = PlacementConstraints.targetIn((String)"node", (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTag((String[])new String[]{"hbase-m"})});
        PlacementConstraint.SingleConstraint sConstraint = (PlacementConstraint.SingleConstraint)constraintExpr;
        Assert.assertEquals((Object)"node", (Object)sConstraint.getScope());
        Assert.assertEquals((long)1L, (long)sConstraint.getMinCardinality());
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)sConstraint.getMaxCardinality());
        Assert.assertEquals((long)1L, (long)sConstraint.getTargetExpressions().size());
        PlacementConstraint.TargetExpression tExpr = (PlacementConstraint.TargetExpression)sConstraint.getTargetExpressions().iterator().next();
        Assert.assertEquals((Object)AllocationTagNamespaceType.SELF.toString(), (Object)tExpr.getTargetKey());
        Assert.assertEquals((Object)PlacementConstraint.TargetExpression.TargetType.ALLOCATION_TAG, (Object)tExpr.getTargetType());
        Assert.assertEquals((long)1L, (long)tExpr.getTargetValues().size());
        Assert.assertEquals((Object)"hbase-m", tExpr.getTargetValues().iterator().next());
        PlacementConstraint constraint = PlacementConstraints.build((PlacementConstraint.AbstractConstraint)constraintExpr);
        Assert.assertNotNull((Object)constraint.getConstraintExpr());
    }

    @Test
    public void testNodeAntiAffinityToAttribute() {
        PlacementConstraint.AbstractConstraint constraintExpr = PlacementConstraints.targetNotIn((String)"node", (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.nodeAttribute((String)"java", (String[])new String[]{"1.8"})});
        PlacementConstraint.SingleConstraint sConstraint = (PlacementConstraint.SingleConstraint)constraintExpr;
        Assert.assertEquals((Object)"node", (Object)sConstraint.getScope());
        Assert.assertEquals((long)0L, (long)sConstraint.getMinCardinality());
        Assert.assertEquals((long)0L, (long)sConstraint.getMaxCardinality());
        Assert.assertEquals((long)1L, (long)sConstraint.getTargetExpressions().size());
        PlacementConstraint.TargetExpression tExpr = (PlacementConstraint.TargetExpression)sConstraint.getTargetExpressions().iterator().next();
        Assert.assertEquals((Object)"java", (Object)tExpr.getTargetKey());
        Assert.assertEquals((Object)PlacementConstraint.TargetExpression.TargetType.NODE_ATTRIBUTE, (Object)tExpr.getTargetType());
        Assert.assertEquals((long)1L, (long)tExpr.getTargetValues().size());
        Assert.assertEquals((Object)"1.8", tExpr.getTargetValues().iterator().next());
    }

    @Test
    public void testAndConstraint() {
        PlacementConstraint.And constraintExpr;
        PlacementConstraint.And andExpr = constraintExpr = PlacementConstraints.and((PlacementConstraint.AbstractConstraint[])new PlacementConstraint.AbstractConstraint[]{PlacementConstraints.targetIn((String)"rack", (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTag((String[])new String[]{"spark"})}), PlacementConstraints.maxCardinality((String)"node", (int)3, (String[])new String[]{"spark"}), PlacementConstraints.targetCardinality((String)"rack", (int)2, (int)10, (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTag((String[])new String[]{"zk"})})});
        Assert.assertEquals((long)3L, (long)andExpr.getChildren().size());
        PlacementConstraint.SingleConstraint sConstr = (PlacementConstraint.SingleConstraint)andExpr.getChildren().get(0);
        PlacementConstraint.TargetExpression tExpr = (PlacementConstraint.TargetExpression)sConstr.getTargetExpressions().iterator().next();
        Assert.assertEquals((Object)"spark", tExpr.getTargetValues().iterator().next());
        sConstr = (PlacementConstraint.SingleConstraint)andExpr.getChildren().get(1);
        Assert.assertEquals((long)0L, (long)sConstr.getMinCardinality());
        Assert.assertEquals((long)3L, (long)sConstr.getMaxCardinality());
        sConstr = (PlacementConstraint.SingleConstraint)andExpr.getChildren().get(2);
        Assert.assertEquals((long)2L, (long)sConstr.getMinCardinality());
        Assert.assertEquals((long)10L, (long)sConstr.getMaxCardinality());
    }
}

