/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.conf;

import org.apache.hadoop.yarn.api.records.ResourceInformation;
import org.junit.Assert;
import org.junit.Test;

public class TestResourceInformation {
    @Test
    public void testName() {
        String name = "yarn.io/test";
        ResourceInformation ri = ResourceInformation.newInstance((String)name);
        Assert.assertEquals((String)"Resource name incorrect", (Object)name, (Object)ri.getName());
    }

    @Test
    public void testUnits() {
        String name = "yarn.io/test";
        String units = "m";
        ResourceInformation ri = ResourceInformation.newInstance((String)name, (String)units);
        Assert.assertEquals((String)"Resource name incorrect", (Object)name, (Object)ri.getName());
        Assert.assertEquals((String)"Resource units incorrect", (Object)units, (Object)ri.getUnits());
        units = "z";
        try {
            ResourceInformation.newInstance((String)name, (String)units).setUnits(units);
            Assert.fail((String)(units + "is not a valid unit"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testValue() {
        String name = "yarn.io/test";
        long value = 1L;
        ResourceInformation ri = ResourceInformation.newInstance((String)name, (long)value);
        Assert.assertEquals((String)"Resource name incorrect", (Object)name, (Object)ri.getName());
        Assert.assertEquals((String)"Resource value incorrect", (long)value, (long)ri.getValue());
    }

    @Test
    public void testResourceInformation() {
        String name = "yarn.io/test";
        long value = 1L;
        String units = "m";
        ResourceInformation ri = ResourceInformation.newInstance((String)name, (String)units, (long)value);
        Assert.assertEquals((String)"Resource name incorrect", (Object)name, (Object)ri.getName());
        Assert.assertEquals((String)"Resource value incorrect", (long)value, (long)ri.getValue());
        Assert.assertEquals((String)"Resource units incorrect", (Object)units, (Object)ri.getUnits());
    }
}

