/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.resource;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.yarn.api.records.NodeAttributeOpCode;
import org.apache.hadoop.yarn.api.resource.PlacementConstraint;
import org.apache.hadoop.yarn.api.resource.PlacementConstraints;
import org.apache.hadoop.yarn.util.constraint.PlacementConstraintParseException;
import org.apache.hadoop.yarn.util.constraint.PlacementConstraintParser;
import org.junit.Assert;
import org.junit.Test;

public class TestPlacementConstraintParser {
    @Test
    public void testTargetExpressionParser() throws PlacementConstraintParseException {
        String expressionStr = "NOTIN, NODE, foo";
        PlacementConstraintParser.TargetConstraintParser parser = new PlacementConstraintParser.TargetConstraintParser(expressionStr);
        PlacementConstraint.AbstractConstraint constraint = parser.parse();
        Assert.assertTrue((boolean)(constraint instanceof PlacementConstraint.SingleConstraint));
        PlacementConstraint.SingleConstraint single = (PlacementConstraint.SingleConstraint)constraint;
        Assert.assertEquals((Object)"node", (Object)single.getScope());
        Assert.assertEquals((long)0L, (long)single.getMinCardinality());
        Assert.assertEquals((long)0L, (long)single.getMaxCardinality());
        this.verifyConstraintToString(expressionStr, constraint);
        expressionStr = "notin, node, foo";
        parser = new PlacementConstraintParser.TargetConstraintParser(expressionStr);
        constraint = parser.parse();
        Assert.assertTrue((boolean)(constraint instanceof PlacementConstraint.SingleConstraint));
        single = (PlacementConstraint.SingleConstraint)constraint;
        Assert.assertEquals((Object)"node", (Object)single.getScope());
        Assert.assertEquals((long)0L, (long)single.getMinCardinality());
        Assert.assertEquals((long)0L, (long)single.getMaxCardinality());
        this.verifyConstraintToString(expressionStr, constraint);
        expressionStr = "IN, NODE, foo";
        parser = new PlacementConstraintParser.TargetConstraintParser(expressionStr);
        constraint = parser.parse();
        Assert.assertTrue((boolean)(constraint instanceof PlacementConstraint.SingleConstraint));
        single = (PlacementConstraint.SingleConstraint)constraint;
        Assert.assertEquals((Object)"node", (Object)single.getScope());
        Assert.assertEquals((long)1L, (long)single.getMinCardinality());
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)single.getMaxCardinality());
        this.verifyConstraintToString(expressionStr, constraint);
        expressionStr = "NOTIN, NODE, foo, bar, exp";
        parser = new PlacementConstraintParser.TargetConstraintParser(expressionStr);
        constraint = parser.parse();
        Assert.assertTrue((boolean)(constraint instanceof PlacementConstraint.SingleConstraint));
        single = (PlacementConstraint.SingleConstraint)constraint;
        Assert.assertEquals((Object)"node", (Object)single.getScope());
        Assert.assertEquals((long)0L, (long)single.getMinCardinality());
        Assert.assertEquals((long)0L, (long)single.getMaxCardinality());
        Assert.assertEquals((long)1L, (long)single.getTargetExpressions().size());
        PlacementConstraint.TargetExpression exp = (PlacementConstraint.TargetExpression)single.getTargetExpressions().iterator().next();
        Assert.assertEquals((Object)"ALLOCATION_TAG", (Object)exp.getTargetType().toString());
        Assert.assertEquals((long)3L, (long)exp.getTargetValues().size());
        this.verifyConstraintToString(expressionStr, constraint);
        parser = new PlacementConstraintParser.TargetConstraintParser("XYZ, NODE, foo");
        try {
            parser.parse();
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof PlacementConstraintParseException));
            Assert.assertTrue((boolean)e.getMessage().contains("expecting in or notin"));
        }
    }

    @Test
    public void testCardinalityConstraintParser() throws PlacementConstraintParseException {
        String expressionExpr = "cardinality, NODE, foo, 0, 1";
        PlacementConstraintParser.CardinalityConstraintParser parser = new PlacementConstraintParser.CardinalityConstraintParser(expressionExpr);
        PlacementConstraint.AbstractConstraint constraint = parser.parse();
        Assert.assertTrue((boolean)(constraint instanceof PlacementConstraint.SingleConstraint));
        PlacementConstraint.SingleConstraint single = (PlacementConstraint.SingleConstraint)constraint;
        Assert.assertEquals((Object)"node", (Object)single.getScope());
        Assert.assertEquals((long)0L, (long)single.getMinCardinality());
        Assert.assertEquals((long)1L, (long)single.getMaxCardinality());
        Assert.assertEquals((long)1L, (long)single.getTargetExpressions().size());
        PlacementConstraint.TargetExpression exp = (PlacementConstraint.TargetExpression)single.getTargetExpressions().iterator().next();
        Assert.assertEquals((Object)"ALLOCATION_TAG", (Object)exp.getTargetType().toString());
        Assert.assertEquals((long)1L, (long)exp.getTargetValues().size());
        Assert.assertEquals((Object)"foo", exp.getTargetValues().iterator().next());
        this.verifyConstraintToString(expressionExpr, constraint);
        expressionExpr = "cardinality,RACK,foo,bar,moo,0,1";
        parser = new PlacementConstraintParser.CardinalityConstraintParser(expressionExpr);
        constraint = parser.parse();
        Assert.assertTrue((boolean)(constraint instanceof PlacementConstraint.SingleConstraint));
        single = (PlacementConstraint.SingleConstraint)constraint;
        Assert.assertEquals((Object)"rack", (Object)single.getScope());
        Assert.assertEquals((long)0L, (long)single.getMinCardinality());
        Assert.assertEquals((long)1L, (long)single.getMaxCardinality());
        Assert.assertEquals((long)1L, (long)single.getTargetExpressions().size());
        exp = (PlacementConstraint.TargetExpression)single.getTargetExpressions().iterator().next();
        Assert.assertEquals((Object)"ALLOCATION_TAG", (Object)exp.getTargetType().toString());
        Assert.assertEquals((long)3L, (long)exp.getTargetValues().size());
        HashSet expectedTags = Sets.newHashSet((Object[])new String[]{"foo", "bar", "moo"});
        Assert.assertTrue((boolean)Sets.difference((Set)expectedTags, (Set)exp.getTargetValues()).isEmpty());
        this.verifyConstraintToString(expressionExpr, constraint);
        try {
            parser = new PlacementConstraintParser.CardinalityConstraintParser("cardinality,NOWHERE,foo,bar,moo,0,1");
            parser.parse();
            Assert.fail((String)"Expecting a parsing failure!");
        }
        catch (PlacementConstraintParseException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("expecting scope to node or rack, but met NOWHERE"));
        }
        try {
            parser = new PlacementConstraintParser.CardinalityConstraintParser("cardinality,NODE,0,1");
            parser.parse();
            Assert.fail((String)"Expecting a parsing failure!");
        }
        catch (PlacementConstraintParseException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("at least 5 elements, but only 4 is given"));
        }
    }

    @Test
    public void testAndConstraintParser() throws PlacementConstraintParseException {
        String expressionExpr = "AND(NOTIN,NODE,foo:NOTIN,NODE,bar)";
        PlacementConstraintParser.ConjunctionConstraintParser parser = new PlacementConstraintParser.ConjunctionConstraintParser(expressionExpr);
        PlacementConstraint.AbstractConstraint constraint = parser.parse();
        Assert.assertTrue((boolean)(constraint instanceof PlacementConstraint.And));
        PlacementConstraint.And and = (PlacementConstraint.And)constraint;
        Assert.assertEquals((long)2L, (long)and.getChildren().size());
        this.verifyConstraintToString(expressionExpr, constraint);
        expressionExpr = "AND(NOTIN,NODE,foo:cardinality,NODE,foo,0,1)";
        parser = new PlacementConstraintParser.ConjunctionConstraintParser(expressionExpr);
        constraint = parser.parse();
        Assert.assertTrue((boolean)(constraint instanceof PlacementConstraint.And));
        Assert.assertEquals((long)2L, (long)and.getChildren().size());
        this.verifyConstraintToString(expressionExpr, constraint);
        expressionExpr = "AND(NOTIN,NODE,foo:AND(NOTIN,NODE,foo:cardinality,NODE,foo,0,1))";
        parser = new PlacementConstraintParser.ConjunctionConstraintParser(expressionExpr);
        constraint = parser.parse();
        Assert.assertTrue((boolean)(constraint instanceof PlacementConstraint.And));
        and = (PlacementConstraint.And)constraint;
        Assert.assertTrue((boolean)(and.getChildren().get(0) instanceof PlacementConstraint.SingleConstraint));
        Assert.assertTrue((boolean)(and.getChildren().get(1) instanceof PlacementConstraint.And));
        and = (PlacementConstraint.And)and.getChildren().get(1);
        Assert.assertEquals((long)2L, (long)and.getChildren().size());
        this.verifyConstraintToString(expressionExpr, constraint);
    }

    @Test
    public void testOrConstraintParser() throws PlacementConstraintParseException {
        String expressionExpr = "OR(NOTIN,NODE,foo:NOTIN,NODE,bar)";
        PlacementConstraintParser.ConjunctionConstraintParser parser = new PlacementConstraintParser.ConjunctionConstraintParser(expressionExpr);
        PlacementConstraint.AbstractConstraint constraint = parser.parse();
        Assert.assertTrue((boolean)(constraint instanceof PlacementConstraint.Or));
        PlacementConstraint.Or or = (PlacementConstraint.Or)constraint;
        Assert.assertEquals((long)2L, (long)or.getChildren().size());
        this.verifyConstraintToString(expressionExpr, constraint);
        expressionExpr = "OR(NOTIN,NODE,foo:cardinality,NODE,foo,0,1)";
        parser = new PlacementConstraintParser.ConjunctionConstraintParser(expressionExpr);
        constraint = parser.parse();
        Assert.assertTrue((boolean)(constraint instanceof PlacementConstraint.Or));
        Assert.assertEquals((long)2L, (long)or.getChildren().size());
        this.verifyConstraintToString(expressionExpr, constraint);
        expressionExpr = "OR(NOTIN,NODE,foo:OR(NOTIN,NODE,foo:cardinality,NODE,foo,0,1))";
        parser = new PlacementConstraintParser.ConjunctionConstraintParser(expressionExpr);
        constraint = parser.parse();
        Assert.assertTrue((boolean)(constraint instanceof PlacementConstraint.Or));
        or = (PlacementConstraint.Or)constraint;
        Assert.assertTrue((boolean)(or.getChildren().get(0) instanceof PlacementConstraint.SingleConstraint));
        Assert.assertTrue((boolean)(or.getChildren().get(1) instanceof PlacementConstraint.Or));
        or = (PlacementConstraint.Or)or.getChildren().get(1);
        Assert.assertEquals((long)2L, (long)or.getChildren().size());
        this.verifyConstraintToString(expressionExpr, constraint);
    }

    @Test
    public void testMultipleConstraintsTokenizer() throws PlacementConstraintParseException {
        PlacementConstraintParser.MultipleConstraintsTokenizer ct = new PlacementConstraintParser.MultipleConstraintsTokenizer("foo=1,A1,A2,A3:bar=2,B1,B2:moo=3,C1,C2");
        TokenizerTester mp = new TokenizerTester((PlacementConstraintParser.ConstraintTokenizer)ct, "foo=1,A1,A2,A3", "bar=2,B1,B2", "moo=3,C1,C2");
        mp.verify();
        ct = new PlacementConstraintParser.MultipleConstraintsTokenizer("foo=1,AND(A2:A3):bar=2,OR(B1:AND(B2:B3)):moo=3,C1,C2");
        mp = new TokenizerTester((PlacementConstraintParser.ConstraintTokenizer)ct, "foo=1,AND(A2:A3)", "bar=2,OR(B1:AND(B2:B3))", "moo=3,C1,C2");
        mp.verify();
        ct = new PlacementConstraintParser.MultipleConstraintsTokenizer("A:B:C");
        mp = new TokenizerTester((PlacementConstraintParser.ConstraintTokenizer)ct, "A", "B", "C");
        mp.verify();
        ct = new PlacementConstraintParser.MultipleConstraintsTokenizer("A:AND(B:C):D");
        mp = new TokenizerTester((PlacementConstraintParser.ConstraintTokenizer)ct, "A", "AND(B:C)", "D");
        mp.verify();
        ct = new PlacementConstraintParser.MultipleConstraintsTokenizer("A:AND(B:OR(C:D)):E");
        mp = new TokenizerTester((PlacementConstraintParser.ConstraintTokenizer)ct, "A", "AND(B:OR(C:D))", "E");
        mp.verify();
        ct = new PlacementConstraintParser.MultipleConstraintsTokenizer("A:AND(B:OR(C:D)):E");
        mp = new TokenizerTester((PlacementConstraintParser.ConstraintTokenizer)ct, "A", "AND(B:OR(C:D))", "E");
        mp.verify();
        PlacementConstraintParser.SourceTagsTokenizer st = new PlacementConstraintParser.SourceTagsTokenizer("A=4");
        mp = new TokenizerTester((PlacementConstraintParser.ConstraintTokenizer)st, "A", "4");
        mp.verify();
        try {
            st = new PlacementConstraintParser.SourceTagsTokenizer("A=B");
            mp = new TokenizerTester((PlacementConstraintParser.ConstraintTokenizer)st, "A", "B");
            mp.verify();
            Assert.fail((String)"Expecting a parsing failure");
        }
        catch (PlacementConstraintParseException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Value of the expression must be an integer"));
        }
    }

    @Test
    public void testParsePlacementSpec() throws PlacementConstraintParseException {
        Map result = PlacementConstraintParser.parsePlacementSpec((String)"foo=3,notin,node,foo");
        Assert.assertEquals((long)1L, (long)result.size());
        PlacementConstraintParser.SourceTags tag1 = (PlacementConstraintParser.SourceTags)result.keySet().iterator().next();
        Assert.assertEquals((Object)"foo", (Object)tag1.getTag());
        Assert.assertEquals((long)3L, (long)tag1.getNumOfAllocations());
        PlacementConstraint expectedPc1 = PlacementConstraints.targetNotIn((String)"node", (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTag((String[])new String[]{"foo"})}).build();
        PlacementConstraint actualPc1 = (PlacementConstraint)result.values().iterator().next();
        Assert.assertEquals((Object)expectedPc1, (Object)actualPc1);
        result = PlacementConstraintParser.parsePlacementSpec((String)"foo=3,NOTIN,NODE,foo");
        Assert.assertEquals((long)1L, (long)result.size());
        tag1 = (PlacementConstraintParser.SourceTags)result.keySet().iterator().next();
        Assert.assertEquals((Object)"foo", (Object)tag1.getTag());
        Assert.assertEquals((long)3L, (long)tag1.getNumOfAllocations());
        expectedPc1 = PlacementConstraints.targetNotIn((String)"node", (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTag((String[])new String[]{"foo"})}).build();
        actualPc1 = (PlacementConstraint)result.values().iterator().next();
        Assert.assertEquals((Object)expectedPc1, (Object)actualPc1);
        result = PlacementConstraintParser.parsePlacementSpec((String)"foo=10,cardinality,node,foo,bar,0,100");
        Assert.assertEquals((long)1L, (long)result.size());
        tag1 = (PlacementConstraintParser.SourceTags)result.keySet().iterator().next();
        Assert.assertEquals((Object)"foo", (Object)tag1.getTag());
        Assert.assertEquals((long)10L, (long)tag1.getNumOfAllocations());
        expectedPc1 = PlacementConstraints.cardinality((String)"node", (int)0, (int)100, (String[])new String[]{"foo", "bar"}).build();
        Assert.assertEquals((Object)expectedPc1, result.values().iterator().next());
        result = PlacementConstraintParser.parsePlacementSpec((String)"foo=3,notin,node,foo:bar=2,in,node,foo");
        Assert.assertEquals((long)2L, (long)result.size());
        Iterator keyIt = result.keySet().iterator();
        tag1 = (PlacementConstraintParser.SourceTags)keyIt.next();
        Assert.assertEquals((Object)"foo", (Object)tag1.getTag());
        Assert.assertEquals((long)3L, (long)tag1.getNumOfAllocations());
        PlacementConstraintParser.SourceTags tag2 = (PlacementConstraintParser.SourceTags)keyIt.next();
        Assert.assertEquals((Object)"bar", (Object)tag2.getTag());
        Assert.assertEquals((long)2L, (long)tag2.getNumOfAllocations());
        Iterator valueIt = result.values().iterator();
        expectedPc1 = PlacementConstraints.targetNotIn((String)"node", (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTag((String[])new String[]{"foo"})}).build();
        PlacementConstraint expectedPc2 = PlacementConstraints.targetIn((String)"node", (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTag((String[])new String[]{"foo"})}).build();
        Assert.assertEquals((Object)expectedPc1, valueIt.next());
        Assert.assertEquals((Object)expectedPc2, valueIt.next());
        result = PlacementConstraintParser.parsePlacementSpec((String)"foo=1000,and(notin,node,bar:in,node,foo)");
        Assert.assertEquals((long)1L, (long)result.size());
        keyIt = result.keySet().iterator();
        tag1 = (PlacementConstraintParser.SourceTags)keyIt.next();
        Assert.assertEquals((Object)"foo", (Object)tag1.getTag());
        Assert.assertEquals((long)1000L, (long)tag1.getNumOfAllocations());
        actualPc1 = (PlacementConstraint)result.values().iterator().next();
        expectedPc1 = PlacementConstraints.and((PlacementConstraint.AbstractConstraint[])new PlacementConstraint.AbstractConstraint[]{PlacementConstraints.targetNotIn((String)"node", (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTag((String[])new String[]{"bar"})}), PlacementConstraints.targetIn((String)"node", (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTag((String[])new String[]{"foo"})})}).build();
        Assert.assertEquals((Object)expectedPc1, (Object)actualPc1);
        result = PlacementConstraintParser.parsePlacementSpec((String)"foo=1000,and(notin,node,bar:or(in,node,foo:in,node,moo)):bar=200,notin,node,foo");
        Assert.assertEquals((long)2L, (long)result.size());
        keyIt = result.keySet().iterator();
        tag1 = (PlacementConstraintParser.SourceTags)keyIt.next();
        tag2 = (PlacementConstraintParser.SourceTags)keyIt.next();
        Assert.assertEquals((Object)"foo", (Object)tag1.getTag());
        Assert.assertEquals((long)1000L, (long)tag1.getNumOfAllocations());
        Assert.assertEquals((Object)"bar", (Object)tag2.getTag());
        Assert.assertEquals((long)200L, (long)tag2.getNumOfAllocations());
        valueIt = result.values().iterator();
        actualPc1 = (PlacementConstraint)valueIt.next();
        PlacementConstraint actualPc2 = (PlacementConstraint)valueIt.next();
        expectedPc1 = PlacementConstraints.and((PlacementConstraint.AbstractConstraint[])new PlacementConstraint.AbstractConstraint[]{PlacementConstraints.targetNotIn((String)"node", (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTag((String[])new String[]{"bar"})}), PlacementConstraints.or((PlacementConstraint.AbstractConstraint[])new PlacementConstraint.AbstractConstraint[]{PlacementConstraints.targetIn((String)"node", (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTag((String[])new String[]{"foo"})}), PlacementConstraints.targetIn((String)"node", (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTag((String[])new String[]{"moo"})})})}).build();
        Assert.assertEquals((Object)actualPc1, (Object)expectedPc1);
        expectedPc2 = PlacementConstraints.targetNotIn((String)"node", (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTag((String[])new String[]{"foo"})}).build();
        Assert.assertEquals((Object)expectedPc2, (Object)actualPc2);
    }

    private void verifyConstraintToString(String inputExpr, PlacementConstraint.AbstractConstraint constraint) {
        String constrainExpr = constraint.toString();
        System.out.println("Input:    " + inputExpr.toLowerCase().replaceAll(" ", ""));
        System.out.println("ToString: " + constrainExpr);
        try {
            PlacementConstraintParser.parseExpression((String)constrainExpr);
        }
        catch (PlacementConstraintParseException e) {
            Assert.fail((String)("The parser is unable to parse the expression: " + constrainExpr + ", caused by: " + e.getMessage()));
        }
    }

    @Test
    public void testParseNodeAttributeSpec() throws PlacementConstraintParseException {
        Map result = PlacementConstraintParser.parsePlacementSpec((String)"xyz=4,rm.yarn.io/foo=true");
        Assert.assertEquals((long)1L, (long)result.size());
        PlacementConstraint.TargetExpression target = PlacementConstraints.PlacementTargets.nodeAttribute((String)"rm.yarn.io/foo", (String[])new String[]{"true"});
        PlacementConstraint.AbstractConstraint expectedPc1 = PlacementConstraints.targetNodeAttribute((String)"node", (NodeAttributeOpCode)NodeAttributeOpCode.EQ, (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{target});
        PlacementConstraint actualPc1 = (PlacementConstraint)result.values().iterator().next();
        Assert.assertEquals((Object)expectedPc1, (Object)actualPc1.getConstraintExpr());
        result = PlacementConstraintParser.parsePlacementSpec((String)"xyz=3,rm.yarn.io/foo!=abc");
        Assert.assertEquals((long)1L, (long)result.size());
        target = PlacementConstraints.PlacementTargets.nodeAttribute((String)"rm.yarn.io/foo", (String[])new String[]{"abc"});
        expectedPc1 = PlacementConstraints.targetNodeAttribute((String)"node", (NodeAttributeOpCode)NodeAttributeOpCode.NE, (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{target});
        actualPc1 = (PlacementConstraint)result.values().iterator().next();
        Assert.assertEquals((Object)expectedPc1, (Object)actualPc1.getConstraintExpr());
        actualPc1 = (PlacementConstraint)result.values().iterator().next();
        Assert.assertEquals((Object)expectedPc1, (Object)actualPc1.getConstraintExpr());
        result = PlacementConstraintParser.parsePlacementSpec((String)"xyz=1,rm.yarn.io/foo!=abc:zxy=1,rm.yarn.io/bar=true");
        Assert.assertEquals((long)2L, (long)result.size());
        target = PlacementConstraints.PlacementTargets.nodeAttribute((String)"rm.yarn.io/foo", (String[])new String[]{"abc"});
        expectedPc1 = PlacementConstraints.targetNodeAttribute((String)"node", (NodeAttributeOpCode)NodeAttributeOpCode.NE, (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{target});
        target = PlacementConstraints.PlacementTargets.nodeAttribute((String)"rm.yarn.io/bar", (String[])new String[]{"true"});
        PlacementConstraint.AbstractConstraint expectedPc2 = PlacementConstraints.targetNodeAttribute((String)"node", (NodeAttributeOpCode)NodeAttributeOpCode.EQ, (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{target});
        Iterator valueIt = result.values().iterator();
        actualPc1 = (PlacementConstraint)valueIt.next();
        PlacementConstraint actualPc2 = (PlacementConstraint)valueIt.next();
        Assert.assertEquals((Object)expectedPc1, (Object)actualPc1.getConstraintExpr());
        Assert.assertEquals((Object)expectedPc2, (Object)actualPc2.getConstraintExpr());
        result = PlacementConstraintParser.parsePlacementSpec((String)"rm.yarn.io/foo=true");
        Assert.assertEquals((long)1L, (long)result.size());
        target = PlacementConstraints.PlacementTargets.nodeAttribute((String)"rm.yarn.io/foo", (String[])new String[]{"true"});
        expectedPc1 = PlacementConstraints.targetNodeAttribute((String)"node", (NodeAttributeOpCode)NodeAttributeOpCode.EQ, (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{target});
        PlacementConstraintParser.SourceTags actualSourceTags = (PlacementConstraintParser.SourceTags)result.keySet().iterator().next();
        Assert.assertTrue((boolean)actualSourceTags.isEmpty());
        actualPc1 = (PlacementConstraint)result.values().iterator().next();
        Assert.assertEquals((Object)expectedPc1, (Object)actualPc1.getConstraintExpr());
        try {
            PlacementConstraintParser.parsePlacementSpec((String)"rm.yarn.io/foo=true:xyz=1,notin,node,xyz");
            Assert.fail((String)"Expected a failure!");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof PlacementConstraintParseException));
        }
    }

    private static class TokenizerTester {
        private PlacementConstraintParser.ConstraintTokenizer tokenizer;
        private String[] expectedExtractions;

        protected TokenizerTester(PlacementConstraintParser.ConstraintTokenizer tk, String ... expctedStrings) {
            this.tokenizer = tk;
            this.expectedExtractions = expctedStrings;
        }

        void verify() throws PlacementConstraintParseException {
            this.tokenizer.validate();
            int i = 0;
            while (this.tokenizer.hasMoreElements()) {
                String current = (String)this.tokenizer.nextElement();
                Assert.assertTrue((i < this.expectedExtractions.length ? 1 : 0) != 0);
                Assert.assertEquals((Object)this.expectedExtractions[i], (Object)current);
                ++i;
            }
        }
    }
}

