/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.applications.distributedshell;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.yarn.api.resource.PlacementConstraint;
import org.apache.hadoop.yarn.util.constraint.PlacementConstraintParseException;
import org.apache.hadoop.yarn.util.constraint.PlacementConstraintParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlacementSpec {
    private static final Logger LOG = LoggerFactory.getLogger(PlacementSpec.class);
    public final String sourceTag;
    public final PlacementConstraint constraint;
    private int numContainers;

    public PlacementSpec(String sourceTag, int numContainers, PlacementConstraint constraint) {
        this.sourceTag = sourceTag;
        this.numContainers = numContainers;
        this.constraint = constraint;
    }

    public int getNumContainers() {
        return this.numContainers;
    }

    public void setNumContainers(int numContainers) {
        this.numContainers = numContainers;
    }

    public static Map<String, PlacementSpec> parse(String specs) throws IllegalArgumentException {
        LOG.info("Parsing Placement Specs: [{}]", (Object)specs);
        HashMap<String, PlacementSpec> pSpecs = new HashMap<String, PlacementSpec>();
        try {
            Map parsed = PlacementConstraintParser.parsePlacementSpec((String)specs);
            for (Map.Entry entry : parsed.entrySet()) {
                LOG.info("Parsed source tag: {}, number of allocations: {}", (Object)((PlacementConstraintParser.SourceTags)entry.getKey()).getTag(), (Object)((PlacementConstraintParser.SourceTags)entry.getKey()).getNumOfAllocations());
                LOG.info("Parsed constraint: {}", (Object)((PlacementConstraint)entry.getValue()).getConstraintExpr().getClass().getSimpleName());
                pSpecs.put(((PlacementConstraintParser.SourceTags)entry.getKey()).getTag(), new PlacementSpec(((PlacementConstraintParser.SourceTags)entry.getKey()).getTag(), ((PlacementConstraintParser.SourceTags)entry.getKey()).getNumOfAllocations(), (PlacementConstraint)entry.getValue()));
            }
            return pSpecs;
        }
        catch (PlacementConstraintParseException e) {
            throw new IllegalArgumentException("Invalid placement spec: " + specs, e);
        }
    }
}

