/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client;

import io.hops.leader_election.node.ActiveNode;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.retry.FailoverProxyProvider;
import org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.yarn.client.GroupMembershipProxyService;
import org.apache.hadoop.yarn.client.RMFailoverProxyProvider;
import org.apache.hadoop.yarn.client.RMProxy;
import org.apache.hadoop.yarn.conf.YarnConfiguration;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public abstract class ConfiguredRMFailoverHAProxyProvider<T>
implements RMFailoverProxyProvider<T> {
    private static final Log LOG = LogFactory.getLog(ConfiguredRMFailoverHAProxyProvider.class);
    private RMProxy<T> rmProxy;
    private T currentProxy;
    private String currentRMId = null;
    Map<String, T> oldProxies = new HashMap<String, T>();
    private Class<T> protocol;
    protected YarnConfiguration conf;
    protected GroupMembershipProxyService groupMembership;

    @Override
    public void init(Configuration configuration, RMProxy<T> rmProxy, Class<T> protocol) {
        this.rmProxy = rmProxy;
        this.protocol = protocol;
        rmProxy.checkAllowedProtocols(this.protocol);
        this.conf = new YarnConfiguration(configuration);
        this.conf.setInt("ipc.client.connect.max.retries", this.conf.getInt("yarn.client.failover-retries", 0));
        this.conf.setInt("ipc.client.connect.max.retries.on.timeouts", this.conf.getInt("yarn.client.failover-retries-on-socket-timeouts", 0));
        this.groupMembership = new GroupMembershipProxyService((Configuration)this.conf, rmProxy);
    }

    private T getProxyFromActiveNode(ActiveNode leader) {
        T proxy = this.oldProxies.get(leader.getHostname());
        if (proxy != null) {
            return proxy;
        }
        return this.createProxy(leader);
    }

    private T createProxy(ActiveNode leader) {
        try {
            InetSocketAddress rmAddress = this.rmProxy.getRMAddress(this.conf, this.protocol, leader.getHttpAddress());
            LOG.info((Object)("creating proxy from active nodes " + this.currentRMId + " " + rmAddress.getPort()));
            return RMProxy.getProxy((Configuration)this.conf, this.protocol, rmAddress);
        }
        catch (IOException ioe) {
            LOG.error((Object)("Unable to create proxy to the ResourceManager " + leader.toString()), (Throwable)ioe);
            return null;
        }
    }

    public synchronized FailoverProxyProvider.ProxyInfo<T> getProxy() {
        if (this.currentProxy == null) {
            this.performFailover(this.currentProxy);
        }
        return new FailoverProxyProvider.ProxyInfo(this.currentProxy, this.currentRMId);
    }

    public synchronized void performFailover(T currentProxy) {
        LOG.info((Object)"performing failover");
        if (currentProxy != null) {
            this.oldProxies.put(this.currentRMId, this.currentProxy);
        }
        int nbTry = 0;
        do {
            ActiveNode leader;
            if ((leader = this.getActiveNode()) == null) continue;
            if (this.currentRMId == null || !this.currentRMId.equals(leader.getHttpAddress())) {
                this.currentRMId = leader.getHttpAddress();
                this.currentProxy = this.getProxyFromActiveNode(leader);
                continue;
            }
            this.currentProxy = this.createProxy(leader);
            if (this.currentProxy != null) continue;
            ++nbTry;
            try {
                Thread.sleep(RetryPolicies.calculateExponentialTime((long)500L, (int)nbTry, (long)10000L));
            }
            catch (Exception e) {
                LOG.error((Object)e);
            }
        } while (this.currentProxy == null);
        this.conf.set("yarn.resourcemanager.ha.id", this.currentRMId);
        LOG.info((Object)("Failing over to " + this.currentRMId));
    }

    protected abstract ActiveNode getActiveNode();

    public Class<T> getInterface() {
        return this.protocol;
    }

    public synchronized void close() throws IOException {
        this.groupMembership.close();
        for (T proxy : this.oldProxies.values()) {
            if (proxy instanceof Closeable) {
                ((Closeable)proxy).close();
                continue;
            }
            RPC.stopProxy(proxy);
        }
    }
}

