/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util.resource;

import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.util.resource.DominantResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;

public class DominantResourceCalculatorGPU
extends DominantResourceCalculator {
    @Override
    public long computeAvailableContainers(Resource available, Resource required) {
        long vCoreMemoryContainers = Math.min(available.getMemorySize() / required.getMemorySize(), (long)(available.getVirtualCores() / required.getVirtualCores()));
        if (required.getGPUs() > 0) {
            long vCoreMemoryGPUContainers = Math.min(vCoreMemoryContainers, (long)(available.getGPUs() / required.getGPUs()));
            return vCoreMemoryGPUContainers;
        }
        return vCoreMemoryContainers;
    }

    @Override
    public Resource divideAndCeil(Resource numerator, int denominator) {
        return Resources.createResource(DominantResourceCalculatorGPU.divideAndCeil(numerator.getMemorySize(), (long)denominator), DominantResourceCalculatorGPU.divideAndCeil(numerator.getVirtualCores(), denominator), numerator.getGPUs());
    }

    @Override
    public Resource normalize(Resource r, Resource minimumResource, Resource maximumResource, Resource stepFactor) {
        long normalizedMemory = Math.min(DominantResourceCalculatorGPU.roundUp(Math.max(r.getMemorySize(), minimumResource.getMemorySize()), stepFactor.getMemorySize()), maximumResource.getMemorySize());
        int normalizedCores = Math.min(DominantResourceCalculatorGPU.roundUp(Math.max(r.getVirtualCores(), minimumResource.getVirtualCores()), stepFactor.getVirtualCores()), maximumResource.getVirtualCores());
        int normalizedGPUs = Math.min(DominantResourceCalculatorGPU.roundUpWithZero(Math.max(r.getGPUs(), minimumResource.getGPUs()), stepFactor.getGPUs()), maximumResource.getGPUs());
        return Resources.createResource(normalizedMemory, normalizedCores, normalizedGPUs);
    }

    @Override
    public Resource roundUp(Resource r, Resource stepFactor) {
        return Resources.createResource(DominantResourceCalculatorGPU.roundUp(r.getMemorySize(), stepFactor.getMemorySize()), DominantResourceCalculatorGPU.roundUp(r.getVirtualCores(), stepFactor.getVirtualCores()), DominantResourceCalculatorGPU.roundUpWithZero(r.getGPUs(), stepFactor.getGPUs()));
    }

    @Override
    public Resource roundDown(Resource r, Resource stepFactor) {
        return Resources.createResource(DominantResourceCalculatorGPU.roundDown(r.getMemorySize(), stepFactor.getMemorySize()), DominantResourceCalculatorGPU.roundDown(r.getVirtualCores(), stepFactor.getVirtualCores()), DominantResourceCalculatorGPU.roundDownWithZero(r.getGPUs(), stepFactor.getGPUs()));
    }

    @Override
    public Resource multiplyAndNormalizeUp(Resource r, double by, Resource stepFactor) {
        return Resources.createResource(DominantResourceCalculatorGPU.roundUp((long)((int)Math.ceil((double)r.getMemorySize() * by)), stepFactor.getMemorySize()), DominantResourceCalculatorGPU.roundUp((int)Math.ceil((double)r.getVirtualCores() * by), stepFactor.getVirtualCores()), DominantResourceCalculatorGPU.roundUpWithZero((int)Math.ceil((double)r.getGPUs() * by), stepFactor.getGPUs()));
    }

    @Override
    public Resource multiplyAndNormalizeDown(Resource r, double by, Resource stepFactor) {
        return Resources.createResource(DominantResourceCalculatorGPU.roundDown((long)((int)((double)r.getMemorySize() * by)), stepFactor.getMemorySize()), DominantResourceCalculatorGPU.roundDown((int)((double)r.getVirtualCores() * by), stepFactor.getVirtualCores()), DominantResourceCalculatorGPU.roundDownWithZero((int)((double)r.getGPUs() * by), stepFactor.getGPUs()));
    }

    @Override
    public boolean fitsIn(Resource cluster, Resource smaller, Resource bigger) {
        return smaller.getMemorySize() <= bigger.getMemorySize() && smaller.getVirtualCores() <= bigger.getVirtualCores() && smaller.getGPUs() <= bigger.getGPUs();
    }
}

