/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util;

import java.io.File;
import java.util.Enumeration;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.yarn.util.AdHocLogDumper;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.junit.Assert;
import org.junit.Test;

public class TestAdHocLogDumper {
    private static final Log LOG = LogFactory.getLog(TestAdHocLogDumper.class);

    @Test
    public void testDumpingSchedulerLogs() throws Exception {
        boolean del;
        HashMap<AppenderSkeleton, Priority> levels = new HashMap<AppenderSkeleton, Priority>();
        String logHierarchy = TestAdHocLogDumper.class.getName();
        String logFilename = "test.log";
        Log log = LogFactory.getLog((String)logHierarchy);
        if (log instanceof Log4JLogger) {
            Enumeration appenders = Logger.getRootLogger().getAllAppenders();
            while (appenders.hasMoreElements()) {
                Object obj = appenders.nextElement();
                if (!(obj instanceof AppenderSkeleton)) continue;
                AppenderSkeleton appender = (AppenderSkeleton)obj;
                levels.put(appender, appender.getThreshold());
            }
        }
        AdHocLogDumper dumper = new AdHocLogDumper(logHierarchy, logFilename);
        dumper.dumpLogs("DEBUG", 1000);
        LOG.debug((Object)"test message 1");
        LOG.info((Object)"test message 2");
        File logFile = new File(logFilename);
        Assert.assertTrue((boolean)logFile.exists());
        Thread.sleep(2000L);
        long lastWrite = logFile.lastModified();
        Assert.assertTrue((lastWrite < Time.now() ? 1 : 0) != 0);
        Assert.assertTrue((logFile.length() != 0L ? 1 : 0) != 0);
        if (log instanceof Log4JLogger) {
            Enumeration appenders = Logger.getRootLogger().getAllAppenders();
            while (appenders.hasMoreElements()) {
                Object obj = appenders.nextElement();
                if (!(obj instanceof AppenderSkeleton)) continue;
                AppenderSkeleton appender = (AppenderSkeleton)obj;
                Assert.assertEquals(levels.get(appender), (Object)appender.getThreshold());
            }
        }
        if (!(del = logFile.delete())) {
            LOG.info((Object)"Couldn't clean up after test");
        }
    }
}

