/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util.resource;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class DefaultResourceCalculator
extends ResourceCalculator {
    @Override
    public int compare(Resource unused, Resource lhs, Resource rhs) {
        return Long.compare(lhs.getMemorySize(), rhs.getMemorySize());
    }

    @Override
    public long computeAvailableContainers(Resource available, Resource required) {
        return available.getMemorySize() / required.getMemorySize();
    }

    @Override
    public float divide(Resource unused, Resource numerator, Resource denominator) {
        return this.ratio(numerator, denominator);
    }

    @Override
    public boolean isInvalidDivisor(Resource r) {
        return (float)r.getMemorySize() == 0.0f;
    }

    @Override
    public float ratio(Resource a, Resource b) {
        return (float)a.getMemorySize() / (float)b.getMemorySize();
    }

    @Override
    public Resource divideAndCeil(Resource numerator, int denominator) {
        return Resources.createResource(DefaultResourceCalculator.divideAndCeil(numerator.getMemorySize(), (long)denominator));
    }

    @Override
    public Resource normalize(Resource r, Resource minimumResource, Resource maximumResource, Resource stepFactor) {
        long normalizedMemory = Math.min(DefaultResourceCalculator.roundUp(Math.max(r.getMemorySize(), minimumResource.getMemorySize()), stepFactor.getMemorySize()), maximumResource.getMemorySize());
        return Resources.createResource(normalizedMemory);
    }

    @Override
    public Resource normalize(Resource r, Resource minimumResource, Resource maximumResource) {
        return this.normalize(r, minimumResource, maximumResource, minimumResource);
    }

    @Override
    public Resource roundUp(Resource r, Resource stepFactor) {
        return Resources.createResource(DefaultResourceCalculator.roundUp(r.getMemorySize(), stepFactor.getMemorySize()));
    }

    @Override
    public Resource roundDown(Resource r, Resource stepFactor) {
        return Resources.createResource(DefaultResourceCalculator.roundDown(r.getMemorySize(), stepFactor.getMemorySize()));
    }

    @Override
    public Resource multiplyAndNormalizeUp(Resource r, double by, Resource stepFactor) {
        return Resources.createResource(DefaultResourceCalculator.roundUp((long)((double)r.getMemorySize() * by + 0.5), stepFactor.getMemorySize()));
    }

    @Override
    public Resource multiplyAndNormalizeDown(Resource r, double by, Resource stepFactor) {
        return Resources.createResource(DefaultResourceCalculator.roundDown((long)((double)r.getMemorySize() * by), stepFactor.getMemorySize()));
    }

    @Override
    public boolean fitsIn(Resource cluster, Resource smaller, Resource bigger) {
        return smaller.getMemorySize() <= bigger.getMemorySize();
    }
}

