/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util;

import java.io.File;
import java.util.HashMap;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.yarn.util.Apps;
import org.junit.Assert;
import org.junit.Test;

public class TestApps {
    @Test
    public void testSetEnvFromInputString() {
        HashMap<String, String> environment = new HashMap<String, String>();
        environment.put("JAVA_HOME", "/path/jdk");
        String goodEnv = "a1=1,b_2=2,_c=3,d=4,e=,f_win=%JAVA_HOME%,g_nix=$JAVA_HOME";
        Apps.setEnvFromInputString(environment, (String)goodEnv, (String)File.pathSeparator);
        Assert.assertEquals((Object)"1", environment.get("a1"));
        Assert.assertEquals((Object)"2", environment.get("b_2"));
        Assert.assertEquals((Object)"3", environment.get("_c"));
        Assert.assertEquals((Object)"4", environment.get("d"));
        Assert.assertEquals((Object)"", environment.get("e"));
        if (Shell.WINDOWS) {
            Assert.assertEquals((Object)"$JAVA_HOME", environment.get("g_nix"));
            Assert.assertEquals((Object)"/path/jdk", environment.get("f_win"));
        } else {
            Assert.assertEquals((Object)"/path/jdk", environment.get("g_nix"));
            Assert.assertEquals((Object)"%JAVA_HOME%", environment.get("f_win"));
        }
        String badEnv = "1,,2=a=b,3=a=,4==,5==a,==,c-3=3,=";
        environment.clear();
        Apps.setEnvFromInputString(environment, (String)badEnv, (String)File.pathSeparator);
        Assert.assertEquals((long)environment.size(), (long)0L);
        environment.clear();
        Apps.setEnvFromInputString(environment, (String)"b1,e1==,e2=a1=a2,b2", (String)File.pathSeparator);
        Assert.assertEquals((Object)"=", environment.get("e1"));
        Assert.assertEquals((Object)"a1=a2", environment.get("e2"));
    }
}

