/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client;

import com.google.common.base.Preconditions;
import java.io.EOFException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.io.retry.RetryProxy;
import org.apache.hadoop.ipc.RetriableException;
import org.apache.hadoop.net.ConnectTimeoutException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.exceptions.NMNotYetReadyException;
import org.apache.hadoop.yarn.ipc.YarnRPC;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class ServerProxy {
    protected static RetryPolicy createRetryPolicy(Configuration conf, String maxWaitTimeStr, long defMaxWaitTime, String connectRetryIntervalStr, long defRetryInterval) {
        long maxWaitTime = conf.getLong(maxWaitTimeStr, defMaxWaitTime);
        long retryIntervalMS = conf.getLong(connectRetryIntervalStr, defRetryInterval);
        Preconditions.checkArgument((maxWaitTime == -1L || maxWaitTime > 0L ? 1 : 0) != 0, (Object)("Invalid Configuration. " + maxWaitTimeStr + " should be either positive value or -1."));
        Preconditions.checkArgument((retryIntervalMS > 0L ? 1 : 0) != 0, (Object)("Invalid Configuration. " + connectRetryIntervalStr + "should be a positive value."));
        RetryPolicy retryPolicy = null;
        retryPolicy = maxWaitTime == -1L ? RetryPolicies.retryForeverWithFixedSleep((long)retryIntervalMS, (TimeUnit)TimeUnit.MILLISECONDS) : RetryPolicies.retryUpToMaximumTimeWithFixedSleep((long)maxWaitTime, (long)retryIntervalMS, (TimeUnit)TimeUnit.MILLISECONDS);
        HashMap<Class<NMNotYetReadyException>, RetryPolicy> exceptionToPolicyMap = new HashMap<Class<NMNotYetReadyException>, RetryPolicy>();
        exceptionToPolicyMap.put(EOFException.class, retryPolicy);
        exceptionToPolicyMap.put(ConnectException.class, retryPolicy);
        exceptionToPolicyMap.put(NoRouteToHostException.class, retryPolicy);
        exceptionToPolicyMap.put(UnknownHostException.class, retryPolicy);
        exceptionToPolicyMap.put(ConnectTimeoutException.class, retryPolicy);
        exceptionToPolicyMap.put(RetriableException.class, retryPolicy);
        exceptionToPolicyMap.put(SocketException.class, retryPolicy);
        exceptionToPolicyMap.put(SSLException.class, RetryPolicies.TRY_ONCE_THEN_FAIL);
        exceptionToPolicyMap.put(NMNotYetReadyException.class, retryPolicy);
        return RetryPolicies.retryByException((RetryPolicy)RetryPolicies.TRY_ONCE_THEN_FAIL, exceptionToPolicyMap);
    }

    protected static <T> T createRetriableProxy(final Configuration conf, final Class<T> protocol, UserGroupInformation user, final YarnRPC rpc, final InetSocketAddress serverAddress, RetryPolicy retryPolicy) {
        Object proxy = user.doAs(new PrivilegedAction<T>(){

            @Override
            public T run() {
                return rpc.getProxy(protocol, serverAddress, conf);
            }
        });
        return (T)RetryProxy.create(protocol, (Object)proxy, (RetryPolicy)retryPolicy);
    }
}

