/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util;

import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.SystemClock;

public class ControlledClock
implements Clock {
    private long time = -1L;
    private final Clock actualClock;

    public ControlledClock() {
        this((Clock)new SystemClock());
        this.setTime(0L);
    }

    public ControlledClock(Clock actualClock) {
        this.actualClock = actualClock;
    }

    public synchronized void setTime(long time) {
        this.time = time;
    }

    public synchronized void reset() {
        this.time = -1L;
    }

    public synchronized void tickSec(int seconds) {
        this.tickMsec((long)seconds * 1000L);
    }

    public synchronized void tickMsec(long millisec) {
        if (this.time == -1L) {
            throw new IllegalStateException("ControlledClock setTime should be called before incrementing time");
        }
        this.time += millisec;
    }

    public synchronized long getTime() {
        if (this.time != -1L) {
            return this.time;
        }
        return this.actualClock.getTime();
    }
}

