/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client.api.impl;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.timeline.TimelineDomain;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntityGroupId;
import org.apache.hadoop.yarn.client.api.impl.FileSystemTimelineWriter;
import org.apache.hadoop.yarn.client.api.impl.TimelineClientImpl;
import org.apache.hadoop.yarn.client.api.impl.TimelineWriter;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestTimelineClientForATS1_5 {
    protected static Log LOG = LogFactory.getLog(TestTimelineClientForATS1_5.class);
    private TimelineClientImpl client;
    private static FileContext localFS;
    private static File localActiveDir;
    private TimelineWriter spyTimelineWriter;

    @Before
    public void setup() throws Exception {
        localFS = FileContext.getLocalFSFileContext();
        localActiveDir = new File("target", this.getClass().getSimpleName() + "-activeDir").getAbsoluteFile();
        localFS.delete(new Path(localActiveDir.getAbsolutePath()), true);
        localActiveDir.mkdir();
        LOG.info((Object)("Created activeDir in " + localActiveDir.getAbsolutePath()));
        YarnConfiguration conf = new YarnConfiguration();
        conf.setBoolean("yarn.timeline-service.enabled", true);
        conf.setFloat("yarn.timeline-service.version", 1.5f);
        conf.set("yarn.timeline-service.entity-group-fs-store.active-dir", localActiveDir.getAbsolutePath());
        conf.set("yarn.timeline-service.entity-group-fs-store.summary-entity-types", "summary_type");
        this.client = this.createTimelineClient(conf);
    }

    @After
    public void tearDown() throws Exception {
        if (this.client != null) {
            this.client.stop();
        }
        localFS.delete(new Path(localActiveDir.getAbsolutePath()), true);
    }

    @Test
    public void testPostEntities() throws Exception {
        ApplicationId appId = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1);
        TimelineEntityGroupId groupId = TimelineEntityGroupId.newInstance((ApplicationId)appId, (String)"1");
        TimelineEntityGroupId groupId2 = TimelineEntityGroupId.newInstance((ApplicationId)appId, (String)"2");
        TimelineEntity[] entities = new TimelineEntity[]{TestTimelineClientForATS1_5.generateEntity("entity_type"), TestTimelineClientForATS1_5.generateEntity("summary_type")};
        try {
            this.client.putEntities(null, null, entities);
            ((TimelineWriter)Mockito.verify((Object)this.spyTimelineWriter, (VerificationMode)Mockito.times((int)1))).putEntities(entities);
            Mockito.reset((Object[])new TimelineWriter[]{this.spyTimelineWriter});
            ApplicationAttemptId attemptId1 = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1);
            this.client.putEntities(attemptId1, null, entities);
            TimelineEntity[] entityTDB = new TimelineEntity[]{entities[0]};
            ((TimelineWriter)Mockito.verify((Object)this.spyTimelineWriter, (VerificationMode)Mockito.times((int)1))).putEntities(entityTDB);
            Assert.assertTrue((boolean)localFS.util().exists(new Path(this.getAppAttemptDir(attemptId1), "summarylog-" + attemptId1.toString())));
            Mockito.reset((Object[])new TimelineWriter[]{this.spyTimelineWriter});
            ApplicationAttemptId attemptId2 = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)2);
            this.client.putEntities(attemptId2, groupId, entities);
            this.client.putEntities(attemptId2, groupId2, entities);
            ((TimelineWriter)Mockito.verify((Object)this.spyTimelineWriter, (VerificationMode)Mockito.times((int)0))).putEntities((TimelineEntity[])Matchers.any(TimelineEntity[].class));
            Assert.assertTrue((boolean)localFS.util().exists(new Path(this.getAppAttemptDir(attemptId2), "summarylog-" + attemptId2.toString())));
            Assert.assertTrue((boolean)localFS.util().exists(new Path(this.getAppAttemptDir(attemptId2), "entitylog-" + groupId.toString())));
            Assert.assertTrue((boolean)localFS.util().exists(new Path(this.getAppAttemptDir(attemptId2), "entitylog-" + groupId2.toString())));
            Mockito.reset((Object[])new TimelineWriter[]{this.spyTimelineWriter});
        }
        catch (Exception e) {
            Assert.fail((String)("Exception is not expected. " + e));
        }
    }

    @Test
    public void testPutDomain() {
        ApplicationId appId = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1);
        ApplicationAttemptId attemptId1 = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1);
        try {
            TimelineDomain domain = TestTimelineClientForATS1_5.generateDomain();
            this.client.putDomain(null, domain);
            ((TimelineWriter)Mockito.verify((Object)this.spyTimelineWriter, (VerificationMode)Mockito.times((int)1))).putDomain(domain);
            Mockito.reset((Object[])new TimelineWriter[]{this.spyTimelineWriter});
            this.client.putDomain(attemptId1, domain);
            ((TimelineWriter)Mockito.verify((Object)this.spyTimelineWriter, (VerificationMode)Mockito.times((int)0))).putDomain(domain);
            Assert.assertTrue((boolean)localFS.util().exists(new Path(this.getAppAttemptDir(attemptId1), "domainlog-" + attemptId1.toString())));
            Mockito.reset((Object[])new TimelineWriter[]{this.spyTimelineWriter});
        }
        catch (Exception e) {
            Assert.fail((String)("Exception is not expected." + e));
        }
    }

    private Path getAppAttemptDir(ApplicationAttemptId appAttemptId) {
        Path appDir = new Path(localActiveDir.getAbsolutePath(), appAttemptId.getApplicationId().toString());
        Path attemptDir = new Path(appDir, appAttemptId.toString());
        return attemptDir;
    }

    private static TimelineEntity generateEntity(String type) {
        TimelineEntity entity = new TimelineEntity();
        entity.setEntityId("entity id");
        entity.setEntityType(type);
        entity.setStartTime(Long.valueOf(System.currentTimeMillis()));
        return entity;
    }

    private static TimelineDomain generateDomain() {
        TimelineDomain domain = new TimelineDomain();
        domain.setId("namesapce id");
        domain.setDescription("domain description");
        domain.setOwner("domain owner");
        domain.setReaders("domain_reader");
        domain.setWriters("domain_writer");
        domain.setCreatedTime(Long.valueOf(0L));
        domain.setModifiedTime(Long.valueOf(1L));
        return domain;
    }

    private TimelineClientImpl createTimelineClient(YarnConfiguration conf) {
        TimelineClientImpl client = new TimelineClientImpl(){

            protected TimelineWriter createTimelineWriter(Configuration conf, UserGroupInformation authUgi, Client client, URI resURI) throws IOException {
                FileSystemTimelineWriter timelineWriter = new FileSystemTimelineWriter(conf, authUgi, client, resURI){

                    public ClientResponse doPostingObject(Object object, String path) {
                        ClientResponse response = (ClientResponse)Mockito.mock(ClientResponse.class);
                        Mockito.when((Object)response.getClientResponseStatus()).thenReturn((Object)ClientResponse.Status.OK);
                        return response;
                    }
                };
                TestTimelineClientForATS1_5.this.spyTimelineWriter = (TimelineWriter)Mockito.spy((Object)timelineWriter);
                return TestTimelineClientForATS1_5.this.spyTimelineWriter;
            }
        };
        client.init((Configuration)conf);
        client.start();
        return client;
    }
}

