/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util.resource;

import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.Assert;
import org.junit.Test;

public class TestResources {
    public Resource createResource(long memory, int vCores, int gpus) {
        return Resource.newInstance((long)memory, (int)vCores, (int)gpus);
    }

    @Test(timeout=10000L)
    public void testCompareToWithUnboundedResource() {
        Assert.assertTrue((Resources.unbounded().compareTo((Object)this.createResource(Long.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((Resources.unbounded().compareTo((Object)this.createResource(Long.MAX_VALUE, 0, Integer.MAX_VALUE)) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((Resources.unbounded().compareTo((Object)this.createResource(0L, Integer.MAX_VALUE, Integer.MAX_VALUE)) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((Resources.unbounded().compareTo((Object)this.createResource(Long.MAX_VALUE, Integer.MAX_VALUE, 0)) > 0 ? 1 : 0) != 0);
    }

    @Test(timeout=10000L)
    public void testCompareToWithNoneResource() {
        Assert.assertTrue((Resources.none().compareTo((Object)this.createResource(0L, 0, 0)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((Resources.none().compareTo((Object)this.createResource(1L, 0, 0)) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((Resources.none().compareTo((Object)this.createResource(0L, 1, 0)) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((Resources.none().compareTo((Object)this.createResource(0L, 0, 1)) < 0 ? 1 : 0) != 0);
    }
}

