/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util;

import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.URL;
import org.apache.hadoop.yarn.factories.RecordFactory;

@InterfaceAudience.Public
public class ConverterUtils {
    public static final String APPLICATION_PREFIX = "application";
    public static final String CONTAINER_PREFIX = "container";
    public static final String APPLICATION_ATTEMPT_PREFIX = "appattempt";

    @InterfaceAudience.Public
    @Deprecated
    public static Path getPathFromYarnURL(URL url) throws URISyntaxException {
        return url.toPath();
    }

    @InterfaceAudience.Public
    @Deprecated
    public static URL getYarnUrlFromPath(Path path) {
        return URL.fromPath((Path)path);
    }

    @InterfaceAudience.Public
    @Deprecated
    public static URL getYarnUrlFromURI(URI uri) {
        return URL.fromURI((URI)uri);
    }

    @InterfaceAudience.Public
    @Deprecated
    public static String toString(ApplicationId appId) {
        return appId.toString();
    }

    @InterfaceAudience.Public
    @Deprecated
    public static ApplicationId toApplicationId(RecordFactory recordFactory, String applicationIdStr) {
        return ApplicationId.fromString((String)applicationIdStr);
    }

    @InterfaceAudience.Public
    @Deprecated
    public static String toString(ContainerId cId) {
        return cId == null ? null : cId.toString();
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static NodeId toNodeIdWithDefaultPort(String nodeIdStr) {
        if (nodeIdStr.indexOf(":") < 0) {
            return NodeId.fromString((String)(nodeIdStr + ":0"));
        }
        return NodeId.fromString((String)nodeIdStr);
    }

    @InterfaceAudience.Public
    @Deprecated
    public static NodeId toNodeId(String nodeIdStr) {
        return NodeId.fromString((String)nodeIdStr);
    }

    @InterfaceAudience.Public
    @Deprecated
    public static ContainerId toContainerId(String containerIdStr) {
        return ContainerId.fromString((String)containerIdStr);
    }

    @InterfaceAudience.Public
    @Deprecated
    public static ApplicationAttemptId toApplicationAttemptId(String applicationAttemptIdStr) {
        return ApplicationAttemptId.fromString((String)applicationAttemptIdStr);
    }

    @InterfaceAudience.Public
    @Deprecated
    public static ApplicationId toApplicationId(String appIdStr) {
        return ApplicationId.fromString((String)appIdStr);
    }

    public static <T extends TokenIdentifier> Token<T> convertFromYarn(org.apache.hadoop.yarn.api.records.Token protoToken, InetSocketAddress serviceAddr) {
        Token token = new Token(protoToken.getIdentifier().array(), protoToken.getPassword().array(), new Text(protoToken.getKind()), new Text(protoToken.getService()));
        if (serviceAddr != null) {
            SecurityUtil.setTokenService((Token)token, (InetSocketAddress)serviceAddr);
        }
        return token;
    }

    public static <T extends TokenIdentifier> Token<T> convertFromYarn(org.apache.hadoop.yarn.api.records.Token protoToken, Text service) {
        Token token = new Token(protoToken.getIdentifier().array(), protoToken.getPassword().array(), new Text(protoToken.getKind()), new Text(protoToken.getService()));
        if (service != null) {
            token.setService(service);
        }
        return token;
    }
}

