/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.resource;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.yarn.api.resource.PlacementConstraint;
import org.apache.hadoop.yarn.api.resource.PlacementConstraintTransformations;
import org.apache.hadoop.yarn.api.resource.PlacementConstraints;
import org.junit.Assert;
import org.junit.Test;

public class TestPlacementConstraintTransformations {
    @Test
    public void testTargetConstraint() {
        PlacementConstraint.AbstractConstraint sConstraintExpr = PlacementConstraints.targetIn((String)"node", (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTag((String[])new String[]{"hbase-m"})});
        Assert.assertTrue((boolean)(sConstraintExpr instanceof PlacementConstraint.SingleConstraint));
        PlacementConstraint sConstraint = PlacementConstraints.build((PlacementConstraint.AbstractConstraint)sConstraintExpr);
        PlacementConstraintTransformations.SpecializedConstraintTransformer specTransformer = new PlacementConstraintTransformations.SpecializedConstraintTransformer(sConstraint);
        PlacementConstraint tConstraint = specTransformer.transform();
        PlacementConstraint.AbstractConstraint tConstraintExpr = tConstraint.getConstraintExpr();
        Assert.assertTrue((boolean)(tConstraintExpr instanceof PlacementConstraint.TargetConstraint));
        PlacementConstraint.SingleConstraint single = (PlacementConstraint.SingleConstraint)sConstraintExpr;
        PlacementConstraint.TargetConstraint target = (PlacementConstraint.TargetConstraint)tConstraintExpr;
        Assert.assertEquals((Object)single.toString(), (Object)target.toString());
        Assert.assertEquals((Object)single.getScope(), (Object)target.getScope());
        Assert.assertEquals((Object)PlacementConstraint.TargetConstraint.TargetOperator.IN, (Object)target.getOp());
        Assert.assertEquals((Object)single.getTargetExpressions(), (Object)target.getTargetExpressions());
        PlacementConstraintTransformations.SingleConstraintTransformer singleTransformer = new PlacementConstraintTransformations.SingleConstraintTransformer(tConstraint);
        sConstraint = singleTransformer.transform();
        sConstraintExpr = sConstraint.getConstraintExpr();
        Assert.assertTrue((boolean)(sConstraintExpr instanceof PlacementConstraint.SingleConstraint));
        single = (PlacementConstraint.SingleConstraint)sConstraintExpr;
        Assert.assertEquals((Object)target.getScope(), (Object)single.getScope());
        Assert.assertEquals((long)1L, (long)single.getMinCardinality());
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)single.getMaxCardinality());
        Assert.assertEquals((Object)single.getTargetExpressions(), (Object)target.getTargetExpressions());
    }

    @Test
    public void testCardinalityConstraint() {
        PlacementConstraint.CardinalityConstraint cardinality = new PlacementConstraint.CardinalityConstraint("rack", 3, 10, new HashSet<String>(Arrays.asList("hb")));
        PlacementConstraint cConstraint = PlacementConstraints.build((PlacementConstraint.AbstractConstraint)cardinality);
        PlacementConstraintTransformations.SingleConstraintTransformer singleTransformer = new PlacementConstraintTransformations.SingleConstraintTransformer(cConstraint);
        PlacementConstraint sConstraint = singleTransformer.transform();
        PlacementConstraint.AbstractConstraint sConstraintExpr = sConstraint.getConstraintExpr();
        Assert.assertTrue((boolean)(sConstraintExpr instanceof PlacementConstraint.SingleConstraint));
        PlacementConstraint.SingleConstraint single = (PlacementConstraint.SingleConstraint)sConstraintExpr;
        Assert.assertEquals((Object)single.toString(), (Object)cardinality.toString());
        Assert.assertEquals((Object)cardinality.getScope(), (Object)single.getScope());
        Assert.assertEquals((long)cardinality.getMinCardinality(), (long)single.getMinCardinality());
        Assert.assertEquals((long)cardinality.getMaxCardinality(), (long)single.getMaxCardinality());
        Assert.assertEquals(new HashSet<PlacementConstraint.TargetExpression>(Arrays.asList(PlacementConstraints.PlacementTargets.allocationTag((String[])new String[]{"hb"}))), (Object)single.getTargetExpressions());
    }

    @Test
    public void testTargetCardinalityConstraint() {
        PlacementConstraint.AbstractConstraint constraintExpr = PlacementConstraints.targetCardinality((String)"rack", (int)3, (int)10, (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTag((String[])new String[]{"zk"})});
        Assert.assertTrue((boolean)(constraintExpr instanceof PlacementConstraint.SingleConstraint));
        PlacementConstraint constraint = PlacementConstraints.build((PlacementConstraint.AbstractConstraint)constraintExpr);
        PlacementConstraintTransformations.SpecializedConstraintTransformer specTransformer = new PlacementConstraintTransformations.SpecializedConstraintTransformer(constraint);
        PlacementConstraint newConstraint = specTransformer.transform();
        Assert.assertEquals((Object)constraintExpr, (Object)newConstraint.getConstraintExpr());
    }

    @Test
    public void testCompositeConstraint() {
        PlacementConstraint.Or constraintExpr = PlacementConstraints.or((PlacementConstraint.AbstractConstraint[])new PlacementConstraint.AbstractConstraint[]{PlacementConstraints.targetIn((String)"rack", (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTag((String[])new String[]{"spark"})}), PlacementConstraints.maxCardinality((String)"node", (int)3, (String[])new String[0]), PlacementConstraints.targetCardinality((String)"rack", (int)2, (int)10, (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTag((String[])new String[]{"zk"})})});
        Assert.assertTrue((boolean)(constraintExpr instanceof PlacementConstraint.Or));
        PlacementConstraint constraint = PlacementConstraints.build((PlacementConstraint.AbstractConstraint)constraintExpr);
        PlacementConstraint.Or orExpr = constraintExpr;
        for (PlacementConstraint.AbstractConstraint child : orExpr.getChildren()) {
            Assert.assertTrue((boolean)(child instanceof PlacementConstraint.SingleConstraint));
        }
        PlacementConstraintTransformations.SpecializedConstraintTransformer specTransformer = new PlacementConstraintTransformations.SpecializedConstraintTransformer(constraint);
        PlacementConstraint specConstraint = specTransformer.transform();
        PlacementConstraint.Or specOrExpr = (PlacementConstraint.Or)specConstraint.getConstraintExpr();
        List specChildren = specOrExpr.getChildren();
        Assert.assertEquals((long)3L, (long)specChildren.size());
        Assert.assertTrue((boolean)(specChildren.get(0) instanceof PlacementConstraint.TargetConstraint));
        Assert.assertTrue((boolean)(specChildren.get(1) instanceof PlacementConstraint.SingleConstraint));
        Assert.assertTrue((boolean)(specChildren.get(2) instanceof PlacementConstraint.SingleConstraint));
        PlacementConstraintTransformations.SingleConstraintTransformer singleTransformer = new PlacementConstraintTransformations.SingleConstraintTransformer(specConstraint);
        PlacementConstraint simConstraint = singleTransformer.transform();
        Assert.assertTrue((boolean)(simConstraint.getConstraintExpr() instanceof PlacementConstraint.Or));
        PlacementConstraint.Or simOrExpr = (PlacementConstraint.Or)specConstraint.getConstraintExpr();
        for (PlacementConstraint.AbstractConstraint child : simOrExpr.getChildren()) {
            Assert.assertTrue((boolean)(child instanceof PlacementConstraint.SingleConstraint));
        }
    }
}

