/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.nodelabels;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeLabel;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.nodelabels.CommonNodeLabelsManager;
import org.apache.hadoop.yarn.nodelabels.DummyCommonNodeLabelsManager;
import org.apache.hadoop.yarn.nodelabels.NodeLabelTestBase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestCommonNodeLabelsManager
extends NodeLabelTestBase {
    DummyCommonNodeLabelsManager mgr = null;

    @Before
    public void before() {
        this.mgr = new DummyCommonNodeLabelsManager();
        YarnConfiguration conf = new YarnConfiguration();
        conf.setBoolean("yarn.node-labels.enabled", true);
        this.mgr.init((Configuration)conf);
        this.mgr.start();
    }

    @After
    public void after() {
        this.mgr.stop();
    }

    @Test(timeout=5000L)
    public void testAddRemovelabel() throws Exception {
        this.mgr.addToCluserNodeLabelsWithDefaultExclusivity((Set)ImmutableSet.of((Object)"hello"));
        this.verifyNodeLabelAdded(Sets.newHashSet((Object[])new String[]{"hello"}), this.mgr.lastAddedlabels);
        this.mgr.addToCluserNodeLabelsWithDefaultExclusivity((Set)ImmutableSet.of((Object)"world"));
        this.mgr.addToCluserNodeLabelsWithDefaultExclusivity(TestCommonNodeLabelsManager.toSet("hello1", "world1"));
        this.verifyNodeLabelAdded(Sets.newHashSet((Object[])new String[]{"hello1", "world1"}), this.mgr.lastAddedlabels);
        Assert.assertTrue((boolean)this.mgr.getClusterNodeLabelNames().containsAll(Sets.newHashSet((Object[])new String[]{"hello", "world", "hello1", "world1"})));
        try {
            this.mgr.addToCluserNodeLabels(Arrays.asList(NodeLabel.newInstance((String)"hello1", (boolean)false)));
            Assert.fail((String)"IOException not thrown on exclusivity change of labels");
        }
        catch (Exception e) {
            Assert.assertTrue((String)"IOException is expected when exclusivity is modified", (boolean)(e instanceof IOException));
        }
        try {
            this.mgr.addToCluserNodeLabels(Arrays.asList(NodeLabel.newInstance((String)"hello1", (boolean)true)));
        }
        catch (Exception e) {
            Assert.assertFalse((String)"IOException not expected when no change in exclusivity", (boolean)(e instanceof IOException));
        }
        for (String p : Arrays.asList(null, "", "xx")) {
            boolean caught = false;
            try {
                this.mgr.removeFromClusterNodeLabels(Arrays.asList(p));
            }
            catch (IOException e) {
                caught = true;
            }
            Assert.assertTrue((String)"remove label should fail when label is null/empty/non-existed", (boolean)caught);
        }
        this.mgr.removeFromClusterNodeLabels(Arrays.asList("hello"));
        TestCommonNodeLabelsManager.assertCollectionEquals(Sets.newHashSet((Object[])new String[]{"hello"}), this.mgr.lastRemovedlabels);
        Assert.assertTrue((boolean)this.mgr.getClusterNodeLabelNames().containsAll(Arrays.asList("world", "hello1", "world1")));
        this.mgr.removeFromClusterNodeLabels(Arrays.asList("hello1", "world1", "world"));
        Assert.assertTrue((boolean)this.mgr.lastRemovedlabels.containsAll(Sets.newHashSet((Object[])new String[]{"hello1", "world1", "world"})));
        Assert.assertTrue((boolean)this.mgr.getClusterNodeLabelNames().isEmpty());
    }

    @Test(timeout=5000L)
    public void testAddlabelWithCase() throws Exception {
        this.mgr.addToCluserNodeLabelsWithDefaultExclusivity((Set)ImmutableSet.of((Object)"HeLlO"));
        this.verifyNodeLabelAdded(Sets.newHashSet((Object[])new String[]{"HeLlO"}), this.mgr.lastAddedlabels);
        Assert.assertFalse((boolean)this.mgr.getClusterNodeLabelNames().containsAll(Arrays.asList("hello")));
    }

    @Test(timeout=5000L)
    public void testAddlabelWithExclusivity() throws Exception {
        this.mgr.addToCluserNodeLabels(Arrays.asList(NodeLabel.newInstance((String)"a", (boolean)false), NodeLabel.newInstance((String)"b", (boolean)true)));
        Assert.assertFalse((boolean)this.mgr.isExclusiveNodeLabel("a"));
        Assert.assertTrue((boolean)this.mgr.isExclusiveNodeLabel("b"));
    }

    @Test(timeout=5000L)
    public void testAddInvalidlabel() throws IOException {
        boolean caught = false;
        try {
            HashSet<Object> set = new HashSet<Object>();
            set.add(null);
            this.mgr.addToCluserNodeLabelsWithDefaultExclusivity(set);
        }
        catch (IOException e) {
            caught = true;
        }
        Assert.assertTrue((String)"null label should not add to repo", (boolean)caught);
        caught = false;
        try {
            this.mgr.addToCluserNodeLabelsWithDefaultExclusivity((Set)ImmutableSet.of((Object)""));
        }
        catch (IOException e) {
            caught = true;
        }
        Assert.assertTrue((String)"empty label should not add to repo", (boolean)caught);
        caught = false;
        try {
            this.mgr.addToCluserNodeLabelsWithDefaultExclusivity((Set)ImmutableSet.of((Object)"-?"));
        }
        catch (IOException e) {
            caught = true;
        }
        Assert.assertTrue((String)"invalid label character should not add to repo", (boolean)caught);
        caught = false;
        try {
            this.mgr.addToCluserNodeLabelsWithDefaultExclusivity((Set)ImmutableSet.of((Object)StringUtils.repeat((String)"c", (int)257)));
        }
        catch (IOException e) {
            caught = true;
        }
        Assert.assertTrue((String)"too long label should not add to repo", (boolean)caught);
        caught = false;
        try {
            this.mgr.addToCluserNodeLabelsWithDefaultExclusivity((Set)ImmutableSet.of((Object)"-aaabbb"));
        }
        catch (IOException e) {
            caught = true;
        }
        Assert.assertTrue((String)"label cannot start with \"-\"", (boolean)caught);
        caught = false;
        try {
            this.mgr.addToCluserNodeLabelsWithDefaultExclusivity((Set)ImmutableSet.of((Object)"_aaabbb"));
        }
        catch (IOException e) {
            caught = true;
        }
        Assert.assertTrue((String)"label cannot start with \"_\"", (boolean)caught);
        caught = false;
        try {
            this.mgr.addToCluserNodeLabelsWithDefaultExclusivity((Set)ImmutableSet.of((Object)"a^aabbb"));
        }
        catch (IOException e) {
            caught = true;
        }
        Assert.assertTrue((String)"label cannot contains other chars like ^[] ...", (boolean)caught);
        caught = false;
        try {
            this.mgr.addToCluserNodeLabelsWithDefaultExclusivity((Set)ImmutableSet.of((Object)"aa[a]bbb"));
        }
        catch (IOException e) {
            caught = true;
        }
        Assert.assertTrue((String)"label cannot contains other chars like ^[] ...", (boolean)caught);
    }

    @Test(timeout=5000L)
    public void testAddReplaceRemoveLabelsOnNodes() throws Exception {
        boolean caught = false;
        try {
            this.mgr.replaceLabelsOnNode((Map)ImmutableMap.of((Object)this.toNodeId("node"), TestCommonNodeLabelsManager.toSet("label")));
        }
        catch (IOException e) {
            caught = true;
        }
        Assert.assertTrue((String)"trying to set a label to a node but label doesn't exist in repository should fail", (boolean)caught);
        try {
            this.mgr.replaceLabelsOnNode((Map)ImmutableMap.of((Object)this.toNodeId(""), TestCommonNodeLabelsManager.toSet("label")));
        }
        catch (IOException e) {
            caught = true;
        }
        Assert.assertTrue((String)"trying to add a empty node but succeeded", (boolean)caught);
        this.mgr.addToCluserNodeLabelsWithDefaultExclusivity(TestCommonNodeLabelsManager.toSet("p1", "p2", "p3"));
        this.mgr.replaceLabelsOnNode((Map)ImmutableMap.of((Object)this.toNodeId("n1"), TestCommonNodeLabelsManager.toSet("p1")));
        this.mgr.replaceLabelsOnNode((Map)ImmutableMap.of((Object)this.toNodeId("n1"), TestCommonNodeLabelsManager.toSet("p2")));
        this.mgr.replaceLabelsOnNode((Map)ImmutableMap.of((Object)this.toNodeId("n2"), TestCommonNodeLabelsManager.toSet("p3")));
        TestCommonNodeLabelsManager.assertMapEquals(this.mgr.getNodeLabels(), (ImmutableMap<NodeId, Set<String>>)ImmutableMap.of((Object)this.toNodeId("n1"), TestCommonNodeLabelsManager.toSet("p2"), (Object)this.toNodeId("n2"), TestCommonNodeLabelsManager.toSet("p3")));
        TestCommonNodeLabelsManager.assertMapEquals(this.mgr.lastNodeToLabels, (ImmutableMap<NodeId, Set<String>>)ImmutableMap.of((Object)this.toNodeId("n2"), TestCommonNodeLabelsManager.toSet("p3")));
        this.mgr.replaceLabelsOnNode((Map)ImmutableMap.of((Object)this.toNodeId("n3"), TestCommonNodeLabelsManager.toSet("p3"), (Object)this.toNodeId("n1"), TestCommonNodeLabelsManager.toSet("p1")));
        TestCommonNodeLabelsManager.assertMapEquals(this.mgr.getNodeLabels(), (ImmutableMap<NodeId, Set<String>>)ImmutableMap.of((Object)this.toNodeId("n1"), TestCommonNodeLabelsManager.toSet("p1"), (Object)this.toNodeId("n2"), TestCommonNodeLabelsManager.toSet("p3"), (Object)this.toNodeId("n3"), TestCommonNodeLabelsManager.toSet("p3")));
        TestCommonNodeLabelsManager.assertMapEquals(this.mgr.lastNodeToLabels, (ImmutableMap<NodeId, Set<String>>)ImmutableMap.of((Object)this.toNodeId("n3"), TestCommonNodeLabelsManager.toSet("p3"), (Object)this.toNodeId("n1"), TestCommonNodeLabelsManager.toSet("p1")));
        this.mgr.removeLabelsFromNode((Map)ImmutableMap.of((Object)this.toNodeId("n1"), TestCommonNodeLabelsManager.toSet("p1")));
        TestCommonNodeLabelsManager.assertMapEquals(this.mgr.getNodeLabels(), (ImmutableMap<NodeId, Set<String>>)ImmutableMap.of((Object)this.toNodeId("n2"), TestCommonNodeLabelsManager.toSet("p3"), (Object)this.toNodeId("n3"), TestCommonNodeLabelsManager.toSet("p3")));
        TestCommonNodeLabelsManager.assertMapEquals(this.mgr.lastNodeToLabels, (ImmutableMap<NodeId, Set<String>>)ImmutableMap.of((Object)this.toNodeId("n1"), (Object)CommonNodeLabelsManager.EMPTY_STRING_SET));
        this.mgr.addLabelsToNode((Map)ImmutableMap.of((Object)this.toNodeId("n1"), TestCommonNodeLabelsManager.toSet("p1")));
        TestCommonNodeLabelsManager.assertMapEquals(this.mgr.getNodeLabels(), (ImmutableMap<NodeId, Set<String>>)ImmutableMap.of((Object)this.toNodeId("n1"), TestCommonNodeLabelsManager.toSet("p1"), (Object)this.toNodeId("n2"), TestCommonNodeLabelsManager.toSet("p3"), (Object)this.toNodeId("n3"), TestCommonNodeLabelsManager.toSet("p3")));
        TestCommonNodeLabelsManager.assertMapEquals(this.mgr.lastNodeToLabels, (ImmutableMap<NodeId, Set<String>>)ImmutableMap.of((Object)this.toNodeId("n1"), TestCommonNodeLabelsManager.toSet("p1")));
        this.mgr.removeLabelsFromNode((Map)ImmutableMap.of((Object)this.toNodeId("n1"), TestCommonNodeLabelsManager.toSet("p1"), (Object)this.toNodeId("n2"), TestCommonNodeLabelsManager.toSet("p3"), (Object)this.toNodeId("n3"), TestCommonNodeLabelsManager.toSet("p3")));
        Assert.assertEquals((long)0L, (long)this.mgr.getNodeLabels().size());
        TestCommonNodeLabelsManager.assertMapEquals(this.mgr.lastNodeToLabels, (ImmutableMap<NodeId, Set<String>>)ImmutableMap.of((Object)this.toNodeId("n1"), (Object)CommonNodeLabelsManager.EMPTY_STRING_SET, (Object)this.toNodeId("n2"), (Object)CommonNodeLabelsManager.EMPTY_STRING_SET, (Object)this.toNodeId("n3"), (Object)CommonNodeLabelsManager.EMPTY_STRING_SET));
    }

    @Test(timeout=5000L)
    public void testRemovelabelWithNodes() throws Exception {
        this.mgr.addToCluserNodeLabelsWithDefaultExclusivity(TestCommonNodeLabelsManager.toSet("p1", "p2", "p3"));
        this.mgr.replaceLabelsOnNode((Map)ImmutableMap.of((Object)this.toNodeId("n1"), TestCommonNodeLabelsManager.toSet("p1")));
        this.mgr.replaceLabelsOnNode((Map)ImmutableMap.of((Object)this.toNodeId("n2"), TestCommonNodeLabelsManager.toSet("p2")));
        this.mgr.replaceLabelsOnNode((Map)ImmutableMap.of((Object)this.toNodeId("n3"), TestCommonNodeLabelsManager.toSet("p3")));
        this.mgr.removeFromClusterNodeLabels((Collection)ImmutableSet.of((Object)"p1"));
        TestCommonNodeLabelsManager.assertMapEquals(this.mgr.getNodeLabels(), (ImmutableMap<NodeId, Set<String>>)ImmutableMap.of((Object)this.toNodeId("n2"), TestCommonNodeLabelsManager.toSet("p2"), (Object)this.toNodeId("n3"), TestCommonNodeLabelsManager.toSet("p3")));
        TestCommonNodeLabelsManager.assertCollectionEquals(Arrays.asList("p1"), this.mgr.lastRemovedlabels);
        this.mgr.removeFromClusterNodeLabels((Collection)ImmutableSet.of((Object)"p2", (Object)"p3"));
        Assert.assertTrue((boolean)this.mgr.getNodeLabels().isEmpty());
        Assert.assertTrue((boolean)this.mgr.getClusterNodeLabelNames().isEmpty());
        TestCommonNodeLabelsManager.assertCollectionEquals(Arrays.asList("p2", "p3"), this.mgr.lastRemovedlabels);
    }

    @Test(timeout=5000L)
    public void testTrimLabelsWhenAddRemoveNodeLabels() throws IOException {
        this.mgr.addToCluserNodeLabelsWithDefaultExclusivity(TestCommonNodeLabelsManager.toSet(" p1"));
        TestCommonNodeLabelsManager.assertCollectionEquals(TestCommonNodeLabelsManager.toSet("p1"), this.mgr.getClusterNodeLabelNames());
        this.mgr.removeFromClusterNodeLabels(TestCommonNodeLabelsManager.toSet("p1 "));
        Assert.assertTrue((boolean)this.mgr.getClusterNodeLabelNames().isEmpty());
    }

    @Test(timeout=5000L)
    public void testTrimLabelsWhenModifyLabelsOnNodes() throws IOException {
        this.mgr.addToCluserNodeLabelsWithDefaultExclusivity(TestCommonNodeLabelsManager.toSet(" p1", "p2"));
        this.mgr.addLabelsToNode((Map)ImmutableMap.of((Object)this.toNodeId("n1"), TestCommonNodeLabelsManager.toSet("p1 ")));
        TestCommonNodeLabelsManager.assertMapEquals(this.mgr.getNodeLabels(), (ImmutableMap<NodeId, Set<String>>)ImmutableMap.of((Object)this.toNodeId("n1"), TestCommonNodeLabelsManager.toSet("p1")));
        this.mgr.replaceLabelsOnNode((Map)ImmutableMap.of((Object)this.toNodeId("n1"), TestCommonNodeLabelsManager.toSet(" p2")));
        TestCommonNodeLabelsManager.assertMapEquals(this.mgr.getNodeLabels(), (ImmutableMap<NodeId, Set<String>>)ImmutableMap.of((Object)this.toNodeId("n1"), TestCommonNodeLabelsManager.toSet("p2")));
        this.mgr.removeLabelsFromNode((Map)ImmutableMap.of((Object)this.toNodeId("n1"), TestCommonNodeLabelsManager.toSet("  p2 ")));
        Assert.assertTrue((boolean)this.mgr.getNodeLabels().isEmpty());
    }

    @Test(timeout=5000L)
    public void testReplaceLabelsOnHostsShouldUpdateNodesBelongTo() throws IOException {
        this.mgr.addToCluserNodeLabelsWithDefaultExclusivity(TestCommonNodeLabelsManager.toSet("p1", "p2", "p3"));
        this.mgr.addLabelsToNode((Map)ImmutableMap.of((Object)this.toNodeId("n1"), TestCommonNodeLabelsManager.toSet("p1")));
        TestCommonNodeLabelsManager.assertMapEquals(this.mgr.getNodeLabels(), (ImmutableMap<NodeId, Set<String>>)ImmutableMap.of((Object)this.toNodeId("n1"), TestCommonNodeLabelsManager.toSet("p1")));
        this.mgr.replaceLabelsOnNode((Map)ImmutableMap.of((Object)this.toNodeId("n1:1"), TestCommonNodeLabelsManager.toSet("p2"), (Object)this.toNodeId("n1:2"), TestCommonNodeLabelsManager.toSet("p2")));
        TestCommonNodeLabelsManager.assertMapEquals(this.mgr.getNodeLabels(), (ImmutableMap<NodeId, Set<String>>)ImmutableMap.of((Object)this.toNodeId("n1"), TestCommonNodeLabelsManager.toSet("p1"), (Object)this.toNodeId("n1:1"), TestCommonNodeLabelsManager.toSet("p2"), (Object)this.toNodeId("n1:2"), TestCommonNodeLabelsManager.toSet("p2")));
        this.mgr.replaceLabelsOnNode((Map)ImmutableMap.of((Object)this.toNodeId("n1"), TestCommonNodeLabelsManager.toSet("p1")));
        TestCommonNodeLabelsManager.assertMapEquals(this.mgr.getNodeLabels(), (ImmutableMap<NodeId, Set<String>>)ImmutableMap.of((Object)this.toNodeId("n1"), TestCommonNodeLabelsManager.toSet("p1"), (Object)this.toNodeId("n1:1"), TestCommonNodeLabelsManager.toSet("p1"), (Object)this.toNodeId("n1:2"), TestCommonNodeLabelsManager.toSet("p1")));
        this.mgr.replaceLabelsOnNode((Map)ImmutableMap.of((Object)this.toNodeId("n1:1"), TestCommonNodeLabelsManager.toSet("p2")));
    }

    private void assertNodeLabelsDisabledErrorMessage(IOException e) {
        Assert.assertEquals((Object)"Node-label-based scheduling is disabled. Please check yarn.node-labels.enabled", (Object)e.getMessage());
    }

    @Test(timeout=5000L)
    public void testNodeLabelsDisabled() throws IOException {
        DummyCommonNodeLabelsManager mgr = new DummyCommonNodeLabelsManager();
        YarnConfiguration conf = new YarnConfiguration();
        conf.setBoolean("yarn.node-labels.enabled", false);
        mgr.init((Configuration)conf);
        mgr.start();
        boolean caught = false;
        try {
            mgr.addToCluserNodeLabelsWithDefaultExclusivity((Set)ImmutableSet.of((Object)"x"));
        }
        catch (IOException e) {
            this.assertNodeLabelsDisabledErrorMessage(e);
            caught = true;
        }
        Assert.assertTrue((boolean)caught);
        caught = false;
        try {
            mgr.removeFromClusterNodeLabels((Collection)ImmutableSet.of((Object)"x"));
        }
        catch (IOException e) {
            this.assertNodeLabelsDisabledErrorMessage(e);
            caught = true;
        }
        Assert.assertTrue((boolean)caught);
        caught = false;
        try {
            mgr.addLabelsToNode((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"host", (int)0), (Object)CommonNodeLabelsManager.EMPTY_STRING_SET));
        }
        catch (IOException e) {
            this.assertNodeLabelsDisabledErrorMessage(e);
            caught = true;
        }
        Assert.assertTrue((boolean)caught);
        caught = false;
        try {
            mgr.removeLabelsFromNode((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"host", (int)0), (Object)CommonNodeLabelsManager.EMPTY_STRING_SET));
        }
        catch (IOException e) {
            this.assertNodeLabelsDisabledErrorMessage(e);
            caught = true;
        }
        Assert.assertTrue((boolean)caught);
        caught = false;
        try {
            mgr.replaceLabelsOnNode((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"host", (int)0), (Object)CommonNodeLabelsManager.EMPTY_STRING_SET));
        }
        catch (IOException e) {
            this.assertNodeLabelsDisabledErrorMessage(e);
            caught = true;
        }
        Assert.assertTrue((boolean)caught);
        caught = false;
        mgr.close();
    }

    @Test(timeout=5000L)
    public void testLabelsToNodes() throws IOException {
        this.mgr.addToCluserNodeLabelsWithDefaultExclusivity(TestCommonNodeLabelsManager.toSet("p1", "p2", "p3"));
        this.mgr.addLabelsToNode((Map)ImmutableMap.of((Object)this.toNodeId("n1"), TestCommonNodeLabelsManager.toSet("p1")));
        Map labelsToNodes = this.mgr.getLabelsToNodes();
        TestCommonNodeLabelsManager.assertLabelsToNodesEquals(labelsToNodes, (ImmutableMap<String, Set<NodeId>>)ImmutableMap.of((Object)"p1", TestCommonNodeLabelsManager.toSet(this.toNodeId("n1"))));
        TestCommonNodeLabelsManager.assertLabelsToNodesEquals(labelsToNodes, TestCommonNodeLabelsManager.transposeNodeToLabels(this.mgr.getNodeLabels()));
        this.mgr.replaceLabelsOnNode((Map)ImmutableMap.of((Object)this.toNodeId("n1:1"), TestCommonNodeLabelsManager.toSet("p2"), (Object)this.toNodeId("n1:2"), TestCommonNodeLabelsManager.toSet("p2")));
        labelsToNodes = this.mgr.getLabelsToNodes();
        TestCommonNodeLabelsManager.assertLabelsToNodesEquals(labelsToNodes, (ImmutableMap<String, Set<NodeId>>)ImmutableMap.of((Object)"p1", TestCommonNodeLabelsManager.toSet(this.toNodeId("n1")), (Object)"p2", TestCommonNodeLabelsManager.toSet(this.toNodeId("n1:1"), this.toNodeId("n1:2"))));
        TestCommonNodeLabelsManager.assertLabelsToNodesEquals(labelsToNodes, TestCommonNodeLabelsManager.transposeNodeToLabels(this.mgr.getNodeLabels()));
        this.mgr.replaceLabelsOnNode((Map)ImmutableMap.of((Object)this.toNodeId("n1"), TestCommonNodeLabelsManager.toSet("p1")));
        labelsToNodes = this.mgr.getLabelsToNodes();
        TestCommonNodeLabelsManager.assertLabelsToNodesEquals(labelsToNodes, (ImmutableMap<String, Set<NodeId>>)ImmutableMap.of((Object)"p1", TestCommonNodeLabelsManager.toSet(this.toNodeId("n1"), this.toNodeId("n1:1"), this.toNodeId("n1:2"))));
        TestCommonNodeLabelsManager.assertLabelsToNodesEquals(labelsToNodes, TestCommonNodeLabelsManager.transposeNodeToLabels(this.mgr.getNodeLabels()));
        this.mgr.replaceLabelsOnNode((Map)ImmutableMap.of((Object)this.toNodeId("n1:1"), TestCommonNodeLabelsManager.toSet("p2")));
        this.mgr.addLabelsToNode((Map)ImmutableMap.of((Object)this.toNodeId("n2"), TestCommonNodeLabelsManager.toSet("p3")));
        labelsToNodes = this.mgr.getLabelsToNodes();
        TestCommonNodeLabelsManager.assertLabelsToNodesEquals(labelsToNodes, (ImmutableMap<String, Set<NodeId>>)ImmutableMap.of((Object)"p1", TestCommonNodeLabelsManager.toSet(this.toNodeId("n1"), this.toNodeId("n1:2")), (Object)"p2", TestCommonNodeLabelsManager.toSet(this.toNodeId("n1:1")), (Object)"p3", TestCommonNodeLabelsManager.toSet(this.toNodeId("n2"))));
        TestCommonNodeLabelsManager.assertLabelsToNodesEquals(labelsToNodes, TestCommonNodeLabelsManager.transposeNodeToLabels(this.mgr.getNodeLabels()));
        this.mgr.removeLabelsFromNode((Map)ImmutableMap.of((Object)this.toNodeId("n2"), TestCommonNodeLabelsManager.toSet("p3")));
        labelsToNodes = this.mgr.getLabelsToNodes();
        TestCommonNodeLabelsManager.assertLabelsToNodesEquals(labelsToNodes, (ImmutableMap<String, Set<NodeId>>)ImmutableMap.of((Object)"p1", TestCommonNodeLabelsManager.toSet(this.toNodeId("n1"), this.toNodeId("n1:2")), (Object)"p2", TestCommonNodeLabelsManager.toSet(this.toNodeId("n1:1"))));
        TestCommonNodeLabelsManager.assertLabelsToNodesEquals(labelsToNodes, TestCommonNodeLabelsManager.transposeNodeToLabels(this.mgr.getNodeLabels()));
    }

    @Test(timeout=5000L)
    public void testLabelsToNodesForSelectedLabels() throws IOException {
        this.mgr.addToCluserNodeLabelsWithDefaultExclusivity(TestCommonNodeLabelsManager.toSet("p1", "p2", "p3"));
        this.mgr.addLabelsToNode((Map)ImmutableMap.of((Object)this.toNodeId("n1:1"), TestCommonNodeLabelsManager.toSet("p1"), (Object)this.toNodeId("n1:2"), TestCommonNodeLabelsManager.toSet("p2")));
        HashSet<String> setlabels = new HashSet<String>(Arrays.asList("p1"));
        TestCommonNodeLabelsManager.assertLabelsToNodesEquals(this.mgr.getLabelsToNodes(setlabels), (ImmutableMap<String, Set<NodeId>>)ImmutableMap.of((Object)"p1", TestCommonNodeLabelsManager.toSet(this.toNodeId("n1:1"))));
        this.mgr.replaceLabelsOnNode((Map)ImmutableMap.of((Object)this.toNodeId("n1"), TestCommonNodeLabelsManager.toSet("p3")));
        Assert.assertTrue((boolean)this.mgr.getLabelsToNodes(setlabels).isEmpty());
        setlabels = new HashSet<String>(Arrays.asList("p2", "p3"));
        TestCommonNodeLabelsManager.assertLabelsToNodesEquals(this.mgr.getLabelsToNodes(setlabels), (ImmutableMap<String, Set<NodeId>>)ImmutableMap.of((Object)"p3", TestCommonNodeLabelsManager.toSet(this.toNodeId("n1"), this.toNodeId("n1:1"), this.toNodeId("n1:2"))));
        this.mgr.addLabelsToNode((Map)ImmutableMap.of((Object)this.toNodeId("n2"), TestCommonNodeLabelsManager.toSet("p2")));
        TestCommonNodeLabelsManager.assertLabelsToNodesEquals(this.mgr.getLabelsToNodes(setlabels), (ImmutableMap<String, Set<NodeId>>)ImmutableMap.of((Object)"p2", TestCommonNodeLabelsManager.toSet(this.toNodeId("n2")), (Object)"p3", TestCommonNodeLabelsManager.toSet(this.toNodeId("n1"), this.toNodeId("n1:1"), this.toNodeId("n1:2"))));
        this.mgr.removeLabelsFromNode((Map)ImmutableMap.of((Object)this.toNodeId("n1"), TestCommonNodeLabelsManager.toSet("p3")));
        setlabels = new HashSet<String>(Arrays.asList("p1", "p2", "p3"));
        TestCommonNodeLabelsManager.assertLabelsToNodesEquals(this.mgr.getLabelsToNodes(setlabels), (ImmutableMap<String, Set<NodeId>>)ImmutableMap.of((Object)"p2", TestCommonNodeLabelsManager.toSet(this.toNodeId("n2"))));
        this.mgr.addLabelsToNode((Map)ImmutableMap.of((Object)this.toNodeId("n3"), TestCommonNodeLabelsManager.toSet("p1")));
        TestCommonNodeLabelsManager.assertLabelsToNodesEquals(this.mgr.getLabelsToNodes(setlabels), (ImmutableMap<String, Set<NodeId>>)ImmutableMap.of((Object)"p1", TestCommonNodeLabelsManager.toSet(this.toNodeId("n3")), (Object)"p2", TestCommonNodeLabelsManager.toSet(this.toNodeId("n2"))));
        this.mgr.replaceLabelsOnNode((Map)ImmutableMap.of((Object)this.toNodeId("n2:2"), TestCommonNodeLabelsManager.toSet("p3")));
        TestCommonNodeLabelsManager.assertLabelsToNodesEquals(this.mgr.getLabelsToNodes(setlabels), (ImmutableMap<String, Set<NodeId>>)ImmutableMap.of((Object)"p1", TestCommonNodeLabelsManager.toSet(this.toNodeId("n3")), (Object)"p2", TestCommonNodeLabelsManager.toSet(this.toNodeId("n2")), (Object)"p3", TestCommonNodeLabelsManager.toSet(this.toNodeId("n2:2"))));
        setlabels = new HashSet<String>(Arrays.asList("p1"));
        TestCommonNodeLabelsManager.assertLabelsToNodesEquals(this.mgr.getLabelsToNodes(setlabels), (ImmutableMap<String, Set<NodeId>>)ImmutableMap.of((Object)"p1", TestCommonNodeLabelsManager.toSet(this.toNodeId("n3"))));
    }

    @Test(timeout=5000L)
    public void testNoMoreThanOneLabelExistedInOneHost() throws IOException {
        boolean failed = false;
        this.mgr.addToCluserNodeLabelsWithDefaultExclusivity(TestCommonNodeLabelsManager.toSet("p1", "p2", "p3"));
        try {
            this.mgr.replaceLabelsOnNode((Map)ImmutableMap.of((Object)this.toNodeId("n1"), TestCommonNodeLabelsManager.toSet("p1", "p2")));
        }
        catch (IOException e) {
            failed = true;
        }
        Assert.assertTrue((String)"Should failed when set > 1 labels on a host", (boolean)failed);
        try {
            this.mgr.addLabelsToNode((Map)ImmutableMap.of((Object)this.toNodeId("n1"), TestCommonNodeLabelsManager.toSet("p1", "p2")));
        }
        catch (IOException e) {
            failed = true;
        }
        Assert.assertTrue((String)"Should failed when add > 1 labels on a host", (boolean)failed);
        this.mgr.addLabelsToNode((Map)ImmutableMap.of((Object)this.toNodeId("n1"), TestCommonNodeLabelsManager.toSet("p1")));
        this.mgr.addLabelsToNode((Map)ImmutableMap.of((Object)this.toNodeId("n1"), TestCommonNodeLabelsManager.toSet("p1")));
        try {
            this.mgr.addLabelsToNode((Map)ImmutableMap.of((Object)this.toNodeId("n1"), TestCommonNodeLabelsManager.toSet("p2")));
        }
        catch (IOException e) {
            failed = true;
        }
        Assert.assertTrue((String)"Should failed when #labels > 1 on a host after add", (boolean)failed);
    }

    private void verifyNodeLabelAdded(Set<String> expectedAddedLabelNames, Collection<NodeLabel> addedNodeLabels) {
        Assert.assertEquals((long)expectedAddedLabelNames.size(), (long)addedNodeLabels.size());
        for (NodeLabel label : addedNodeLabels) {
            Assert.assertTrue((boolean)expectedAddedLabelNames.contains(label.getName()));
        }
    }

    @Test(timeout=5000L)
    public void testReplaceLabelsOnNodeInDistributedMode() throws Exception {
        this.mgr.stop();
        this.mgr = new DummyCommonNodeLabelsManager();
        YarnConfiguration conf = new YarnConfiguration();
        conf.setBoolean("yarn.node-labels.enabled", true);
        conf.set("yarn.node-labels.configuration-type", "distributed");
        this.mgr.init((Configuration)conf);
        this.mgr.start();
        this.mgr.addToCluserNodeLabelsWithDefaultExclusivity(TestCommonNodeLabelsManager.toSet("p1", "p2", "p3"));
        this.mgr.replaceLabelsOnNode((Map)ImmutableMap.of((Object)this.toNodeId("n1"), TestCommonNodeLabelsManager.toSet("p1")));
        Set labelsByNode = this.mgr.getLabelsByNode(this.toNodeId("n1"));
        Assert.assertNull((String)"Labels are not expected to be written to the NodeLabelStore", this.mgr.lastNodeToLabels);
        Assert.assertNotNull((String)"Updated labels should be available from the Mgr", (Object)labelsByNode);
        Assert.assertTrue((boolean)labelsByNode.contains("p1"));
    }

    @Test(timeout=5000L)
    public void testLabelsInfoToNodes() throws IOException {
        this.mgr.addToCluserNodeLabels(Arrays.asList(NodeLabel.newInstance((String)"p1", (boolean)false), NodeLabel.newInstance((String)"p2", (boolean)true), NodeLabel.newInstance((String)"p3", (boolean)true)));
        this.mgr.addLabelsToNode((Map)ImmutableMap.of((Object)this.toNodeId("n1"), TestCommonNodeLabelsManager.toSet("p1")));
        Map labelsToNodes = this.mgr.getLabelsInfoToNodes();
        TestCommonNodeLabelsManager.assertLabelsInfoToNodesEquals(labelsToNodes, (ImmutableMap<NodeLabel, Set<NodeId>>)ImmutableMap.of((Object)NodeLabel.newInstance((String)"p1", (boolean)false), TestCommonNodeLabelsManager.toSet(this.toNodeId("n1"))));
    }

    @Test(timeout=5000L)
    public void testGetNodeLabelsInfo() throws IOException {
        this.mgr.addToCluserNodeLabels(Arrays.asList(NodeLabel.newInstance((String)"p1", (boolean)false), NodeLabel.newInstance((String)"p2", (boolean)true), NodeLabel.newInstance((String)"p3", (boolean)false)));
        this.mgr.addLabelsToNode((Map)ImmutableMap.of((Object)this.toNodeId("n1"), TestCommonNodeLabelsManager.toSet("p2")));
        this.mgr.addLabelsToNode((Map)ImmutableMap.of((Object)this.toNodeId("n2"), TestCommonNodeLabelsManager.toSet("p3")));
        TestCommonNodeLabelsManager.assertLabelInfoMapEquals(this.mgr.getNodeLabelsInfo(), (ImmutableMap<NodeId, Set<NodeLabel>>)ImmutableMap.of((Object)this.toNodeId("n1"), TestCommonNodeLabelsManager.toSet(NodeLabel.newInstance((String)"p2", (boolean)true)), (Object)this.toNodeId("n2"), TestCommonNodeLabelsManager.toSet(NodeLabel.newInstance((String)"p3", (boolean)false))));
    }
}

