/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.logaggregation;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.logaggregation.AggregatedLogFormat;
import org.apache.hadoop.yarn.logaggregation.LogAggregationUtils;
import org.apache.hadoop.yarn.logaggregation.filecontroller.LogAggregationFileController;
import org.apache.hadoop.yarn.logaggregation.filecontroller.LogAggregationFileControllerContext;
import org.apache.hadoop.yarn.logaggregation.filecontroller.LogAggregationFileControllerFactory;
import org.junit.Assert;

public final class TestContainerLogsUtils {
    private TestContainerLogsUtils() {
    }

    public static void createContainerLogFileInRemoteFS(Configuration conf, FileSystem fs, String rootLogDir, ContainerId containerId, NodeId nodeId, String fileName, String user, String content, boolean deleteRemoteLogDir) throws Exception {
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)user);
        ApplicationId appId = containerId.getApplicationAttemptId().getApplicationId();
        ArrayList<String> rootLogDirList = new ArrayList<String>();
        rootLogDirList.add(rootLogDir);
        Path rootLogDirPath = new Path(rootLogDir);
        if (fs.exists(rootLogDirPath)) {
            fs.delete(rootLogDirPath, true);
        }
        Assert.assertTrue((boolean)fs.mkdirs(rootLogDirPath));
        Path appLogsDir = new Path(rootLogDirPath, appId.toString());
        if (fs.exists(appLogsDir)) {
            fs.delete(appLogsDir, true);
        }
        Assert.assertTrue((boolean)fs.mkdirs(appLogsDir));
        TestContainerLogsUtils.createContainerLogInLocalDir(appLogsDir, containerId, fs, fileName, content);
        Path path = new Path(conf.get("yarn.nodemanager.remote-app-log-dir"), user + "/logs/" + appId.toString());
        if (fs.exists(path) && deleteRemoteLogDir) {
            fs.delete(path, true);
        }
        Assert.assertTrue((boolean)fs.mkdirs(path));
        TestContainerLogsUtils.uploadContainerLogIntoRemoteDir(ugi, conf, rootLogDirList, nodeId, containerId, path, fs);
    }

    private static void createContainerLogInLocalDir(Path appLogsDir, ContainerId containerId, FileSystem fs, String fileName, String content) throws IOException {
        Path containerLogsDir = new Path(appLogsDir, containerId.toString());
        if (fs.exists(containerLogsDir)) {
            fs.delete(containerLogsDir, true);
        }
        Assert.assertTrue((boolean)fs.mkdirs(containerLogsDir));
        FileWriter writer = new FileWriter(new File(containerLogsDir.toString(), fileName));
        writer.write(content);
        ((Writer)writer).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void uploadContainerLogIntoRemoteDir(UserGroupInformation ugi, Configuration configuration, List<String> rootLogDirs, NodeId nodeId, ContainerId containerId, Path appDir, FileSystem fs) throws Exception {
        Path path = new Path(appDir, LogAggregationUtils.getNodeString((NodeId)nodeId));
        LogAggregationFileControllerFactory factory = new LogAggregationFileControllerFactory(configuration);
        LogAggregationFileController fileController = factory.getFileControllerForWrite();
        try {
            HashMap<ApplicationAccessType, String> appAcls = new HashMap<ApplicationAccessType, String>();
            appAcls.put(ApplicationAccessType.VIEW_APP, ugi.getUserName());
            ApplicationId appId = containerId.getApplicationAttemptId().getApplicationId();
            LogAggregationFileControllerContext context = new LogAggregationFileControllerContext(path, path, true, 1000L, appId, appAcls, nodeId, ugi);
            fileController.initializeWriter(context);
            fileController.write(new AggregatedLogFormat.LogKey(containerId), new AggregatedLogFormat.LogValue(rootLogDirs, containerId, ugi.getShortUserName()));
        }
        finally {
            fileController.closeWriter();
        }
    }
}

