/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util;

import org.apache.hadoop.yarn.util.BoundedAppender;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class TestBoundedAppender {
    @Rule
    public ExpectedException expected = ExpectedException.none();

    @Test
    public void initWithZeroLimitThrowsException() {
        this.expected.expect(IllegalArgumentException.class);
        this.expected.expectMessage("limit should be positive");
        new BoundedAppender(0);
    }

    @Test
    public void nullAppendedNullStringRead() {
        BoundedAppender boundedAppender = new BoundedAppender(4);
        boundedAppender.append(null);
        Assert.assertEquals((String)"null appended, \"null\" read", (Object)"null", (Object)boundedAppender.toString());
    }

    @Test
    public void appendBelowLimitOnceValueIsReadCorrectly() {
        BoundedAppender boundedAppender = new BoundedAppender(2);
        boundedAppender.append((CharSequence)"ab");
        Assert.assertEquals((String)"value appended is read correctly", (Object)"ab", (Object)boundedAppender.toString());
    }

    @Test
    public void appendValuesBelowLimitAreReadCorrectlyInFifoOrder() {
        BoundedAppender boundedAppender = new BoundedAppender(3);
        boundedAppender.append((CharSequence)"ab");
        boundedAppender.append((CharSequence)"cd");
        boundedAppender.append((CharSequence)"e");
        boundedAppender.append((CharSequence)"fg");
        Assert.assertEquals((String)"last values appended fitting limit are read correctly", (Object)String.format("Diagnostic messages truncated, showing last %d chars out of %d:%n...%s", 3, 7, "efg"), (Object)boundedAppender.toString());
    }

    @Test
    public void appendLastAboveLimitPreservesLastMessagePostfix() {
        BoundedAppender boundedAppender = new BoundedAppender(3);
        boundedAppender.append((CharSequence)"ab");
        boundedAppender.append((CharSequence)"cde");
        boundedAppender.append((CharSequence)"fghij");
        Assert.assertEquals((String)"last value appended above limit postfix is read correctly", (Object)String.format("Diagnostic messages truncated, showing last %d chars out of %d:%n...%s", 3, 10, "hij"), (Object)boundedAppender.toString());
    }

    @Test
    public void appendMiddleAboveLimitPreservesLastMessageAndMiddlePostfix() {
        BoundedAppender boundedAppender = new BoundedAppender(3);
        boundedAppender.append((CharSequence)"ab");
        boundedAppender.append((CharSequence)"cde");
        Assert.assertEquals((String)"last value appended above limit postfix is read correctly", (Object)String.format("Diagnostic messages truncated, showing last %d chars out of %d:%n...%s", 3, 5, "cde"), (Object)boundedAppender.toString());
        boundedAppender.append((CharSequence)"fg");
        Assert.assertEquals((String)"middle value appended above limit postfix and last value are read correctly", (Object)String.format("Diagnostic messages truncated, showing last %d chars out of %d:%n...%s", 3, 7, "efg"), (Object)boundedAppender.toString());
        boundedAppender.append((CharSequence)"hijkl");
        Assert.assertEquals((String)"last value appended above limit postfix is read correctly", (Object)String.format("Diagnostic messages truncated, showing last %d chars out of %d:%n...%s", 3, 12, "jkl"), (Object)boundedAppender.toString());
    }
}

