/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.conf;

import java.net.InetSocketAddress;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.conf.HAUtil;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestYarnConfiguration {
    @Test
    public void testDefaultRMWebUrl() throws Exception {
        YarnConfiguration conf = new YarnConfiguration();
        String rmWebUrl = WebAppUtils.getRMWebAppURLWithScheme((Configuration)conf);
        Assert.assertNotSame((String)"RM Web Url is not correct", (Object)"http://0.0.0.0:8088", (Object)rmWebUrl);
        conf.setBoolean("yarn.resourcemanager.ha.enabled", true);
        conf.set("yarn.resourcemanager.ha.rm-ids", "rm1, rm2");
        conf.set("yarn.resourcemanager.webapp.address.rm1", "10.10.10.10:18088");
        conf.set("yarn.resourcemanager.webapp.address.rm2", "20.20.20.20:28088");
        String rmWebUrlinHA = WebAppUtils.getRMWebAppURLWithScheme((Configuration)conf);
        Assert.assertEquals((Object)"http://10.10.10.10:18088", (Object)rmWebUrlinHA);
        YarnConfiguration conf2 = new YarnConfiguration();
        conf2.setBoolean("yarn.resourcemanager.ha.enabled", true);
        conf2.set("yarn.resourcemanager.ha.rm-ids", "rm1, rm2");
        conf2.set("yarn.resourcemanager.hostname.rm1", "30.30.30.30");
        conf2.set("yarn.resourcemanager.hostname.rm2", "40.40.40.40");
        String rmWebUrlinHA2 = WebAppUtils.getRMWebAppURLWithScheme((Configuration)conf2);
        Assert.assertEquals((Object)"http://30.30.30.30:8088", (Object)rmWebUrlinHA2);
    }

    @Test
    public void testRMWebUrlSpecified() throws Exception {
        YarnConfiguration conf = new YarnConfiguration();
        conf.set("yarn.resourcemanager.webapp.address", "fortesting:24543");
        conf.set("yarn.resourcemanager.address", "rmtesting:9999");
        String rmWebUrl = WebAppUtils.getRMWebAppURLWithScheme((Configuration)conf);
        String[] parts = rmWebUrl.split(":");
        Assert.assertEquals((String)"RM Web URL Port is incrrect", (long)24543L, (long)Integer.parseInt(parts[parts.length - 1]));
        Assert.assertNotSame((String)"RM Web Url not resolved correctly. Should not be rmtesting", (Object)"http://rmtesting:24543", (Object)rmWebUrl);
    }

    @Test
    public void testGetSocketAddressForNMWithHA() {
        YarnConfiguration conf = new YarnConfiguration();
        conf.set("yarn.nodemanager.address", "0.0.0.0:1234");
        conf.setBoolean("yarn.resourcemanager.ha.enabled", true);
        conf.set("yarn.resourcemanager.ha.id", "rm1");
        Assert.assertTrue((boolean)HAUtil.isHAEnabled((Configuration)conf));
        InetSocketAddress addr = conf.getSocketAddr("yarn.nodemanager.address", "0.0.0.0:0", 0);
        Assert.assertEquals((long)1234L, (long)addr.getPort());
    }

    @Test
    public void testGetSocketAddr() throws Exception {
        YarnConfiguration conf = new YarnConfiguration();
        InetSocketAddress resourceTrackerAddress = conf.getSocketAddr("yarn.resourcemanager.bind-host", "yarn.resourcemanager.resource-tracker.address", "0.0.0.0:8031", 8031);
        Assert.assertEquals((Object)new InetSocketAddress("0.0.0.0:8031".split(":")[0], 8031), (Object)resourceTrackerAddress);
        conf.set("yarn.resourcemanager.resource-tracker.address", "10.0.0.1");
        resourceTrackerAddress = conf.getSocketAddr("yarn.resourcemanager.bind-host", "yarn.resourcemanager.resource-tracker.address", "0.0.0.0:8031", 8031);
        Assert.assertEquals((Object)new InetSocketAddress("10.0.0.1", 8031), (Object)resourceTrackerAddress);
        conf.set("yarn.resourcemanager.resource-tracker.address", "10.0.0.2:5001");
        resourceTrackerAddress = conf.getSocketAddr("yarn.resourcemanager.bind-host", "yarn.resourcemanager.resource-tracker.address", "0.0.0.0:8031", 8031);
        Assert.assertEquals((Object)new InetSocketAddress("10.0.0.2", 5001), (Object)resourceTrackerAddress);
        conf = new YarnConfiguration();
        conf.set("yarn.resourcemanager.bind-host", "10.0.0.3");
        resourceTrackerAddress = conf.getSocketAddr("yarn.resourcemanager.bind-host", "yarn.resourcemanager.resource-tracker.address", "0.0.0.0:8031", 8031);
        Assert.assertEquals((Object)new InetSocketAddress("10.0.0.3", 8031), (Object)resourceTrackerAddress);
        conf.set("yarn.resourcemanager.bind-host", "0.0.0.0");
        conf.set("yarn.resourcemanager.resource-tracker.address", "10.0.0.2");
        resourceTrackerAddress = conf.getSocketAddr("yarn.resourcemanager.bind-host", "yarn.resourcemanager.resource-tracker.address", "0.0.0.0:8031", 8031);
        Assert.assertEquals((Object)new InetSocketAddress("0.0.0.0", 8031), (Object)resourceTrackerAddress);
        conf.set("yarn.resourcemanager.bind-host", "0.0.0.0");
        conf.set("yarn.resourcemanager.resource-tracker.address", "10.0.0.2:5003");
        resourceTrackerAddress = conf.getSocketAddr("yarn.resourcemanager.bind-host", "yarn.resourcemanager.resource-tracker.address", "0.0.0.0:8031", 8031);
        Assert.assertEquals((Object)new InetSocketAddress("0.0.0.0", 5003), (Object)resourceTrackerAddress);
    }

    @Test
    public void testUpdateConnectAddr() throws Exception {
        YarnConfiguration conf = new YarnConfiguration();
        conf.set("yarn.resourcemanager.resource-tracker.address", "yo.yo.yo");
        InetSocketAddress serverAddress = new InetSocketAddress("0.0.0.0:8031".split(":")[0], Integer.parseInt("0.0.0.0:8031".split(":")[1]));
        InetSocketAddress resourceTrackerConnectAddress = conf.updateConnectAddr("yarn.resourcemanager.bind-host", "yarn.resourcemanager.resource-tracker.address", "0.0.0.0:8031", serverAddress);
        Assert.assertFalse((boolean)resourceTrackerConnectAddress.toString().startsWith("yo.yo.yo"));
        conf = new YarnConfiguration();
        conf.set("yarn.resourcemanager.resource-tracker.address", "yo.yo.yo");
        conf.set("yarn.resourcemanager.bind-host", "0.0.0.0");
        serverAddress = new InetSocketAddress("0.0.0.0:8031".split(":")[0], Integer.parseInt("0.0.0.0:8031".split(":")[1]));
        resourceTrackerConnectAddress = conf.updateConnectAddr("yarn.resourcemanager.bind-host", "yarn.resourcemanager.resource-tracker.address", "0.0.0.0:8031", serverAddress);
        Assert.assertTrue((boolean)resourceTrackerConnectAddress.toString().startsWith("yo.yo.yo"));
        conf = new YarnConfiguration();
        conf.set("yarn.nodemanager.localizer.address", "yo.yo.yo");
        conf.set("yarn.nodemanager.bind-host", "0.0.0.0");
        conf.setBoolean("yarn.resourcemanager.ha.enabled", true);
        conf.set("yarn.resourcemanager.ha.id", "rm1");
        serverAddress = new InetSocketAddress("0.0.0.0:8040".split(":")[0], Integer.parseInt("0.0.0.0:8040".split(":")[1]));
        InetSocketAddress localizerAddress = conf.updateConnectAddr("yarn.nodemanager.bind-host", "yarn.nodemanager.localizer.address", "0.0.0.0:8040", serverAddress);
        Assert.assertTrue((boolean)localizerAddress.toString().startsWith("yo.yo.yo"));
        Assert.assertNull((Object)conf.get(HAUtil.addSuffix((String)"yarn.nodemanager.localizer.address", (String)"rm1")));
    }
}

