/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.resourcetypes;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceInformation;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;

public final class ResourceTypesTestHelper {
    private static final Pattern RESOURCE_VALUE_AND_UNIT_PATTERN = Pattern.compile("(\\d+)([A-za-z]*)");
    private static final RecordFactory RECORD_FACTORY = RecordFactoryProvider.getRecordFactory(null);

    private ResourceTypesTestHelper() {
    }

    public static Resource newResource(long memory, int vCores, Map<String, String> customResources) {
        Resource resource = (Resource)RECORD_FACTORY.newRecordInstance(Resource.class);
        resource.setMemorySize(memory);
        resource.setVirtualCores(vCores);
        for (Map.Entry<String, String> customResource : customResources.entrySet()) {
            String resourceName = customResource.getKey();
            ResourceInformation resourceInformation = ResourceTypesTestHelper.createResourceInformation(resourceName, customResource.getValue());
            resource.setResourceInformation(resourceName, resourceInformation);
        }
        return resource;
    }

    public static ResourceInformation createResourceInformation(String resourceName, String descriptor) {
        ResourceValueAndUnit resourceValueAndUnit = ResourceTypesTestHelper.getResourceValueAndUnit(descriptor);
        return ResourceInformation.newInstance((String)resourceName, (String)resourceValueAndUnit.unit, (long)resourceValueAndUnit.value);
    }

    private static ResourceValueAndUnit getResourceValueAndUnit(String val) {
        Matcher matcher = RESOURCE_VALUE_AND_UNIT_PATTERN.matcher(val);
        if (!matcher.find()) {
            throw new RuntimeException("Invalid pattern of resource descriptor: " + val);
        }
        if (matcher.groupCount() != 2) {
            throw new RuntimeException("Capturing group count in string " + val + " is not 2!");
        }
        long value = Long.parseLong(matcher.group(1));
        return new ResourceValueAndUnit(value, matcher.group(2));
    }

    private static final class ResourceValueAndUnit {
        private final Long value;
        private final String unit;

        private ResourceValueAndUnit(Long value, String unit) {
            this.value = value;
            this.unit = unit;
        }
    }
}

