/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.Futures;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.security.PrivilegedExceptionAction;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.RunJar;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.exceptions.YarnException;

@InterfaceAudience.LimitedPrivate(value={"YARN", "MapReduce"})
public class FSDownload
implements Callable<Path> {
    private static final Log LOG = LogFactory.getLog(FSDownload.class);
    private FileContext files;
    private final UserGroupInformation userUgi;
    private Configuration conf;
    private LocalResource resource;
    private final LoadingCache<Path, Future<FileStatus>> statCache;
    private Path destDirPath;
    private static final FsPermission cachePerms = new FsPermission(493);
    static final FsPermission PUBLIC_FILE_PERMS = new FsPermission(365);
    static final FsPermission PRIVATE_FILE_PERMS = new FsPermission(336);
    static final FsPermission PUBLIC_DIR_PERMS = new FsPermission(493);
    static final FsPermission PRIVATE_DIR_PERMS = new FsPermission(448);

    public FSDownload(FileContext files, UserGroupInformation ugi, Configuration conf, Path destDirPath, LocalResource resource) {
        this(files, ugi, conf, destDirPath, resource, null);
    }

    public FSDownload(FileContext files, UserGroupInformation ugi, Configuration conf, Path destDirPath, LocalResource resource, LoadingCache<Path, Future<FileStatus>> statCache) {
        this.conf = conf;
        this.destDirPath = destDirPath;
        this.files = files;
        this.userUgi = ugi;
        this.resource = resource;
        this.statCache = statCache;
    }

    LocalResource getResource() {
        return this.resource;
    }

    private void createDir(Path path, FsPermission perm) throws IOException {
        this.files.mkdir(path, perm, false);
        if (!perm.equals((Object)this.files.getUMask().applyUMask(perm))) {
            this.files.setPermission(path, perm);
        }
    }

    public static CacheLoader<Path, Future<FileStatus>> createStatusCacheLoader(final Configuration conf) {
        return new CacheLoader<Path, Future<FileStatus>>(){

            public Future<FileStatus> load(Path path) {
                try {
                    FileSystem fs = path.getFileSystem(conf);
                    return Futures.immediateFuture((Object)fs.getFileStatus(path));
                }
                catch (Throwable th) {
                    return Futures.immediateFailedFuture((Throwable)th);
                }
            }
        };
    }

    @InterfaceAudience.Private
    public static boolean isPublic(FileSystem fs, Path current, FileStatus sStat, LoadingCache<Path, Future<FileStatus>> statCache) throws IOException {
        current = fs.makeQualified(current);
        if (!FSDownload.checkPublicPermsForAll(fs, sStat, FsAction.READ_EXECUTE, FsAction.READ)) {
            return false;
        }
        if (Shell.WINDOWS && fs instanceof LocalFileSystem) {
            return true;
        }
        return FSDownload.ancestorsHaveExecutePermissions(fs, current.getParent(), statCache);
    }

    private static boolean checkPublicPermsForAll(FileSystem fs, FileStatus status, FsAction dir, FsAction file) throws IOException {
        FsPermission perms = status.getPermission();
        FsAction otherAction = perms.getOtherAction();
        if (status.isDirectory()) {
            if (!otherAction.implies(dir)) {
                return false;
            }
            for (FileStatus child : fs.listStatus(status.getPath())) {
                if (FSDownload.checkPublicPermsForAll(fs, child, dir, file)) continue;
                return false;
            }
            return true;
        }
        return otherAction.implies(file);
    }

    @VisibleForTesting
    static boolean ancestorsHaveExecutePermissions(FileSystem fs, Path path, LoadingCache<Path, Future<FileStatus>> statCache) throws IOException {
        for (Path current = path; current != null; current = current.getParent()) {
            if (FSDownload.checkPermissionOfOther(fs, current, FsAction.EXECUTE, statCache)) continue;
            return false;
        }
        return true;
    }

    private static boolean checkPermissionOfOther(FileSystem fs, Path path, FsAction action, LoadingCache<Path, Future<FileStatus>> statCache) throws IOException {
        FileStatus status = FSDownload.getFileStatus(fs, path, statCache);
        FsPermission perms = status.getPermission();
        FsAction otherAction = perms.getOtherAction();
        return otherAction.implies(action);
    }

    private static FileStatus getFileStatus(FileSystem fs, Path path, LoadingCache<Path, Future<FileStatus>> statCache) throws IOException {
        if (statCache == null) {
            return fs.getFileStatus(path);
        }
        try {
            return (FileStatus)((Future)statCache.get((Object)path)).get();
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw new IOException(cause);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException(e);
        }
    }

    private void verifyAndCopy(Path destination) throws IOException, YarnException {
        Path sCopy;
        try {
            sCopy = this.resource.getResource().toPath();
        }
        catch (URISyntaxException e) {
            throw new IOException("Invalid resource", e);
        }
        FileSystem sourceFs = sCopy.getFileSystem(this.conf);
        FileStatus sStat = sourceFs.getFileStatus(sCopy);
        if (sStat.getModificationTime() != this.resource.getTimestamp()) {
            throw new IOException("Resource " + sCopy + " changed on src filesystem (expected " + this.resource.getTimestamp() + ", was " + sStat.getModificationTime());
        }
        if (this.resource.getVisibility() == LocalResourceVisibility.PUBLIC && !FSDownload.isPublic(sourceFs, sCopy, sStat, this.statCache)) {
            throw new IOException("Resource " + sCopy + " is not publicly accessible and as such cannot be part of the public cache.");
        }
        this.downloadAndUnpack(sCopy, destination);
    }

    private void downloadAndUnpack(Path source, Path destination) throws YarnException {
        try {
            FileSystem sourceFileSystem = source.getFileSystem(this.conf);
            FileSystem destinationFileSystem = destination.getFileSystem(this.conf);
            if (sourceFileSystem.getFileStatus(source).isDirectory()) {
                FileUtil.copy((FileSystem)sourceFileSystem, (Path)source, (FileSystem)destinationFileSystem, (Path)destination, (boolean)false, (boolean)true, (Configuration)this.conf);
            } else {
                this.unpack(source, destination, sourceFileSystem, destinationFileSystem);
            }
        }
        catch (Exception e) {
            throw new YarnException("Download and unpack failed", (Throwable)e);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void unpack(Path source, Path destination, FileSystem sourceFileSystem, FileSystem destinationFileSystem) throws IOException, InterruptedException, ExecutionException {
        inputStream = sourceFileSystem.open(source);
        var6_6 = null;
        try {
            dst = new File(destination.toUri());
            lowerDst = StringUtils.toLowerCase((String)dst.getName());
            switch (4.$SwitchMap$org$apache$hadoop$yarn$api$records$LocalResourceType[this.resource.getType().ordinal()]) {
                case 1: {
                    if (lowerDst.endsWith(".jar")) {
                        RunJar.unJar((InputStream)inputStream, (File)dst, (Pattern)RunJar.MATCH_ANY);
                        ** break;
lbl11:
                        // 1 sources

                        break;
                    }
                    if (lowerDst.endsWith(".zip")) {
                        FileUtil.unZip((InputStream)inputStream, (File)dst);
                        ** break;
lbl15:
                        // 1 sources

                        break;
                    }
                    if (lowerDst.endsWith(".tar.gz") || lowerDst.endsWith(".tgz") || lowerDst.endsWith(".tar")) {
                        FileUtil.unTar((InputStream)inputStream, (File)dst, (boolean)lowerDst.endsWith("gz"));
                        ** break;
lbl19:
                        // 1 sources

                        break;
                    }
                    FSDownload.LOG.warn((Object)("Cannot unpack " + source));
                    outputStream = destinationFileSystem.create(destination, true);
                    var10_15 = null;
                    IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
                    if (outputStream == null) break;
                    if (var10_15 == null) ** GOTO lbl36
                    try {
                        outputStream.close();
                        ** break;
lbl31:
                        // 1 sources

                    }
                    catch (Throwable var11_18) {
                        var10_15.addSuppressed(var11_18);
                        ** break;
                    }
lbl35:
                    // 1 sources

                    break;
lbl36:
                    // 1 sources

                    outputStream.close();
                    ** break;
lbl38:
                    // 1 sources

                    break;
                    catch (Throwable var11_19) {
                        try {
                            var10_15 = var11_19;
                            throw var11_19;
                        }
                        catch (Throwable var12_24) {
                            if (outputStream != null) {
                                if (var10_15 != null) {
                                    try {
                                        outputStream.close();
                                    }
                                    catch (Throwable var13_25) {
                                        var10_15.addSuppressed(var13_25);
                                    }
                                } else {
                                    outputStream.close();
                                }
                            }
                            throw var12_24;
                        }
                    }
                }
                case 2: {
                    if (lowerDst.endsWith(".jar")) {
                        p = this.resource.getPattern();
                        if (!dst.exists() && !dst.mkdir()) {
                            throw new IOException("Unable to create directory: [" + dst + "]");
                        }
                        RunJar.unJarAndSave((InputStream)inputStream, (File)dst, (String)source.getName(), (Pattern)(p == null ? RunJar.MATCH_ANY : Pattern.compile(p)));
                        ** break;
lbl61:
                        // 1 sources

                        break;
                    }
                    if (lowerDst.endsWith(".zip")) {
                        FSDownload.LOG.warn((Object)("Treating [" + source + "] as an archive even though it was specified as PATTERN"));
                        FileUtil.unZip((InputStream)inputStream, (File)dst);
                        ** break;
lbl66:
                        // 1 sources

                        break;
                    }
                    if (lowerDst.endsWith(".tar.gz") || lowerDst.endsWith(".tgz") || lowerDst.endsWith(".tar")) {
                        FSDownload.LOG.warn((Object)("Treating [" + source + "] as an archive even though it was specified as PATTERN"));
                        FileUtil.unTar((InputStream)inputStream, (File)dst, (boolean)lowerDst.endsWith("gz"));
                        ** break;
lbl71:
                        // 1 sources

                        break;
                    }
                    FSDownload.LOG.warn((Object)("Cannot unpack " + source));
                    outputStream = destinationFileSystem.create(destination, true);
                    var10_16 = null;
                    IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
                    if (outputStream == null) break;
                    if (var10_16 == null) ** GOTO lbl88
                    try {
                        outputStream.close();
                        ** break;
lbl83:
                        // 1 sources

                    }
                    catch (Throwable var11_20) {
                        var10_16.addSuppressed(var11_20);
                        ** break;
                    }
lbl87:
                    // 1 sources

                    break;
lbl88:
                    // 1 sources

                    outputStream.close();
                    ** break;
lbl90:
                    // 1 sources

                    break;
                    catch (Throwable var11_21) {
                        try {
                            var10_16 = var11_21;
                            throw var11_21;
                        }
                        catch (Throwable var14_26) {
                            if (outputStream != null) {
                                if (var10_16 != null) {
                                    try {
                                        outputStream.close();
                                    }
                                    catch (Throwable var15_27) {
                                        var10_16.addSuppressed(var15_27);
                                    }
                                } else {
                                    outputStream.close();
                                }
                            }
                            throw var14_26;
                        }
                    }
                }
                default: {
                    outputStream = destinationFileSystem.create(destination, true);
                    var10_17 = null;
                    IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
                    if (outputStream == null) break;
                    if (var10_17 == null) ** GOTO lbl122
                    try {
                        outputStream.close();
                        ** break;
lbl117:
                        // 1 sources

                    }
                    catch (Throwable var11_22) {
                        var10_17.addSuppressed(var11_22);
                        ** break;
                    }
lbl121:
                    // 1 sources

                    break;
lbl122:
                    // 1 sources

                    outputStream.close();
                    ** break;
lbl124:
                    // 1 sources

                    break;
                    catch (Throwable var11_23) {
                        try {
                            var10_17 = var11_23;
                            throw var11_23;
                        }
                        catch (Throwable var16_28) {
                            if (outputStream != null) {
                                if (var10_17 != null) {
                                    try {
                                        outputStream.close();
                                    }
                                    catch (Throwable var17_29) {
                                        var10_17.addSuppressed(var17_29);
                                    }
                                } else {
                                    outputStream.close();
                                }
                            }
                            throw var16_28;
                        }
                    }
                }
            }
        }
        catch (Throwable var7_9) {
            var6_6 = var7_9;
            throw var7_9;
        }
        finally {
            if (inputStream != null) {
                if (var6_6 != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable var7_8) {
                        var6_6.addSuppressed(var7_8);
                    }
                } else {
                    inputStream.close();
                }
            }
        }
    }

    @Override
    public Path call() throws Exception {
        Path sCopy;
        try {
            sCopy = this.resource.getResource().toPath();
        }
        catch (URISyntaxException e) {
            throw new IOException("Invalid resource", e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("Starting to download %s %s %s", sCopy, this.resource.getType(), this.resource.getPattern()));
        }
        Path destinationTmp = new Path(this.destDirPath + "_tmp");
        this.createDir(destinationTmp, cachePerms);
        final Path dFinal = this.files.makeQualified(new Path(destinationTmp, sCopy.getName()));
        try {
            if (this.userUgi == null) {
                this.verifyAndCopy(dFinal);
            } else {
                this.userUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        FSDownload.this.verifyAndCopy(dFinal);
                        return null;
                    }
                });
            }
            this.changePermissions(dFinal.getFileSystem(this.conf), dFinal);
            this.files.rename(destinationTmp, this.destDirPath, new Options.Rename[]{Options.Rename.OVERWRITE});
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)String.format("File has been downloaded to %s from %s", new Path(this.destDirPath, sCopy.getName()), sCopy));
            }
        }
        catch (Exception e) {
            try {
                this.files.delete(this.destDirPath, true);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw e;
        }
        finally {
            try {
                this.files.delete(destinationTmp, true);
            }
            catch (FileNotFoundException fileNotFoundException) {}
            this.conf = null;
            this.resource = null;
        }
        return this.files.makeQualified(new Path(this.destDirPath, sCopy.getName()));
    }

    private void changePermissions(FileSystem fs, final Path path) throws IOException, InterruptedException {
        File f = new File(path.toUri());
        if (FileUtils.isSymlink((File)f)) {
            return;
        }
        boolean isDir = f.isDirectory();
        FsPermission perm = cachePerms;
        if (this.resource.getVisibility() == LocalResourceVisibility.PUBLIC) {
            perm = isDir ? PUBLIC_DIR_PERMS : PUBLIC_FILE_PERMS;
        } else {
            FsPermission fsPermission = perm = isDir ? PRIVATE_DIR_PERMS : PRIVATE_FILE_PERMS;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Changing permissions for path " + path + " to perm " + perm));
        }
        final FsPermission fPerm = perm;
        if (null == this.userUgi) {
            this.files.setPermission(path, perm);
        } else {
            this.userUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    FSDownload.this.files.setPermission(path, fPerm);
                    return null;
                }
            });
        }
        if (isDir) {
            FileStatus[] statuses;
            for (FileStatus status : statuses = fs.listStatus(path)) {
                this.changePermissions(fs, status.getPath());
            }
        }
    }
}

