/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.logaggregation.filecontroller;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.logaggregation.AggregatedLogFormat;
import org.apache.hadoop.yarn.logaggregation.ContainerLogMeta;
import org.apache.hadoop.yarn.logaggregation.ContainerLogsRequest;
import org.apache.hadoop.yarn.logaggregation.filecontroller.LogAggregationFileController;
import org.apache.hadoop.yarn.logaggregation.filecontroller.LogAggregationFileControllerContext;
import org.apache.hadoop.yarn.logaggregation.filecontroller.LogAggregationFileControllerFactory;
import org.apache.hadoop.yarn.logaggregation.filecontroller.tfile.LogAggregationTFileController;
import org.apache.hadoop.yarn.webapp.View;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;
import org.junit.Assert;
import org.junit.Test;

public class TestLogAggregationFileControllerFactory {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testLogAggregationFileControllerFactory() throws Exception {
        FileWriter writer2;
        ApplicationId appId = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1);
        String appOwner = "test";
        String remoteLogRootDir = "target/app-logs/";
        YarnConfiguration conf = new YarnConfiguration();
        conf.setBoolean("yarn.log-aggregation-enable", true);
        conf.set("yarn.nodemanager.remote-app-log-dir", remoteLogRootDir);
        conf.set("yarn.nodemanager.remote-app-log-dir-suffix", "log");
        FileSystem fs = FileSystem.get((Configuration)conf);
        LogAggregationFileControllerFactory factory = new LogAggregationFileControllerFactory((Configuration)conf);
        LinkedList list = factory.getConfiguredLogAggregationFileControllerList();
        Assert.assertTrue((list.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)(list.getFirst() instanceof LogAggregationTFileController));
        Assert.assertTrue((boolean)(factory.getFileControllerForWrite() instanceof LogAggregationTFileController));
        Path logPath = ((LogAggregationFileController)list.getFirst()).getRemoteAppLogDir(appId, appOwner);
        try {
            if (fs.exists(logPath)) {
                fs.delete(logPath, true);
            }
            Assert.assertTrue((boolean)fs.mkdirs(logPath));
            writer2 = new FileWriter(new File(logPath.toString(), "testLog"));
            writer2.write("test");
            ((Writer)writer2).close();
            Assert.assertTrue((boolean)(factory.getFileControllerForRead(appId, appOwner) instanceof LogAggregationTFileController));
        }
        finally {
            fs.delete(logPath, true);
        }
        conf.set("yarn.log-aggregation.file-formats", "TestLogAggregationFileController");
        try {
            factory = new LogAggregationFileControllerFactory((Configuration)conf);
            Assert.fail();
        }
        catch (Exception writer2) {
            // empty catch block
        }
        conf.set("yarn.log-aggregation.file-formats", "TestLogAggregationFileController,TFile");
        conf.setClass("yarn.log-aggregation.file-controller.TestLogAggregationFileController.class", TestLogAggregationFileController.class, LogAggregationFileController.class);
        conf.set("yarn.log-aggregation.TestLogAggregationFileController.remote-app-log-dir", remoteLogRootDir);
        conf.set("yarn.log-aggregation.TestLogAggregationFileController.remote-app-log-dir-suffix", "testLog");
        factory = new LogAggregationFileControllerFactory((Configuration)conf);
        list = factory.getConfiguredLogAggregationFileControllerList();
        Assert.assertTrue((list.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)(list.getFirst() instanceof TestLogAggregationFileController));
        Assert.assertTrue((boolean)(list.getLast() instanceof LogAggregationTFileController));
        Assert.assertTrue((boolean)(factory.getFileControllerForWrite() instanceof TestLogAggregationFileController));
        logPath = ((LogAggregationFileController)list.getFirst()).getRemoteAppLogDir(appId, appOwner);
        try {
            if (fs.exists(logPath)) {
                fs.delete(logPath, true);
            }
            Assert.assertTrue((boolean)fs.mkdirs(logPath));
            writer2 = new FileWriter(new File(logPath.toString(), "testLog"));
            writer2.write("test");
            ((Writer)writer2).close();
            Assert.assertTrue((boolean)(factory.getFileControllerForRead(appId, appOwner) instanceof TestLogAggregationFileController));
        }
        finally {
            fs.delete(logPath, true);
        }
    }

    private static class TestLogAggregationFileController
    extends LogAggregationFileController {
        private TestLogAggregationFileController() {
        }

        public void initInternal(Configuration conf) {
            String remoteDirStr = String.format("yarn.log-aggregation.%s.remote-app-log-dir", this.fileControllerName);
            this.remoteRootLogDir = new Path(conf.get(remoteDirStr));
            String suffix = String.format("yarn.log-aggregation.%s.remote-app-log-dir-suffix", this.fileControllerName);
            this.remoteRootLogDirSuffix = conf.get(suffix);
        }

        public void closeWriter() {
        }

        public void write(AggregatedLogFormat.LogKey logKey, AggregatedLogFormat.LogValue logValue) throws IOException {
        }

        public void postWrite(LogAggregationFileControllerContext record) throws Exception {
        }

        public void initializeWriter(LogAggregationFileControllerContext context) throws IOException {
        }

        public boolean readAggregatedLogs(ContainerLogsRequest logRequest, OutputStream os) throws IOException {
            return false;
        }

        public List<ContainerLogMeta> readAggregatedLogsMeta(ContainerLogsRequest logRequest) throws IOException {
            return null;
        }

        public void renderAggregatedLogsBlock(HtmlBlock.Block html, View.ViewContext context) {
        }

        public String getApplicationOwner(Path aggregatedLogPath, ApplicationId appId) throws IOException {
            return null;
        }

        public Map<ApplicationAccessType, String> getApplicationAcls(Path aggregatedLogPath, ApplicationId appId) throws IOException {
            return null;
        }
    }
}

