/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.webapp.util;

import io.hops.security.SuperuserKeystoresLoader;
import java.io.File;
import java.io.IOException;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.http.HttpServer2;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.alias.CredentialProvider;
import org.apache.hadoop.security.alias.CredentialProviderFactory;
import org.apache.hadoop.security.ssl.FileBasedKeyStoresFactory;
import org.apache.hadoop.security.ssl.SSLFactory;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;

public class TestWebAppUtils {
    private static final String RM1_NODE_ID = "rm1";
    private static final String RM2_NODE_ID = "rm2";
    private static String[] dummyHostNames = new String[]{"host1", "host2", "host3"};
    private static final String anyIpAddress = "1.2.3.4";
    private static Map<String, String> savedStaticResolution = new HashMap<String, String>();

    @BeforeClass
    public static void initializeDummyHostnameResolution() throws Exception {
        for (String hostName : dummyHostNames) {
            String previousIpAddress = NetUtils.getStaticResolution((String)hostName);
            if (null != previousIpAddress) {
                savedStaticResolution.put(hostName, previousIpAddress);
            }
            NetUtils.addStaticResolution((String)hostName, (String)anyIpAddress);
        }
    }

    @AfterClass
    public static void restoreDummyHostnameResolution() throws Exception {
        for (Map.Entry<String, String> hostnameToIpEntry : savedStaticResolution.entrySet()) {
            NetUtils.addStaticResolution((String)hostnameToIpEntry.getKey(), (String)hostnameToIpEntry.getValue());
        }
    }

    @Test
    public void TestRMWebAppURLRemoteAndLocal() throws UnknownHostException {
        Configuration configuration = new Configuration();
        String rmAddress = "host1:8088";
        configuration.set("yarn.resourcemanager.webapp.address", "host1:8088");
        String rm1Address = "host2:8088";
        String rm2Address = "host3:8088";
        configuration.set("yarn.resourcemanager.webapp.address.rm1", "host2:8088");
        configuration.set("yarn.resourcemanager.webapp.address.rm2", "host3:8088");
        configuration.setBoolean("yarn.resourcemanager.ha.enabled", true);
        configuration.set("yarn.resourcemanager.ha.rm-ids", "rm1,rm2");
        String rmRemoteUrl = WebAppUtils.getResolvedRemoteRMWebAppURLWithoutScheme((Configuration)configuration);
        Assert.assertEquals((String)"ResolvedRemoteRMWebAppUrl should resolve to the first HA RM address", (Object)"host2:8088", (Object)rmRemoteUrl);
        String rmLocalUrl = WebAppUtils.getResolvedRMWebAppURLWithoutScheme((Configuration)configuration);
        Assert.assertEquals((String)"ResolvedRMWebAppUrl should resolve to the default RM webapp address", (Object)"host1:8088", (Object)rmLocalUrl);
    }

    @Test
    public void testGetPassword() throws Exception {
        Configuration conf = this.provisionCredentialsForSSL();
        Assert.assertEquals((Object)"keypass", (Object)WebAppUtils.getPassword((Configuration)conf, (String)"ssl.server.keystore.keypassword"));
        Assert.assertEquals((Object)"storepass", (Object)WebAppUtils.getPassword((Configuration)conf, (String)"ssl.server.keystore.password"));
        Assert.assertEquals((Object)"trustpass", (Object)WebAppUtils.getPassword((Configuration)conf, (String)"ssl.server.truststore.password"));
        Assert.assertEquals(null, (Object)WebAppUtils.getPassword((Configuration)conf, (String)"invalid-alias"));
    }

    @Test
    public void testLoadFromSSLServerConf() throws Exception {
        Configuration conf = this.provisionCredentialsForSSL();
        conf.set(FileBasedKeyStoresFactory.resolvePropertyName((SSLFactory.Mode)SSLFactory.Mode.SERVER, (String)"ssl.{0}.keystore.location"), "kStore.jks");
        TestBuilder builder = new TestBuilder();
        builder = (TestBuilder)WebAppUtils.loadSslConfiguration((HttpServer2.Builder)builder, (Configuration)conf);
        String keypass = "keypass";
        String storepass = "storepass";
        String trustpass = "trustpass";
        Assert.assertEquals((Object)keypass, (Object)builder.keypass);
        Assert.assertEquals((Object)storepass, (Object)builder.keystorePassword);
        Assert.assertEquals((Object)trustpass, (Object)builder.truststorePassword);
    }

    @Test
    public void testLoadFromSuperUserLoader() throws Exception {
        Configuration conf = this.provisionCredentialsForSSL();
        String tmp = System.getProperty("test.build.data", "target/test-dir");
        conf.set("hops.tls.superuser-material-directory", tmp);
        String password = "password";
        SuperuserKeystoresLoader loader = new SuperuserKeystoresLoader(conf);
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        java.nio.file.Path passwd = Paths.get(tmp, loader.getSuperMaterialPasswdFilename(ugi.getUserName()));
        FileUtils.writeStringToFile((File)passwd.toFile(), (String)password, (Charset)StandardCharsets.UTF_8);
        TestBuilder builder = new TestBuilder();
        builder = (TestBuilder)WebAppUtils.loadSslConfiguration((HttpServer2.Builder)builder, (Configuration)conf);
        Assert.assertEquals((Object)password, (Object)builder.keypass);
        Assert.assertEquals((Object)password, (Object)builder.keystorePassword);
        Assert.assertEquals((Object)password, (Object)builder.truststorePassword);
    }

    protected Configuration provisionCredentialsForSSL() throws IOException, Exception {
        File testDir = new File(System.getProperty("test.build.data", "target/test-dir"));
        Configuration conf = new Configuration();
        Path jksPath = new Path(testDir.toString(), "test.jks");
        String ourUrl = "jceks://file" + jksPath.toUri();
        File file = new File(testDir, "test.jks");
        file.delete();
        conf.set("hadoop.security.credential.provider.path", ourUrl);
        CredentialProvider provider = (CredentialProvider)CredentialProviderFactory.getProviders((Configuration)conf).get(0);
        char[] keypass = new char[]{'k', 'e', 'y', 'p', 'a', 's', 's'};
        char[] storepass = new char[]{'s', 't', 'o', 'r', 'e', 'p', 'a', 's', 's'};
        char[] trustpass = new char[]{'t', 'r', 'u', 's', 't', 'p', 'a', 's', 's'};
        Assert.assertEquals(null, (Object)provider.getCredentialEntry("ssl.server.keystore.keypassword"));
        Assert.assertEquals(null, (Object)provider.getCredentialEntry("ssl.server.keystore.password"));
        Assert.assertEquals(null, (Object)provider.getCredentialEntry("ssl.server.truststore.password"));
        try {
            provider.createCredentialEntry("ssl.server.keystore.keypassword", keypass);
            provider.createCredentialEntry("ssl.server.keystore.password", storepass);
            provider.createCredentialEntry("ssl.server.truststore.password", trustpass);
            provider.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        Assert.assertArrayEquals((char[])keypass, (char[])provider.getCredentialEntry("ssl.server.keystore.keypassword").getCredential());
        Assert.assertArrayEquals((char[])storepass, (char[])provider.getCredentialEntry("ssl.server.keystore.password").getCredential());
        Assert.assertArrayEquals((char[])trustpass, (char[])provider.getCredentialEntry("ssl.server.truststore.password").getCredential());
        return conf;
    }

    @Test
    public void testAppendQueryParams() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        String targetUri = "/test/path";
        Mockito.when((Object)request.getCharacterEncoding()).thenReturn(null);
        HashMap<String, String> paramResultMap = new HashMap<String, String>();
        paramResultMap.put("param1=x", targetUri + "?param1=x");
        paramResultMap.put("param1=x&param2=y", targetUri + "?param1=x&param2=y");
        paramResultMap.put("param1=x&param2=y&param3=x+y", targetUri + "?param1=x&param2=y&param3=x+y");
        for (Map.Entry entry : paramResultMap.entrySet()) {
            Mockito.when((Object)request.getQueryString()).thenReturn(entry.getKey());
            String uri = WebAppUtils.appendQueryParams((HttpServletRequest)request, (String)targetUri);
            Assert.assertEquals(entry.getValue(), (Object)uri);
        }
    }

    @Test
    public void testGetHtmlEscapedURIWithQueryString() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        String targetUri = "/test/path";
        Mockito.when((Object)request.getCharacterEncoding()).thenReturn(null);
        Mockito.when((Object)request.getRequestURI()).thenReturn((Object)targetUri);
        HashMap<String, String> paramResultMap = new HashMap<String, String>();
        paramResultMap.put("param1=x", targetUri + "?param1=x");
        paramResultMap.put("param1=x&param2=y", targetUri + "?param1=x&amp;param2=y");
        paramResultMap.put("param1=x&param2=y&param3=x+y", targetUri + "?param1=x&amp;param2=y&amp;param3=x+y");
        for (Map.Entry entry : paramResultMap.entrySet()) {
            Mockito.when((Object)request.getQueryString()).thenReturn(entry.getKey());
            String uri = WebAppUtils.getHtmlEscapedURIWithQueryString((HttpServletRequest)request);
            Assert.assertEquals(entry.getValue(), (Object)uri);
        }
    }

    public class TestBuilder
    extends HttpServer2.Builder {
        public String keypass;
        public String keystorePassword;
        public String truststorePassword;

        public HttpServer2.Builder trustStore(String location, String password, String type) {
            this.truststorePassword = password;
            return super.trustStore(location, password, type);
        }

        public HttpServer2.Builder keyStore(String location, String password, String type) {
            this.keystorePassword = password;
            return super.keyStore(location, password, type);
        }

        public HttpServer2.Builder keyPassword(String password) {
            this.keypass = password;
            return super.keyPassword(password);
        }
    }
}

