/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.registry.server.dns;

import java.io.IOException;
import java.math.BigInteger;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.spec.RSAPrivateKeySpec;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.apache.commons.net.util.Base64;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.registry.client.binding.RegistryUtils;
import org.apache.hadoop.registry.client.types.ServiceRecord;
import org.apache.hadoop.registry.server.dns.BaseServiceRecordProcessor;
import org.apache.hadoop.registry.server.dns.RegistryDNS;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.xbill.DNS.AAAARecord;
import org.xbill.DNS.ARecord;
import org.xbill.DNS.CNAMERecord;
import org.xbill.DNS.DNSKEYRecord;
import org.xbill.DNS.DNSSEC;
import org.xbill.DNS.Message;
import org.xbill.DNS.Name;
import org.xbill.DNS.OPTRecord;
import org.xbill.DNS.PTRRecord;
import org.xbill.DNS.RRSIGRecord;
import org.xbill.DNS.RRset;
import org.xbill.DNS.Record;
import org.xbill.DNS.SRVRecord;

public class TestRegistryDNS
extends Assert {
    private RegistryDNS registryDNS;
    private RegistryUtils.ServiceRecordMarshal marshal;
    private static final String APPLICATION_RECORD = "{\n  \"type\" : \"JSONServiceRecord\",\n  \"description\" : \"Slider Application Master\",\n  \"external\" : [ {\n    \"api\" : \"classpath:org.apache.hadoop.yarn.service.appmaster.ipc\",\n    \"addressType\" : \"host/port\",\n    \"protocolType\" : \"hadoop/IPC\",\n    \"addresses\" : [ {\n      \"host\" : \"192.168.1.5\",\n      \"port\" : \"1026\"\n    } ]\n  }, {\n    \"api\" : \"http://\",\n    \"addressType\" : \"uri\",\n    \"protocolType\" : \"webui\",\n    \"addresses\" : [ {\n      \"uri\" : \"http://192.168.1.5:1027\"\n    } ]\n  }, {\n    \"api\" : \"classpath:org.apache.hadoop.yarn.service.management\",\n    \"addressType\" : \"uri\",\n    \"protocolType\" : \"REST\",\n    \"addresses\" : [ {\n      \"uri\" : \"http://192.168.1.5:1027/ws/v1/slider/mgmt\"\n    } ]\n  } ],\n  \"internal\" : [ {\n    \"api\" : \"classpath:org.apache.hadoop.yarn.service.agents.secure\",\n    \"addressType\" : \"uri\",\n    \"protocolType\" : \"REST\",\n    \"addresses\" : [ {\n      \"uri\" : \"https://192.168.1.5:47700/ws/v1/slider/agents\"\n    } ]\n  }, {\n    \"api\" : \"classpath:org.apache.hadoop.yarn.service.agents.oneway\",\n    \"addressType\" : \"uri\",\n    \"protocolType\" : \"REST\",\n    \"addresses\" : [ {\n      \"uri\" : \"https://192.168.1.5:35531/ws/v1/slider/agents\"\n    } ]\n  } ],\n  \"yarn:id\" : \"application_1451931954322_0016\",\n  \"yarn:persistence\" : \"application\"\n}\n";
    static final String CONTAINER_RECORD = "{\n  \"type\" : \"JSONServiceRecord\",\n  \"description\" : \"httpd-1\",\n  \"external\" : [ ],\n  \"internal\" : [ ],\n  \"yarn:id\" : \"container_e50_1451931954322_0016_01_000002\",\n  \"yarn:persistence\" : \"container\",\n  \"yarn:ip\" : \"172.17.0.19\",\n  \"yarn:hostname\" : \"host1\",\n  \"yarn:component\" : \"httpd\"\n}\n";
    static final String CONTAINER_RECORD2 = "{\n  \"type\" : \"JSONServiceRecord\",\n  \"description\" : \"httpd-2\",\n  \"external\" : [ ],\n  \"internal\" : [ ],\n  \"yarn:id\" : \"container_e50_1451931954322_0016_01_000003\",\n  \"yarn:persistence\" : \"container\",\n  \"yarn:ip\" : \"172.17.0.20\",\n  \"yarn:hostname\" : \"host2\",\n  \"yarn:component\" : \"httpd\"\n}\n";
    private static final String CONTAINER_RECORD_NO_IP = "{\n  \"type\" : \"JSONServiceRecord\",\n  \"description\" : \"httpd-1\",\n  \"external\" : [ ],\n  \"internal\" : [ ],\n  \"yarn:id\" : \"container_e50_1451931954322_0016_01_000002\",\n  \"yarn:persistence\" : \"container\",\n  \"yarn:component\" : \"httpd\"\n}\n";
    private static final String CONTAINER_RECORD_YARN_PERSISTANCE_ABSENT = "{\n  \"type\" : \"JSONServiceRecord\",\n  \"description\" : \"httpd-1\",\n  \"external\" : [ ],\n  \"internal\" : [ ],\n  \"yarn:id\" : \"container_e50_1451931954322_0016_01_000003\",\n  \"yarn:ip\" : \"172.17.0.19\",\n  \"yarn:hostname\" : \"0a134d6329bb\",\n  \"yarn:component\" : \"httpd\"}\n";

    @Before
    public void initialize() throws Exception {
        this.setRegistryDNS(new RegistryDNS("TestRegistry"));
        Configuration conf = this.createConfiguration();
        this.getRegistryDNS().setDomainName(conf);
        this.getRegistryDNS().initializeZones(conf);
        this.setMarshal(new RegistryUtils.ServiceRecordMarshal());
    }

    protected Configuration createConfiguration() {
        Configuration conf = new Configuration();
        conf.set("hadoop.registry.dns.domain-name", "dev.test");
        conf.set("hadoop.registry.dns.zone-subnet", "172.17.0");
        conf.setTimeDuration("hadoop.registry.dns.dns-ttl", 30L, TimeUnit.SECONDS);
        return conf;
    }

    protected boolean isSecure() {
        return false;
    }

    @After
    public void closeRegistry() throws Exception {
        this.getRegistryDNS().stopExecutor();
    }

    @Test
    public void testAppRegistration() throws Exception {
        ServiceRecord record = (ServiceRecord)this.getMarshal().fromBytes("somepath", APPLICATION_RECORD.getBytes());
        this.getRegistryDNS().register("/registry/users/root/services/org-apache-slider/test1/", record);
        Record[] recs = this.assertDNSQuery("test1.root.dev.test.");
        TestRegistryDNS.assertEquals((String)"wrong result", (Object)"192.168.1.5", (Object)((ARecord)recs[0]).getAddress().getHostAddress());
        recs = this.assertDNSQuery("management-api.test1.root.dev.test.", 2);
        TestRegistryDNS.assertEquals((String)"wrong target name", (Object)"test1.root.dev.test.", (Object)((CNAMERecord)recs[0]).getTarget().toString());
        TestRegistryDNS.assertTrue((String)"not an ARecord", (boolean)(recs[this.isSecure() ? 2 : 1] instanceof ARecord));
        recs = this.assertDNSQuery("appmaster-ipc-api.test1.root.dev.test.", 33, 1);
        TestRegistryDNS.assertTrue((String)"not an SRV record", (boolean)(recs[0] instanceof SRVRecord));
        TestRegistryDNS.assertEquals((String)"wrong port", (long)1026L, (long)((SRVRecord)recs[0]).getPort());
        recs = this.assertDNSQuery("appmaster-ipc-api.test1.root.dev.test.", 2);
        TestRegistryDNS.assertEquals((String)"wrong target name", (Object)"test1.root.dev.test.", (Object)((CNAMERecord)recs[0]).getTarget().toString());
        TestRegistryDNS.assertTrue((String)"not an ARecord", (boolean)(recs[this.isSecure() ? 2 : 1] instanceof ARecord));
        recs = this.assertDNSQuery("http-api.test1.root.dev.test.", 2);
        TestRegistryDNS.assertEquals((String)"wrong target name", (Object)"test1.root.dev.test.", (Object)((CNAMERecord)recs[0]).getTarget().toString());
        TestRegistryDNS.assertTrue((String)"not an ARecord", (boolean)(recs[this.isSecure() ? 2 : 1] instanceof ARecord));
        recs = this.assertDNSQuery("http-api.test1.root.dev.test.", 33, 1);
        TestRegistryDNS.assertTrue((String)"not an SRV record", (boolean)(recs[0] instanceof SRVRecord));
        TestRegistryDNS.assertEquals((String)"wrong port", (long)1027L, (long)((SRVRecord)recs[0]).getPort());
        this.assertDNSQuery("test1.root.dev.test.", 16, 3);
        this.assertDNSQuery("appmaster-ipc-api.test1.root.dev.test.", 16, 1);
        this.assertDNSQuery("http-api.test1.root.dev.test.", 16, 1);
        this.assertDNSQuery("management-api.test1.root.dev.test.", 16, 1);
    }

    @Test
    public void testContainerRegistration() throws Exception {
        ServiceRecord record = (ServiceRecord)this.getMarshal().fromBytes("somepath", CONTAINER_RECORD.getBytes());
        this.getRegistryDNS().register("/registry/users/root/services/org-apache-slider/test1/components/ctr-e50-1451931954322-0016-01-000002", record);
        Record[] recs = this.assertDNSQuery("ctr-e50-1451931954322-0016-01-000002.dev.test.");
        TestRegistryDNS.assertEquals((String)"wrong result", (Object)"172.17.0.19", (Object)((ARecord)recs[0]).getAddress().getHostAddress());
        recs = this.assertDNSQuery("httpd-1.test1.root.dev.test.", 1);
        TestRegistryDNS.assertTrue((String)"not an ARecord", (boolean)(recs[0] instanceof ARecord));
    }

    @Test
    public void testContainerRegistrationPersistanceAbsent() throws Exception {
        ServiceRecord record = (ServiceRecord)this.marshal.fromBytes("somepath", CONTAINER_RECORD_YARN_PERSISTANCE_ABSENT.getBytes());
        this.registryDNS.register("/registry/users/root/services/org-apache-slider/test1/components/ctr-e50-1451931954322-0016-01-000003", record);
        Name name = Name.fromString((String)"ctr-e50-1451931954322-0016-01-000002.dev.test.");
        Record question = Record.newRecord((Name)name, (int)1, (int)1);
        Message query = Message.newQuery((Record)question);
        byte[] responseBytes = this.registryDNS.generateReply(query, null);
        Message response = new Message(responseBytes);
        TestRegistryDNS.assertEquals((String)"Excepting NXDOMAIN as Record must not have regsisterd wrong", (long)3L, (long)response.getRcode());
    }

    @Test
    public void testRecordTTL() throws Exception {
        ServiceRecord record = (ServiceRecord)this.getMarshal().fromBytes("somepath", CONTAINER_RECORD.getBytes());
        this.getRegistryDNS().register("/registry/users/root/services/org-apache-slider/test1/components/ctr-e50-1451931954322-0016-01-000002", record);
        Record[] recs = this.assertDNSQuery("ctr-e50-1451931954322-0016-01-000002.dev.test.");
        TestRegistryDNS.assertEquals((String)"wrong result", (Object)"172.17.0.19", (Object)((ARecord)recs[0]).getAddress().getHostAddress());
        TestRegistryDNS.assertEquals((String)"wrong ttl", (long)30L, (long)recs[0].getTTL());
        recs = this.assertDNSQuery("httpd-1.test1.root.dev.test.", 1);
        TestRegistryDNS.assertTrue((String)"not an ARecord", (boolean)(recs[0] instanceof ARecord));
        TestRegistryDNS.assertEquals((String)"wrong ttl", (long)30L, (long)recs[0].getTTL());
    }

    @Test
    public void testReverseLookup() throws Exception {
        ServiceRecord record = (ServiceRecord)this.getMarshal().fromBytes("somepath", CONTAINER_RECORD.getBytes());
        this.getRegistryDNS().register("/registry/users/root/services/org-apache-slider/test1/components/ctr-e50-1451931954322-0016-01-000002", record);
        Record[] recs = this.assertDNSQuery("19.0.17.172.in-addr.arpa.", 12, 1);
        TestRegistryDNS.assertEquals((String)"wrong result", (Object)"httpd-1.test1.root.dev.test.", (Object)((PTRRecord)recs[0]).getTarget().toString());
    }

    @Test
    public void testReverseLookupInLargeNetwork() throws Exception {
        this.setRegistryDNS(new RegistryDNS("TestRegistry"));
        Configuration conf = this.createConfiguration();
        conf.set("hadoop.registry.dns.domain-name", "dev.test");
        conf.set("hadoop.registry.dns.zone-subnet", "172.17.0.0");
        conf.set("hadoop.registry.dns.zone-mask", "255.255.224.0");
        conf.setTimeDuration("hadoop.registry.dns.dns-ttl", 30L, TimeUnit.SECONDS);
        this.getRegistryDNS().setDomainName(conf);
        this.getRegistryDNS().initializeZones(conf);
        ServiceRecord record = (ServiceRecord)this.getMarshal().fromBytes("somepath", CONTAINER_RECORD.getBytes());
        this.getRegistryDNS().register("/registry/users/root/services/org-apache-slider/test1/components/ctr-e50-1451931954322-0016-01-000002", record);
        Record[] recs = this.assertDNSQuery("19.0.17.172.in-addr.arpa.", 12, 1);
        TestRegistryDNS.assertEquals((String)"wrong result", (Object)"httpd-1.test1.root.dev.test.", (Object)((PTRRecord)recs[0]).getTarget().toString());
    }

    @Test
    public void testMissingReverseLookup() throws Exception {
        ServiceRecord record = (ServiceRecord)this.getMarshal().fromBytes("somepath", CONTAINER_RECORD.getBytes());
        this.getRegistryDNS().register("/registry/users/root/services/org-apache-slider/test1/components/ctr-e50-1451931954322-0016-01-000002", record);
        Name name = Name.fromString((String)"19.1.17.172.in-addr.arpa.");
        Record question = Record.newRecord((Name)name, (int)12, (int)1);
        Message query = Message.newQuery((Record)question);
        OPTRecord optRecord = new OPTRecord(4096, 0, 0, 32768, null);
        query.addRecord((Record)optRecord, 3);
        byte[] responseBytes = this.getRegistryDNS().generateReply(query, null);
        Message response = new Message(responseBytes);
        TestRegistryDNS.assertEquals((String)"Missing record should be: ", (long)3L, (long)response.getRcode());
    }

    @Test
    public void testNoContainerIP() throws Exception {
        ServiceRecord record = (ServiceRecord)this.getMarshal().fromBytes("somepath", CONTAINER_RECORD_NO_IP.getBytes());
        this.getRegistryDNS().register("/registry/users/root/services/org-apache-slider/test1/components/ctr-e50-1451931954322-0016-01-000002", record);
        Name name = Name.fromString((String)"ctr-e50-1451931954322-0016-01-000002.dev.test.");
        Record question = Record.newRecord((Name)name, (int)1, (int)1);
        Message query = Message.newQuery((Record)question);
        byte[] responseBytes = this.getRegistryDNS().generateReply(query, null);
        Message response = new Message(responseBytes);
        TestRegistryDNS.assertEquals((String)"wrong status", (long)3L, (long)response.getRcode());
    }

    private Record[] assertDNSQuery(String lookup) throws IOException {
        return this.assertDNSQuery(lookup, 1, 1);
    }

    private Record[] assertDNSQuery(String lookup, int numRecs) throws IOException {
        return this.assertDNSQuery(lookup, 1, numRecs);
    }

    Record[] assertDNSQuery(String lookup, int type, int numRecs) throws IOException {
        Name name = Name.fromString((String)lookup);
        Record question = Record.newRecord((Name)name, (int)type, (int)1);
        Message query = Message.newQuery((Record)question);
        OPTRecord optRecord = new OPTRecord(4096, 0, 0, 32768, null);
        query.addRecord((Record)optRecord, 3);
        byte[] responseBytes = this.getRegistryDNS().generateReply(query, null);
        Message response = new Message(responseBytes);
        TestRegistryDNS.assertEquals((String)"not successful", (long)0L, (long)response.getRcode());
        TestRegistryDNS.assertNotNull((String)"Null response", (Object)response);
        TestRegistryDNS.assertEquals((String)"Questions do not match", (Object)query.getQuestion(), (Object)response.getQuestion());
        Record[] recs = response.getSectionArray(1);
        TestRegistryDNS.assertEquals((String)"wrong number of answer records", (long)(this.isSecure() ? (long)(numRecs * 2) : (long)numRecs), (long)recs.length);
        if (this.isSecure()) {
            boolean signed = false;
            for (Record record : recs) {
                boolean bl = signed = record.getType() == 46;
                if (signed) break;
            }
            TestRegistryDNS.assertTrue((String)"No signatures found", (boolean)signed);
        }
        return recs;
    }

    Record[] assertDNSQueryNotNull(String lookup, int type, int answerCount) throws IOException {
        Name name = Name.fromString((String)lookup);
        Record question = Record.newRecord((Name)name, (int)type, (int)1);
        Message query = Message.newQuery((Record)question);
        OPTRecord optRecord = new OPTRecord(4096, 0, 0, 32768, null);
        query.addRecord((Record)optRecord, 3);
        byte[] responseBytes = this.getRegistryDNS().generateReply(query, null);
        Message response = new Message(responseBytes);
        TestRegistryDNS.assertEquals((String)"not successful", (long)0L, (long)response.getRcode());
        TestRegistryDNS.assertNotNull((String)"Null response", (Object)response);
        TestRegistryDNS.assertEquals((String)"Questions do not match", (Object)query.getQuestion(), (Object)response.getQuestion());
        Record[] recs = response.getSectionArray(1);
        TestRegistryDNS.assertEquals((long)answerCount, (long)recs.length);
        TestRegistryDNS.assertEquals((long)recs[0].getType(), (long)type);
        return recs;
    }

    @Test
    public void testDNSKEYRecord() throws Exception {
        String publicK = "AwEAAe1Jev0Az1khlQCvf0nud1/CNHQwwPEu8BNchZthdDxKPVn29yrD CHoAWjwiGsOSw3SzIPrawSbHzyJsjn0oLBhGrH6QedFGnydoxjNsw3m/ SCmOjR/a7LGBAMDFKqFioi4gOyuN66svBeY+/5uw72+0ei9AQ20gqf6q l9Ozs5bV";
        DNSKEYRecord dnskeyRecord = new DNSKEYRecord(Name.fromString((String)"dev.test."), 1, 0L, 256, 3, 8, Base64.decodeBase64((byte[])publicK.getBytes()));
        TestRegistryDNS.assertNotNull((Object)dnskeyRecord);
        RSAPrivateKeySpec privateSpec = new RSAPrivateKeySpec(new BigInteger(1, Base64.decodeBase64((String)"7Ul6/QDPWSGVAK9/Se53X8I0dDDA8S7wE1yFm2F0PEo9Wfb3KsMIegBaPCIaw5LDdLMg+trBJsfPImyOfSgsGEasfpB50UafJ2jGM2zDeb9IKY6NH9rssYEAwMUqoWKiLiA7K43rqy8F5j7/m7Dvb7R6L0BDbSCp/qqX07OzltU=")), new BigInteger(1, Base64.decodeBase64((String)"MgbQ6DBYhskeufNGGdct0cGG/4wb0X183ggenwCv2dopDyOTPq+5xMb4Pz9Ndzgk/yCY7mpaWIu9rttGOzrR+LBRR30VobPpMK1bMnzu2C0x08oYAguVwZB79DLC705qmZpiaaFB+LnhG7VtpPiOBm3UzZxdrBfeq/qaKrXid60=")));
        KeyFactory factory = KeyFactory.getInstance("RSA");
        PrivateKey priv = factory.generatePrivate(privateSpec);
        ARecord aRecord = new ARecord(Name.fromString((String)"some.test."), 1, 0L, InetAddress.getByName("192.168.0.1"));
        Calendar cal = Calendar.getInstance();
        Date inception = cal.getTime();
        cal.add(1, 1);
        Date expiration = cal.getTime();
        RRset rrset = new RRset((Record)aRecord);
        RRSIGRecord rrsigRecord = DNSSEC.sign((RRset)rrset, (DNSKEYRecord)dnskeyRecord, (PrivateKey)priv, (Date)inception, (Date)expiration);
        DNSSEC.verify((RRset)rrset, (RRSIGRecord)rrsigRecord, (DNSKEYRecord)dnskeyRecord);
    }

    @Test
    public void testIpv4toIpv6() throws Exception {
        InetAddress address = BaseServiceRecordProcessor.getIpv6Address((InetAddress)InetAddress.getByName("172.17.0.19"));
        TestRegistryDNS.assertTrue((String)"not an ipv6 address", (boolean)(address instanceof Inet6Address));
        TestRegistryDNS.assertEquals((String)"wrong IP", (Object)"172.17.0.19", (Object)InetAddress.getByAddress(address.getAddress()).getHostAddress());
    }

    @Test
    public void testAAAALookup() throws Exception {
        ServiceRecord record = (ServiceRecord)this.getMarshal().fromBytes("somepath", CONTAINER_RECORD.getBytes());
        this.getRegistryDNS().register("/registry/users/root/services/org-apache-slider/test1/components/ctr-e50-1451931954322-0016-01-000002", record);
        Record[] recs = this.assertDNSQuery("ctr-e50-1451931954322-0016-01-000002.dev.test.", 28, 1);
        TestRegistryDNS.assertEquals((String)"wrong result", (Object)"172.17.0.19", (Object)((AAAARecord)recs[0]).getAddress().getHostAddress());
        recs = this.assertDNSQuery("httpd-1.test1.root.dev.test.", 28, 1);
        TestRegistryDNS.assertTrue((String)"not an ARecord", (boolean)(recs[0] instanceof AAAARecord));
    }

    @Test
    public void testNegativeLookup() throws Exception {
        ServiceRecord record = (ServiceRecord)this.getMarshal().fromBytes("somepath", CONTAINER_RECORD.getBytes());
        this.getRegistryDNS().register("/registry/users/root/services/org-apache-slider/test1/components/ctr-e50-1451931954322-0016-01-000002", record);
        Name name = Name.fromString((String)"missing.dev.test.");
        Record question = Record.newRecord((Name)name, (int)1, (int)1);
        Message query = Message.newQuery((Record)question);
        byte[] responseBytes = this.getRegistryDNS().generateReply(query, null);
        Message response = new Message(responseBytes);
        TestRegistryDNS.assertEquals((String)"not successful", (long)3L, (long)response.getRcode());
        TestRegistryDNS.assertNotNull((String)"Null response", (Object)response);
        TestRegistryDNS.assertEquals((String)"Questions do not match", (Object)query.getQuestion(), (Object)response.getQuestion());
        Record[] sectionArray = response.getSectionArray(2);
        TestRegistryDNS.assertEquals((String)"Wrong number of recs in AUTHORITY", (long)(this.isSecure() ? 2L : 1L), (long)sectionArray.length);
        boolean soaFound = false;
        for (Record rec : sectionArray) {
            boolean bl = soaFound = rec.getType() == 6;
            if (soaFound) break;
        }
        TestRegistryDNS.assertTrue((String)"wrong record type", (boolean)soaFound);
    }

    @Test
    public void testReadMasterFile() throws Exception {
        this.setRegistryDNS(new RegistryDNS("TestRegistry"));
        Configuration conf = new Configuration();
        conf.set("hadoop.registry.dns.domain-name", "dev.test");
        conf.set("hadoop.registry.dns.zone-subnet", "172.17.0");
        conf.setTimeDuration("hadoop.registry.dns.dns-ttl", 30L, TimeUnit.SECONDS);
        conf.set("hadoop.registry.dns.zones-dir", ((Object)((Object)this)).getClass().getResource("/").getFile());
        if (this.isSecure()) {
            conf.setBoolean("hadoop.registry.dns.dnssec.enabled", true);
            conf.set("hadoop.registry.dns.public-key", "AwEAAe1Jev0Az1khlQCvf0nud1/CNHQwwPEu8BNchZthdDxKPVn29yrD CHoAWjwiGsOSw3SzIPrawSbHzyJsjn0oLBhGrH6QedFGnydoxjNsw3m/ SCmOjR/a7LGBAMDFKqFioi4gOyuN66svBeY+/5uw72+0ei9AQ20gqf6q l9Ozs5bV");
            conf.set("hadoop.registry.dns.private-key-file", ((Object)((Object)this)).getClass().getResource("/test.private").getFile());
        }
        this.getRegistryDNS().setDomainName(conf);
        this.getRegistryDNS().initializeZones(conf);
        ServiceRecord record = (ServiceRecord)this.getMarshal().fromBytes("somepath", CONTAINER_RECORD.getBytes());
        this.getRegistryDNS().register("/registry/users/root/services/org-apache-slider/test1/components/ctr-e50-1451931954322-0016-01-000002", record);
        Record[] recs = this.assertDNSQuery("ctr-e50-1451931954322-0016-01-000002.dev.test.");
        TestRegistryDNS.assertEquals((String)"wrong result", (Object)"172.17.0.19", (Object)((ARecord)recs[0]).getAddress().getHostAddress());
        recs = this.assertDNSQuery("httpd-1.test1.root.dev.test.", 1);
        TestRegistryDNS.assertTrue((String)"not an ARecord", (boolean)(recs[0] instanceof ARecord));
        recs = this.assertDNSQuery("19.0.17.172.in-addr.arpa.", 12, 1);
        TestRegistryDNS.assertEquals((String)"wrong result", (Object)"httpd-1.test1.root.dev.test.", (Object)((PTRRecord)recs[0]).getTarget().toString());
        Name name = Name.fromString((String)"5.0.17.172.in-addr.arpa.");
        Record question = Record.newRecord((Name)name, (int)12, (int)1);
        Message query = Message.newQuery((Record)question);
        OPTRecord optRecord = new OPTRecord(4096, 0, 0, 32768, null);
        query.addRecord((Record)optRecord, 3);
        byte[] responseBytes = this.getRegistryDNS().generateReply(query, null);
        Message response = new Message(responseBytes);
        recs = response.getSectionArray(1);
        TestRegistryDNS.assertEquals((String)"wrong result", (Object)"cn005.dev.test.", (Object)((PTRRecord)recs[0]).getTarget().toString());
    }

    @Test
    public void testReverseZoneNames() throws Exception {
        Configuration conf = new Configuration();
        conf.set("hadoop.registry.dns.zone-subnet", "172.26.32.0");
        conf.set("hadoop.registry.dns.zone-mask", "255.255.224.0");
        Name name = this.getRegistryDNS().getReverseZoneName(conf);
        TestRegistryDNS.assertEquals((String)"wrong name", (Object)"26.172.in-addr.arpa.", (Object)name.toString());
    }

    @Test
    public void testSplitReverseZoneNames() throws Exception {
        Configuration conf = new Configuration();
        this.registryDNS = new RegistryDNS("TestRegistry");
        conf.set("hadoop.registry.dns.domain-name", "example.com");
        conf.set("hadoop.registry.dns.split-reverse-zone", "true");
        conf.set("hadoop.registry.dns.split-reverse-zone-range", "256");
        conf.set("hadoop.registry.dns.zone-subnet", "172.26.32.0");
        conf.set("hadoop.registry.dns.zone-mask", "255.255.224.0");
        conf.setTimeDuration("hadoop.registry.dns.dns-ttl", 30L, TimeUnit.SECONDS);
        conf.set("hadoop.registry.dns.zones-dir", ((Object)((Object)this)).getClass().getResource("/").getFile());
        if (this.isSecure()) {
            conf.setBoolean("hadoop.registry.dns.dnssec.enabled", true);
            conf.set("hadoop.registry.dns.public-key", "AwEAAe1Jev0Az1khlQCvf0nud1/CNHQwwPEu8BNchZthdDxKPVn29yrD CHoAWjwiGsOSw3SzIPrawSbHzyJsjn0oLBhGrH6QedFGnydoxjNsw3m/ SCmOjR/a7LGBAMDFKqFioi4gOyuN66svBeY+/5uw72+0ei9AQ20gqf6q l9Ozs5bV");
            conf.set("hadoop.registry.dns.private-key-file", ((Object)((Object)this)).getClass().getResource("/test.private").getFile());
        }
        this.registryDNS.setDomainName(conf);
        this.registryDNS.setDNSSECEnabled(conf);
        this.registryDNS.addSplitReverseZones(conf, 4);
        TestRegistryDNS.assertEquals((long)4L, (long)this.registryDNS.getZoneCount());
    }

    @Test
    public void testExampleDotCom() throws Exception {
        Name name = Name.fromString((String)"example.com.");
        Record[] records = this.getRegistryDNS().getRecords(name, 6);
        TestRegistryDNS.assertNotNull((String)"example.com exists:", (Object)records);
    }

    @Test
    public void testExternalCNAMERecord() throws Exception {
        this.setRegistryDNS(new RegistryDNS("TestRegistry"));
        Configuration conf = new Configuration();
        conf.set("hadoop.registry.dns.domain-name", "dev.test");
        conf.set("hadoop.registry.dns.zone-subnet", "172.17.0");
        conf.setTimeDuration("hadoop.registry.dns.dns-ttl", 30L, TimeUnit.SECONDS);
        conf.set("hadoop.registry.dns.zones-dir", ((Object)((Object)this)).getClass().getResource("/").getFile());
        this.getRegistryDNS().setDomainName(conf);
        this.getRegistryDNS().initializeZones(conf);
        Record[] recs = this.assertDNSQueryNotNull("mail.yahoo.com.", 5, 1);
    }

    @Test
    public void testRootLookup() throws Exception {
        this.setRegistryDNS(new RegistryDNS("TestRegistry"));
        Configuration conf = new Configuration();
        conf.set("hadoop.registry.dns.domain-name", "dev.test");
        conf.set("hadoop.registry.dns.zone-subnet", "172.17.0");
        conf.setTimeDuration("hadoop.registry.dns.dns-ttl", 30L, TimeUnit.SECONDS);
        conf.set("hadoop.registry.dns.zones-dir", ((Object)((Object)this)).getClass().getResource("/").getFile());
        this.getRegistryDNS().setDomainName(conf);
        this.getRegistryDNS().initializeZones(conf);
        Record[] recs = this.assertDNSQueryNotNull(".", 2, 13);
    }

    @Test
    public void testMultiARecord() throws Exception {
        ServiceRecord record = (ServiceRecord)this.getMarshal().fromBytes("somepath", CONTAINER_RECORD.getBytes());
        ServiceRecord record2 = (ServiceRecord)this.getMarshal().fromBytes("somepath", CONTAINER_RECORD2.getBytes());
        this.getRegistryDNS().register("/registry/users/root/services/org-apache-slider/test1/components/ctr-e50-1451931954322-0016-01-000002", record);
        this.getRegistryDNS().register("/registry/users/root/services/org-apache-slider/test1/components/ctr-e50-1451931954322-0016-01-000003", record2);
        Record[] recs = this.assertDNSQuery("httpd.test1.root.dev.test.", 2);
        TestRegistryDNS.assertTrue((String)"not an ARecord", (boolean)(recs[0] instanceof ARecord));
        TestRegistryDNS.assertTrue((String)"not an ARecord", (boolean)(recs[1] instanceof ARecord));
    }

    @Test(timeout=5000L)
    public void testUpstreamFault() throws Exception {
        Name name = Name.fromString((String)"19.0.17.172.in-addr.arpa.");
        Record[] recs = this.getRegistryDNS().getRecords(name, 5);
        TestRegistryDNS.assertNull((String)"Record is not null", (Object)recs);
    }

    public RegistryDNS getRegistryDNS() {
        return this.registryDNS;
    }

    public void setRegistryDNS(RegistryDNS registryDNS) {
        this.registryDNS = registryDNS;
    }

    public RegistryUtils.ServiceRecordMarshal getMarshal() {
        return this.marshal;
    }

    public void setMarshal(RegistryUtils.ServiceRecordMarshal marshal) {
        this.marshal = marshal;
    }
}

