/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.registry.server.dns;

import java.net.UnknownHostException;
import org.apache.hadoop.registry.server.dns.ReverseZoneUtils;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class TestReverseZoneUtils {
    private static final String NET = "172.17.4.0";
    private static final int RANGE = 256;
    private static final int INDEX = 0;
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Test
    public void testGetReverseZoneNetworkAddress() throws Exception {
        Assert.assertEquals((Object)NET, (Object)ReverseZoneUtils.getReverseZoneNetworkAddress((String)NET, (int)256, (int)0));
    }

    @Test
    public void testSplitIp() throws Exception {
        long[] splitIp = ReverseZoneUtils.splitIp((String)NET);
        Assert.assertEquals((long)172L, (long)splitIp[0]);
        Assert.assertEquals((long)17L, (long)splitIp[1]);
        Assert.assertEquals((long)4L, (long)splitIp[2]);
        Assert.assertEquals((long)0L, (long)splitIp[3]);
    }

    @Test
    public void testThrowIllegalArgumentExceptionIfIndexIsNegative() throws Exception {
        this.exception.expect(IllegalArgumentException.class);
        ReverseZoneUtils.getReverseZoneNetworkAddress((String)NET, (int)256, (int)-1);
    }

    @Test
    public void testThrowUnknownHostExceptionIfIpIsInvalid() throws Exception {
        this.exception.expect(UnknownHostException.class);
        ReverseZoneUtils.getReverseZoneNetworkAddress((String)"213124.21231.14123.13", (int)256, (int)0);
    }

    @Test
    public void testThrowIllegalArgumentExceptionIfRangeIsNegative() throws Exception {
        this.exception.expect(IllegalArgumentException.class);
        ReverseZoneUtils.getReverseZoneNetworkAddress((String)NET, (int)-1, (int)0);
    }

    @Test
    public void testVariousRangeAndIndexValues() throws Exception {
        Assert.assertEquals((Object)"172.17.9.0", (Object)ReverseZoneUtils.getReverseZoneNetworkAddress((String)NET, (int)256, (int)5));
        Assert.assertEquals((Object)"172.17.4.128", (Object)ReverseZoneUtils.getReverseZoneNetworkAddress((String)NET, (int)128, (int)1));
        Assert.assertEquals((Object)"172.18.0.0", (Object)ReverseZoneUtils.getReverseZoneNetworkAddress((String)NET, (int)256, (int)252));
        Assert.assertEquals((Object)"172.17.12.0", (Object)ReverseZoneUtils.getReverseZoneNetworkAddress((String)NET, (int)1024, (int)2));
        Assert.assertEquals((Object)NET, (Object)ReverseZoneUtils.getReverseZoneNetworkAddress((String)NET, (int)0, (int)1));
        Assert.assertEquals((Object)NET, (Object)ReverseZoneUtils.getReverseZoneNetworkAddress((String)NET, (int)1, (int)0));
        Assert.assertEquals((Object)"172.17.4.1", (Object)ReverseZoneUtils.getReverseZoneNetworkAddress((String)NET, (int)1, (int)1));
    }
}

