/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timeline.webapp;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.servlet.GuiceFilter;
import com.google.inject.servlet.GuiceServletContextListener;
import com.google.inject.servlet.ServletModule;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.guice.spi.container.servlet.GuiceContainer;
import com.sun.jersey.test.framework.WebAppDescriptor;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.timeline.TimelineAbout;
import org.apache.hadoop.yarn.api.records.timeline.TimelineDomain;
import org.apache.hadoop.yarn.api.records.timeline.TimelineDomains;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntities;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEvent;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEvents;
import org.apache.hadoop.yarn.api.records.timeline.TimelinePutResponse;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.security.AdminACLsManager;
import org.apache.hadoop.yarn.security.client.TimelineDelegationTokenIdentifier;
import org.apache.hadoop.yarn.server.timeline.TestMemoryTimelineStore;
import org.apache.hadoop.yarn.server.timeline.TimelineDataManager;
import org.apache.hadoop.yarn.server.timeline.TimelineStore;
import org.apache.hadoop.yarn.server.timeline.security.TimelineACLsManager;
import org.apache.hadoop.yarn.server.timeline.security.TimelineAuthenticationFilter;
import org.apache.hadoop.yarn.server.timeline.webapp.TimelineWebServices;
import org.apache.hadoop.yarn.util.timeline.TimelineUtils;
import org.apache.hadoop.yarn.webapp.GenericExceptionHandler;
import org.apache.hadoop.yarn.webapp.JerseyTestBase;
import org.apache.hadoop.yarn.webapp.YarnJacksonJaxbJsonProvider;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class TestTimelineWebServices
extends JerseyTestBase {
    private static TimelineStore store;
    private static TimelineACLsManager timelineACLsManager;
    private static AdminACLsManager adminACLsManager;
    private long beforeTime;
    private Injector injector = Guice.createInjector((Module[])new Module[]{new ServletModule(){

        protected void configureServlets() {
            this.bind(YarnJacksonJaxbJsonProvider.class);
            this.bind(TimelineWebServices.class);
            this.bind(GenericExceptionHandler.class);
            try {
                store = TestTimelineWebServices.this.mockTimelineStore();
            }
            catch (Exception e) {
                Assert.fail();
            }
            YarnConfiguration conf = new YarnConfiguration();
            conf.setBoolean("yarn.acl.enable", false);
            timelineACLsManager = new TimelineACLsManager((Configuration)conf);
            timelineACLsManager.setTimelineStore(store);
            conf.setBoolean("yarn.acl.enable", true);
            conf.set("yarn.admin.acl", "admin");
            adminACLsManager = new AdminACLsManager((Configuration)conf);
            TimelineDataManager timelineDataManager = new TimelineDataManager(store, timelineACLsManager);
            timelineDataManager.init((Configuration)conf);
            timelineDataManager.start();
            this.bind(TimelineDataManager.class).toInstance((Object)timelineDataManager);
            this.serve("/*", new String[0]).with(GuiceContainer.class);
            TimelineAuthenticationFilter taFilter = new TimelineAuthenticationFilter();
            FilterConfig filterConfig = (FilterConfig)Mockito.mock(FilterConfig.class);
            Mockito.when((Object)filterConfig.getInitParameter("config.prefix")).thenReturn(null);
            Mockito.when((Object)filterConfig.getInitParameter("type")).thenReturn((Object)"simple");
            Mockito.when((Object)filterConfig.getInitParameter("simple.anonymous.allowed")).thenReturn((Object)"true");
            ServletContext context = (ServletContext)Mockito.mock(ServletContext.class);
            Mockito.when((Object)filterConfig.getServletContext()).thenReturn((Object)context);
            Enumeration names = (Enumeration)Mockito.mock(Enumeration.class);
            Mockito.when((Object)names.hasMoreElements()).thenReturn((Object)true, (Object[])new Boolean[]{true, true, false});
            Mockito.when(names.nextElement()).thenReturn((Object)"type", new Object[]{"simple.anonymous.allowed", "delegation-token.token-kind"});
            Mockito.when((Object)filterConfig.getInitParameterNames()).thenReturn((Object)names);
            Mockito.when((Object)filterConfig.getInitParameter("delegation-token.token-kind")).thenReturn((Object)TimelineDelegationTokenIdentifier.KIND_NAME.toString());
            try {
                taFilter.init(filterConfig);
            }
            catch (ServletException e) {
                Assert.fail((String)("Unable to initialize TimelineAuthenticationFilter: " + e.getMessage()));
            }
            taFilter = (TimelineAuthenticationFilter)Mockito.spy((Object)taFilter);
            try {
                ((TimelineAuthenticationFilter)Mockito.doNothing().when((Object)taFilter)).init((FilterConfig)Matchers.any(FilterConfig.class));
            }
            catch (ServletException e) {
                Assert.fail((String)("Unable to initialize TimelineAuthenticationFilter: " + e.getMessage()));
            }
            this.filter("/*", new String[0]).through((Filter)taFilter);
        }
    }});

    private TimelineStore mockTimelineStore() throws Exception {
        this.beforeTime = System.currentTimeMillis() - 1L;
        TestMemoryTimelineStore store = new TestMemoryTimelineStore();
        store.setup();
        return store.getTimelineStore();
    }

    public TestTimelineWebServices() {
        super(((WebAppDescriptor.Builder)new WebAppDescriptor.Builder(new String[]{"org.apache.hadoop.yarn.server.applicationhistoryservice.webapp"}).contextListenerClass(GuiceServletConfig.class).filterClass(GuiceFilter.class).contextPath("jersey-guice-filter").servletPath("/").clientConfig((ClientConfig)new DefaultClientConfig(new Class[]{YarnJacksonJaxbJsonProvider.class}))).build());
    }

    @Test
    public void testAbout() throws Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("timeline").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        TimelineAbout actualAbout = (TimelineAbout)response.getEntity(TimelineAbout.class);
        TimelineAbout expectedAbout = TimelineUtils.createTimelineAbout((String)"Timeline API");
        Assert.assertNotNull((String)"Timeline service about response is null", (Object)actualAbout);
        Assert.assertEquals((Object)expectedAbout.getAbout(), (Object)actualAbout.getAbout());
        Assert.assertEquals((Object)expectedAbout.getTimelineServiceVersion(), (Object)actualAbout.getTimelineServiceVersion());
        Assert.assertEquals((Object)expectedAbout.getTimelineServiceBuildVersion(), (Object)actualAbout.getTimelineServiceBuildVersion());
        Assert.assertEquals((Object)expectedAbout.getTimelineServiceVersionBuiltOn(), (Object)actualAbout.getTimelineServiceVersionBuiltOn());
        Assert.assertEquals((Object)expectedAbout.getHadoopVersion(), (Object)actualAbout.getHadoopVersion());
        Assert.assertEquals((Object)expectedAbout.getHadoopBuildVersion(), (Object)actualAbout.getHadoopBuildVersion());
        Assert.assertEquals((Object)expectedAbout.getHadoopVersionBuiltOn(), (Object)actualAbout.getHadoopVersionBuiltOn());
    }

    private static void verifyEntities(TimelineEntities entities) {
        Assert.assertNotNull((Object)entities);
        Assert.assertEquals((long)3L, (long)entities.getEntities().size());
        TimelineEntity entity1 = (TimelineEntity)entities.getEntities().get(0);
        Assert.assertNotNull((Object)entity1);
        Assert.assertEquals((Object)"id_1", (Object)entity1.getEntityId());
        Assert.assertEquals((Object)"type_1", (Object)entity1.getEntityType());
        Assert.assertEquals((long)123L, (long)entity1.getStartTime());
        Assert.assertEquals((long)2L, (long)entity1.getEvents().size());
        Assert.assertEquals((long)4L, (long)entity1.getPrimaryFilters().size());
        Assert.assertEquals((long)4L, (long)entity1.getOtherInfo().size());
        TimelineEntity entity2 = (TimelineEntity)entities.getEntities().get(1);
        Assert.assertNotNull((Object)entity2);
        Assert.assertEquals((Object)"id_2", (Object)entity2.getEntityId());
        Assert.assertEquals((Object)"type_1", (Object)entity2.getEntityType());
        Assert.assertEquals((long)123L, (long)entity2.getStartTime());
        Assert.assertEquals((long)2L, (long)entity2.getEvents().size());
        Assert.assertEquals((long)4L, (long)entity2.getPrimaryFilters().size());
        Assert.assertEquals((long)4L, (long)entity2.getOtherInfo().size());
        TimelineEntity entity3 = (TimelineEntity)entities.getEntities().get(2);
        Assert.assertNotNull((Object)entity2);
        Assert.assertEquals((Object)"id_6", (Object)entity3.getEntityId());
        Assert.assertEquals((Object)"type_1", (Object)entity3.getEntityType());
        Assert.assertEquals((long)61L, (long)entity3.getStartTime());
        Assert.assertEquals((long)0L, (long)entity3.getEvents().size());
        Assert.assertEquals((long)4L, (long)entity3.getPrimaryFilters().size());
        Assert.assertEquals((long)4L, (long)entity3.getOtherInfo().size());
    }

    @Test
    public void testGetEntities() throws Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("timeline").path("type_1").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        TestTimelineWebServices.verifyEntities((TimelineEntities)response.getEntity(TimelineEntities.class));
    }

    @Test
    public void testFromId() throws Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("timeline").path("type_1").queryParam("fromId", "id_2").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        Assert.assertEquals((long)2L, (long)((TimelineEntities)response.getEntity(TimelineEntities.class)).getEntities().size());
        response = (ClientResponse)r.path("ws").path("v1").path("timeline").path("type_1").queryParam("fromId", "id_1").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        Assert.assertEquals((long)3L, (long)((TimelineEntities)response.getEntity(TimelineEntities.class)).getEntities().size());
    }

    @Test
    public void testFromTs() throws Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("timeline").path("type_1").queryParam("fromTs", Long.toString(this.beforeTime)).accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        Assert.assertEquals((long)0L, (long)((TimelineEntities)response.getEntity(TimelineEntities.class)).getEntities().size());
        response = (ClientResponse)r.path("ws").path("v1").path("timeline").path("type_1").queryParam("fromTs", Long.toString(System.currentTimeMillis())).accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        Assert.assertEquals((long)3L, (long)((TimelineEntities)response.getEntity(TimelineEntities.class)).getEntities().size());
    }

    @Test
    public void testPrimaryFilterString() {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("timeline").path("type_1").queryParam("primaryFilter", "user:username").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        TestTimelineWebServices.verifyEntities((TimelineEntities)response.getEntity(TimelineEntities.class));
    }

    @Test
    public void testPrimaryFilterInteger() {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("timeline").path("type_1").queryParam("primaryFilter", "appname:" + Integer.toString(Integer.MAX_VALUE)).accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        TestTimelineWebServices.verifyEntities((TimelineEntities)response.getEntity(TimelineEntities.class));
    }

    @Test
    public void testPrimaryFilterLong() {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("timeline").path("type_1").queryParam("primaryFilter", "long:" + Long.toString(0x80000000L)).accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        TestTimelineWebServices.verifyEntities((TimelineEntities)response.getEntity(TimelineEntities.class));
    }

    @Test
    public void testPrimaryFilterNumericString() {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("timeline").path("type_1").queryParam("primaryFilter", "other:123abc").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        Assert.assertEquals((long)0L, (long)((TimelineEntities)response.getEntity(TimelineEntities.class)).getEntities().size());
    }

    @Test
    public void testPrimaryFilterNumericStringWithQuotes() {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("timeline").path("type_1").queryParam("primaryFilter", "other:\"123abc\"").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        TestTimelineWebServices.verifyEntities((TimelineEntities)response.getEntity(TimelineEntities.class));
    }

    @Test
    public void testSecondaryFilters() {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("timeline").path("type_1").queryParam("secondaryFilter", "user:username,appname:" + Integer.toString(Integer.MAX_VALUE)).accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        TestTimelineWebServices.verifyEntities((TimelineEntities)response.getEntity(TimelineEntities.class));
    }

    @Test
    public void testGetEntity() throws Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("timeline").path("type_1").path("id_1").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        TimelineEntity entity = (TimelineEntity)response.getEntity(TimelineEntity.class);
        Assert.assertNotNull((Object)entity);
        Assert.assertEquals((Object)"id_1", (Object)entity.getEntityId());
        Assert.assertEquals((Object)"type_1", (Object)entity.getEntityType());
        Assert.assertEquals((long)123L, (long)entity.getStartTime());
        Assert.assertEquals((long)2L, (long)entity.getEvents().size());
        Assert.assertEquals((long)4L, (long)entity.getPrimaryFilters().size());
        Assert.assertEquals((long)4L, (long)entity.getOtherInfo().size());
    }

    @Test
    public void testGetEntityFields1() throws Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("timeline").path("type_1").path("id_1").queryParam("fields", "events,otherinfo").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        TimelineEntity entity = (TimelineEntity)response.getEntity(TimelineEntity.class);
        Assert.assertNotNull((Object)entity);
        Assert.assertEquals((Object)"id_1", (Object)entity.getEntityId());
        Assert.assertEquals((Object)"type_1", (Object)entity.getEntityType());
        Assert.assertEquals((long)123L, (long)entity.getStartTime());
        Assert.assertEquals((long)2L, (long)entity.getEvents().size());
        Assert.assertEquals((long)0L, (long)entity.getPrimaryFilters().size());
        Assert.assertEquals((long)4L, (long)entity.getOtherInfo().size());
    }

    @Test
    public void testGetEntityFields2() throws Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("timeline").path("type_1").path("id_1").queryParam("fields", "lasteventonly,primaryfilters,relatedentities").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        TimelineEntity entity = (TimelineEntity)response.getEntity(TimelineEntity.class);
        Assert.assertNotNull((Object)entity);
        Assert.assertEquals((Object)"id_1", (Object)entity.getEntityId());
        Assert.assertEquals((Object)"type_1", (Object)entity.getEntityType());
        Assert.assertEquals((long)123L, (long)entity.getStartTime());
        Assert.assertEquals((long)1L, (long)entity.getEvents().size());
        Assert.assertEquals((long)4L, (long)entity.getPrimaryFilters().size());
        Assert.assertEquals((long)0L, (long)entity.getOtherInfo().size());
    }

    @Test
    public void testGetEvents() throws Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("timeline").path("type_1").path("events").queryParam("entityId", "id_1").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        TimelineEvents events = (TimelineEvents)response.getEntity(TimelineEvents.class);
        Assert.assertNotNull((Object)events);
        Assert.assertEquals((long)1L, (long)events.getAllEvents().size());
        TimelineEvents.EventsOfOneEntity partEvents = (TimelineEvents.EventsOfOneEntity)events.getAllEvents().get(0);
        Assert.assertEquals((long)2L, (long)partEvents.getEvents().size());
        TimelineEvent event1 = (TimelineEvent)partEvents.getEvents().get(0);
        Assert.assertEquals((long)456L, (long)event1.getTimestamp());
        Assert.assertEquals((Object)"end_event", (Object)event1.getEventType());
        Assert.assertEquals((long)1L, (long)event1.getEventInfo().size());
        TimelineEvent event2 = (TimelineEvent)partEvents.getEvents().get(1);
        Assert.assertEquals((long)123L, (long)event2.getTimestamp());
        Assert.assertEquals((Object)"start_event", (Object)event2.getEventType());
        Assert.assertEquals((long)0L, (long)event2.getEventInfo().size());
    }

    @Test
    public void testPostEntitiesWithPrimaryFilter() throws Exception {
        TimelineEntities entities = new TimelineEntities();
        TimelineEntity entity = new TimelineEntity();
        HashMap filters = new HashMap();
        filters.put(TimelineStore.SystemFilter.ENTITY_OWNER.toString(), new HashSet());
        entity.setPrimaryFilters(filters);
        entity.setEntityId("test id 6");
        entity.setEntityType("test type 6");
        entity.setStartTime(Long.valueOf(System.currentTimeMillis()));
        entities.addEntity(entity);
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)((WebResource.Builder)r.path("ws").path("v1").path("timeline").queryParam("user.name", "tester").accept(new String[]{"application/json"}).type("application/json")).post(ClientResponse.class, (Object)entities);
        TimelinePutResponse putResposne = (TimelinePutResponse)response.getEntity(TimelinePutResponse.class);
        Assert.assertEquals((long)0L, (long)putResposne.getErrors().size());
    }

    @Test
    public void testPostEntities() throws Exception {
        TimelineEntities entities = new TimelineEntities();
        TimelineEntity entity = new TimelineEntity();
        entity.setEntityId("test id 1");
        entity.setEntityType("test type 1");
        entity.setStartTime(Long.valueOf(System.currentTimeMillis()));
        entity.setDomainId("domain_id_1");
        entities.addEntity(entity);
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)((WebResource.Builder)r.path("ws").path("v1").path("timeline").accept(new String[]{"application/json"}).type("application/json")).post(ClientResponse.class, (Object)entities);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        Assert.assertEquals((Object)ClientResponse.Status.FORBIDDEN, (Object)response.getClientResponseStatus());
        response = (ClientResponse)((WebResource.Builder)r.path("ws").path("v1").path("timeline").queryParam("user.name", "tester").accept(new String[]{"application/json"}).type("application/json")).post(ClientResponse.class, (Object)entities);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        TimelinePutResponse putResposne = (TimelinePutResponse)response.getEntity(TimelinePutResponse.class);
        Assert.assertNotNull((Object)putResposne);
        Assert.assertEquals((long)0L, (long)putResposne.getErrors().size());
        response = (ClientResponse)r.path("ws").path("v1").path("timeline").path("test type 1").path("test id 1").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        entity = (TimelineEntity)response.getEntity(TimelineEntity.class);
        Assert.assertNotNull((Object)entity);
        Assert.assertEquals((Object)"test id 1", (Object)entity.getEntityId());
        Assert.assertEquals((Object)"test type 1", (Object)entity.getEntityType());
    }

    @Test
    public void testPostIncompleteEntities() throws Exception {
        TimelineEntities entities = new TimelineEntities();
        TimelineEntity entity1 = new TimelineEntity();
        entity1.setEntityId("test id 1");
        entity1.setEntityType("test type 1");
        entity1.setStartTime(Long.valueOf(System.currentTimeMillis()));
        entity1.setDomainId("domain_id_1");
        entities.addEntity(entity1);
        entities.addEntity(new TimelineEntity());
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)((WebResource.Builder)r.path("ws").path("v1").path("timeline").queryParam("user.name", "tester").accept(new String[]{"application/json"}).type("application/json")).post(ClientResponse.class, (Object)entities);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        Assert.assertEquals((Object)ClientResponse.Status.BAD_REQUEST, (Object)response.getClientResponseStatus());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPostEntitiesWithYarnACLsEnabled() throws Exception {
        AdminACLsManager oldAdminACLsManager = timelineACLsManager.setAdminACLsManager(adminACLsManager);
        try {
            TimelineEntities entities = new TimelineEntities();
            TimelineEntity entity = new TimelineEntity();
            entity.setEntityId("test id 2");
            entity.setEntityType("test type 2");
            entity.setStartTime(Long.valueOf(System.currentTimeMillis()));
            entity.setDomainId("domain_id_1");
            entities.addEntity(entity);
            WebResource r = this.resource();
            ClientResponse response = (ClientResponse)((WebResource.Builder)r.path("ws").path("v1").path("timeline").queryParam("user.name", "writer_user_1").accept(new String[]{"application/json"}).type("application/json")).post(ClientResponse.class, (Object)entities);
            Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
            TimelinePutResponse putResponse = (TimelinePutResponse)response.getEntity(TimelinePutResponse.class);
            Assert.assertNotNull((Object)putResponse);
            Assert.assertEquals((long)0L, (long)putResponse.getErrors().size());
            response = (ClientResponse)((WebResource.Builder)r.path("ws").path("v1").path("timeline").queryParam("user.name", "writer_user_3").accept(new String[]{"application/json"}).type("application/json")).post(ClientResponse.class, (Object)entities);
            Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
            putResponse = (TimelinePutResponse)response.getEntity(TimelinePutResponse.class);
            Assert.assertNotNull((Object)putResponse);
            Assert.assertEquals((long)1L, (long)putResponse.getErrors().size());
            Assert.assertEquals((long)4L, (long)((TimelinePutResponse.TimelinePutError)putResponse.getErrors().get(0)).getErrorCode());
            entities = new TimelineEntities();
            entity = new TimelineEntity();
            entity.setEntityId("test id 3");
            entity.setEntityType("test type 2");
            entity.setStartTime(Long.valueOf(System.currentTimeMillis()));
            entity.setDomainId("domain_id_2");
            entity.setRelatedEntities(Collections.singletonMap("test type 2", Collections.singleton("test id 2")));
            entities.addEntity(entity);
            r = this.resource();
            response = (ClientResponse)((WebResource.Builder)r.path("ws").path("v1").path("timeline").queryParam("user.name", "writer_user_3").accept(new String[]{"application/json"}).type("application/json")).post(ClientResponse.class, (Object)entities);
            Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
            putResponse = (TimelinePutResponse)response.getEntity(TimelinePutResponse.class);
            Assert.assertNotNull((Object)putResponse);
            Assert.assertEquals((long)1L, (long)putResponse.getErrors().size());
            Assert.assertEquals((long)6L, (long)((TimelinePutResponse.TimelinePutError)putResponse.getErrors().get(0)).getErrorCode());
            response = (ClientResponse)r.path("ws").path("v1").path("timeline").path("test type 2").path("test id 3").queryParam("user.name", "reader_user_3").accept(new String[]{"application/json"}).get(ClientResponse.class);
            Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
            entity = (TimelineEntity)response.getEntity(TimelineEntity.class);
            Assert.assertNotNull((Object)entity);
            Assert.assertEquals((Object)"test id 3", (Object)entity.getEntityId());
            Assert.assertEquals((Object)"test type 2", (Object)entity.getEntityType());
        }
        finally {
            timelineACLsManager.setAdminACLsManager(oldAdminACLsManager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPostEntitiesToDefaultDomain() throws Exception {
        AdminACLsManager oldAdminACLsManager = timelineACLsManager.setAdminACLsManager(adminACLsManager);
        try {
            TimelineEntities entities = new TimelineEntities();
            TimelineEntity entity = new TimelineEntity();
            entity.setEntityId("test id 7");
            entity.setEntityType("test type 7");
            entity.setStartTime(Long.valueOf(System.currentTimeMillis()));
            entities.addEntity(entity);
            WebResource r = this.resource();
            ClientResponse response = (ClientResponse)((WebResource.Builder)r.path("ws").path("v1").path("timeline").queryParam("user.name", "anybody_1").accept(new String[]{"application/json"}).type("application/json")).post(ClientResponse.class, (Object)entities);
            Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
            TimelinePutResponse putResposne = (TimelinePutResponse)response.getEntity(TimelinePutResponse.class);
            Assert.assertNotNull((Object)putResposne);
            Assert.assertEquals((long)0L, (long)putResposne.getErrors().size());
            response = (ClientResponse)r.path("ws").path("v1").path("timeline").path("test type 7").path("test id 7").queryParam("user.name", "any_body_2").accept(new String[]{"application/json"}).get(ClientResponse.class);
            Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
            entity = (TimelineEntity)response.getEntity(TimelineEntity.class);
            Assert.assertNotNull((Object)entity);
            Assert.assertEquals((Object)"test id 7", (Object)entity.getEntityId());
            Assert.assertEquals((Object)"test type 7", (Object)entity.getEntityType());
            Assert.assertEquals((Object)"DEFAULT", (Object)entity.getDomainId());
        }
        finally {
            timelineACLsManager.setAdminACLsManager(oldAdminACLsManager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetEntityWithYarnACLsEnabled() throws Exception {
        AdminACLsManager oldAdminACLsManager = timelineACLsManager.setAdminACLsManager(adminACLsManager);
        try {
            TimelineEntities entities = new TimelineEntities();
            TimelineEntity entity = new TimelineEntity();
            entity.setEntityId("test id 3");
            entity.setEntityType("test type 3");
            entity.setStartTime(Long.valueOf(System.currentTimeMillis()));
            entity.setDomainId("domain_id_1");
            entities.addEntity(entity);
            WebResource r = this.resource();
            ClientResponse response = (ClientResponse)((WebResource.Builder)r.path("ws").path("v1").path("timeline").queryParam("user.name", "writer_user_1").accept(new String[]{"application/json"}).type("application/json")).post(ClientResponse.class, (Object)entities);
            Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
            TimelinePutResponse putResponse = (TimelinePutResponse)response.getEntity(TimelinePutResponse.class);
            Assert.assertEquals((long)0L, (long)putResponse.getErrors().size());
            response = (ClientResponse)r.path("ws").path("v1").path("timeline").path("test type 3").path("test id 3").queryParam("user.name", "reader_user_1").accept(new String[]{"application/json"}).get(ClientResponse.class);
            Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
            entity = (TimelineEntity)response.getEntity(TimelineEntity.class);
            Assert.assertNull(entity.getPrimaryFilters().get(TimelineStore.SystemFilter.ENTITY_OWNER.toString()));
            response = (ClientResponse)r.path("ws").path("v1").path("timeline").path("test type 3").path("test id 3").queryParam("fields", "relatedentities").queryParam("user.name", "reader_user_1").accept(new String[]{"application/json"}).get(ClientResponse.class);
            Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
            entity = (TimelineEntity)response.getEntity(TimelineEntity.class);
            Assert.assertNull(entity.getPrimaryFilters().get(TimelineStore.SystemFilter.ENTITY_OWNER.toString()));
            response = (ClientResponse)r.path("ws").path("v1").path("timeline").path("test type 3").path("test id 3").queryParam("fields", "primaryfilters").queryParam("user.name", "reader_user_1").accept(new String[]{"application/json"}).get(ClientResponse.class);
            Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
            entity = (TimelineEntity)response.getEntity(TimelineEntity.class);
            Assert.assertNull(entity.getPrimaryFilters().get(TimelineStore.SystemFilter.ENTITY_OWNER.toString()));
            response = (ClientResponse)r.path("ws").path("v1").path("timeline").path("test type 3").path("test id 3").queryParam("user.name", "reader_user_2").accept(new String[]{"application/json"}).get(ClientResponse.class);
            Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
            Assert.assertEquals((Object)ClientResponse.Status.NOT_FOUND, (Object)response.getClientResponseStatus());
        }
        finally {
            timelineACLsManager.setAdminACLsManager(oldAdminACLsManager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetEntitiesWithYarnACLsEnabled() {
        AdminACLsManager oldAdminACLsManager = timelineACLsManager.setAdminACLsManager(adminACLsManager);
        try {
            TimelineEntities entities = new TimelineEntities();
            TimelineEntity entity = new TimelineEntity();
            entity.setEntityId("test id 4");
            entity.setEntityType("test type 4");
            entity.setStartTime(Long.valueOf(System.currentTimeMillis()));
            entity.setDomainId("domain_id_1");
            entities.addEntity(entity);
            WebResource r = this.resource();
            ClientResponse response = (ClientResponse)((WebResource.Builder)r.path("ws").path("v1").path("timeline").queryParam("user.name", "writer_user_1").accept(new String[]{"application/json"}).type("application/json")).post(ClientResponse.class, (Object)entities);
            Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
            TimelinePutResponse putResponse = (TimelinePutResponse)response.getEntity(TimelinePutResponse.class);
            Assert.assertEquals((long)0L, (long)putResponse.getErrors().size());
            entities = new TimelineEntities();
            entity = new TimelineEntity();
            entity.setEntityId("test id 5");
            entity.setEntityType("test type 4");
            entity.setStartTime(Long.valueOf(System.currentTimeMillis()));
            entity.setDomainId("domain_id_2");
            entities.addEntity(entity);
            r = this.resource();
            response = (ClientResponse)((WebResource.Builder)r.path("ws").path("v1").path("timeline").queryParam("user.name", "writer_user_3").accept(new String[]{"application/json"}).type("application/json")).post(ClientResponse.class, (Object)entities);
            Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
            putResponse = (TimelinePutResponse)response.getEntity(TimelinePutResponse.class);
            Assert.assertEquals((long)0L, (long)putResponse.getErrors().size());
            response = (ClientResponse)r.path("ws").path("v1").path("timeline").queryParam("user.name", "reader_user_1").path("test type 4").accept(new String[]{"application/json"}).get(ClientResponse.class);
            Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
            entities = (TimelineEntities)response.getEntity(TimelineEntities.class);
            Assert.assertEquals((long)1L, (long)entities.getEntities().size());
            Assert.assertEquals((Object)"test type 4", (Object)((TimelineEntity)entities.getEntities().get(0)).getEntityType());
            Assert.assertEquals((Object)"test id 4", (Object)((TimelineEntity)entities.getEntities().get(0)).getEntityId());
        }
        finally {
            timelineACLsManager.setAdminACLsManager(oldAdminACLsManager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetEventsWithYarnACLsEnabled() {
        AdminACLsManager oldAdminACLsManager = timelineACLsManager.setAdminACLsManager(adminACLsManager);
        try {
            TimelineEntities entities = new TimelineEntities();
            TimelineEntity entity = new TimelineEntity();
            entity.setEntityId("test id 5");
            entity.setEntityType("test type 5");
            entity.setStartTime(Long.valueOf(System.currentTimeMillis()));
            entity.setDomainId("domain_id_1");
            TimelineEvent event = new TimelineEvent();
            event.setEventType("event type 1");
            event.setTimestamp(System.currentTimeMillis());
            entity.addEvent(event);
            entities.addEntity(entity);
            WebResource r = this.resource();
            ClientResponse response = (ClientResponse)((WebResource.Builder)r.path("ws").path("v1").path("timeline").queryParam("user.name", "writer_user_1").accept(new String[]{"application/json"}).type("application/json")).post(ClientResponse.class, (Object)entities);
            Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
            TimelinePutResponse putResponse = (TimelinePutResponse)response.getEntity(TimelinePutResponse.class);
            Assert.assertEquals((long)0L, (long)putResponse.getErrors().size());
            entities = new TimelineEntities();
            entity = new TimelineEntity();
            entity.setEntityId("test id 6");
            entity.setEntityType("test type 5");
            entity.setStartTime(Long.valueOf(System.currentTimeMillis()));
            entity.setDomainId("domain_id_2");
            event = new TimelineEvent();
            event.setEventType("event type 2");
            event.setTimestamp(System.currentTimeMillis());
            entity.addEvent(event);
            entities.addEntity(entity);
            r = this.resource();
            response = (ClientResponse)((WebResource.Builder)r.path("ws").path("v1").path("timeline").queryParam("user.name", "writer_user_3").accept(new String[]{"application/json"}).type("application/json")).post(ClientResponse.class, (Object)entities);
            Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
            putResponse = (TimelinePutResponse)response.getEntity(TimelinePutResponse.class);
            Assert.assertEquals((long)0L, (long)putResponse.getErrors().size());
            response = (ClientResponse)r.path("ws").path("v1").path("timeline").path("test type 5").path("events").queryParam("user.name", "reader_user_1").queryParam("entityId", "test id 5,test id 6").accept(new String[]{"application/json"}).get(ClientResponse.class);
            Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
            TimelineEvents events = (TimelineEvents)response.getEntity(TimelineEvents.class);
            Assert.assertEquals((long)1L, (long)events.getAllEvents().size());
            Assert.assertEquals((Object)"test id 5", (Object)((TimelineEvents.EventsOfOneEntity)events.getAllEvents().get(0)).getEntityId());
        }
        finally {
            timelineACLsManager.setAdminACLsManager(oldAdminACLsManager);
        }
    }

    @Test
    public void testGetDomain() throws Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("timeline").path("domain").path("domain_id_1").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        TimelineDomain domain = (TimelineDomain)response.getEntity(TimelineDomain.class);
        TestTimelineWebServices.verifyDomain(domain, "domain_id_1");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetDomainYarnACLsEnabled() {
        AdminACLsManager oldAdminACLsManager = timelineACLsManager.setAdminACLsManager(adminACLsManager);
        try {
            WebResource r = this.resource();
            ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("timeline").path("domain").path("domain_id_1").queryParam("user.name", "owner_1").accept(new String[]{"application/json"}).get(ClientResponse.class);
            Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
            TimelineDomain domain = (TimelineDomain)response.getEntity(TimelineDomain.class);
            TestTimelineWebServices.verifyDomain(domain, "domain_id_1");
            response = (ClientResponse)r.path("ws").path("v1").path("timeline").path("domain").path("domain_id_1").queryParam("user.name", "tester").accept(new String[]{"application/json"}).get(ClientResponse.class);
            Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
            Assert.assertEquals((Object)ClientResponse.Status.NOT_FOUND, (Object)response.getClientResponseStatus());
        }
        finally {
            timelineACLsManager.setAdminACLsManager(oldAdminACLsManager);
        }
    }

    @Test
    public void testGetDomains() throws Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("timeline").path("domain").queryParam("owner", "owner_1").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        TimelineDomains domains = (TimelineDomains)response.getEntity(TimelineDomains.class);
        Assert.assertEquals((long)2L, (long)domains.getDomains().size());
        for (int i = 0; i < domains.getDomains().size(); ++i) {
            TestTimelineWebServices.verifyDomain((TimelineDomain)domains.getDomains().get(i), i == 0 ? "domain_id_4" : "domain_id_1");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetDomainsYarnACLsEnabled() throws Exception {
        AdminACLsManager oldAdminACLsManager = timelineACLsManager.setAdminACLsManager(adminACLsManager);
        try {
            WebResource r = this.resource();
            ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("timeline").path("domain").queryParam("user.name", "owner_1").accept(new String[]{"application/json"}).get(ClientResponse.class);
            Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
            TimelineDomains domains = (TimelineDomains)response.getEntity(TimelineDomains.class);
            Assert.assertEquals((long)2L, (long)domains.getDomains().size());
            for (int i = 0; i < domains.getDomains().size(); ++i) {
                TestTimelineWebServices.verifyDomain((TimelineDomain)domains.getDomains().get(i), i == 0 ? "domain_id_4" : "domain_id_1");
            }
            response = (ClientResponse)r.path("ws").path("v1").path("timeline").path("domain").queryParam("owner", "owner_1").queryParam("user.name", "tester").accept(new String[]{"application/json"}).get(ClientResponse.class);
            Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
            domains = (TimelineDomains)response.getEntity(TimelineDomains.class);
            Assert.assertEquals((long)0L, (long)domains.getDomains().size());
        }
        finally {
            timelineACLsManager.setAdminACLsManager(oldAdminACLsManager);
        }
    }

    @Test
    public void testPutDomain() throws Exception {
        TimelineDomain domain = new TimelineDomain();
        domain.setId("test_domain_id");
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)((WebResource.Builder)r.path("ws").path("v1").path("timeline").path("domain").accept(new String[]{"application/json"}).type("application/json")).put(ClientResponse.class, (Object)domain);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        Assert.assertEquals((Object)ClientResponse.Status.FORBIDDEN, (Object)response.getClientResponseStatus());
        response = (ClientResponse)((WebResource.Builder)r.path("ws").path("v1").path("timeline").path("domain").queryParam("user.name", "tester").accept(new String[]{"application/json"}).type("application/json")).put(ClientResponse.class, (Object)domain);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        response = (ClientResponse)r.path("ws").path("v1").path("timeline").path("domain").path("test_domain_id").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        domain = (TimelineDomain)response.getEntity(TimelineDomain.class);
        Assert.assertNotNull((Object)domain);
        Assert.assertEquals((Object)"test_domain_id", (Object)domain.getId());
        Assert.assertEquals((Object)"tester", (Object)domain.getOwner());
        Assert.assertEquals(null, (Object)domain.getDescription());
        domain.setDescription("test_description");
        response = (ClientResponse)((WebResource.Builder)r.path("ws").path("v1").path("timeline").path("domain").queryParam("user.name", "tester").accept(new String[]{"application/json"}).type("application/json")).put(ClientResponse.class, (Object)domain);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        response = (ClientResponse)r.path("ws").path("v1").path("timeline").path("domain").path("test_domain_id").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        domain = (TimelineDomain)response.getEntity(TimelineDomain.class);
        Assert.assertNotNull((Object)domain);
        Assert.assertEquals((Object)"test_domain_id", (Object)domain.getId());
        Assert.assertEquals((Object)"test_description", (Object)domain.getDescription());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPutDomainYarnACLsEnabled() throws Exception {
        AdminACLsManager oldAdminACLsManager = timelineACLsManager.setAdminACLsManager(adminACLsManager);
        try {
            TimelineDomain domain = new TimelineDomain();
            domain.setId("test_domain_id_acl");
            WebResource r = this.resource();
            ClientResponse response = (ClientResponse)((WebResource.Builder)r.path("ws").path("v1").path("timeline").path("domain").queryParam("user.name", "tester").accept(new String[]{"application/json"}).type("application/json")).put(ClientResponse.class, (Object)domain);
            Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
            response = (ClientResponse)((WebResource.Builder)r.path("ws").path("v1").path("timeline").path("domain").queryParam("user.name", "other").accept(new String[]{"application/json"}).type("application/json")).put(ClientResponse.class, (Object)domain);
            Assert.assertEquals((long)Response.Status.FORBIDDEN.getStatusCode(), (long)response.getStatus());
        }
        finally {
            timelineACLsManager.setAdminACLsManager(oldAdminACLsManager);
        }
    }

    private static void verifyDomain(TimelineDomain domain, String domainId) {
        Assert.assertNotNull((Object)domain);
        Assert.assertEquals((Object)domainId, (Object)domain.getId());
        Assert.assertNotNull((Object)domain.getDescription());
        Assert.assertNotNull((Object)domain.getOwner());
        Assert.assertNotNull((Object)domain.getReaders());
        Assert.assertNotNull((Object)domain.getWriters());
        Assert.assertNotNull((Object)domain.getCreatedTime());
        Assert.assertNotNull((Object)domain.getModifiedTime());
    }

    public class GuiceServletConfig
    extends GuiceServletContextListener {
        protected Injector getInjector() {
            return TestTimelineWebServices.this.injector;
        }
    }
}

